
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `accept_estimates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accept_estimates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `estimate_id` int unsigned NOT NULL,
  `full_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `signature` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accept_estimates_estimate_id_foreign` (`estimate_id`),
  KEY `accept_estimates_company_id_foreign` (`company_id`),
  CONSTRAINT `accept_estimates_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `accept_estimates_estimate_id_foreign` FOREIGN KEY (`estimate_id`) REFERENCES `estimates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accept_estimates` WRITE;
/*!40000 ALTER TABLE `accept_estimates` DISABLE KEYS */;
/*!40000 ALTER TABLE `accept_estimates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `appreciations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `appreciations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `award_id` bigint unsigned NOT NULL,
  `award_to` int unsigned NOT NULL,
  `award_date` date NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `summary` text COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `appreciations_company_id_foreign` (`company_id`),
  KEY `appreciations_award_id_foreign` (`award_id`),
  KEY `appreciations_award_to_foreign` (`award_to`),
  KEY `appreciations_added_by_foreign` (`added_by`),
  CONSTRAINT `appreciations_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `appreciations_award_id_foreign` FOREIGN KEY (`award_id`) REFERENCES `awards` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `appreciations_award_to_foreign` FOREIGN KEY (`award_to`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `appreciations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `appreciations` WRITE;
/*!40000 ALTER TABLE `appreciations` DISABLE KEYS */;
/*!40000 ALTER TABLE `appreciations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `attendance_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendance_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `auto_clock_in` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `office_start_time` time NOT NULL,
  `office_end_time` time NOT NULL,
  `halfday_mark_time` time DEFAULT NULL,
  `late_mark_duration` tinyint NOT NULL,
  `clockin_in_day` int NOT NULL DEFAULT '1',
  `employee_clock_in_out` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `office_open_days` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[1,2,3,4,5]',
  `ip_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `radius` int DEFAULT NULL,
  `radius_check` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `ip_check` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `alert_after` int DEFAULT NULL,
  `alert_after_status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `save_current_location` tinyint(1) NOT NULL DEFAULT '0',
  `default_employee_shift` bigint unsigned DEFAULT '1',
  `week_start_from` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `allow_shift_change` tinyint(1) NOT NULL DEFAULT '1',
  `show_clock_in_button` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `attendance_settings_default_employee_shift_foreign` (`default_employee_shift`),
  KEY `attendance_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `attendance_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `attendance_settings_default_employee_shift_foreign` FOREIGN KEY (`default_employee_shift`) REFERENCES `employee_shifts` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `attendance_settings` WRITE;
/*!40000 ALTER TABLE `attendance_settings` DISABLE KEYS */;
INSERT INTO `attendance_settings` VALUES (1,1,'no','09:00:00','18:00:00',NULL,20,1,'yes','[1,2,3,4,5]',NULL,NULL,'no','no',NULL,1,'2022-10-28 07:30:08','2022-10-28 07:30:08',0,1,'1',1,'no'),(2,2,'no','09:00:00','18:00:00',NULL,20,1,'yes','[1,2,3,4,5]',NULL,NULL,'no','no',NULL,1,'2022-10-28 07:30:09','2022-10-28 07:30:09',0,2,'1',1,'no'),(3,3,'no','09:00:00','18:00:00',NULL,20,1,'yes','[1,2,3,4,5]',NULL,NULL,'no','no',NULL,1,'2022-10-28 07:30:10','2022-10-28 07:30:10',0,3,'1',1,'no'),(4,4,'no','09:00:00','18:00:00',NULL,20,1,'yes','[1,2,3,4,5]',NULL,NULL,'no','no',NULL,1,'2022-10-28 07:34:32','2022-10-28 07:34:32',0,10,'1',1,'no');
/*!40000 ALTER TABLE `attendance_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `attendances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendances` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `location_id` bigint unsigned DEFAULT NULL,
  `clock_in_time` datetime NOT NULL,
  `clock_out_time` datetime DEFAULT NULL,
  `clock_in_ip` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `clock_out_ip` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `working_from` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'office',
  `late` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `half_day` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(11,8) DEFAULT NULL,
  `shift_start_time` datetime DEFAULT NULL,
  `shift_end_time` datetime DEFAULT NULL,
  `employee_shift_id` bigint unsigned DEFAULT NULL,
  `work_from_type` enum('home','office','other') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'other',
  PRIMARY KEY (`id`),
  KEY `attendances_user_id_foreign` (`user_id`),
  KEY `attendances_location_id_foreign` (`location_id`),
  KEY `attendances_clock_in_time_index` (`clock_in_time`),
  KEY `attendances_clock_out_time_index` (`clock_out_time`),
  KEY `attendances_added_by_foreign` (`added_by`),
  KEY `attendances_last_updated_by_foreign` (`last_updated_by`),
  KEY `attendances_employee_shift_id_foreign` (`employee_shift_id`),
  KEY `attendances_company_id_foreign` (`company_id`),
  CONSTRAINT `attendances_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `attendances_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `attendances_employee_shift_id_foreign` FOREIGN KEY (`employee_shift_id`) REFERENCES `employee_shifts` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `attendances_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `attendances_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `company_addresses` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `attendances_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `attendances` WRITE;
/*!40000 ALTER TABLE `attendances` DISABLE KEYS */;
INSERT INTO `attendances` VALUES (1,1,2,NULL,'2022-03-30 13:00:00','2022-03-30 16:00:00','33.193.78.158','33.193.78.158','office','yes','no','2022-06-04 10:03:03','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(2,1,3,NULL,'2022-06-29 11:10:00','2022-06-29 14:10:00','61.182.186.108','61.182.186.108','office','yes','no','2022-08-31 21:46:16','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(3,1,10,NULL,'2022-10-18 11:00:00','2022-10-18 13:00:00','219.219.41.102','219.219.41.102','office','yes','no','2022-07-07 13:19:07','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(4,1,11,NULL,'2022-10-12 11:00:00','2022-10-12 18:00:00','243.81.17.75','243.81.17.75','office','no','no','2022-05-22 13:56:41','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(5,1,12,NULL,'2022-10-01 09:00:00','2022-10-01 15:00:00','196.9.167.179','196.9.167.179','office','no','no','2022-03-11 05:13:49','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(6,1,13,NULL,'2022-10-12 12:10:00','2022-10-12 18:10:00','31.224.174.118','31.224.174.118','office','yes','no','2022-02-24 22:28:12','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(7,1,14,NULL,'2022-07-16 15:00:00','2022-07-16 18:00:00','174.124.217.46','174.124.217.46','office','no','no','2022-04-26 09:10:30','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(8,1,2,NULL,'2022-10-19 09:00:00','2022-10-19 12:00:00','79.169.21.73','79.169.21.73','office','yes','no','2022-09-16 07:13:22','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(9,1,3,NULL,'2022-10-19 12:00:00','2022-10-19 18:00:00','5.48.74.53','5.48.74.53','office','no','no','2022-01-18 07:01:03','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(10,1,10,NULL,'2022-01-13 12:00:00','2022-01-13 17:00:00','1.70.7.249','1.70.7.249','office','yes','no','2022-03-21 12:44:39','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(11,1,11,NULL,'2022-06-05 09:00:00','2022-06-05 18:00:00','117.73.231.187','117.73.231.187','office','yes','no','2022-10-11 22:58:02','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(12,1,12,NULL,'2022-08-12 13:00:00','2022-08-12 21:00:00','22.250.93.9','22.250.93.9','office','no','no','2022-02-05 17:23:12','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(13,1,13,NULL,'2022-07-06 12:00:00','2022-07-06 20:00:00','87.235.0.154','87.235.0.154','office','no','no','2022-08-30 05:45:51','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(14,1,14,NULL,'2022-10-15 09:00:00','2022-10-15 16:00:00','4.155.206.208','4.155.206.208','office','yes','no','2022-04-16 22:07:29','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(15,1,2,NULL,'2022-10-13 09:00:00','2022-10-13 14:00:00','176.24.174.109','176.24.174.109','office','yes','no','2022-04-19 11:34:36','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(16,1,3,NULL,'2022-05-04 11:00:00','2022-05-04 18:00:00','11.246.37.100','11.246.37.100','office','yes','no','2022-09-17 22:21:57','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(17,1,10,NULL,'2022-05-14 11:00:00','2022-05-14 17:00:00','104.48.102.239','104.48.102.239','office','yes','no','2022-10-27 19:25:55','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(18,1,11,NULL,'2022-02-18 09:15:00','2022-02-18 12:15:00','55.39.168.171','55.39.168.171','office','yes','no','2022-08-12 00:28:40','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(19,1,12,NULL,'2022-10-02 13:00:00','2022-10-02 18:00:00','57.90.140.185','57.90.140.185','office','yes','no','2022-07-18 23:15:38','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(20,1,13,NULL,'2022-08-06 09:00:00','2022-08-06 11:00:00','233.92.162.68','233.92.162.68','office','yes','no','2022-06-24 13:35:47','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(21,1,14,NULL,'2022-10-08 10:40:00','2022-10-08 16:40:00','109.84.216.140','109.84.216.140','office','yes','no','2022-07-10 10:36:17','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(22,1,2,NULL,'2022-10-25 13:00:00','2022-10-25 16:00:00','242.104.241.154','242.104.241.154','office','no','no','2022-01-30 10:15:50','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(23,1,3,NULL,'2022-01-13 09:00:00','2022-01-13 13:00:00','49.90.108.23','49.90.108.23','office','yes','no','2022-10-12 13:26:26','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(24,1,10,NULL,'2022-09-29 13:10:00','2022-09-29 17:10:00','203.209.110.82','203.209.110.82','office','no','no','2022-09-08 11:55:32','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(25,1,11,NULL,'2022-03-25 14:00:00','2022-03-25 21:00:00','23.250.155.71','23.250.155.71','office','no','no','2022-09-03 12:42:11','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(26,1,12,NULL,'2022-05-04 09:00:00','2022-05-04 13:00:00','56.54.80.1','56.54.80.1','office','yes','no','2022-01-28 13:02:27','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(27,1,13,NULL,'2022-06-11 10:00:00','2022-06-11 18:00:00','54.4.182.83','54.4.182.83','office','yes','no','2022-05-31 19:24:56','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(28,1,14,NULL,'2022-10-24 09:00:00','2022-10-24 18:00:00','213.44.201.185','213.44.201.185','office','yes','no','2022-01-22 01:12:46','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(29,1,2,NULL,'2022-09-28 09:00:00','2022-09-28 13:00:00','130.34.33.201','130.34.33.201','office','yes','no','2022-06-15 17:48:20','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(30,1,3,NULL,'2022-10-08 12:00:00','2022-10-08 20:00:00','237.191.90.171','237.191.90.171','office','no','no','2022-08-13 02:12:28','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(31,1,10,NULL,'2022-06-29 10:00:00','2022-06-29 12:00:00','215.54.217.132','215.54.217.132','office','yes','no','2022-05-11 00:53:29','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(32,1,11,NULL,'2022-06-10 10:00:00','2022-06-10 13:00:00','129.160.10.78','129.160.10.78','office','no','no','2022-06-26 11:48:05','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(33,1,12,NULL,'2022-10-27 11:45:00','2022-10-27 13:45:00','88.100.92.235','88.100.92.235','office','no','no','2022-10-08 21:25:39','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(34,1,13,NULL,'2022-10-07 10:00:00','2022-10-07 11:00:00','152.205.220.32','152.205.220.32','office','yes','no','2022-08-08 11:52:32','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(35,1,14,NULL,'2022-01-02 10:00:00','2022-01-02 16:00:00','10.210.208.131','10.210.208.131','office','yes','no','2022-06-03 08:17:23','2022-10-28 07:30:13',2,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(36,2,15,NULL,'2022-09-28 11:00:00','2022-09-28 13:00:00','254.119.62.51','254.119.62.51','office','no','no','2022-05-20 05:33:11','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(37,2,16,NULL,'2022-08-08 11:00:00','2022-08-08 20:00:00','93.171.7.236','93.171.7.236','office','yes','no','2022-05-06 06:59:35','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(38,2,23,NULL,'2022-10-04 09:00:00','2022-10-04 16:00:00','254.191.213.92','254.191.213.92','office','no','no','2022-05-16 15:52:12','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(39,2,24,NULL,'2022-07-29 11:00:00','2022-07-29 15:00:00','96.182.7.145','96.182.7.145','office','yes','no','2022-01-17 11:37:55','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(40,2,25,NULL,'2022-10-09 08:40:00','2022-10-09 17:40:00','245.98.198.233','245.98.198.233','office','yes','no','2022-10-07 17:02:37','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(41,2,26,NULL,'2022-09-28 11:00:00','2022-09-28 15:00:00','132.121.83.177','132.121.83.177','office','yes','no','2022-02-02 14:34:38','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(42,2,27,NULL,'2022-10-04 08:40:00','2022-10-04 11:40:00','19.69.174.248','19.69.174.248','office','yes','no','2022-01-10 07:16:43','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(43,2,15,NULL,'2022-10-20 09:00:00','2022-10-20 10:00:00','254.229.239.219','254.229.239.219','office','no','no','2022-04-07 22:40:13','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(44,2,16,NULL,'2022-05-07 10:00:00','2022-05-07 13:00:00','219.251.18.80','219.251.18.80','office','yes','no','2022-08-30 11:48:56','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(45,2,23,NULL,'2022-03-04 14:00:00','2022-03-04 21:00:00','58.162.147.60','58.162.147.60','office','yes','no','2022-07-14 07:33:42','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(46,2,24,NULL,'2022-02-02 12:00:00','2022-02-02 13:00:00','125.194.137.223','125.194.137.223','office','yes','no','2022-05-10 13:40:22','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(47,2,25,NULL,'2022-10-16 13:00:00','2022-10-16 15:00:00','48.13.166.199','48.13.166.199','office','yes','no','2022-02-12 08:07:39','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(48,2,26,NULL,'2022-10-12 13:15:00','2022-10-12 21:15:00','83.46.219.8','83.46.219.8','office','no','no','2022-02-10 20:22:34','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(49,2,27,NULL,'2022-10-01 11:00:00','2022-10-01 13:00:00','128.124.23.211','128.124.23.211','office','no','no','2022-07-15 12:02:55','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(50,2,15,NULL,'2022-10-20 15:00:00','2022-10-20 21:00:00','124.109.80.210','124.109.80.210','office','no','no','2022-08-09 06:16:58','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(51,2,16,NULL,'2022-10-23 11:00:00','2022-10-23 18:00:00','163.128.20.102','163.128.20.102','office','no','no','2022-10-08 12:05:55','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(52,2,23,NULL,'2022-04-29 12:00:00','2022-04-29 15:00:00','229.148.118.147','229.148.118.147','office','no','no','2022-06-26 15:59:23','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(53,2,24,NULL,'2022-08-01 11:00:00','2022-08-01 20:00:00','8.204.57.131','8.204.57.131','office','yes','no','2022-07-31 19:48:54','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(54,2,25,NULL,'2022-03-14 11:00:00','2022-03-14 20:00:00','67.199.90.88','67.199.90.88','office','yes','no','2022-02-04 17:13:42','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(55,2,26,NULL,'2022-10-08 12:00:00','2022-10-08 18:00:00','134.20.133.217','134.20.133.217','office','yes','no','2022-01-21 16:35:20','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(56,2,27,NULL,'2022-08-14 12:00:00','2022-08-14 13:00:00','149.105.37.88','149.105.37.88','office','yes','no','2022-06-01 23:09:26','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(57,2,15,NULL,'2022-08-17 11:07:00','2022-08-17 18:07:00','168.132.129.196','168.132.129.196','office','yes','no','2022-04-23 15:03:17','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(58,2,16,NULL,'2022-10-01 11:00:00','2022-10-01 19:00:00','98.243.55.124','98.243.55.124','office','yes','no','2022-01-08 08:52:43','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(59,2,23,NULL,'2022-10-17 10:00:00','2022-10-17 12:00:00','168.6.117.198','168.6.117.198','office','yes','no','2022-02-09 16:52:13','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(60,2,24,NULL,'2022-10-07 12:00:00','2022-10-07 19:00:00','58.116.70.174','58.116.70.174','office','no','no','2022-07-08 18:41:22','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(61,2,25,NULL,'2022-09-29 12:07:00','2022-09-29 15:07:00','250.80.149.63','250.80.149.63','office','no','no','2022-08-19 17:38:03','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(62,2,26,NULL,'2022-10-06 12:15:00','2022-10-06 15:15:00','110.24.173.132','110.24.173.132','office','yes','no','2022-10-26 12:42:38','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(63,2,27,NULL,'2022-05-26 12:00:00','2022-05-26 19:00:00','105.80.42.44','105.80.42.44','office','no','no','2022-06-11 13:04:34','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(64,2,15,NULL,'2022-08-25 11:15:00','2022-08-25 13:15:00','83.123.193.11','83.123.193.11','office','no','no','2022-01-18 18:27:15','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(65,2,16,NULL,'2022-04-27 09:00:00','2022-04-27 15:00:00','198.46.30.120','198.46.30.120','office','yes','no','2022-10-24 08:52:18','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(66,2,23,NULL,'2022-05-28 10:00:00','2022-05-28 16:00:00','131.59.6.5','131.59.6.5','office','no','no','2022-06-17 10:01:38','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(67,2,24,NULL,'2022-04-13 12:00:00','2022-04-13 13:00:00','69.65.155.217','69.65.155.217','office','no','no','2022-03-15 06:58:22','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(68,2,25,NULL,'2022-05-06 12:00:00','2022-05-06 13:00:00','112.221.26.28','112.221.26.28','office','yes','no','2022-05-22 08:06:26','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(69,2,26,NULL,'2022-08-31 12:00:00','2022-08-31 18:00:00','217.209.211.232','217.209.211.232','office','no','no','2022-01-23 23:13:54','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(70,2,27,NULL,'2022-02-25 09:00:00','2022-02-25 10:00:00','21.182.122.224','21.182.122.224','office','yes','no','2022-09-20 11:30:31','2022-10-28 07:30:16',15,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(71,3,28,NULL,'2022-09-29 09:00:00','2022-09-29 17:00:00','140.205.188.229','140.205.188.229','office','yes','no','2022-02-22 21:24:03','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(72,3,29,NULL,'2022-08-05 13:00:00','2022-08-05 16:00:00','96.227.160.187','96.227.160.187','office','no','no','2022-08-14 07:48:35','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(73,3,36,NULL,'2022-02-14 12:00:00','2022-02-14 14:00:00','106.145.229.186','106.145.229.186','office','yes','no','2022-07-05 02:50:42','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(74,3,37,NULL,'2022-04-16 11:40:00','2022-04-16 13:40:00','152.244.75.164','152.244.75.164','office','no','no','2022-01-14 10:55:13','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(75,3,38,NULL,'2022-10-25 11:10:00','2022-10-25 14:10:00','127.219.185.165','127.219.185.165','office','yes','no','2022-08-26 17:41:34','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(76,3,39,NULL,'2022-02-08 09:00:00','2022-02-08 10:00:00','75.38.116.24','75.38.116.24','office','yes','no','2022-01-31 02:30:47','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(77,3,40,NULL,'2022-10-24 13:00:00','2022-10-24 18:00:00','215.55.184.77','215.55.184.77','office','no','no','2022-05-08 17:20:11','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(78,3,28,NULL,'2022-01-01 11:00:00','2022-01-01 12:00:00','97.191.118.123','97.191.118.123','office','yes','no','2022-10-16 01:10:58','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(79,3,29,NULL,'2022-10-22 11:00:00','2022-10-22 19:00:00','215.247.55.45','215.247.55.45','office','no','no','2022-01-10 18:54:14','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(80,3,36,NULL,'2022-04-19 12:15:00','2022-04-19 20:15:00','98.137.61.151','98.137.61.151','office','yes','no','2022-04-17 09:07:49','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(81,3,37,NULL,'2022-10-12 12:00:00','2022-10-12 21:00:00','69.83.233.78','69.83.233.78','office','yes','no','2022-06-16 01:04:31','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(82,3,38,NULL,'2022-10-14 12:00:00','2022-10-14 16:00:00','227.110.95.70','227.110.95.70','office','no','no','2022-05-09 18:09:56','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(83,3,39,NULL,'2022-10-11 13:00:00','2022-10-11 17:00:00','62.49.63.186','62.49.63.186','office','yes','no','2022-08-14 19:54:27','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(84,3,40,NULL,'2022-06-21 10:00:00','2022-06-21 11:00:00','234.207.210.9','234.207.210.9','office','yes','no','2022-03-09 03:16:59','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(85,3,28,NULL,'2022-06-14 13:10:00','2022-06-14 15:10:00','6.118.11.176','6.118.11.176','office','no','no','2022-01-02 06:04:29','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(86,3,29,NULL,'2022-10-19 13:15:00','2022-10-19 17:15:00','188.207.209.80','188.207.209.80','office','yes','no','2022-03-21 07:16:47','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(87,3,36,NULL,'2022-10-28 09:00:00','2022-10-28 15:00:00','114.12.222.129','114.12.222.129','office','yes','no','2022-02-06 04:28:49','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(88,3,37,NULL,'2022-07-21 09:00:00','2022-07-21 13:00:00','50.35.242.206','50.35.242.206','office','yes','no','2022-05-14 23:28:58','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(89,3,38,NULL,'2022-10-07 10:00:00','2022-10-07 13:00:00','121.31.162.58','121.31.162.58','office','no','no','2022-04-21 13:02:51','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(90,3,39,NULL,'2022-03-07 12:00:00','2022-03-07 13:00:00','140.205.172.162','140.205.172.162','office','yes','no','2022-04-02 00:49:05','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(91,3,40,NULL,'2022-02-06 12:00:00','2022-02-06 17:00:00','14.145.97.12','14.145.97.12','office','yes','no','2022-10-18 21:35:34','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(92,3,28,NULL,'2022-06-07 10:15:00','2022-06-07 17:15:00','108.10.123.48','108.10.123.48','office','yes','no','2022-07-01 03:16:34','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(93,3,29,NULL,'2022-10-16 12:15:00','2022-10-16 18:15:00','123.196.144.170','123.196.144.170','office','no','no','2022-06-11 14:59:02','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(94,3,36,NULL,'2022-10-08 09:15:00','2022-10-08 15:15:00','96.15.224.34','96.15.224.34','office','no','no','2022-05-09 13:28:14','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(95,3,37,NULL,'2022-02-11 12:00:00','2022-02-11 18:00:00','101.15.136.110','101.15.136.110','office','no','no','2022-03-03 21:54:54','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(96,3,38,NULL,'2022-10-11 13:15:00','2022-10-11 22:15:00','46.49.42.236','46.49.42.236','office','yes','no','2022-03-16 14:06:21','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(97,3,39,NULL,'2022-10-12 13:00:00','2022-10-12 17:00:00','67.56.103.214','67.56.103.214','office','no','no','2022-09-04 04:57:09','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(98,3,40,NULL,'2022-07-11 11:15:00','2022-07-11 12:15:00','71.17.192.181','71.17.192.181','office','yes','no','2022-01-29 22:45:04','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(99,3,28,NULL,'2022-10-01 13:10:00','2022-10-01 14:10:00','147.194.201.239','147.194.201.239','office','yes','no','2022-09-28 04:41:23','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(100,3,29,NULL,'2022-10-13 10:00:00','2022-10-13 14:00:00','160.119.168.202','160.119.168.202','office','no','no','2022-02-22 22:47:06','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(101,3,36,NULL,'2022-05-31 12:00:00','2022-05-31 14:00:00','148.169.241.232','148.169.241.232','office','yes','no','2022-04-11 08:01:40','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(102,3,37,NULL,'2022-10-02 09:00:00','2022-10-02 17:00:00','179.71.147.115','179.71.147.115','office','no','no','2022-04-10 16:05:29','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(103,3,38,NULL,'2022-10-16 09:10:00','2022-10-16 11:10:00','107.134.14.50','107.134.14.50','office','no','no','2022-08-06 13:42:11','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(104,3,39,NULL,'2022-09-15 13:00:00','2022-09-15 16:00:00','78.98.220.27','78.98.220.27','office','yes','no','2022-07-08 12:30:55','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other'),(105,3,40,NULL,'2022-10-03 12:00:00','2022-10-03 21:00:00','111.3.150.206','111.3.150.206','office','no','no','2022-05-02 00:22:03','2022-10-28 07:30:20',28,NULL,NULL,NULL,NULL,NULL,NULL,'other');
/*!40000 ALTER TABLE `attendances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `authorize_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `authorize_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned NOT NULL,
  `package_id` bigint unsigned NOT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_date` date DEFAULT NULL,
  `next_pay_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `authorize_invoices_company_id_foreign` (`company_id`),
  KEY `authorize_invoices_package_id_foreign` (`package_id`),
  CONSTRAINT `authorize_invoices_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `authorize_invoices_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `authorize_invoices` WRITE;
/*!40000 ALTER TABLE `authorize_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `authorize_invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `award_icons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `award_icons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `award_icons` WRITE;
/*!40000 ALTER TABLE `award_icons` DISABLE KEYS */;
INSERT INTO `award_icons` VALUES (1,'Trophy','trophy-fill','2022-10-28 07:30:06','2022-10-28 07:30:06'),(2,'Thumbs Up','hand-thumbs-up-fill','2022-10-28 07:30:06','2022-10-28 07:30:06'),(3,'Award','award-fill','2022-10-28 07:30:06','2022-10-28 07:30:06'),(4,'Book','book-fill','2022-10-28 07:30:06','2022-10-28 07:30:06'),(5,'Gift','gift-fill','2022-10-28 07:30:06','2022-10-28 07:30:06'),(6,'Watch','watch','2022-10-28 07:30:06','2022-10-28 07:30:06'),(7,'Cup','cup-hot-fill','2022-10-28 07:30:06','2022-10-28 07:30:06'),(8,'Puzzle','puzzle-fill','2022-10-28 07:30:06','2022-10-28 07:30:06'),(9,'Plane','airplane-fill','2022-10-28 07:30:06','2022-10-28 07:30:06'),(10,'Money','piggy-bank-fill','2022-10-28 07:30:06','2022-10-28 07:30:06');
/*!40000 ALTER TABLE `award_icons` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `awards`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `awards` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `award_icon_id` bigint unsigned DEFAULT NULL,
  `summary` text COLLATE utf8mb4_unicode_ci,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `color_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `awards_company_id_foreign` (`company_id`),
  KEY `awards_award_icon_id_foreign` (`award_icon_id`),
  CONSTRAINT `awards_award_icon_id_foreign` FOREIGN KEY (`award_icon_id`) REFERENCES `award_icons` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `awards_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `awards` WRITE;
/*!40000 ALTER TABLE `awards` DISABLE KEYS */;
/*!40000 ALTER TABLE `awards` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_categories_company_id_foreign` (`company_id`),
  CONSTRAINT `client_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_categories` WRITE;
/*!40000 ALTER TABLE `client_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_contacts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `contact_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_contacts_user_id_foreign` (`user_id`),
  KEY `client_contacts_added_by_foreign` (`added_by`),
  KEY `client_contacts_last_updated_by_foreign` (`last_updated_by`),
  KEY `client_contacts_company_id_foreign` (`company_id`),
  CONSTRAINT `client_contacts_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_contacts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_contacts_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_contacts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_contacts` WRITE;
/*!40000 ALTER TABLE `client_contacts` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_details` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `company_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `shipping_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `postal_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `office` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `linkedin` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facebook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `skype` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gst_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `category_id` bigint unsigned DEFAULT NULL,
  `sub_category_id` bigint unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_details_user_id_foreign` (`user_id`),
  KEY `client_details_category_id_foreign` (`category_id`),
  KEY `client_details_sub_category_id_foreign` (`sub_category_id`),
  KEY `client_details_added_by_foreign` (`added_by`),
  KEY `client_details_last_updated_by_foreign` (`last_updated_by`),
  KEY `client_details_company_id_foreign` (`company_id`),
  CONSTRAINT `client_details_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_details_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `client_categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_details_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_details_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_details_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `client_sub_categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_details_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_details` WRITE;
/*!40000 ALTER TABLE `client_details` DISABLE KEYS */;
INSERT INTO `client_details` VALUES (1,1,4,'Lehner PLC','510 Walter Station\nEast Paulton, OH 58797-1456',NULL,NULL,NULL,NULL,NULL,'http://orn.info/voluptatum-possimus-exercitationem-blanditiis-deleniti',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10',NULL,NULL,NULL,NULL),(2,1,5,'Shanahan, Steuber and Haley','506 Block Bridge Apt. 002\nCreolatown, WV 44951',NULL,NULL,NULL,NULL,NULL,'http://bogisich.com/occaecati-sequi-odit-qui-excepturi-odio-molestiae-at.html',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10',NULL,NULL,NULL,NULL),(3,1,6,'Daniel, Toy and Heathcote','2821 Christ Turnpike Apt. 457\nEast Darrentown, OH 03503-7497',NULL,NULL,NULL,NULL,NULL,'http://turcotte.com/',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10',NULL,NULL,NULL,NULL),(4,1,7,'Gleason-Beier','502 Thompson Dale\nNorth Vincenza, ME 94414',NULL,NULL,NULL,NULL,NULL,'http://www.windler.com/harum-enim-voluptas-dolor-quidem-sit-voluptatem-mollitia-officiis.html',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,NULL,NULL,NULL),(5,1,8,'Ledner, Weber and Lebsack','9787 McDermott Islands Suite 727\nMuellerville, TN 30412-3179',NULL,NULL,NULL,NULL,NULL,'http://trantow.org/animi-numquam-ea-saepe-consequatur-iure-soluta-nobis',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,NULL,NULL,NULL),(6,1,9,'Goodwin-Mitchell','9657 Wendy Mills\nEast Donavon, SC 94218-1082',NULL,NULL,NULL,NULL,NULL,'http://dare.com/in-fugiat-necessitatibus-harum-totam-quis-ad-quam',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,NULL,NULL,NULL),(7,2,17,'Waelchi-Hackett','136 Tyra Union\nNolanville, DC 28404',NULL,NULL,NULL,NULL,NULL,'http://durgan.org/exercitationem-perspiciatis-quos-repellendus-laborum-et-eligendi',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:14','2022-10-28 07:30:14',NULL,NULL,NULL,NULL),(8,2,18,'Fay-Lakin','134 Turcotte Rapid\nRoxanneview, WV 02019-6385',NULL,NULL,NULL,NULL,NULL,'https://schultz.info/distinctio-aut-et-tempora-tempora-rerum.html',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:14','2022-10-28 07:30:14',NULL,NULL,NULL,NULL),(9,2,19,'Wintheiser, Zieme and Hamill','1507 Wilhelm Walks\nLake Marjorie, MS 00681',NULL,NULL,NULL,NULL,NULL,'http://kertzmann.com/corporis-rerum-sunt-praesentium-atque-minima-dolorem',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:14','2022-10-28 07:30:14',NULL,NULL,NULL,NULL),(10,2,20,'Green-Blick','31645 Macie Groves Suite 087\nSouth Tod, CT 65063-4432',NULL,NULL,NULL,NULL,NULL,'http://oberbrunner.com/',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:14','2022-10-28 07:30:14',NULL,NULL,NULL,NULL),(11,2,21,'Willms Inc','81034 Bailey Parkways\nMaggioland, MT 11486-3252',NULL,NULL,NULL,NULL,NULL,'http://www.ferry.com/',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:14','2022-10-28 07:30:14',NULL,NULL,NULL,NULL),(12,2,22,'Bednar LLC','55197 Tromp Street Suite 616\nNorth Micaelaland, MD 59921',NULL,NULL,NULL,NULL,NULL,'http://greenfelder.biz/quod-iusto-amet-vero-doloribus-veritatis',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:14','2022-10-28 07:30:14',NULL,NULL,NULL,NULL),(13,3,30,'Marquardt Inc','3362 Janie Run Suite 059\nEast Bulahview, ID 36267-0991',NULL,NULL,NULL,NULL,NULL,'http://kohler.com/architecto-cumque-corrupti-quaerat-molestias-inventore-aut-dolor',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:17','2022-10-28 07:30:17',NULL,NULL,NULL,NULL),(14,3,31,'Roberts, Dietrich and O\'Keefe','60784 Cierra Fields\nManteland, NY 91780-9228',NULL,NULL,NULL,NULL,NULL,'http://www.romaguera.org/officiis-fugiat-sint-assumenda-odit.html',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:17','2022-10-28 07:30:17',NULL,NULL,NULL,NULL),(15,3,32,'Konopelski-Armstrong','50690 Gislason Fort\nPort Alfredo, ND 28376',NULL,NULL,NULL,NULL,NULL,'http://prohaska.biz/veniam-ea-nihil-est-velit-rerum-praesentium-mollitia.html',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:17','2022-10-28 07:30:17',NULL,NULL,NULL,NULL),(16,3,33,'Kuhic LLC','327 Wade Bypass Suite 916\nNew Victoria, DE 21054-9336',NULL,NULL,NULL,NULL,NULL,'http://www.huels.com/et-molestiae-nobis-inventore-aut',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:17','2022-10-28 07:30:17',NULL,NULL,NULL,NULL),(17,3,34,'McGlynn, Jast and Wolff','58257 Reyes Turnpike Apt. 295\nKemmerside, CO 54998-6836',NULL,NULL,NULL,NULL,NULL,'http://www.volkman.com/nam-necessitatibus-laboriosam-voluptas-id',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,NULL,NULL,NULL),(18,3,35,'Wuckert LLC','95901 Angela Coves\nLake Paulaton, UT 18497',NULL,NULL,NULL,NULL,NULL,'http://prohaska.biz/reiciendis-itaque-voluptatibus-sed-harum-necessitatibus',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `client_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_docs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_docs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_docs_user_id_foreign` (`user_id`),
  KEY `client_docs_added_by_foreign` (`added_by`),
  KEY `client_docs_last_updated_by_foreign` (`last_updated_by`),
  KEY `client_docs_company_id_foreign` (`company_id`),
  CONSTRAINT `client_docs_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_docs_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_docs_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_docs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_docs` WRITE;
/*!40000 ALTER TABLE `client_docs` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_docs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned DEFAULT NULL,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `member_id` int unsigned DEFAULT NULL,
  `is_client_show` tinyint(1) NOT NULL DEFAULT '0',
  `ask_password` tinyint(1) NOT NULL DEFAULT '0',
  `details` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_notes_client_id_foreign` (`client_id`),
  KEY `client_notes_member_id_foreign` (`member_id`),
  KEY `client_notes_added_by_foreign` (`added_by`),
  KEY `client_notes_last_updated_by_foreign` (`last_updated_by`),
  KEY `client_notes_company_id_foreign` (`company_id`),
  CONSTRAINT `client_notes_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_notes_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_notes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_notes_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_notes_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_notes` WRITE;
/*!40000 ALTER TABLE `client_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_sub_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_sub_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_id` bigint unsigned NOT NULL,
  `category_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_sub_categories_category_id_foreign` (`category_id`),
  KEY `client_sub_categories_company_id_foreign` (`company_id`),
  CONSTRAINT `client_sub_categories_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `client_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_sub_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_sub_categories` WRITE;
/*!40000 ALTER TABLE `client_sub_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_sub_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_user_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_user_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `client_note_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_user_notes_user_id_foreign` (`user_id`),
  KEY `client_user_notes_client_note_id_foreign` (`client_note_id`),
  KEY `client_user_notes_company_id_foreign` (`company_id`),
  CONSTRAINT `client_user_notes_client_note_id_foreign` FOREIGN KEY (`client_note_id`) REFERENCES `client_notes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_user_notes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_user_notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_user_notes` WRITE;
/*!40000 ALTER TABLE `client_user_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_user_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `companies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `companies` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `app_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_phone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `login_background` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `website` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `package_id` bigint unsigned DEFAULT NULL,
  `package_type` enum('monthly','annual') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'monthly',
  `timezone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Asia/Kolkata',
  `date_format` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'd-m-Y',
  `date_picker_format` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `year_starts_from` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `moment_format` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time_format` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h:i a',
  `locale` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `latitude` decimal(10,8) NOT NULL DEFAULT '26.91243360',
  `longitude` decimal(11,8) NOT NULL DEFAULT '75.78727090',
  `leaves_start_from` enum('joining_date','year_start') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'joining_date',
  `active_theme` enum('default','custom') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `last_updated_by` int unsigned DEFAULT NULL,
  `google_map_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `task_self` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `rounded_theme` tinyint(1) DEFAULT '1',
  `logo_background_color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#ffffff',
  `before_days` int NOT NULL,
  `after_days` int NOT NULL,
  `on_deadline` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `default_task_status` int unsigned DEFAULT NULL,
  `dashboard_clock` tinyint(1) NOT NULL DEFAULT '1',
  `ticket_form_google_captcha` tinyint(1) NOT NULL DEFAULT '0',
  `lead_form_google_captcha` tinyint(1) NOT NULL DEFAULT '0',
  `taskboard_length` int NOT NULL DEFAULT '10',
  `auth_theme` enum('dark','light') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'light',
  `light_logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sidebar_logo_style` enum('square','full') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'square',
  `allow_client_signup` tinyint(1) NOT NULL,
  `admin_client_signup_approval` tinyint(1) NOT NULL,
  `google_calendar_status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `google_client_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `google_client_secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `google_calendar_verification_status` enum('verified','non_verified') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'non_verified',
  `google_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `rtl` tinyint(1) NOT NULL DEFAULT '0',
  `stripe_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_brand` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_last_four` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trial_ends_at` timestamp NULL DEFAULT NULL,
  `licence_expire_on` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `organisation_settings_currency_id_foreign` (`currency_id`),
  KEY `organisation_settings_last_updated_by_foreign` (`last_updated_by`),
  KEY `organisation_settings_default_task_status_foreign` (`default_task_status`),
  KEY `companies_package_id_foreign` (`package_id`),
  CONSTRAINT `companies_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `organisation_settings_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `organisation_settings_default_task_status_foreign` FOREIGN KEY (`default_task_status`) REFERENCES `taskboard_columns` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `organisation_settings_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `companies` WRITE;
/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` VALUES (1,'Worksuite','Worksuite','company@email.com','1234567891',NULL,NULL,'Your Company address here','https://worksuite.biz',1,1,'monthly','America/New_York','d-m-Y','dd-mm-yyyy','1','DD-MM-YYYY','h:i a','en',26.91243360,75.78727090,'joining_date','default','active',2,NULL,'yes',1,'#FFFFFF',0,0,'yes',1,0,0,0,10,'light',NULL,'square',0,0,'inactive',NULL,NULL,'non_verified',NULL,NULL,NULL,'BOC542w6nQfwWdv0CtM82HKdXdxKPl1v','2022-10-28 07:30:07','2022-10-31 02:28:46',NULL,0,NULL,NULL,NULL,NULL,NULL),(2,'Mooney Rosales Traders','Kerluke-Funk','rerdman@example.com','240-626-1744',NULL,NULL,'66882 Ferry Meadow\nPort Maximillian, CO 35454','https://www.parker.com/excepturi-sit-et-qui',5,1,'monthly','Asia/Kolkata','d-m-Y','dd-mm-yyyy','1','DD-MM-YYYY','h:i a','en',26.91243360,75.78727090,'joining_date','default','active',15,NULL,'yes',1,'#ffffff',0,0,'yes',5,1,0,0,10,'light','29ab3385d321e5355a738f16ff4d08eb.png','square',0,0,'inactive',NULL,NULL,'non_verified',NULL,NULL,NULL,'tY6uMKZuuBtOrr4wac6LQPcigEXdAUia','2022-10-28 07:30:08','2022-10-31 02:03:03',NULL,0,NULL,NULL,NULL,NULL,NULL),(3,'Cummerata, Langworth and Aufderhar','Cummerata, Langworth and Aufderhar','lbergstrom@example.net','602-741-0070',NULL,NULL,'18199 Spinka Garden\nPort Myrtieside, LA 28881','http://erdman.org/eius-et-cumque-sunt-omnis-ipsa-optio-culpa.html',9,1,'monthly','Asia/Kolkata','d-m-Y','dd-mm-yyyy','1','DD-MM-YYYY','h:i a','en',26.91243360,75.78727090,'joining_date','default','active',NULL,NULL,'yes',1,'#ffffff',0,0,'yes',9,1,0,0,10,'light',NULL,'square',0,0,'inactive',NULL,NULL,'non_verified',NULL,NULL,NULL,'YHzEsVrNdXCLsQ0AqdUsyf6aVRHhL0NV','2022-10-28 07:30:09','2022-10-28 07:30:10',NULL,0,NULL,NULL,NULL,NULL,NULL),(4,'Jenkins Horn Trading','Jenkins Horn Trading','bymusihe@mailinator.com',NULL,NULL,NULL,'sdad',NULL,13,1,'monthly','Africa/Abidjan','d-m-Y','dd-mm-yyyy','1','DD-MM-YYYY','h:i a','en',26.91243360,75.78727090,'joining_date','default','active',1,NULL,'yes',1,'#ffffff',0,0,'yes',13,1,0,0,10,'light',NULL,'square',0,0,'inactive',NULL,NULL,'non_verified',NULL,NULL,NULL,'WHoYMuFfEMj9FBgYRzMxPbLfZw1JyKWb','2022-10-28 07:34:31','2022-10-28 07:34:33',NULL,0,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `company_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `company_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `address` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL,
  `tax_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_addresses_company_id_foreign` (`company_id`),
  CONSTRAINT `company_addresses_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `company_addresses` WRITE;
/*!40000 ALTER TABLE `company_addresses` DISABLE KEYS */;
INSERT INTO `company_addresses` VALUES (1,1,'Your Company address here',1,NULL,NULL,'Worksuite','2022-10-28 07:30:07','2022-10-28 07:30:07'),(2,2,'66882 Ferry Meadow\nPort Maximillian, CO 35454',1,NULL,NULL,'Kerluke-Funk','2022-10-28 07:30:08','2022-10-28 07:30:08'),(3,3,'18199 Spinka Garden\nPort Myrtieside, LA 28881',1,NULL,NULL,'Cummerata, Langworth and Aufderhar','2022-10-28 07:30:09','2022-10-28 07:30:09'),(4,4,'sdad',1,NULL,NULL,'Jenkins Horn Trading','2022-10-28 07:34:31','2022-10-28 07:34:31');
/*!40000 ALTER TABLE `company_addresses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_discussions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_discussions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `contract_id` bigint unsigned NOT NULL,
  `from` int unsigned NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_discussions_contract_id_foreign` (`contract_id`),
  KEY `contract_discussions_from_foreign` (`from`),
  KEY `contract_discussions_added_by_foreign` (`added_by`),
  KEY `contract_discussions_last_updated_by_foreign` (`last_updated_by`),
  KEY `contract_discussions_company_id_foreign` (`company_id`),
  CONSTRAINT `contract_discussions_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contract_discussions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_discussions_contract_id_foreign` FOREIGN KEY (`contract_id`) REFERENCES `contracts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_discussions_from_foreign` FOREIGN KEY (`from`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_discussions_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_discussions` WRITE;
/*!40000 ALTER TABLE `contract_discussions` DISABLE KEYS */;
/*!40000 ALTER TABLE `contract_discussions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `contract_id` bigint unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `google_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `dropbox_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `external_link_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_files_user_id_foreign` (`user_id`),
  KEY `contract_files_contract_id_foreign` (`contract_id`),
  KEY `contract_files_added_by_foreign` (`added_by`),
  KEY `contract_files_last_updated_by_foreign` (`last_updated_by`),
  KEY `contract_files_company_id_foreign` (`company_id`),
  CONSTRAINT `contract_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contract_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_files_contract_id_foreign` FOREIGN KEY (`contract_id`) REFERENCES `contracts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contract_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_files` WRITE;
/*!40000 ALTER TABLE `contract_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `contract_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_renews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_renews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `renewed_by` int unsigned NOT NULL,
  `contract_id` bigint unsigned NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_renews_renewed_by_foreign` (`renewed_by`),
  KEY `contract_renews_contract_id_foreign` (`contract_id`),
  KEY `contract_renews_added_by_foreign` (`added_by`),
  KEY `contract_renews_last_updated_by_foreign` (`last_updated_by`),
  KEY `contract_renews_company_id_foreign` (`company_id`),
  CONSTRAINT `contract_renews_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contract_renews_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_renews_contract_id_foreign` FOREIGN KEY (`contract_id`) REFERENCES `contracts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_renews_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contract_renews_renewed_by_foreign` FOREIGN KEY (`renewed_by`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_renews` WRITE;
/*!40000 ALTER TABLE `contract_renews` DISABLE KEYS */;
/*!40000 ALTER TABLE `contract_renews` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_signs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_signs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `contract_id` bigint unsigned NOT NULL,
  `full_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `signature` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_signs_contract_id_foreign` (`contract_id`),
  KEY `contract_signs_company_id_foreign` (`company_id`),
  CONSTRAINT `contract_signs_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_signs_contract_id_foreign` FOREIGN KEY (`contract_id`) REFERENCES `contracts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_signs` WRITE;
/*!40000 ALTER TABLE `contract_signs` DISABLE KEYS */;
/*!40000 ALTER TABLE `contract_signs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_templates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contract_type_id` bigint unsigned NOT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `contract_detail` longtext COLLATE utf8mb4_unicode_ci,
  `added_by` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_templates_contract_type_id_foreign` (`contract_type_id`),
  KEY `contract_templates_currency_id_foreign` (`currency_id`),
  KEY `contract_templates_company_id_foreign` (`company_id`),
  CONSTRAINT `contract_templates_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_templates_contract_type_id_foreign` FOREIGN KEY (`contract_type_id`) REFERENCES `contract_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_templates_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_templates` WRITE;
/*!40000 ALTER TABLE `contract_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `contract_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_types_company_id_foreign` (`company_id`),
  CONSTRAINT `contract_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_types` WRITE;
/*!40000 ALTER TABLE `contract_types` DISABLE KEYS */;
INSERT INTO `contract_types` VALUES (1,1,'Adhesion Contracts','2022-10-28 07:30:12','2022-10-28 07:30:12'),(2,1,'Aleatory Contracts','2022-10-28 07:30:12','2022-10-28 07:30:12'),(3,1,'Bilateral and Unilateral Contracts','2022-10-28 07:30:12','2022-10-28 07:30:12'),(4,1,'Contracts under Seal','2022-10-28 07:30:12','2022-10-28 07:30:12'),(5,1,'Executed and Executory Contracts','2022-10-28 07:30:12','2022-10-28 07:30:12'),(6,1,'Express Contracts','2022-10-28 07:30:12','2022-10-28 07:30:12'),(7,1,'Implied Contracts','2022-10-28 07:30:12','2022-10-28 07:30:12'),(8,1,'Unconscionable Contracts','2022-10-28 07:30:12','2022-10-28 07:30:12'),(9,1,'Void and Voidable Contracts','2022-10-28 07:30:12','2022-10-28 07:30:12'),(10,2,'Adhesion Contracts','2022-10-28 07:30:16','2022-10-28 07:30:16'),(11,2,'Aleatory Contracts','2022-10-28 07:30:16','2022-10-28 07:30:16'),(12,2,'Bilateral and Unilateral Contracts','2022-10-28 07:30:16','2022-10-28 07:30:16'),(13,2,'Contracts under Seal','2022-10-28 07:30:16','2022-10-28 07:30:16'),(14,2,'Executed and Executory Contracts','2022-10-28 07:30:16','2022-10-28 07:30:16'),(15,2,'Express Contracts','2022-10-28 07:30:16','2022-10-28 07:30:16'),(16,2,'Implied Contracts','2022-10-28 07:30:16','2022-10-28 07:30:16'),(17,2,'Unconscionable Contracts','2022-10-28 07:30:16','2022-10-28 07:30:16'),(18,2,'Void and Voidable Contracts','2022-10-28 07:30:16','2022-10-28 07:30:16'),(19,3,'Adhesion Contracts','2022-10-28 07:30:19','2022-10-28 07:30:19'),(20,3,'Aleatory Contracts','2022-10-28 07:30:19','2022-10-28 07:30:19'),(21,3,'Bilateral and Unilateral Contracts','2022-10-28 07:30:19','2022-10-28 07:30:19'),(22,3,'Contracts under Seal','2022-10-28 07:30:19','2022-10-28 07:30:19'),(23,3,'Executed and Executory Contracts','2022-10-28 07:30:19','2022-10-28 07:30:19'),(24,3,'Express Contracts','2022-10-28 07:30:19','2022-10-28 07:30:19'),(25,3,'Implied Contracts','2022-10-28 07:30:19','2022-10-28 07:30:19'),(26,3,'Unconscionable Contracts','2022-10-28 07:30:19','2022-10-28 07:30:19'),(27,3,'Void and Voidable Contracts','2022-10-28 07:30:19','2022-10-28 07:30:19');
/*!40000 ALTER TABLE `contract_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contracts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contracts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned NOT NULL,
  `subject` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_amount` decimal(15,2) NOT NULL,
  `contract_type_id` bigint unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `original_start_date` date NOT NULL,
  `end_date` date DEFAULT NULL,
  `original_end_date` date DEFAULT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `contract_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_address` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cell` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `office` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contract_detail` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `hash` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `currency_id` int unsigned DEFAULT NULL,
  `event_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `contracts_client_id_foreign` (`client_id`),
  KEY `contracts_contract_type_id_foreign` (`contract_type_id`),
  KEY `contracts_added_by_foreign` (`added_by`),
  KEY `contracts_last_updated_by_foreign` (`last_updated_by`),
  KEY `contracts_currency_id_foreign` (`currency_id`),
  KEY `contracts_company_id_foreign` (`company_id`),
  CONSTRAINT `contracts_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contracts_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contracts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contracts_contract_type_id_foreign` FOREIGN KEY (`contract_type_id`) REFERENCES `contract_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contracts_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contracts_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contracts` WRITE;
/*!40000 ALTER TABLE `contracts` DISABLE KEYS */;
INSERT INTO `contracts` VALUES (1,1,4,'Lobster Quadrille.','593',593.00,4,'2022-10-25','2022-10-25','2023-03-28','2023-03-28','Sed velit voluptatem dolores voluptates molestiae ratione consectetur. Quis natus temporibus illum nam eveniet. Qui officiis molestiae et temporibus deleniti. Maiores ea sed officia error neque.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Alice glanced rather anxiously at the door that led into the air off all its feet at once, she found a little door into that lovely garden. I think I must be growing small again.\' She got up this morning? I almost wish I had it written down: but I shall ever see such a nice little histories about.','2022-10-28 07:30:12','2022-10-28 07:30:12',2,NULL,'0scjjBB9QuyjsfqpI2Gc1oe5yD8vXVvo',1,NULL),(2,1,4,'Hatter. \'You might.','353',353.00,4,'2022-10-20','2022-10-20','2022-11-28','2022-11-28','Quo a et sunt quae rerum pariatur necessitatibus. Molestias maiores quaerat neque exercitationem fugiat et optio. Ut voluptas in molestiae illo.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Alice was more than nine feet high. \'I wish I hadn\'t mentioned Dinah!\' she said this, she came upon a time she saw them, they were nice grand words to say.) Presently she began thinking over all the time he was speaking, and this was his first remark, \'It was the Cat went on, \'--likely to win.','2022-10-28 07:30:12','2022-10-28 07:30:12',2,NULL,'LvvfFKElGGgqTWGD1bdtWqqCyYrz8pqx',1,NULL),(3,1,4,'Alice, swallowing.','915',915.00,8,'2022-10-23','2022-10-23','2023-02-28','2023-02-28','Veniam fugiat quae quod quaerat perferendis deleniti. Dignissimos non iste amet autem. Doloremque minus est omnis.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'An obstacle that came between Him, and ourselves, and it. Don\'t let me help to undo it!\' \'I shall sit here,\' the Footman continued in the air. Even the Duchess was sitting on a three-legged stool in the chimney as she could, and waited till the Pigeon in a sulky tone; \'Seven jogged my elbow.\' On.','2022-10-28 07:30:12','2022-10-28 07:30:12',2,NULL,'JKzNyZdKmpJ1zjxntzr3famhp0TXlFBt',1,NULL),(4,1,6,'The Antipathies, I.','362',362.00,6,'2022-10-28','2022-10-28','2023-03-28','2023-03-28','Qui culpa consequuntur impedit officia quidem placeat. Qui necessitatibus est blanditiis eum illo aut officia et. Eum aperiam tempore natus repellendus. Voluptas adipisci temporibus ad aperiam et sint facere.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Dodo suddenly called out as loud as she could see her after the rest of the song, perhaps?\' \'I\'ve heard something like it,\' said Alice, (she had grown to her full size by this very sudden change, but she got back to finish his story. CHAPTER IV. The Rabbit started violently, dropped the white kid.','2022-10-28 07:30:12','2022-10-28 07:30:12',2,NULL,'nXbabm4WwrXtRQZrNVX63dRWBKJa5tNF',1,NULL),(5,1,6,'Queen, stamping on.','152',152.00,1,'2022-10-16','2022-10-16','2023-03-28','2023-03-28','Perspiciatis nemo tempore vitae voluptatum. Aut sed repudiandae magni modi. Iste deleniti qui consequatur recusandae.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Alice had been looking over their shoulders, that all the rats and--oh dear!\' cried Alice (she was rather glad there WAS no one to listen to her. The Cat seemed to think about stopping herself before she made out what it was labelled \'ORANGE MARMALADE\', but to her ear. \'You\'re thinking about.','2022-10-28 07:30:12','2022-10-28 07:30:12',2,NULL,'Hq8wrX1MKFKKIyTte3RJzJ7WyrN8qe20',1,NULL),(6,2,19,'He moved on as he.','437',437.00,16,'2022-10-05','2022-10-05','2023-03-28','2023-03-28','Vel laboriosam et natus maiores quae. Qui suscipit possimus et dolores. Repellendus sequi eum accusamus laborum dolorem necessitatibus sit.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'I\'ll kick you down stairs!\' \'That is not said right,\' said the White Rabbit, \'and that\'s why. Pig!\' She said the Hatter. \'He won\'t stand beating. Now, if you only kept on good terms with him, he\'d do almost anything you liked with the Dormouse. \'Fourteenth of March, I think I can go back and see.','2022-10-28 07:30:16','2022-10-28 07:30:16',15,NULL,'Y3WWh0pz4KRZXx0u8K7oVdH97oZpM8T7',5,NULL),(7,2,19,'Hatter. \'He won\'t.','346',346.00,13,'2022-10-16','2022-10-16','2023-02-28','2023-02-28','Nemo voluptatem corporis eum vel. Laboriosam unde dolor iste velit nobis. Cumque veniam ex adipisci aliquid officia nisi nihil. Officiis quis ut totam quo et.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'That he met in the wood, \'is to grow larger again, and Alice rather unwillingly took the hookah out of sight: then it watched the White Rabbit hurried by--the frightened Mouse splashed his way through the little golden key, and when she looked back once or twice, and shook itself. Then it got down.','2022-10-28 07:30:16','2022-10-28 07:30:16',15,NULL,'rkmDouK8mdoCO9oBCpZ59mJTuNoL9F0O',5,NULL),(8,2,20,'I get SOMEWHERE,\'.','945',945.00,12,'2022-10-10','2022-10-10','2022-11-28','2022-11-28','Ratione consequatur rerum laborum enim est ut. Ex qui nihil sunt omnis laboriosam. Commodi nesciunt et ut magnam velit ducimus. Aut ullam dolor mollitia numquam voluptates a qui.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'I\'ve had such a dreadful time.\' So Alice began to cry again, for this time the Queen had only one who got any advantage from the sky! Ugh, Serpent!\' \'But I\'m not myself, you see.\' \'I don\'t know what they\'re like.\' \'I believe so,\' Alice replied in an offended tone, \'was, that the Queen was silent.','2022-10-28 07:30:16','2022-10-28 07:30:16',15,NULL,'t3DHfhAIysRkOGjX1fK9wC2K2y6xvsR7',5,NULL),(9,2,21,'Alice to herself.','603',603.00,12,'2022-10-19','2022-10-19','2022-12-28','2022-12-28','Laudantium dolor dolorum illo nisi facere. Possimus error rerum et aut aut laborum.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Queen added to one of them didn\'t know that you\'re mad?\' \'To begin with,\' the Mock Turtle: \'crumbs would all come wrong, and she dropped it hastily, just in time to hear the Rabbit asked. \'No, I give you fair warning,\' shouted the Queen, the royal children, and everybody else. \'Leave off that!\'.','2022-10-28 07:30:16','2022-10-28 07:30:16',15,NULL,'VsfoyjBFdhc0fN1mIUIcFvVym5wvM9rP',5,NULL),(10,2,18,'SAID was, \'Why is.','622',622.00,14,'2022-10-26','2022-10-26','2023-03-28','2023-03-28','Molestiae mollitia voluptatem ab qui. Et quod error inventore. Beatae rerum quia minima cupiditate velit.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'YOUR temper!\' \'Hold your tongue, Ma!\' said the Hatter, who turned pale and fidgeted. \'Give your evidence,\' the King said to herself \'It\'s the Cheshire Cat, she was losing her temper. \'Are you content now?\' said the Hatter. Alice felt a very decided tone: \'tell her something worth hearing. For some.','2022-10-28 07:30:16','2022-10-28 07:30:16',15,NULL,'y05l58shgDYUin2Ebmgjyk7dO7X8uMOa',5,NULL),(11,3,30,'Gryphon. \'I mean.','764',764.00,25,'2022-10-25','2022-10-25','2023-02-28','2023-02-28','Beatae quam necessitatibus consequatur unde. Et eveniet et non sed provident possimus. Omnis sint sit assumenda distinctio. Et sunt dicta debitis qui ipsam neque quia.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Caterpillar; and it set to work very diligently to write out a box of comfits, (luckily the salt water had not attended to this last remark. \'Of course they were\', said the Mock Turtle went on. \'I do,\' Alice said nothing; she had caught the flamingo and brought it back, the fight was over, and she.','2022-10-28 07:30:19','2022-10-28 07:30:19',28,NULL,'J8YXhMkkl7aTjAGp2L3a1SmUBQq31mLN',9,NULL),(12,3,30,'Alice asked in a.','860',860.00,19,'2022-10-23','2022-10-23','2022-11-28','2022-11-28','Dolores porro consequatur architecto atque aut. Consectetur dolorem adipisci eum quaerat sunt et minus. Reiciendis unde commodi commodi provident facere voluptas.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Tortoise--\' \'Why did you do either!\' And the executioner myself,\' said the Caterpillar, and the shrill voice of thunder, and people began running when they had to do such a wretched height to rest herself, and nibbled a little of her age knew the right way to explain the paper. \'If there\'s no name.','2022-10-28 07:30:19','2022-10-28 07:30:19',28,NULL,'9mRFLsRvkm3IbhNpTj6HwwoIFFa0jtg4',9,NULL),(13,3,31,'I say,\' the Mock.','265',265.00,25,'2022-10-06','2022-10-06','2022-11-28','2022-11-28','Inventore culpa explicabo fuga aut exercitationem accusantium repudiandae. Tempore id velit quasi ut aut. Et magnam iste quidem eos at molestias ut. Dicta tempora autem voluptatem possimus mollitia neque rerum.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Hatter was out of its mouth, and its great eyes half shut. This seemed to be told so. \'It\'s really dreadful,\' she muttered to herself, as well as if a fish came to the croquet-ground. The other side will make you grow taller, and the Dormouse shall!\' they both cried. \'Wake up, Alice dear!\' said.','2022-10-28 07:30:19','2022-10-28 07:30:19',28,NULL,'Qi0EUvxjMVdIUGJzfmQggnQCOqTN4hDN',9,NULL),(14,3,35,'Hatter, and, just.','310',310.00,20,'2022-09-30','2022-09-30','2023-03-28','2023-03-28','Dolor dolores et ratione saepe optio accusantium. Odit commodi corrupti fugit ex at ut rerum. Porro amet velit nulla mollitia qui omnis.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'And she\'s such a fall as this, I shall ever see such a thing before, but she stopped hastily, for the accident of the accident, all except the Lizard, who seemed to be true): If she should push the matter with it. There was a dead silence. \'It\'s a pun!\' the King sharply. \'Do you take me for.','2022-10-28 07:30:19','2022-10-28 07:30:19',28,NULL,'xVfoHjJsSNZEWBDMVOx5ttmSAbtRGj3I',9,NULL),(15,3,32,'Do come back with.','920',920.00,23,'2022-10-04','2022-10-04','2023-01-28','2023-01-28','Numquam rerum eum iure ad. Aut voluptatum quos corrupti sit veritatis. Harum amet aut quos dolore veritatis et voluptatem accusantium. Et aut quis placeat.',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Alice, thinking it was the White Rabbit; \'in fact, there\'s nothing written on the top of her little sister\'s dream. The long grass rustled at her feet in a sorrowful tone; \'at least there\'s no use denying it. I suppose I ought to eat or drink under the door; so either way I\'ll get into her.','2022-10-28 07:30:19','2022-10-28 07:30:19',28,NULL,'BeOJ7jAGcPaNsAGygHcpyLBo9EmGFItJ',9,NULL);
/*!40000 ALTER TABLE `contracts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `conversation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `conversation` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_one` int unsigned NOT NULL,
  `user_two` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conversation_user_one_foreign` (`user_one`),
  KEY `conversation_user_two_foreign` (`user_two`),
  KEY `conversation_company_id_foreign` (`company_id`),
  CONSTRAINT `conversation_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `conversation_user_one_foreign` FOREIGN KEY (`user_one`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `conversation_user_two_foreign` FOREIGN KEY (`user_two`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `conversation` WRITE;
/*!40000 ALTER TABLE `conversation` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversation` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `conversation_reply`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `conversation_reply` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `conversation_id` int unsigned NOT NULL,
  `reply` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conversation_reply_conversation_id_foreign` (`conversation_id`),
  KEY `conversation_reply_user_id_foreign` (`user_id`),
  KEY `conversation_reply_company_id_foreign` (`company_id`),
  CONSTRAINT `conversation_reply_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `conversation_reply_conversation_id_foreign` FOREIGN KEY (`conversation_id`) REFERENCES `conversation` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `conversation_reply_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `conversation_reply` WRITE;
/*!40000 ALTER TABLE `conversation_reply` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversation_reply` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `iso` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nicename` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `iso3` char(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numcode` smallint DEFAULT NULL,
  `phonecode` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'AF','AFGHANISTAN','Afghanistan','AFG',4,93),(2,'AL','ALBANIA','Albania','ALB',8,355),(3,'DZ','ALGERIA','Algeria','DZA',12,213),(4,'AS','AMERICAN SAMOA','American Samoa','ASM',16,1684),(5,'AD','ANDORRA','Andorra','AND',20,376),(6,'AO','ANGOLA','Angola','AGO',24,244),(7,'AI','ANGUILLA','Anguilla','AIA',660,1264),(8,'AQ','ANTARCTICA','Antarctica',NULL,NULL,0),(9,'AG','ANTIGUA AND BARBUDA','Antigua and Barbuda','ATG',28,1268),(10,'AR','ARGENTINA','Argentina','ARG',32,54),(11,'AM','ARMENIA','Armenia','ARM',51,374),(12,'AW','ARUBA','Aruba','ABW',533,297),(13,'AU','AUSTRALIA','Australia','AUS',36,61),(14,'AT','AUSTRIA','Austria','AUT',40,43),(15,'AZ','AZERBAIJAN','Azerbaijan','AZE',31,994),(16,'BS','BAHAMAS','Bahamas','BHS',44,1242),(17,'BH','BAHRAIN','Bahrain','BHR',48,973),(18,'BD','BANGLADESH','Bangladesh','BGD',50,880),(19,'BB','BARBADOS','Barbados','BRB',52,1246),(20,'BY','BELARUS','Belarus','BLR',112,375),(21,'BE','BELGIUM','Belgium','BEL',56,32),(22,'BZ','BELIZE','Belize','BLZ',84,501),(23,'BJ','BENIN','Benin','BEN',204,229),(24,'BM','BERMUDA','Bermuda','BMU',60,1441),(25,'BT','BHUTAN','Bhutan','BTN',64,975),(26,'BO','BOLIVIA','Bolivia','BOL',68,591),(27,'BA','BOSNIA AND HERZEGOVINA','Bosnia and Herzegovina','BIH',70,387),(28,'BW','BOTSWANA','Botswana','BWA',72,267),(29,'BV','BOUVET ISLAND','Bouvet Island',NULL,NULL,0),(30,'BR','BRAZIL','Brazil','BRA',76,55),(31,'IO','BRITISH INDIAN OCEAN TERRITORY','British Indian Ocean Territory',NULL,NULL,246),(32,'BN','BRUNEI DARUSSALAM','Brunei Darussalam','BRN',96,673),(33,'BG','BULGARIA','Bulgaria','BGR',100,359),(34,'BF','BURKINA FASO','Burkina Faso','BFA',854,226),(35,'BI','BURUNDI','Burundi','BDI',108,257),(36,'KH','CAMBODIA','Cambodia','KHM',116,855),(37,'CM','CAMEROON','Cameroon','CMR',120,237),(38,'CA','CANADA','Canada','CAN',124,1),(39,'CV','CAPE VERDE','Cape Verde','CPV',132,238),(40,'KY','CAYMAN ISLANDS','Cayman Islands','CYM',136,1345),(41,'CF','CENTRAL AFRICAN REPUBLIC','Central African Republic','CAF',140,236),(42,'TD','CHAD','Chad','TCD',148,235),(43,'CL','CHILE','Chile','CHL',152,56),(44,'CN','CHINA','China','CHN',156,86),(45,'CX','CHRISTMAS ISLAND','Christmas Island',NULL,NULL,61),(46,'CC','COCOS (KEELING) ISLANDS','Cocos (Keeling) Islands',NULL,NULL,672),(47,'CO','COLOMBIA','Colombia','COL',170,57),(48,'KM','COMOROS','Comoros','COM',174,269),(49,'CG','CONGO','Congo','COG',178,242),(50,'CD','CONGO, THE DEMOCRATIC REPUBLIC OF THE','Congo, the Democratic Republic of the','COD',180,242),(51,'CK','COOK ISLANDS','Cook Islands','COK',184,682),(52,'CR','COSTA RICA','Costa Rica','CRI',188,506),(53,'CI','COTE D\'IVOIRE','Cote D\'Ivoire','CIV',384,225),(54,'HR','CROATIA','Croatia','HRV',191,385),(55,'CU','CUBA','Cuba','CUB',192,53),(56,'CY','CYPRUS','Cyprus','CYP',196,357),(57,'CZ','CZECH REPUBLIC','Czech Republic','CZE',203,420),(58,'DK','DENMARK','Denmark','DNK',208,45),(59,'DJ','DJIBOUTI','Djibouti','DJI',262,253),(60,'DM','DOMINICA','Dominica','DMA',212,1767),(61,'DO','DOMINICAN REPUBLIC','Dominican Republic','DOM',214,1809),(62,'EC','ECUADOR','Ecuador','ECU',218,593),(63,'EG','EGYPT','Egypt','EGY',818,20),(64,'SV','EL SALVADOR','El Salvador','SLV',222,503),(65,'GQ','EQUATORIAL GUINEA','Equatorial Guinea','GNQ',226,240),(66,'ER','ERITREA','Eritrea','ERI',232,291),(67,'EE','ESTONIA','Estonia','EST',233,372),(68,'ET','ETHIOPIA','Ethiopia','ETH',231,251),(69,'FK','FALKLAND ISLANDS (MALVINAS)','Falkland Islands (Malvinas)','FLK',238,500),(70,'FO','FAROE ISLANDS','Faroe Islands','FRO',234,298),(71,'FJ','FIJI','Fiji','FJI',242,679),(72,'FI','FINLAND','Finland','FIN',246,358),(73,'FR','FRANCE','France','FRA',250,33),(74,'GF','FRENCH GUIANA','French Guiana','GUF',254,594),(75,'PF','FRENCH POLYNESIA','French Polynesia','PYF',258,689),(76,'TF','FRENCH SOUTHERN TERRITORIES','French Southern Territories',NULL,NULL,0),(77,'GA','GABON','Gabon','GAB',266,241),(78,'GM','GAMBIA','Gambia','GMB',270,220),(79,'GE','GEORGIA','Georgia','GEO',268,995),(80,'DE','GERMANY','Germany','DEU',276,49),(81,'GH','GHANA','Ghana','GHA',288,233),(82,'GI','GIBRALTAR','Gibraltar','GIB',292,350),(83,'GR','GREECE','Greece','GRC',300,30),(84,'GL','GREENLAND','Greenland','GRL',304,299),(85,'GD','GRENADA','Grenada','GRD',308,1473),(86,'GP','GUADELOUPE','Guadeloupe','GLP',312,590),(87,'GU','GUAM','Guam','GUM',316,1671),(88,'GT','GUATEMALA','Guatemala','GTM',320,502),(89,'GN','GUINEA','Guinea','GIN',324,224),(90,'GW','GUINEA-BISSAU','Guinea-Bissau','GNB',624,245),(91,'GY','GUYANA','Guyana','GUY',328,592),(92,'HT','HAITI','Haiti','HTI',332,509),(93,'HM','HEARD ISLAND AND MCDONALD ISLANDS','Heard Island and Mcdonald Islands',NULL,NULL,0),(94,'VA','HOLY SEE (VATICAN CITY STATE)','Holy See (Vatican City State)','VAT',336,39),(95,'HN','HONDURAS','Honduras','HND',340,504),(96,'HK','HONG KONG','Hong Kong','HKG',344,852),(97,'HU','HUNGARY','Hungary','HUN',348,36),(98,'IS','ICELAND','Iceland','ISL',352,354),(99,'IN','INDIA','India','IND',356,91),(100,'ID','INDONESIA','Indonesia','IDN',360,62),(101,'IR','IRAN, ISLAMIC REPUBLIC OF','Iran, Islamic Republic of','IRN',364,98),(102,'IQ','IRAQ','Iraq','IRQ',368,964),(103,'IE','IRELAND','Ireland','IRL',372,353),(104,'IL','ISRAEL','Israel','ISR',376,972),(105,'IT','ITALY','Italy','ITA',380,39),(106,'JM','JAMAICA','Jamaica','JAM',388,1876),(107,'JP','JAPAN','Japan','JPN',392,81),(108,'JO','JORDAN','Jordan','JOR',400,962),(109,'KZ','KAZAKHSTAN','Kazakhstan','KAZ',398,7),(110,'KE','KENYA','Kenya','KEN',404,254),(111,'KI','KIRIBATI','Kiribati','KIR',296,686),(112,'KP','KOREA, DEMOCRATIC PEOPLE\'S REPUBLIC OF','Korea, Democratic People\'s Republic of','PRK',408,850),(113,'KR','KOREA, REPUBLIC OF','Korea, Republic of','KOR',410,82),(114,'KW','KUWAIT','Kuwait','KWT',414,965),(115,'KG','KYRGYZSTAN','Kyrgyzstan','KGZ',417,996),(116,'LA','LAO PEOPLE\'S DEMOCRATIC REPUBLIC','Lao People\'s Democratic Republic','LAO',418,856),(117,'LV','LATVIA','Latvia','LVA',428,371),(118,'LB','LEBANON','Lebanon','LBN',422,961),(119,'LS','LESOTHO','Lesotho','LSO',426,266),(120,'LR','LIBERIA','Liberia','LBR',430,231),(121,'LY','LIBYAN ARAB JAMAHIRIYA','Libyan Arab Jamahiriya','LBY',434,218),(122,'LI','LIECHTENSTEIN','Liechtenstein','LIE',438,423),(123,'LT','LITHUANIA','Lithuania','LTU',440,370),(124,'LU','LUXEMBOURG','Luxembourg','LUX',442,352),(125,'MO','MACAO','Macao','MAC',446,853),(126,'MK','MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF','Macedonia, the Former Yugoslav Republic of','MKD',807,389),(127,'MG','MADAGASCAR','Madagascar','MDG',450,261),(128,'MW','MALAWI','Malawi','MWI',454,265),(129,'MY','MALAYSIA','Malaysia','MYS',458,60),(130,'MV','MALDIVES','Maldives','MDV',462,960),(131,'ML','MALI','Mali','MLI',466,223),(132,'MT','MALTA','Malta','MLT',470,356),(133,'MH','MARSHALL ISLANDS','Marshall Islands','MHL',584,692),(134,'MQ','MARTINIQUE','Martinique','MTQ',474,596),(135,'MR','MAURITANIA','Mauritania','MRT',478,222),(136,'MU','MAURITIUS','Mauritius','MUS',480,230),(137,'YT','MAYOTTE','Mayotte',NULL,NULL,269),(138,'MX','MEXICO','Mexico','MEX',484,52),(139,'FM','MICRONESIA, FEDERATED STATES OF','Micronesia, Federated States of','FSM',583,691),(140,'MD','MOLDOVA, REPUBLIC OF','Moldova, Republic of','MDA',498,373),(141,'MC','MONACO','Monaco','MCO',492,377),(142,'MN','MONGOLIA','Mongolia','MNG',496,976),(143,'MS','MONTSERRAT','Montserrat','MSR',500,1664),(144,'MA','MOROCCO','Morocco','MAR',504,212),(145,'MZ','MOZAMBIQUE','Mozambique','MOZ',508,258),(146,'MM','MYANMAR','Myanmar','MMR',104,95),(147,'NA','NAMIBIA','Namibia','NAM',516,264),(148,'NR','NAURU','Nauru','NRU',520,674),(149,'NP','NEPAL','Nepal','NPL',524,977),(150,'NL','NETHERLANDS','Netherlands','NLD',528,31),(151,'AN','NETHERLANDS ANTILLES','Netherlands Antilles','ANT',530,599),(152,'NC','NEW CALEDONIA','New Caledonia','NCL',540,687),(153,'NZ','NEW ZEALAND','New Zealand','NZL',554,64),(154,'NI','NICARAGUA','Nicaragua','NIC',558,505),(155,'NE','NIGER','Niger','NER',562,227),(156,'NG','NIGERIA','Nigeria','NGA',566,234),(157,'NU','NIUE','Niue','NIU',570,683),(158,'NF','NORFOLK ISLAND','Norfolk Island','NFK',574,672),(159,'MP','NORTHERN MARIANA ISLANDS','Northern Mariana Islands','MNP',580,1670),(160,'NO','NORWAY','Norway','NOR',578,47),(161,'OM','OMAN','Oman','OMN',512,968),(162,'PK','PAKISTAN','Pakistan','PAK',586,92),(163,'PW','PALAU','Palau','PLW',585,680),(164,'PS','PALESTINIAN TERRITORY, OCCUPIED','Palestinian Territory, Occupied',NULL,NULL,970),(165,'PA','PANAMA','Panama','PAN',591,507),(166,'PG','PAPUA NEW GUINEA','Papua New Guinea','PNG',598,675),(167,'PY','PARAGUAY','Paraguay','PRY',600,595),(168,'PE','PERU','Peru','PER',604,51),(169,'PH','PHILIPPINES','Philippines','PHL',608,63),(170,'PN','PITCAIRN','Pitcairn','PCN',612,0),(171,'PL','POLAND','Poland','POL',616,48),(172,'PT','PORTUGAL','Portugal','PRT',620,351),(173,'PR','PUERTO RICO','Puerto Rico','PRI',630,1787),(174,'QA','QATAR','Qatar','QAT',634,974),(175,'RE','REUNION','Reunion','REU',638,262),(176,'RO','ROMANIA','Romania','ROM',642,40),(177,'RU','RUSSIAN FEDERATION','Russian Federation','RUS',643,70),(178,'RW','RWANDA','Rwanda','RWA',646,250),(179,'SH','SAINT HELENA','Saint Helena','SHN',654,290),(180,'KN','SAINT KITTS AND NEVIS','Saint Kitts and Nevis','KNA',659,1869),(181,'LC','SAINT LUCIA','Saint Lucia','LCA',662,1758),(182,'PM','SAINT PIERRE AND MIQUELON','Saint Pierre and Miquelon','SPM',666,508),(183,'VC','SAINT VINCENT AND THE GRENADINES','Saint Vincent and the Grenadines','VCT',670,1784),(184,'WS','SAMOA','Samoa','WSM',882,684),(185,'SM','SAN MARINO','San Marino','SMR',674,378),(186,'ST','SAO TOME AND PRINCIPE','Sao Tome and Principe','STP',678,239),(187,'SA','SAUDI ARABIA','Saudi Arabia','SAU',682,966),(188,'SN','SENEGAL','Senegal','SEN',686,221),(189,'CS','SERBIA AND MONTENEGRO','Serbia and Montenegro',NULL,NULL,381),(190,'SC','SEYCHELLES','Seychelles','SYC',690,248),(191,'SL','SIERRA LEONE','Sierra Leone','SLE',694,232),(192,'SG','SINGAPORE','Singapore','SGP',702,65),(193,'SK','SLOVAKIA','Slovakia','SVK',703,421),(194,'SI','SLOVENIA','Slovenia','SVN',705,386),(195,'SB','SOLOMON ISLANDS','Solomon Islands','SLB',90,677),(196,'SO','SOMALIA','Somalia','SOM',706,252),(197,'ZA','SOUTH AFRICA','South Africa','ZAF',710,27),(198,'GS','SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS','South Georgia and the South Sandwich Islands',NULL,NULL,0),(199,'ES','SPAIN','Spain','ESP',724,34),(200,'LK','SRI LANKA','Sri Lanka','LKA',144,94),(201,'SD','SUDAN','Sudan','SDN',736,249),(202,'SR','SURINAME','Suriname','SUR',740,597),(203,'SJ','SVALBARD AND JAN MAYEN','Svalbard and Jan Mayen','SJM',744,47),(204,'SZ','SWAZILAND','Swaziland','SWZ',748,268),(205,'SE','SWEDEN','Sweden','SWE',752,46),(206,'CH','SWITZERLAND','Switzerland','CHE',756,41),(207,'SY','SYRIAN ARAB REPUBLIC','Syrian Arab Republic','SYR',760,963),(208,'TW','TAIWAN, PROVINCE OF CHINA','Taiwan, Province of China','TWN',158,886),(209,'TJ','TAJIKISTAN','Tajikistan','TJK',762,992),(210,'TZ','TANZANIA, UNITED REPUBLIC OF','Tanzania, United Republic of','TZA',834,255),(211,'TH','THAILAND','Thailand','THA',764,66),(212,'TL','TIMOR-LESTE','Timor-Leste',NULL,NULL,670),(213,'TG','TOGO','Togo','TGO',768,228),(214,'TK','TOKELAU','Tokelau','TKL',772,690),(215,'TO','TONGA','Tonga','TON',776,676),(216,'TT','TRINIDAD AND TOBAGO','Trinidad and Tobago','TTO',780,1868),(217,'TN','TUNISIA','Tunisia','TUN',788,216),(218,'TR','TURKEY','Turkey','TUR',792,90),(219,'TM','TURKMENISTAN','Turkmenistan','TKM',795,7370),(220,'TC','TURKS AND CAICOS ISLANDS','Turks and Caicos Islands','TCA',796,1649),(221,'TV','TUVALU','Tuvalu','TUV',798,688),(222,'UG','UGANDA','Uganda','UGA',800,256),(223,'UA','UKRAINE','Ukraine','UKR',804,380),(224,'AE','UNITED ARAB EMIRATES','United Arab Emirates','ARE',784,971),(225,'GB','UNITED KINGDOM','United Kingdom','GBR',826,44),(226,'US','UNITED STATES','United States','USA',840,1),(227,'UM','UNITED STATES MINOR OUTLYING ISLANDS','United States Minor Outlying Islands',NULL,NULL,1),(228,'UY','URUGUAY','Uruguay','URY',858,598),(229,'UZ','UZBEKISTAN','Uzbekistan','UZB',860,998),(230,'VU','VANUATU','Vanuatu','VUT',548,678),(231,'VE','VENEZUELA','Venezuela','VEN',862,58),(232,'VN','VIET NAM','Viet Nam','VNM',704,84),(233,'VG','VIRGIN ISLANDS, BRITISH','Virgin Islands, British','VGB',92,1284),(234,'VI','VIRGIN ISLANDS, U.S.','Virgin Islands, U.s.','VIR',850,1340),(235,'WF','WALLIS AND FUTUNA','Wallis and Futuna','WLF',876,681),(236,'EH','WESTERN SAHARA','Western Sahara','ESH',732,212),(237,'YE','YEMEN','Yemen','YEM',887,967),(238,'ZM','ZAMBIA','Zambia','ZMB',894,260),(239,'ZW','ZIMBABWE','Zimbabwe','ZWE',716,263),(240,'RS','SERBIA','Serbia','SRB',688,381),(241,'AP','ASIA PACIFIC REGION','Asia / Pacific Region','0',0,0),(242,'ME','MONTENEGRO','Montenegro','MNE',499,382),(243,'AX','ALAND ISLANDS','Aland Islands','ALA',248,358),(244,'BQ','BONAIRE, SINT EUSTATIUS AND SABA','Bonaire, Sint Eustatius and Saba','BES',535,599),(245,'CW','CURACAO','Curacao','CUW',531,599),(246,'GG','GUERNSEY','Guernsey','GGY',831,44),(247,'IM','ISLE OF MAN','Isle of Man','IMN',833,44),(248,'JE','JERSEY','Jersey','JEY',832,44),(249,'XK','KOSOVO','Kosovo','---',0,381),(250,'BL','SAINT BARTHELEMY','Saint Barthelemy','BLM',652,590),(251,'MF','SAINT MARTIN','Saint Martin','MAF',663,590),(252,'SX','SINT MAARTEN','Sint Maarten','SXM',534,1),(253,'SS','SOUTH SUDAN','South Sudan','SSD',728,211);
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `credit_note_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `credit_note_item_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `credit_note_item_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `credit_note_item_images_credit_note_item_id_foreign` (`credit_note_item_id`),
  CONSTRAINT `credit_note_item_images_credit_note_item_id_foreign` FOREIGN KEY (`credit_note_item_id`) REFERENCES `credit_note_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `credit_note_item_images` WRITE;
/*!40000 ALTER TABLE `credit_note_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `credit_note_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `credit_note_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `credit_note_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `credit_note_id` int unsigned NOT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('item','discount','tax') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `quantity` int NOT NULL,
  `unit_price` double(8,2) NOT NULL,
  `amount` double(8,2) NOT NULL,
  `taxes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_summary` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `credit_note_items_credit_note_id_foreign` (`credit_note_id`),
  CONSTRAINT `credit_note_items_credit_note_id_foreign` FOREIGN KEY (`credit_note_id`) REFERENCES `credit_notes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `credit_note_items` WRITE;
/*!40000 ALTER TABLE `credit_note_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `credit_note_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `credit_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `credit_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned DEFAULT NULL,
  `cn_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_id` int unsigned DEFAULT NULL,
  `issue_date` date NOT NULL,
  `due_date` date NOT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `discount_type` enum('percent','fixed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'percent',
  `sub_total` double(15,2) NOT NULL,
  `total` double(15,2) NOT NULL,
  `adjustment_amount` double(8,2) DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `status` enum('closed','open') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `recurring` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `billing_frequency` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_interval` int DEFAULT NULL,
  `billing_cycle` int DEFAULT NULL,
  `file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_original_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `calculate_tax` enum('after_discount','before_discount') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'after_discount',
  PRIMARY KEY (`id`),
  KEY `credit_notes_project_id_foreign` (`project_id`),
  KEY `credit_notes_client_id_foreign` (`client_id`),
  KEY `credit_notes_currency_id_foreign` (`currency_id`),
  KEY `credit_notes_added_by_foreign` (`added_by`),
  KEY `credit_notes_last_updated_by_foreign` (`last_updated_by`),
  KEY `credit_notes_company_id_foreign` (`company_id`),
  CONSTRAINT `credit_notes_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `credit_notes_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `credit_notes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `credit_notes_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `credit_notes_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `credit_notes_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `credit_notes` WRITE;
/*!40000 ALTER TABLE `credit_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `credit_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `currencies` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `currency_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_symbol` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exchange_rate` double DEFAULT NULL,
  `is_cryptocurrency` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `usd_price` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currencies_company_id_foreign` (`company_id`),
  CONSTRAINT `currencies_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,1,'Dollars','$','USD',NULL,'no',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07'),(2,1,'Pounds','£','GBP',NULL,'no',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07'),(3,1,'Euros','€','EUR',NULL,'no',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07'),(4,1,'Rupee','₹','INR',NULL,'no',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07'),(5,2,'Dollars','$','USD',NULL,'no',NULL,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(6,2,'Pounds','£','GBP',NULL,'no',NULL,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(7,2,'Euros','€','EUR',NULL,'no',NULL,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(8,2,'Rupee','₹','INR',NULL,'no',NULL,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(9,3,'Dollars','$','USD',NULL,'no',NULL,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(10,3,'Pounds','£','GBP',NULL,'no',NULL,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(11,3,'Euros','€','EUR',NULL,'no',NULL,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(12,3,'Rupee','₹','INR',NULL,'no',NULL,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(13,4,'Dollars','$','USD',NULL,'no',NULL,'2022-10-28 07:34:31','2022-10-28 07:34:31'),(14,4,'Pounds','£','GBP',NULL,'no',NULL,'2022-10-28 07:34:31','2022-10-28 07:34:31'),(15,4,'Euros','€','EUR',NULL,'no',NULL,'2022-10-28 07:34:31','2022-10-28 07:34:31'),(16,4,'Rupee','₹','INR',NULL,'no',NULL,'2022-10-28 07:34:31','2022-10-28 07:34:31');
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currency_format_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `currency_format_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `currency_position` enum('left','right','left_with_space','right_with_space') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'left',
  `no_of_decimal` int unsigned NOT NULL,
  `thousand_separator` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `decimal_separator` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currency_format_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `currency_format_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currency_format_settings` WRITE;
/*!40000 ALTER TABLE `currency_format_settings` DISABLE KEYS */;
INSERT INTO `currency_format_settings` VALUES (1,1,'left',2,',','.'),(2,2,'left',2,',','.'),(3,3,'left',2,',','.'),(4,4,'left',2,',','.');
/*!40000 ALTER TABLE `currency_format_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_field_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_field_groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `custom_field_groups_model_index` (`model`),
  KEY `custom_field_groups_company_id_foreign` (`company_id`),
  CONSTRAINT `custom_field_groups_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_field_groups` WRITE;
/*!40000 ALTER TABLE `custom_field_groups` DISABLE KEYS */;
INSERT INTO `custom_field_groups` VALUES (1,NULL,'Company','App\\Models\\Company'),(2,1,'Client','App\\Models\\ClientDetails'),(3,1,'Employee','App\\Models\\EmployeeDetails'),(4,1,'Project','App\\Models\\Project'),(5,1,'Invoice','App\\Models\\Invoice'),(6,1,'Estimate','App\\Models\\Estimate'),(7,1,'Task','App\\Models\\Task'),(8,1,'Expense','App\\Models\\Expense'),(9,1,'Lead','App\\Models\\Lead'),(10,1,'Product','App\\Models\\Product'),(11,1,'Ticket','App\\Models\\Ticket'),(12,1,'Time Log','App\\Models\\ProjectTimeLog'),(13,2,'Client','App\\Models\\ClientDetails'),(14,2,'Employee','App\\Models\\EmployeeDetails'),(15,2,'Project','App\\Models\\Project'),(16,2,'Invoice','App\\Models\\Invoice'),(17,2,'Estimate','App\\Models\\Estimate'),(18,2,'Task','App\\Models\\Task'),(19,2,'Expense','App\\Models\\Expense'),(20,2,'Lead','App\\Models\\Lead'),(21,2,'Product','App\\Models\\Product'),(22,2,'Ticket','App\\Models\\Ticket'),(23,2,'Time Log','App\\Models\\ProjectTimeLog'),(24,3,'Client','App\\Models\\ClientDetails'),(25,3,'Employee','App\\Models\\EmployeeDetails'),(26,3,'Project','App\\Models\\Project'),(27,3,'Invoice','App\\Models\\Invoice'),(28,3,'Estimate','App\\Models\\Estimate'),(29,3,'Task','App\\Models\\Task'),(30,3,'Expense','App\\Models\\Expense'),(31,3,'Lead','App\\Models\\Lead'),(32,3,'Product','App\\Models\\Product'),(33,3,'Ticket','App\\Models\\Ticket'),(34,3,'Time Log','App\\Models\\ProjectTimeLog'),(35,4,'Client','App\\Models\\ClientDetails'),(36,4,'Employee','App\\Models\\EmployeeDetails'),(37,4,'Project','App\\Models\\Project'),(38,4,'Invoice','App\\Models\\Invoice'),(39,4,'Estimate','App\\Models\\Estimate'),(40,4,'Task','App\\Models\\Task'),(41,4,'Expense','App\\Models\\Expense'),(42,4,'Lead','App\\Models\\Lead'),(43,4,'Product','App\\Models\\Product'),(44,4,'Ticket','App\\Models\\Ticket'),(45,4,'Time Log','App\\Models\\ProjectTimeLog');
/*!40000 ALTER TABLE `custom_field_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `custom_field_group_id` int unsigned DEFAULT NULL,
  `label` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `values` varchar(5000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `custom_fields_custom_field_group_id_foreign` (`custom_field_group_id`),
  KEY `custom_fields_company_id_foreign` (`company_id`),
  CONSTRAINT `custom_fields_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `custom_fields_custom_field_group_id_foreign` FOREIGN KEY (`custom_field_group_id`) REFERENCES `custom_field_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_fields` WRITE;
/*!40000 ALTER TABLE `custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_fields` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_fields_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_fields_data` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` int unsigned NOT NULL,
  `model_id` int unsigned NOT NULL,
  `model` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(10000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `custom_fields_data_custom_field_id_foreign` (`custom_field_id`),
  KEY `custom_fields_data_model_index` (`model`),
  CONSTRAINT `custom_fields_data_custom_field_id_foreign` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_fields_data` WRITE;
/*!40000 ALTER TABLE `custom_fields_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_fields_data` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `widget_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `dashboard_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widgets_company_id_foreign` (`company_id`),
  CONSTRAINT `dashboard_widgets_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=305 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
INSERT INTO `dashboard_widgets` VALUES (1,1,'total_clients',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-dashboard'),(2,1,'total_employees',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-dashboard'),(3,1,'total_projects',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-dashboard'),(4,1,'total_unpaid_invoices',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-dashboard'),(5,1,'total_hours_logged',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-dashboard'),(6,1,'total_pending_tasks',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-dashboard'),(7,1,'total_today_attendance',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-dashboard'),(8,1,'total_unresolved_tickets',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-dashboard'),(9,1,'recent_earnings',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-dashboard'),(10,1,'settings_leaves',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-dashboard'),(11,1,'new_tickets',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-dashboard'),(12,1,'overdue_tasks',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-dashboard'),(13,1,'pending_follow_up',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-dashboard'),(14,1,'project_activity_timeline',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-dashboard'),(15,1,'user_activity_timeline',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-dashboard'),(16,1,'timelogs',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-dashboard'),(17,1,'total_clients',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-client-dashboard'),(18,1,'total_leads',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-client-dashboard'),(19,1,'total_lead_conversions',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-client-dashboard'),(20,1,'total_contracts_generated',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-client-dashboard'),(21,1,'total_contracts_signed',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-client-dashboard'),(22,1,'client_wise_earnings',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-client-dashboard'),(23,1,'client_wise_timelogs',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-client-dashboard'),(24,1,'lead_vs_status',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-client-dashboard'),(25,1,'lead_vs_source',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-client-dashboard'),(26,1,'latest_client',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-client-dashboard'),(27,1,'recent_login_activities',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-client-dashboard'),(28,1,'total_paid_invoices',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-finance-dashboard'),(29,1,'total_expenses',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-finance-dashboard'),(30,1,'total_earnings',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-finance-dashboard'),(31,1,'total_pending_amount',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-finance-dashboard'),(32,1,'invoice_overview',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-finance-dashboard'),(33,1,'estimate_overview',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-finance-dashboard'),(34,1,'proposal_overview',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-finance-dashboard'),(35,1,'earnings_by_client',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-finance-dashboard'),(36,1,'earnings_by_projects',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-finance-dashboard'),(37,1,'total_unpaid_invoices',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-finance-dashboard'),(38,1,'total_leaves_approved',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-hr-dashboard'),(39,1,'total_new_employee',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-hr-dashboard'),(40,1,'total_employee_exits',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-hr-dashboard'),(41,1,'average_attendance',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-hr-dashboard'),(42,1,'department_wise_employee',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-hr-dashboard'),(43,1,'designation_wise_employee',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-hr-dashboard'),(44,1,'gender_wise_employee',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-hr-dashboard'),(45,1,'role_wise_employee',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-hr-dashboard'),(46,1,'leaves_taken',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-hr-dashboard'),(47,1,'late_attendance_mark',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-hr-dashboard'),(48,1,'headcount',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-hr-dashboard'),(49,1,'joining_vs_attrition',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-hr-dashboard'),(50,1,'birthday',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-hr-dashboard'),(51,1,'total_today_attendance',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-hr-dashboard'),(52,1,'total_project',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-project-dashboard'),(53,1,'total_hours_logged',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-project-dashboard'),(54,1,'total_overdue_project',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-project-dashboard'),(55,1,'status_wise_project',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-project-dashboard'),(56,1,'pending_milestone',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-project-dashboard'),(57,1,'total_tickets',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-ticket-dashboard'),(58,1,'total_unassigned_ticket',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-ticket-dashboard'),(59,1,'type_wise_ticket',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-ticket-dashboard'),(60,1,'status_wise_ticket',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-ticket-dashboard'),(61,1,'channel_wise_ticket',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-ticket-dashboard'),(62,1,'new_tickets',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','admin-ticket-dashboard'),(63,1,'profile',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','private-dashboard'),(64,1,'shift_schedule',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','private-dashboard'),(65,1,'birthday',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','private-dashboard'),(66,1,'notices',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','private-dashboard'),(67,1,'tasks',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','private-dashboard'),(68,1,'projects',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','private-dashboard'),(69,1,'my_task',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','private-dashboard'),(70,1,'my_calender',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','private-dashboard'),(71,1,'week_timelog',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','private-dashboard'),(72,1,'leave',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','private-dashboard'),(73,1,'lead',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','private-dashboard'),(74,1,'work_from_home',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','private-dashboard'),(75,1,'appreciation',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','private-dashboard'),(76,1,'work_anniversary',1,'2022-10-28 07:30:08','2022-10-28 07:30:08','private-dashboard'),(77,2,'total_clients',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-dashboard'),(78,2,'total_employees',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-dashboard'),(79,2,'total_projects',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-dashboard'),(80,2,'total_unpaid_invoices',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-dashboard'),(81,2,'total_hours_logged',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-dashboard'),(82,2,'total_pending_tasks',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-dashboard'),(83,2,'total_today_attendance',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-dashboard'),(84,2,'total_unresolved_tickets',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-dashboard'),(85,2,'recent_earnings',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-dashboard'),(86,2,'settings_leaves',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-dashboard'),(87,2,'new_tickets',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-dashboard'),(88,2,'overdue_tasks',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-dashboard'),(89,2,'pending_follow_up',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-dashboard'),(90,2,'project_activity_timeline',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-dashboard'),(91,2,'user_activity_timeline',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-dashboard'),(92,2,'timelogs',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-dashboard'),(93,2,'total_clients',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-client-dashboard'),(94,2,'total_leads',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-client-dashboard'),(95,2,'total_lead_conversions',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-client-dashboard'),(96,2,'total_contracts_generated',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-client-dashboard'),(97,2,'total_contracts_signed',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-client-dashboard'),(98,2,'client_wise_earnings',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-client-dashboard'),(99,2,'client_wise_timelogs',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-client-dashboard'),(100,2,'lead_vs_status',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-client-dashboard'),(101,2,'lead_vs_source',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-client-dashboard'),(102,2,'latest_client',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-client-dashboard'),(103,2,'recent_login_activities',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-client-dashboard'),(104,2,'total_paid_invoices',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-finance-dashboard'),(105,2,'total_expenses',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-finance-dashboard'),(106,2,'total_earnings',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-finance-dashboard'),(107,2,'total_pending_amount',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-finance-dashboard'),(108,2,'invoice_overview',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-finance-dashboard'),(109,2,'estimate_overview',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-finance-dashboard'),(110,2,'proposal_overview',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-finance-dashboard'),(111,2,'earnings_by_client',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-finance-dashboard'),(112,2,'earnings_by_projects',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-finance-dashboard'),(113,2,'total_unpaid_invoices',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-finance-dashboard'),(114,2,'total_leaves_approved',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-hr-dashboard'),(115,2,'total_new_employee',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-hr-dashboard'),(116,2,'total_employee_exits',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-hr-dashboard'),(117,2,'average_attendance',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-hr-dashboard'),(118,2,'department_wise_employee',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-hr-dashboard'),(119,2,'designation_wise_employee',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-hr-dashboard'),(120,2,'gender_wise_employee',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-hr-dashboard'),(121,2,'role_wise_employee',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-hr-dashboard'),(122,2,'leaves_taken',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-hr-dashboard'),(123,2,'late_attendance_mark',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-hr-dashboard'),(124,2,'headcount',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-hr-dashboard'),(125,2,'joining_vs_attrition',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-hr-dashboard'),(126,2,'birthday',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-hr-dashboard'),(127,2,'total_today_attendance',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-hr-dashboard'),(128,2,'total_project',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-project-dashboard'),(129,2,'total_hours_logged',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-project-dashboard'),(130,2,'total_overdue_project',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-project-dashboard'),(131,2,'status_wise_project',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-project-dashboard'),(132,2,'pending_milestone',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-project-dashboard'),(133,2,'total_tickets',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-ticket-dashboard'),(134,2,'total_unassigned_ticket',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-ticket-dashboard'),(135,2,'type_wise_ticket',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-ticket-dashboard'),(136,2,'status_wise_ticket',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-ticket-dashboard'),(137,2,'channel_wise_ticket',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-ticket-dashboard'),(138,2,'new_tickets',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','admin-ticket-dashboard'),(139,2,'profile',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','private-dashboard'),(140,2,'shift_schedule',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','private-dashboard'),(141,2,'birthday',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','private-dashboard'),(142,2,'notices',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','private-dashboard'),(143,2,'tasks',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','private-dashboard'),(144,2,'projects',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','private-dashboard'),(145,2,'my_task',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','private-dashboard'),(146,2,'my_calender',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','private-dashboard'),(147,2,'week_timelog',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','private-dashboard'),(148,2,'leave',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','private-dashboard'),(149,2,'lead',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','private-dashboard'),(150,2,'work_from_home',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','private-dashboard'),(151,2,'appreciation',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','private-dashboard'),(152,2,'work_anniversary',1,'2022-10-28 07:30:09','2022-10-28 07:30:09','private-dashboard'),(153,3,'total_clients',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-dashboard'),(154,3,'total_employees',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-dashboard'),(155,3,'total_projects',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-dashboard'),(156,3,'total_unpaid_invoices',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-dashboard'),(157,3,'total_hours_logged',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-dashboard'),(158,3,'total_pending_tasks',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-dashboard'),(159,3,'total_today_attendance',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-dashboard'),(160,3,'total_unresolved_tickets',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-dashboard'),(161,3,'recent_earnings',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-dashboard'),(162,3,'settings_leaves',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-dashboard'),(163,3,'new_tickets',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-dashboard'),(164,3,'overdue_tasks',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-dashboard'),(165,3,'pending_follow_up',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-dashboard'),(166,3,'project_activity_timeline',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-dashboard'),(167,3,'user_activity_timeline',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-dashboard'),(168,3,'timelogs',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-dashboard'),(169,3,'total_clients',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-client-dashboard'),(170,3,'total_leads',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-client-dashboard'),(171,3,'total_lead_conversions',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-client-dashboard'),(172,3,'total_contracts_generated',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-client-dashboard'),(173,3,'total_contracts_signed',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-client-dashboard'),(174,3,'client_wise_earnings',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-client-dashboard'),(175,3,'client_wise_timelogs',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-client-dashboard'),(176,3,'lead_vs_status',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-client-dashboard'),(177,3,'lead_vs_source',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-client-dashboard'),(178,3,'latest_client',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-client-dashboard'),(179,3,'recent_login_activities',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-client-dashboard'),(180,3,'total_paid_invoices',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-finance-dashboard'),(181,3,'total_expenses',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-finance-dashboard'),(182,3,'total_earnings',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-finance-dashboard'),(183,3,'total_pending_amount',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-finance-dashboard'),(184,3,'invoice_overview',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-finance-dashboard'),(185,3,'estimate_overview',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-finance-dashboard'),(186,3,'proposal_overview',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-finance-dashboard'),(187,3,'earnings_by_client',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-finance-dashboard'),(188,3,'earnings_by_projects',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-finance-dashboard'),(189,3,'total_unpaid_invoices',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-finance-dashboard'),(190,3,'total_leaves_approved',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-hr-dashboard'),(191,3,'total_new_employee',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-hr-dashboard'),(192,3,'total_employee_exits',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-hr-dashboard'),(193,3,'average_attendance',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-hr-dashboard'),(194,3,'department_wise_employee',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-hr-dashboard'),(195,3,'designation_wise_employee',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-hr-dashboard'),(196,3,'gender_wise_employee',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-hr-dashboard'),(197,3,'role_wise_employee',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-hr-dashboard'),(198,3,'leaves_taken',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-hr-dashboard'),(199,3,'late_attendance_mark',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-hr-dashboard'),(200,3,'headcount',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-hr-dashboard'),(201,3,'joining_vs_attrition',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-hr-dashboard'),(202,3,'birthday',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-hr-dashboard'),(203,3,'total_today_attendance',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-hr-dashboard'),(204,3,'total_project',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-project-dashboard'),(205,3,'total_hours_logged',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-project-dashboard'),(206,3,'total_overdue_project',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-project-dashboard'),(207,3,'status_wise_project',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-project-dashboard'),(208,3,'pending_milestone',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-project-dashboard'),(209,3,'total_tickets',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-ticket-dashboard'),(210,3,'total_unassigned_ticket',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-ticket-dashboard'),(211,3,'type_wise_ticket',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-ticket-dashboard'),(212,3,'status_wise_ticket',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-ticket-dashboard'),(213,3,'channel_wise_ticket',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-ticket-dashboard'),(214,3,'new_tickets',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','admin-ticket-dashboard'),(215,3,'profile',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','private-dashboard'),(216,3,'shift_schedule',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','private-dashboard'),(217,3,'birthday',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','private-dashboard'),(218,3,'notices',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','private-dashboard'),(219,3,'tasks',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','private-dashboard'),(220,3,'projects',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','private-dashboard'),(221,3,'my_task',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','private-dashboard'),(222,3,'my_calender',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','private-dashboard'),(223,3,'week_timelog',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','private-dashboard'),(224,3,'leave',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','private-dashboard'),(225,3,'lead',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','private-dashboard'),(226,3,'work_from_home',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','private-dashboard'),(227,3,'appreciation',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','private-dashboard'),(228,3,'work_anniversary',1,'2022-10-28 07:30:10','2022-10-28 07:30:10','private-dashboard'),(229,4,'total_clients',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-dashboard'),(230,4,'total_employees',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-dashboard'),(231,4,'total_projects',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-dashboard'),(232,4,'total_unpaid_invoices',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-dashboard'),(233,4,'total_hours_logged',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-dashboard'),(234,4,'total_pending_tasks',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-dashboard'),(235,4,'total_today_attendance',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-dashboard'),(236,4,'total_unresolved_tickets',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-dashboard'),(237,4,'recent_earnings',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-dashboard'),(238,4,'settings_leaves',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-dashboard'),(239,4,'new_tickets',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-dashboard'),(240,4,'overdue_tasks',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-dashboard'),(241,4,'pending_follow_up',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-dashboard'),(242,4,'project_activity_timeline',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-dashboard'),(243,4,'user_activity_timeline',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-dashboard'),(244,4,'timelogs',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-dashboard'),(245,4,'total_clients',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-client-dashboard'),(246,4,'total_leads',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-client-dashboard'),(247,4,'total_lead_conversions',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-client-dashboard'),(248,4,'total_contracts_generated',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-client-dashboard'),(249,4,'total_contracts_signed',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-client-dashboard'),(250,4,'client_wise_earnings',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-client-dashboard'),(251,4,'client_wise_timelogs',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-client-dashboard'),(252,4,'lead_vs_status',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-client-dashboard'),(253,4,'lead_vs_source',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-client-dashboard'),(254,4,'latest_client',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-client-dashboard'),(255,4,'recent_login_activities',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-client-dashboard'),(256,4,'total_paid_invoices',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-finance-dashboard'),(257,4,'total_expenses',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-finance-dashboard'),(258,4,'total_earnings',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-finance-dashboard'),(259,4,'total_pending_amount',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-finance-dashboard'),(260,4,'invoice_overview',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-finance-dashboard'),(261,4,'estimate_overview',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-finance-dashboard'),(262,4,'proposal_overview',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-finance-dashboard'),(263,4,'earnings_by_client',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-finance-dashboard'),(264,4,'earnings_by_projects',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-finance-dashboard'),(265,4,'total_unpaid_invoices',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-finance-dashboard'),(266,4,'total_leaves_approved',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-hr-dashboard'),(267,4,'total_new_employee',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-hr-dashboard'),(268,4,'total_employee_exits',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-hr-dashboard'),(269,4,'average_attendance',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-hr-dashboard'),(270,4,'department_wise_employee',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-hr-dashboard'),(271,4,'designation_wise_employee',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-hr-dashboard'),(272,4,'gender_wise_employee',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-hr-dashboard'),(273,4,'role_wise_employee',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-hr-dashboard'),(274,4,'leaves_taken',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-hr-dashboard'),(275,4,'late_attendance_mark',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-hr-dashboard'),(276,4,'headcount',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-hr-dashboard'),(277,4,'joining_vs_attrition',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-hr-dashboard'),(278,4,'birthday',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-hr-dashboard'),(279,4,'total_today_attendance',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-hr-dashboard'),(280,4,'total_project',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-project-dashboard'),(281,4,'total_hours_logged',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-project-dashboard'),(282,4,'total_overdue_project',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-project-dashboard'),(283,4,'status_wise_project',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-project-dashboard'),(284,4,'pending_milestone',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-project-dashboard'),(285,4,'total_tickets',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-ticket-dashboard'),(286,4,'total_unassigned_ticket',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-ticket-dashboard'),(287,4,'type_wise_ticket',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-ticket-dashboard'),(288,4,'status_wise_ticket',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-ticket-dashboard'),(289,4,'channel_wise_ticket',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-ticket-dashboard'),(290,4,'new_tickets',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','admin-ticket-dashboard'),(291,4,'profile',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','private-dashboard'),(292,4,'shift_schedule',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','private-dashboard'),(293,4,'birthday',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','private-dashboard'),(294,4,'notices',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','private-dashboard'),(295,4,'tasks',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','private-dashboard'),(296,4,'projects',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','private-dashboard'),(297,4,'my_task',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','private-dashboard'),(298,4,'my_calender',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','private-dashboard'),(299,4,'week_timelog',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','private-dashboard'),(300,4,'leave',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','private-dashboard'),(301,4,'lead',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','private-dashboard'),(302,4,'work_from_home',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','private-dashboard'),(303,4,'appreciation',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','private-dashboard'),(304,4,'work_anniversary',1,'2022-10-28 07:34:32','2022-10-28 07:34:32','private-dashboard');
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `database_backup_cron_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `database_backup_cron_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `hour_of_day` time DEFAULT NULL,
  `backup_after_days` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delete_backup_after_days` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `database_backup_cron_settings` WRITE;
/*!40000 ALTER TABLE `database_backup_cron_settings` DISABLE KEYS */;
INSERT INTO `database_backup_cron_settings` VALUES (1,'inactive','00:00:00','0','0');
/*!40000 ALTER TABLE `database_backup_cron_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `database_backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `database_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `database_backups` WRITE;
/*!40000 ALTER TABLE `database_backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `database_backups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `designations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `designations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `designations_added_by_foreign` (`added_by`),
  KEY `designations_last_updated_by_foreign` (`last_updated_by`),
  KEY `designations_company_id_foreign` (`company_id`),
  CONSTRAINT `designations_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `designations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `designations_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `designations` WRITE;
/*!40000 ALTER TABLE `designations` DISABLE KEYS */;
INSERT INTO `designations` VALUES (1,1,'Trainee',NULL,NULL,NULL,NULL,NULL),(2,1,'Senior',NULL,NULL,NULL,NULL,NULL),(3,1,'Junior',NULL,NULL,NULL,NULL,NULL),(4,1,'Team Lead',NULL,NULL,NULL,NULL,NULL),(5,1,'Project Manager',NULL,NULL,NULL,NULL,NULL),(6,2,'Trainee',NULL,NULL,NULL,NULL,NULL),(7,2,'Senior',NULL,NULL,NULL,NULL,NULL),(8,2,'Junior',NULL,NULL,NULL,NULL,NULL),(9,2,'Team Lead',NULL,NULL,NULL,NULL,NULL),(10,2,'Project Manager',NULL,NULL,NULL,NULL,NULL),(11,3,'Trainee',NULL,NULL,NULL,NULL,NULL),(12,3,'Senior',NULL,NULL,NULL,NULL,NULL),(13,3,'Junior',NULL,NULL,NULL,NULL,NULL),(14,3,'Team Lead',NULL,NULL,NULL,NULL,NULL),(15,3,'Project Manager',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `designations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discussion_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `discussion_categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `order` int NOT NULL DEFAULT '1',
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discussion_categories_company_id_foreign` (`company_id`),
  CONSTRAINT `discussion_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discussion_categories` WRITE;
/*!40000 ALTER TABLE `discussion_categories` DISABLE KEYS */;
INSERT INTO `discussion_categories` VALUES (1,1,1,'General','#3498DB','2022-10-28 07:30:08','2022-10-28 07:30:08'),(2,2,1,'General','#3498DB','2022-10-28 07:30:09','2022-10-28 07:30:09'),(3,3,1,'General','#3498DB','2022-10-28 07:30:10','2022-10-28 07:30:10'),(4,4,1,'General','#3498DB','2022-10-28 07:34:32','2022-10-28 07:34:32');
/*!40000 ALTER TABLE `discussion_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discussion_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `discussion_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `discussion_id` int unsigned DEFAULT NULL,
  `discussion_reply_id` int unsigned DEFAULT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `google_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dropbox_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discussion_files_user_id_foreign` (`user_id`),
  KEY `discussion_files_discussion_id_foreign` (`discussion_id`),
  KEY `discussion_files_discussion_reply_id_foreign` (`discussion_reply_id`),
  KEY `discussion_files_company_id_foreign` (`company_id`),
  CONSTRAINT `discussion_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussion_files_discussion_id_foreign` FOREIGN KEY (`discussion_id`) REFERENCES `discussions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussion_files_discussion_reply_id_foreign` FOREIGN KEY (`discussion_reply_id`) REFERENCES `discussion_replies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussion_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discussion_files` WRITE;
/*!40000 ALTER TABLE `discussion_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `discussion_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discussion_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `discussion_replies` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `discussion_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `body` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discussion_replies_discussion_id_foreign` (`discussion_id`),
  KEY `discussion_replies_user_id_foreign` (`user_id`),
  KEY `discussion_replies_company_id_foreign` (`company_id`),
  CONSTRAINT `discussion_replies_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussion_replies_discussion_id_foreign` FOREIGN KEY (`discussion_id`) REFERENCES `discussions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussion_replies_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discussion_replies` WRITE;
/*!40000 ALTER TABLE `discussion_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `discussion_replies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discussions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `discussions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `discussion_category_id` int unsigned DEFAULT '1',
  `project_id` int unsigned DEFAULT NULL,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '#232629',
  `user_id` int unsigned NOT NULL,
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `last_reply_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `best_answer_id` int unsigned DEFAULT NULL,
  `last_reply_by_id` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discussions_discussion_category_id_foreign` (`discussion_category_id`),
  KEY `discussions_project_id_foreign` (`project_id`),
  KEY `discussions_user_id_foreign` (`user_id`),
  KEY `discussions_best_answer_id_foreign` (`best_answer_id`),
  KEY `discussions_last_reply_by_id_foreign` (`last_reply_by_id`),
  KEY `discussions_added_by_foreign` (`added_by`),
  KEY `discussions_last_updated_by_foreign` (`last_updated_by`),
  KEY `discussions_company_id_foreign` (`company_id`),
  CONSTRAINT `discussions_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discussions_best_answer_id_foreign` FOREIGN KEY (`best_answer_id`) REFERENCES `discussion_replies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discussions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussions_discussion_category_id_foreign` FOREIGN KEY (`discussion_category_id`) REFERENCES `discussion_categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discussions_last_reply_by_id_foreign` FOREIGN KEY (`last_reply_by_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discussions_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discussions_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discussions` WRITE;
/*!40000 ALTER TABLE `discussions` DISABLE KEYS */;
/*!40000 ALTER TABLE `discussions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `email_notification_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_notification_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `setting_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `send_email` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `send_slack` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `send_push` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `slug` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `email_notification_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `email_notification_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `email_notification_settings` WRITE;
/*!40000 ALTER TABLE `email_notification_settings` DISABLE KEYS */;
INSERT INTO `email_notification_settings` VALUES (1,1,'New Expense/Added by Admin','yes','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','new-expenseadded-by-admin'),(2,1,'New Expense/Added by Member','yes','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','new-expenseadded-by-member'),(3,1,'Expense Status Changed','yes','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','expense-status-changed'),(4,1,'New Support Ticket Request','yes','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','new-support-ticket-request'),(5,1,'New Leave Application','yes','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','new-leave-application'),(6,1,'Task Completed','yes','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','task-completed'),(7,1,'Invoice Create/Update Notification','yes','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','invoice-createupdate-notification'),(8,1,'Discussion Reply','yes','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','discussion-reply'),(9,1,'New Product Purchase Request','yes','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','new-product-purchase-request'),(10,1,'Lead notification','yes','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','lead-notification'),(11,1,'Order Create/Update Notification','no','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','order-createupdate-notification'),(12,1,'User Join via Invitation','no','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','user-join-via-invitation'),(13,1,'Follow Up Reminder','no','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','follow-up-reminder'),(14,1,'User Registration/Added by Admin','yes','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','user-registrationadded-by-admin'),(15,1,'Employee Assign to Project','yes','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','employee-assign-to-project'),(16,1,'New Notice Published','no','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','new-notice-published'),(17,1,'User Assign to Task','yes','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','user-assign-to-task'),(18,1,'Birthday notification','yes','yes','no','2022-10-28 07:30:08','2022-10-28 07:30:08','birthday-notification'),(19,1,'Payment Notification','yes','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','payment-notification'),(20,1,'Employee Appreciation','yes','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08','appreciation-notification'),(21,2,'New Expense/Added by Admin','yes','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','new-expenseadded-by-admin'),(22,2,'New Expense/Added by Member','yes','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','new-expenseadded-by-member'),(23,2,'Expense Status Changed','yes','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','expense-status-changed'),(24,2,'New Support Ticket Request','yes','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','new-support-ticket-request'),(25,2,'New Leave Application','yes','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','new-leave-application'),(26,2,'Task Completed','yes','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','task-completed'),(27,2,'Invoice Create/Update Notification','yes','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','invoice-createupdate-notification'),(28,2,'Discussion Reply','yes','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','discussion-reply'),(29,2,'New Product Purchase Request','yes','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','new-product-purchase-request'),(30,2,'Lead notification','yes','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','lead-notification'),(31,2,'Order Create/Update Notification','no','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','order-createupdate-notification'),(32,2,'User Join via Invitation','no','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','user-join-via-invitation'),(33,2,'Follow Up Reminder','no','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','follow-up-reminder'),(34,2,'User Registration/Added by Admin','yes','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','user-registrationadded-by-admin'),(35,2,'Employee Assign to Project','yes','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','employee-assign-to-project'),(36,2,'New Notice Published','no','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','new-notice-published'),(37,2,'User Assign to Task','yes','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','user-assign-to-task'),(38,2,'Birthday notification','yes','yes','no','2022-10-28 07:30:09','2022-10-28 07:30:09','birthday-notification'),(39,2,'Payment Notification','yes','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','payment-notification'),(40,2,'Employee Appreciation','yes','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09','appreciation-notification'),(41,3,'New Expense/Added by Admin','yes','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','new-expenseadded-by-admin'),(42,3,'New Expense/Added by Member','yes','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','new-expenseadded-by-member'),(43,3,'Expense Status Changed','yes','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','expense-status-changed'),(44,3,'New Support Ticket Request','yes','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','new-support-ticket-request'),(45,3,'New Leave Application','yes','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','new-leave-application'),(46,3,'Task Completed','yes','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','task-completed'),(47,3,'Invoice Create/Update Notification','yes','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','invoice-createupdate-notification'),(48,3,'Discussion Reply','yes','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','discussion-reply'),(49,3,'New Product Purchase Request','yes','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','new-product-purchase-request'),(50,3,'Lead notification','yes','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','lead-notification'),(51,3,'Order Create/Update Notification','no','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','order-createupdate-notification'),(52,3,'User Join via Invitation','no','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','user-join-via-invitation'),(53,3,'Follow Up Reminder','no','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','follow-up-reminder'),(54,3,'User Registration/Added by Admin','yes','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','user-registrationadded-by-admin'),(55,3,'Employee Assign to Project','yes','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','employee-assign-to-project'),(56,3,'New Notice Published','no','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','new-notice-published'),(57,3,'User Assign to Task','yes','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','user-assign-to-task'),(58,3,'Birthday notification','yes','yes','no','2022-10-28 07:30:10','2022-10-28 07:30:10','birthday-notification'),(59,3,'Payment Notification','yes','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','payment-notification'),(60,3,'Employee Appreciation','yes','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10','appreciation-notification'),(61,4,'New Expense/Added by Admin','yes','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','new-expenseadded-by-admin'),(62,4,'New Expense/Added by Member','yes','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','new-expenseadded-by-member'),(63,4,'Expense Status Changed','yes','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','expense-status-changed'),(64,4,'New Support Ticket Request','yes','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','new-support-ticket-request'),(65,4,'New Leave Application','yes','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','new-leave-application'),(66,4,'Task Completed','yes','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','task-completed'),(67,4,'Invoice Create/Update Notification','yes','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','invoice-createupdate-notification'),(68,4,'Discussion Reply','yes','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','discussion-reply'),(69,4,'New Product Purchase Request','yes','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','new-product-purchase-request'),(70,4,'Lead notification','yes','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','lead-notification'),(71,4,'Order Create/Update Notification','no','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','order-createupdate-notification'),(72,4,'User Join via Invitation','no','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','user-join-via-invitation'),(73,4,'Follow Up Reminder','no','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','follow-up-reminder'),(74,4,'User Registration/Added by Admin','yes','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','user-registrationadded-by-admin'),(75,4,'Employee Assign to Project','yes','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','employee-assign-to-project'),(76,4,'New Notice Published','no','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','new-notice-published'),(77,4,'User Assign to Task','yes','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','user-assign-to-task'),(78,4,'Birthday notification','yes','yes','no','2022-10-28 07:34:32','2022-10-28 07:34:32','birthday-notification'),(79,4,'Payment Notification','yes','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','payment-notification'),(80,4,'Employee Appreciation','yes','no','no','2022-10-28 07:34:32','2022-10-28 07:34:32','appreciation-notification');
/*!40000 ALTER TABLE `email_notification_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `emergency_contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `emergency_contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `relation` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `emergency_contacts_user_id_foreign` (`user_id`),
  KEY `emergency_contacts_added_by_foreign` (`added_by`),
  KEY `emergency_contacts_last_updated_by_foreign` (`last_updated_by`),
  KEY `emergency_contacts_company_id_foreign` (`company_id`),
  CONSTRAINT `emergency_contacts_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `emergency_contacts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `emergency_contacts_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `emergency_contacts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `emergency_contacts` WRITE;
/*!40000 ALTER TABLE `emergency_contacts` DISABLE KEYS */;
/*!40000 ALTER TABLE `emergency_contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_details` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `employee_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `hourly_rate` double DEFAULT NULL,
  `slack_username` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `department_id` int unsigned DEFAULT NULL,
  `designation_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `joining_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_date` date DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `attendance_reminder` date DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `calendar_view` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `about_me` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `reporting_to` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `employee_details_employee_id_company_id_unique` (`employee_id`,`company_id`),
  UNIQUE KEY `employee_details_slack_username_company_id_unique` (`slack_username`,`company_id`),
  KEY `employee_details_user_id_foreign` (`user_id`),
  KEY `employee_details_department_id_foreign` (`department_id`),
  KEY `employee_details_designation_id_foreign` (`designation_id`),
  KEY `employee_details_added_by_foreign` (`added_by`),
  KEY `employee_details_last_updated_by_foreign` (`last_updated_by`),
  KEY `employee_details_reporting_to_foreign` (`reporting_to`),
  KEY `employee_details_company_id_foreign` (`company_id`),
  CONSTRAINT `employee_details_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_details_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_details_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `teams` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_details_designation_id_foreign` FOREIGN KEY (`designation_id`) REFERENCES `designations` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_details_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_details_reporting_to_foreign` FOREIGN KEY (`reporting_to`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_details_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_details` WRITE;
/*!40000 ALTER TABLE `employee_details` DISABLE KEYS */;
INSERT INTO `employee_details` VALUES (1,1,2,'EMP-1','97893 Prosacco Groves\nPort Augustineview, AZ 62157',27,NULL,1,1,'2022-10-28 07:30:10','2022-10-28 07:30:10','2022-01-28 07:30:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,1,3,'EMP-2','71331 Carrie Run Suite 667\nPort Jarrett, AL 14945',74,NULL,3,2,'2022-10-28 07:30:10','2022-10-28 07:30:10','2022-01-28 07:30:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,1,10,'EMP-3','46115 Conn Harbor\nSouth Sandra, ME 90590-0171',63,NULL,1,4,'2022-10-28 07:30:11','2022-10-28 07:30:11','2022-01-28 07:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,1,11,'EMP-4','741 Wyman Coves Apt. 193\nNew Tyreeland, IN 19726',40,NULL,4,1,'2022-10-28 07:30:11','2022-10-28 07:30:11','2022-01-28 07:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,1,12,'EMP-5','5477 Cartwright Prairie Apt. 322\nShieldsville, AK 07439-5822',59,NULL,1,5,'2022-10-28 07:30:11','2022-10-28 07:30:11','2022-01-28 07:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,1,13,'EMP-6','1860 Baumbach Loop Apt. 781\nPort Glendachester, ME 04768',61,NULL,1,5,'2022-10-28 07:30:11','2022-10-28 07:30:11','2022-01-28 07:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,1,14,'EMP-7','8536 Oberbrunner Summit Suite 365\nPort Kaleymouth, ND 68728-5848',98,NULL,5,4,'2022-10-28 07:30:11','2022-10-28 07:30:11','2022-01-28 07:30:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,2,15,'EMP-1','42834 Crooks Station Suite 476\nRichmondmouth, RI 13334-5339',53,NULL,3,1,'2022-10-28 07:30:14','2022-10-28 07:30:14','2022-01-28 07:30:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,2,16,'EMP-2','51347 Alverta Heights Apt. 522\nTonibury, ID 58986',92,NULL,1,5,'2022-10-28 07:30:14','2022-10-28 07:30:14','2022-01-28 07:30:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,2,23,'EMP-3','246 Hessel River Apt. 745\nMoenview, CT 77677',84,NULL,4,2,'2022-10-28 07:30:14','2022-10-28 07:30:14','2022-01-28 07:30:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(11,2,24,'EMP-4','726 Noemy Inlet\nEdenport, IN 20010-3283',37,NULL,3,4,'2022-10-28 07:30:14','2022-10-28 07:30:14','2022-01-28 07:30:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12,2,25,'EMP-5','855 Zulauf Manors\nUriahville, MO 63551',80,NULL,2,5,'2022-10-28 07:30:14','2022-10-28 07:30:14','2022-01-28 07:30:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(13,2,26,'EMP-6','6498 Cremin Club\nRemingtonside, MT 56806',79,NULL,6,1,'2022-10-28 07:30:14','2022-10-28 07:30:14','2022-01-28 07:30:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(14,2,27,'EMP-7','253 Jodie Plains\nEast Millerberg, VA 55461',42,NULL,6,1,'2022-10-28 07:30:14','2022-10-28 07:30:14','2022-01-28 07:30:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(15,3,28,'EMP-1','70312 Osborne Prairie\nNorth Sashachester, MA 33801-3494',49,NULL,2,5,'2022-10-28 07:30:17','2022-10-28 07:30:17','2022-01-28 07:30:17',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(16,3,29,'EMP-2','546 Lafayette Shore Apt. 343\nSchultzside, WI 98941-0947',82,NULL,4,4,'2022-10-28 07:30:17','2022-10-28 07:30:17','2022-01-28 07:30:17',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(17,3,36,'EMP-3','912 Grady Passage\nStuartville, NJ 50588',81,NULL,3,4,'2022-10-28 07:30:18','2022-10-28 07:30:18','2022-01-28 07:30:18',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(18,3,37,'EMP-4','617 Braun Station\nNew Jeramyborough, HI 38987-4044',92,NULL,2,5,'2022-10-28 07:30:18','2022-10-28 07:30:18','2022-01-28 07:30:18',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(19,3,38,'EMP-5','69638 Ebert Streets Apt. 492\nRiceland, ME 02945-2663',69,NULL,1,3,'2022-10-28 07:30:18','2022-10-28 07:30:18','2022-01-28 07:30:18',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(20,3,39,'EMP-6','588 Crist Ramp Suite 230\nRueckerborough, NJ 42485-6057',60,NULL,6,5,'2022-10-28 07:30:18','2022-10-28 07:30:18','2022-01-28 07:30:18',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(21,3,40,'EMP-7','96900 Raleigh Walk Suite 439\nBeierton, OH 46851-3670',96,NULL,4,2,'2022-10-28 07:30:18','2022-10-28 07:30:18','2022-01-28 07:30:18',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22,4,41,'EMP-41',NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:34:33','2022-10-28 07:34:33','2022-10-28 13:04:33',NULL,1,1,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `employee_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_docs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_docs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_docs_user_id_foreign` (`user_id`),
  KEY `employee_docs_added_by_foreign` (`added_by`),
  KEY `employee_docs_last_updated_by_foreign` (`last_updated_by`),
  KEY `employee_docs_company_id_foreign` (`company_id`),
  CONSTRAINT `employee_docs_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_docs_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_docs_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_docs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_docs` WRITE;
/*!40000 ALTER TABLE `employee_docs` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_docs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_leave_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_leave_quotas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `leave_type_id` int unsigned NOT NULL,
  `no_of_leaves` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_leave_quotas_user_id_foreign` (`user_id`),
  KEY `employee_leave_quotas_leave_type_id_foreign` (`leave_type_id`),
  CONSTRAINT `employee_leave_quotas_leave_type_id_foreign` FOREIGN KEY (`leave_type_id`) REFERENCES `leave_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_leave_quotas_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_leave_quotas` WRITE;
/*!40000 ALTER TABLE `employee_leave_quotas` DISABLE KEYS */;
INSERT INTO `employee_leave_quotas` VALUES (1,2,1,5,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(2,2,2,5,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(3,2,3,5,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(4,3,1,5,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(5,3,2,5,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(6,3,3,5,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(7,10,1,5,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(8,10,2,5,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(9,10,3,5,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(10,11,1,5,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(11,11,2,5,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(12,11,3,5,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(13,12,1,5,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(14,12,2,5,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(15,12,3,5,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(16,13,1,5,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(17,13,2,5,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(18,13,3,5,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(19,14,1,5,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(20,14,2,5,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(21,14,3,5,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(22,15,4,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(23,15,5,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(24,15,6,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(25,16,4,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(26,16,5,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(27,16,6,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(28,23,4,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(29,23,5,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(30,23,6,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(31,24,4,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(32,24,5,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(33,24,6,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(34,25,4,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(35,25,5,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(36,25,6,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(37,26,4,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(38,26,5,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(39,26,6,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(40,27,4,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(41,27,5,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(42,27,6,5,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(43,28,7,5,'2022-10-28 07:30:17','2022-10-28 07:30:17'),(44,28,8,5,'2022-10-28 07:30:17','2022-10-28 07:30:17'),(45,28,9,5,'2022-10-28 07:30:17','2022-10-28 07:30:17'),(46,29,7,5,'2022-10-28 07:30:17','2022-10-28 07:30:17'),(47,29,8,5,'2022-10-28 07:30:17','2022-10-28 07:30:17'),(48,29,9,5,'2022-10-28 07:30:17','2022-10-28 07:30:17'),(49,36,7,5,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(50,36,8,5,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(51,36,9,5,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(52,37,7,5,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(53,37,8,5,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(54,37,9,5,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(55,38,7,5,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(56,38,8,5,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(57,38,9,5,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(58,39,7,5,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(59,39,8,5,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(60,39,9,5,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(61,40,7,5,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(62,40,8,5,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(63,40,9,5,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(64,41,10,5,'2022-10-28 07:34:33','2022-10-28 07:34:33'),(65,41,11,5,'2022-10-28 07:34:33','2022-10-28 07:34:33'),(66,41,12,5,'2022-10-28 07:34:33','2022-10-28 07:34:33');
/*!40000 ALTER TABLE `employee_leave_quotas` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_shift_change_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_shift_change_requests` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `shift_schedule_id` bigint unsigned NOT NULL,
  `employee_shift_id` bigint unsigned NOT NULL,
  `status` enum('waiting','accepted','rejected') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting',
  `reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_shift_change_requests_shift_schedule_id_foreign` (`shift_schedule_id`),
  KEY `employee_shift_change_requests_employee_shift_id_foreign` (`employee_shift_id`),
  CONSTRAINT `employee_shift_change_requests_employee_shift_id_foreign` FOREIGN KEY (`employee_shift_id`) REFERENCES `employee_shifts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_shift_change_requests_shift_schedule_id_foreign` FOREIGN KEY (`shift_schedule_id`) REFERENCES `employee_shift_schedules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_shift_change_requests` WRITE;
/*!40000 ALTER TABLE `employee_shift_change_requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_shift_change_requests` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_shift_schedules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_shift_schedules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `date` date NOT NULL,
  `employee_shift_id` bigint unsigned NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `shift_start_time` datetime DEFAULT NULL,
  `shift_end_time` datetime DEFAULT NULL,
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_shift_schedules_user_id_foreign` (`user_id`),
  KEY `employee_shift_schedules_date_index` (`date`),
  KEY `employee_shift_schedules_employee_shift_id_foreign` (`employee_shift_id`),
  KEY `employee_shift_schedules_added_by_foreign` (`added_by`),
  KEY `employee_shift_schedules_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `employee_shift_schedules_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_shift_schedules_employee_shift_id_foreign` FOREIGN KEY (`employee_shift_id`) REFERENCES `employee_shifts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_shift_schedules_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_shift_schedules_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=424 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_shift_schedules` WRITE;
/*!40000 ALTER TABLE `employee_shift_schedules` DISABLE KEYS */;
INSERT INTO `employee_shift_schedules` VALUES (1,2,'2022-10-01',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(2,2,'2022-10-02',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(3,2,'2022-10-03',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(4,2,'2022-10-04',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(5,2,'2022-10-05',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(6,2,'2022-10-06',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(7,2,'2022-10-07',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(8,2,'2022-10-08',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(9,2,'2022-10-09',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(10,2,'2022-10-10',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(11,2,'2022-10-11',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(12,2,'2022-10-12',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(13,2,'2022-10-13',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(14,2,'2022-10-14',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(15,2,'2022-10-15',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(16,2,'2022-10-16',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(17,2,'2022-10-17',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(18,2,'2022-10-18',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(19,2,'2022-10-19',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(20,2,'2022-10-20',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(21,3,'2022-10-01',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(22,3,'2022-10-02',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(23,3,'2022-10-03',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(24,3,'2022-10-04',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(25,3,'2022-10-05',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(26,3,'2022-10-06',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(27,3,'2022-10-07',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(28,3,'2022-10-08',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(29,3,'2022-10-09',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(30,3,'2022-10-10',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(31,3,'2022-10-11',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(32,3,'2022-10-12',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(33,3,'2022-10-13',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(34,3,'2022-10-14',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(35,3,'2022-10-15',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(36,3,'2022-10-16',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(37,3,'2022-10-17',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(38,3,'2022-10-18',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(39,3,'2022-10-19',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(40,3,'2022-10-20',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(41,10,'2022-10-01',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(42,10,'2022-10-02',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(43,10,'2022-10-03',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(44,10,'2022-10-04',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(45,10,'2022-10-05',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(46,10,'2022-10-06',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(47,10,'2022-10-07',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(48,10,'2022-10-08',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(49,10,'2022-10-09',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(50,10,'2022-10-10',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(51,10,'2022-10-11',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(52,10,'2022-10-12',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(53,10,'2022-10-13',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(54,10,'2022-10-14',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(55,10,'2022-10-15',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(56,10,'2022-10-16',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(57,10,'2022-10-17',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(58,10,'2022-10-18',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(59,10,'2022-10-19',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(60,10,'2022-10-20',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(61,11,'2022-10-01',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(62,11,'2022-10-02',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(63,11,'2022-10-03',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(64,11,'2022-10-04',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(65,11,'2022-10-05',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(66,11,'2022-10-06',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(67,11,'2022-10-07',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(68,11,'2022-10-08',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(69,11,'2022-10-09',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(70,11,'2022-10-10',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(71,11,'2022-10-11',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(72,11,'2022-10-12',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(73,11,'2022-10-13',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(74,11,'2022-10-14',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(75,11,'2022-10-15',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(76,11,'2022-10-16',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(77,11,'2022-10-17',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(78,11,'2022-10-18',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(79,11,'2022-10-19',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(80,11,'2022-10-20',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(81,12,'2022-10-01',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(82,12,'2022-10-02',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(83,12,'2022-10-03',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(84,12,'2022-10-04',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(85,12,'2022-10-05',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(86,12,'2022-10-06',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(87,12,'2022-10-07',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(88,12,'2022-10-08',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(89,12,'2022-10-09',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(90,12,'2022-10-10',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(91,12,'2022-10-11',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(92,12,'2022-10-12',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(93,12,'2022-10-13',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(94,12,'2022-10-14',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(95,12,'2022-10-15',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(96,12,'2022-10-16',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(97,12,'2022-10-17',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(98,12,'2022-10-18',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(99,12,'2022-10-19',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(100,12,'2022-10-20',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(101,13,'2022-10-01',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(102,13,'2022-10-02',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(103,13,'2022-10-03',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(104,13,'2022-10-04',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(105,13,'2022-10-05',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(106,13,'2022-10-06',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(107,13,'2022-10-07',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(108,13,'2022-10-08',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(109,13,'2022-10-09',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(110,13,'2022-10-10',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(111,13,'2022-10-11',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(112,13,'2022-10-12',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(113,13,'2022-10-13',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(114,13,'2022-10-14',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(115,13,'2022-10-15',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(116,13,'2022-10-16',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(117,13,'2022-10-17',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(118,13,'2022-10-18',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(119,13,'2022-10-19',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(120,13,'2022-10-20',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(121,14,'2022-10-01',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(122,14,'2022-10-02',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(123,14,'2022-10-03',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(124,14,'2022-10-04',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(125,14,'2022-10-05',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(126,14,'2022-10-06',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(127,14,'2022-10-07',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(128,14,'2022-10-08',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(129,14,'2022-10-09',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(130,14,'2022-10-10',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(131,14,'2022-10-11',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(132,14,'2022-10-12',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(133,14,'2022-10-13',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(134,14,'2022-10-14',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(135,14,'2022-10-15',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(136,14,'2022-10-16',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(137,14,'2022-10-17',1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(138,14,'2022-10-18',5,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(139,14,'2022-10-19',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(140,14,'2022-10-20',4,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:13','2022-10-28 07:30:13'),(141,15,'2022-10-01',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(142,15,'2022-10-02',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(143,15,'2022-10-03',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(144,15,'2022-10-04',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(145,15,'2022-10-05',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(146,15,'2022-10-06',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(147,15,'2022-10-07',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(148,15,'2022-10-08',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(149,15,'2022-10-09',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(150,15,'2022-10-10',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(151,15,'2022-10-11',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(152,15,'2022-10-12',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(153,15,'2022-10-13',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(154,15,'2022-10-14',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(155,15,'2022-10-15',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(156,15,'2022-10-16',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(157,15,'2022-10-17',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(158,15,'2022-10-18',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(159,15,'2022-10-19',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(160,15,'2022-10-20',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(161,16,'2022-10-01',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(162,16,'2022-10-02',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(163,16,'2022-10-03',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(164,16,'2022-10-04',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(165,16,'2022-10-05',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(166,16,'2022-10-06',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(167,16,'2022-10-07',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(168,16,'2022-10-08',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(169,16,'2022-10-09',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(170,16,'2022-10-10',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(171,16,'2022-10-11',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(172,16,'2022-10-12',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(173,16,'2022-10-13',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(174,16,'2022-10-14',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(175,16,'2022-10-15',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(176,16,'2022-10-16',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(177,16,'2022-10-17',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(178,16,'2022-10-18',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(179,16,'2022-10-19',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(180,16,'2022-10-20',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(181,23,'2022-10-01',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(182,23,'2022-10-02',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(183,23,'2022-10-03',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(184,23,'2022-10-04',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(185,23,'2022-10-05',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(186,23,'2022-10-06',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(187,23,'2022-10-07',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(188,23,'2022-10-08',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(189,23,'2022-10-09',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(190,23,'2022-10-10',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(191,23,'2022-10-11',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(192,23,'2022-10-12',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(193,23,'2022-10-13',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(194,23,'2022-10-14',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(195,23,'2022-10-15',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(196,23,'2022-10-16',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(197,23,'2022-10-17',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(198,23,'2022-10-18',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(199,23,'2022-10-19',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(200,23,'2022-10-20',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(201,24,'2022-10-01',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(202,24,'2022-10-02',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(203,24,'2022-10-03',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(204,24,'2022-10-04',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(205,24,'2022-10-05',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(206,24,'2022-10-06',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(207,24,'2022-10-07',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(208,24,'2022-10-08',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(209,24,'2022-10-09',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(210,24,'2022-10-10',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(211,24,'2022-10-11',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(212,24,'2022-10-12',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(213,24,'2022-10-13',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(214,24,'2022-10-14',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(215,24,'2022-10-15',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(216,24,'2022-10-16',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(217,24,'2022-10-17',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(218,24,'2022-10-18',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(219,24,'2022-10-19',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(220,24,'2022-10-20',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(221,25,'2022-10-01',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(222,25,'2022-10-02',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(223,25,'2022-10-03',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(224,25,'2022-10-04',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(225,25,'2022-10-05',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(226,25,'2022-10-06',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(227,25,'2022-10-07',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(228,25,'2022-10-08',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(229,25,'2022-10-09',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(230,25,'2022-10-10',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(231,25,'2022-10-11',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(232,25,'2022-10-12',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(233,25,'2022-10-13',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(234,25,'2022-10-14',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(235,25,'2022-10-15',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(236,25,'2022-10-16',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(237,25,'2022-10-17',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(238,25,'2022-10-18',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(239,25,'2022-10-19',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(240,25,'2022-10-20',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(241,26,'2022-10-01',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(242,26,'2022-10-02',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(243,26,'2022-10-03',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(244,26,'2022-10-04',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(245,26,'2022-10-05',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(246,26,'2022-10-06',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(247,26,'2022-10-07',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(248,26,'2022-10-08',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(249,26,'2022-10-09',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(250,26,'2022-10-10',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(251,26,'2022-10-11',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(252,26,'2022-10-12',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(253,26,'2022-10-13',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(254,26,'2022-10-14',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(255,26,'2022-10-15',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(256,26,'2022-10-16',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(257,26,'2022-10-17',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(258,26,'2022-10-18',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(259,26,'2022-10-19',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(260,26,'2022-10-20',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(261,27,'2022-10-01',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(262,27,'2022-10-02',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(263,27,'2022-10-03',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(264,27,'2022-10-04',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(265,27,'2022-10-05',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(266,27,'2022-10-06',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(267,27,'2022-10-07',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(268,27,'2022-10-08',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(269,27,'2022-10-09',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(270,27,'2022-10-10',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(271,27,'2022-10-11',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(272,27,'2022-10-12',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(273,27,'2022-10-13',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(274,27,'2022-10-14',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(275,27,'2022-10-15',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(276,27,'2022-10-16',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(277,27,'2022-10-17',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(278,27,'2022-10-18',7,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(279,27,'2022-10-19',6,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(280,27,'2022-10-20',2,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(281,28,'2022-10-01',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(282,28,'2022-10-02',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(283,28,'2022-10-03',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(284,28,'2022-10-04',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(285,28,'2022-10-05',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(286,28,'2022-10-06',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(287,28,'2022-10-07',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(288,28,'2022-10-08',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(289,28,'2022-10-09',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(290,28,'2022-10-10',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(291,28,'2022-10-11',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(292,28,'2022-10-12',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(293,28,'2022-10-13',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(294,28,'2022-10-14',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(295,28,'2022-10-15',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(296,28,'2022-10-16',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(297,28,'2022-10-17',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(298,28,'2022-10-18',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(299,28,'2022-10-19',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(300,28,'2022-10-20',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(301,29,'2022-10-01',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(302,29,'2022-10-02',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(303,29,'2022-10-03',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(304,29,'2022-10-04',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(305,29,'2022-10-05',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(306,29,'2022-10-06',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(307,29,'2022-10-07',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(308,29,'2022-10-08',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(309,29,'2022-10-09',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(310,29,'2022-10-10',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(311,29,'2022-10-11',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(312,29,'2022-10-12',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(313,29,'2022-10-13',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(314,29,'2022-10-14',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(315,29,'2022-10-15',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(316,29,'2022-10-16',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(317,29,'2022-10-17',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(318,29,'2022-10-18',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(319,29,'2022-10-19',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(320,29,'2022-10-20',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(321,36,'2022-10-01',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(322,36,'2022-10-02',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(323,36,'2022-10-03',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(324,36,'2022-10-04',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(325,36,'2022-10-05',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(326,36,'2022-10-06',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(327,36,'2022-10-07',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(328,36,'2022-10-08',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(329,36,'2022-10-09',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(330,36,'2022-10-10',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(331,36,'2022-10-11',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(332,36,'2022-10-12',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(333,36,'2022-10-13',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(334,36,'2022-10-14',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(335,36,'2022-10-15',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(336,36,'2022-10-16',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(337,36,'2022-10-17',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(338,36,'2022-10-18',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(339,36,'2022-10-19',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(340,36,'2022-10-20',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(341,37,'2022-10-01',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(342,37,'2022-10-02',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(343,37,'2022-10-03',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(344,37,'2022-10-04',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(345,37,'2022-10-05',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(346,37,'2022-10-06',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(347,37,'2022-10-07',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(348,37,'2022-10-08',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(349,37,'2022-10-09',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(350,37,'2022-10-10',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(351,37,'2022-10-11',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(352,37,'2022-10-12',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(353,37,'2022-10-13',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(354,37,'2022-10-14',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(355,37,'2022-10-15',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(356,37,'2022-10-16',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(357,37,'2022-10-17',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(358,37,'2022-10-18',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(359,37,'2022-10-19',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(360,37,'2022-10-20',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(361,38,'2022-10-01',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(362,38,'2022-10-02',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(363,38,'2022-10-03',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(364,38,'2022-10-04',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(365,38,'2022-10-05',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(366,38,'2022-10-06',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(367,38,'2022-10-07',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(368,38,'2022-10-08',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(369,38,'2022-10-09',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(370,38,'2022-10-10',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(371,38,'2022-10-11',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(372,38,'2022-10-12',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(373,38,'2022-10-13',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(374,38,'2022-10-14',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(375,38,'2022-10-15',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(376,38,'2022-10-16',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(377,38,'2022-10-17',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(378,38,'2022-10-18',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(379,38,'2022-10-19',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(380,38,'2022-10-20',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(381,39,'2022-10-01',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(382,39,'2022-10-02',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(383,39,'2022-10-03',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(384,39,'2022-10-04',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(385,39,'2022-10-05',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(386,39,'2022-10-06',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(387,39,'2022-10-07',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(388,39,'2022-10-08',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(389,39,'2022-10-09',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(390,39,'2022-10-10',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(391,39,'2022-10-11',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(392,39,'2022-10-12',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(393,39,'2022-10-13',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(394,39,'2022-10-14',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(395,39,'2022-10-15',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(396,39,'2022-10-16',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(397,39,'2022-10-17',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(398,39,'2022-10-18',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(399,39,'2022-10-19',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(400,39,'2022-10-20',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(401,40,'2022-10-01',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(402,40,'2022-10-02',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(403,40,'2022-10-03',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(404,40,'2022-10-04',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(405,40,'2022-10-05',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(406,40,'2022-10-06',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(407,40,'2022-10-07',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(408,40,'2022-10-08',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(409,40,'2022-10-09',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(410,40,'2022-10-10',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(411,40,'2022-10-11',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(412,40,'2022-10-12',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(413,40,'2022-10-13',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(414,40,'2022-10-14',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(415,40,'2022-10-15',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(416,40,'2022-10-16',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(417,40,'2022-10-17',9,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(418,40,'2022-10-18',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(419,40,'2022-10-19',8,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(420,40,'2022-10-20',3,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:20','2022-10-28 07:30:20'),(423,2,'2022-11-01',1,2,2,'2022-11-01 09:00:00','2022-11-01 18:00:00',NULL,'2022-10-31 02:38:18','2022-10-31 02:38:18');
/*!40000 ALTER TABLE `employee_shift_schedules` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_shifts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `shift_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `shift_short_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `office_start_time` time NOT NULL,
  `office_end_time` time NOT NULL,
  `halfday_mark_time` time DEFAULT NULL,
  `late_mark_duration` tinyint NOT NULL,
  `clockin_in_day` tinyint NOT NULL,
  `office_open_days` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_shifts_company_id_foreign` (`company_id`),
  CONSTRAINT `employee_shifts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_shifts` WRITE;
/*!40000 ALTER TABLE `employee_shifts` DISABLE KEYS */;
INSERT INTO `employee_shifts` VALUES (1,1,'General Shift','GS','#99C7F1','09:00:00','18:00:00',NULL,20,2,'[1,2,3,4,5]','2022-10-28 07:30:08','2022-10-28 07:30:08'),(2,2,'General Shift','GS','#99C7F1','09:00:00','18:00:00',NULL,20,2,'[1,2,3,4,5]','2022-10-28 07:30:09','2022-10-28 07:30:09'),(3,3,'General Shift','GS','#99C7F1','09:00:00','18:00:00',NULL,20,2,'[1,2,3,4,5]','2022-10-28 07:30:10','2022-10-28 07:30:10'),(4,1,'Night Shift','NS','#4d4c4c','22:00:00','06:00:00','01:00:00',15,1,'[\"1\",\"2\",\"3\",\"4\",\"5\"]','2022-10-28 07:30:12','2022-10-28 07:30:12'),(5,1,'Day Shift','DS','#ff0000','08:00:00','17:00:00','13:30:00',15,1,'[\"1\",\"2\",\"3\",\"4\",\"5\"]','2022-10-28 07:30:12','2022-10-28 07:30:12'),(6,2,'Night Shift','NS','#4d4c4c','22:00:00','06:00:00','01:00:00',15,1,'[\"1\",\"2\",\"3\",\"4\",\"5\"]','2022-10-28 07:30:16','2022-10-28 07:30:16'),(7,2,'Day Shift','DS','#ff0000','08:00:00','17:00:00','13:30:00',15,1,'[\"1\",\"2\",\"3\",\"4\",\"5\"]','2022-10-28 07:30:16','2022-10-28 07:30:16'),(8,3,'Night Shift','NS','#4d4c4c','22:00:00','06:00:00','01:00:00',15,1,'[\"1\",\"2\",\"3\",\"4\",\"5\"]','2022-10-28 07:30:19','2022-10-28 07:30:19'),(9,3,'Day Shift','DS','#ff0000','08:00:00','17:00:00','13:30:00',15,1,'[\"1\",\"2\",\"3\",\"4\",\"5\"]','2022-10-28 07:30:19','2022-10-28 07:30:19'),(10,4,'General Shift','GS','#99C7F1','09:00:00','18:00:00',NULL,20,2,'[1,2,3,4,5]','2022-10-28 07:34:32','2022-10-28 07:34:32');
/*!40000 ALTER TABLE `employee_shifts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_skills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_skills` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `skill_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_skills_user_id_foreign` (`user_id`),
  KEY `employee_skills_skill_id_foreign` (`skill_id`),
  KEY `employee_skills_company_id_foreign` (`company_id`),
  CONSTRAINT `employee_skills_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_skills_skill_id_foreign` FOREIGN KEY (`skill_id`) REFERENCES `skills` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_skills_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_skills` WRITE;
/*!40000 ALTER TABLE `employee_skills` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_skills` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_teams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_teams` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `team_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_teams_team_id_foreign` (`team_id`),
  KEY `employee_teams_user_id_foreign` (`user_id`),
  KEY `employee_teams_company_id_foreign` (`company_id`),
  CONSTRAINT `employee_teams_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_teams_team_id_foreign` FOREIGN KEY (`team_id`) REFERENCES `teams` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_teams_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_teams` WRITE;
/*!40000 ALTER TABLE `employee_teams` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_teams` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `estimate_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `estimate_item_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `estimate_item_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estimate_item_images_estimate_item_id_foreign` (`estimate_item_id`),
  CONSTRAINT `estimate_item_images_estimate_item_id_foreign` FOREIGN KEY (`estimate_item_id`) REFERENCES `estimate_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `estimate_item_images` WRITE;
/*!40000 ALTER TABLE `estimate_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `estimate_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `estimate_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `estimate_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `estimate_id` int unsigned NOT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_summary` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` enum('item','discount','tax') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `quantity` double(16,2) NOT NULL,
  `unit_price` double(16,2) NOT NULL,
  `amount` double(16,2) NOT NULL,
  `taxes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estimate_items_estimate_id_foreign` (`estimate_id`),
  CONSTRAINT `estimate_items_estimate_id_foreign` FOREIGN KEY (`estimate_id`) REFERENCES `estimates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `estimate_items` WRITE;
/*!40000 ALTER TABLE `estimate_items` DISABLE KEYS */;
INSERT INTO `estimate_items` VALUES (1,1,'item 1',NULL,'item',1.00,500.00,500.00,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL),(2,1,'item 2',NULL,'item',1.00,700.00,700.00,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL),(3,2,'item 3',NULL,'item',2.00,1200.00,2400.00,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL),(4,2,'item 4',NULL,'item',1.00,1700.00,1700.00,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL),(5,3,'item 1',NULL,'item',1.00,500.00,500.00,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(6,3,'item 2',NULL,'item',1.00,700.00,700.00,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(7,4,'item 3',NULL,'item',2.00,1200.00,2400.00,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(8,4,'item 4',NULL,'item',1.00,1700.00,1700.00,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(9,5,'item 1',NULL,'item',1.00,500.00,500.00,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',NULL),(10,5,'item 2',NULL,'item',1.00,700.00,700.00,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',NULL),(11,6,'item 3',NULL,'item',2.00,1200.00,2400.00,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',NULL),(12,6,'item 4',NULL,'item',1.00,1700.00,1700.00,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',NULL);
/*!40000 ALTER TABLE `estimate_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `estimates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `estimates` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned NOT NULL,
  `estimate_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valid_till` date NOT NULL,
  `sub_total` double(16,2) NOT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `discount_type` enum('percent','fixed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'percent',
  `total` double(16,2) NOT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `status` enum('declined','accepted','waiting','sent','draft','canceled') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting',
  `note` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `send_status` tinyint(1) NOT NULL DEFAULT '1',
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `hash` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `calculate_tax` enum('after_discount','before_discount') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'after_discount',
  PRIMARY KEY (`id`),
  UNIQUE KEY `estimates_estimate_number_company_id_unique` (`estimate_number`,`company_id`),
  KEY `estimates_client_id_foreign` (`client_id`),
  KEY `estimates_currency_id_foreign` (`currency_id`),
  KEY `estimates_added_by_foreign` (`added_by`),
  KEY `estimates_last_updated_by_foreign` (`last_updated_by`),
  KEY `estimates_company_id_foreign` (`company_id`),
  CONSTRAINT `estimates_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `estimates_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimates_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimates_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimates_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `estimates` WRITE;
/*!40000 ALTER TABLE `estimates` DISABLE KEYS */;
INSERT INTO `estimates` VALUES (1,1,4,'001','2022-10-03',1200.00,0,'percent',1200.00,1,'waiting',NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',1,NULL,NULL,'tMW38P9BgUuHmBcPOOyl9xd7duNl3pV9','after_discount'),(2,1,4,'002','2022-10-10',4100.00,0,'percent',4100.00,1,'waiting',NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',1,NULL,NULL,'65svhKblHW7bdLFFX5x2uVvuIovfMERK','after_discount'),(3,2,17,'001','2022-10-03',1200.00,0,'percent',1200.00,1,'waiting',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',1,NULL,NULL,'GHwT39UvWHmSm3eRGoqhz6iHHf6w4SMv','after_discount'),(4,2,17,'002','2022-10-10',4100.00,0,'percent',4100.00,1,'waiting',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',1,NULL,NULL,'IL9EZvP0lDwV5zn0NTzpvvudDwaHM5XL','after_discount'),(5,3,30,'001','2022-10-03',1200.00,0,'percent',1200.00,1,'waiting',NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',1,NULL,NULL,'vf5YknEEE7LSgX006gCLRhFSqibMYoRS','after_discount'),(6,3,30,'002','2022-10-10',4100.00,0,'percent',4100.00,1,'waiting',NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',1,NULL,NULL,'GbDbF71F3ptnb8zGcC8rJK1O0zo1fpxf','after_discount');
/*!40000 ALTER TABLE `estimates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `event_attendees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `event_attendees` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `event_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `event_attendees_user_id_foreign` (`user_id`),
  KEY `event_attendees_event_id_foreign` (`event_id`),
  KEY `event_attendees_company_id_foreign` (`company_id`),
  CONSTRAINT `event_attendees_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `event_attendees_event_id_foreign` FOREIGN KEY (`event_id`) REFERENCES `events` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `event_attendees_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `event_attendees` WRITE;
/*!40000 ALTER TABLE `event_attendees` DISABLE KEYS */;
INSERT INTO `event_attendees` VALUES (1,NULL,28,1,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(2,NULL,40,1,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(3,NULL,29,1,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(4,NULL,37,1,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(5,NULL,38,1,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(6,NULL,39,1,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(7,NULL,36,1,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(8,NULL,37,2,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(9,NULL,38,2,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(10,NULL,37,5,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(11,NULL,36,5,'2022-10-28 07:30:19','2022-10-28 07:30:19');
/*!40000 ALTER TABLE `event_attendees` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `event_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `event_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `event_id` int unsigned NOT NULL,
  `filename` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `event_files_event_id_foreign` (`event_id`),
  KEY `event_files_added_by_foreign` (`added_by`),
  KEY `event_files_last_updated_by_foreign` (`last_updated_by`),
  KEY `event_files_company_id_foreign` (`company_id`),
  CONSTRAINT `event_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `event_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `event_files_event_id_foreign` FOREIGN KEY (`event_id`) REFERENCES `events` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `event_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `event_files` WRITE;
/*!40000 ALTER TABLE `event_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `event_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `events` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `event_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `label_color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `where` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_date_time` datetime NOT NULL,
  `end_date_time` datetime NOT NULL,
  `repeat` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `repeat_every` int DEFAULT NULL,
  `repeat_cycles` int DEFAULT NULL,
  `repeat_type` enum('day','week','month','year') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'day',
  `send_reminder` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `remind_time` int DEFAULT NULL,
  `remind_type` enum('day','hour','minute') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'day',
  `event_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `event_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `events_added_by_foreign` (`added_by`),
  KEY `events_last_updated_by_foreign` (`last_updated_by`),
  KEY `events_company_id_foreign` (`company_id`),
  CONSTRAINT `events_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `events_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `events_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `events` WRITE;
/*!40000 ALTER TABLE `events` DISABLE KEYS */;
INSERT INTO `events` VALUES (1,3,'Et esse et modi.','#0000A0','4551 Gabriel Row\nBartonport, NJ 63154-3249','Quis nulla iure velit et sed maiores. Voluptas itaque ab voluptatum aliquam voluptate facere. Quod minima nisi rerum illo sint est quasi distinctio. Aut voluptate placeat corrupti quos.','2022-10-11 08:50:40','2022-10-11 08:50:40','no',NULL,NULL,'day','no',NULL,'day',NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,NULL,NULL),(2,3,'Dicta non impedit.','#008000','93036 Bayer Fort\nJaunitaburgh, AK 24767-6273','Omnis quia voluptas sapiente velit porro. Voluptas veniam aliquid accusantium voluptatum. Voluptatem sunt rerum harum distinctio ducimus. Impedit voluptates dolorem perspiciatis ab.','2022-06-01 22:57:42','2022-06-01 22:57:42','no',NULL,NULL,'day','no',NULL,'day',NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,NULL,NULL),(3,3,'Veniam est et.','#808000','59191 Kailyn Burg Apt. 388\nTysonmouth, WV 95926','Quis aut repellat molestiae accusamus sit aperiam possimus occaecati. Nobis eum neque et aspernatur. Ullam error repellendus sed quidem voluptatem ipsa illo. Ex sed corrupti recusandae quia ut libero dolorem.','2022-09-26 12:44:40','2022-09-26 12:44:40','no',NULL,NULL,'day','no',NULL,'day',NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,NULL,NULL),(4,3,'Voluptatibus velit.','#000000','98735 Borer Coves Apt. 936\nSilasbury, TN 82190-4216','Est iure repellat repudiandae nisi doloribus. Autem dolore dolorum aspernatur. Laudantium nobis ut harum voluptatem. Illum unde explicabo debitis dolores.','2022-04-29 05:48:56','2022-04-29 05:48:56','no',NULL,NULL,'day','no',NULL,'day',NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,NULL,NULL),(5,3,'Asperiores ut.','#008000','855 Schaefer Walks\nLockmanmouth, IL 53924-1290','Autem expedita id est neque ea aperiam. Ab totam veritatis excepturi. Dolores enim quis voluptas amet aut. Voluptas tempora voluptas et voluptates enim voluptatem.','2022-10-28 04:31:15','2022-10-28 04:31:15','no',NULL,NULL,'day','no',NULL,'day',NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,NULL,NULL);
/*!40000 ALTER TABLE `events` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `expenses` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `purchase_date` date NOT NULL,
  `purchase_from` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` double(16,2) NOT NULL,
  `currency_id` int unsigned NOT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `bill` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `status` enum('pending','approved','rejected') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `can_claim` tinyint(1) NOT NULL DEFAULT '1',
  `category_id` bigint unsigned DEFAULT NULL,
  `expenses_recurring_id` bigint unsigned DEFAULT NULL,
  `created_by` int unsigned DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `approver_id` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expenses_currency_id_foreign` (`currency_id`),
  KEY `expenses_user_id_foreign` (`user_id`),
  KEY `expenses_category_id_foreign` (`category_id`),
  KEY `expenses_expenses_recurring_id_foreign` (`expenses_recurring_id`),
  KEY `expenses_created_by_foreign` (`created_by`),
  KEY `expenses_added_by_foreign` (`added_by`),
  KEY `expenses_last_updated_by_foreign` (`last_updated_by`),
  KEY `expenses_approver_id_foreign` (`approver_id`),
  KEY `expenses_company_id_foreign` (`company_id`),
  CONSTRAINT `expenses_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_approver_id_foreign` FOREIGN KEY (`approver_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `expenses_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `expenses_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_expenses_recurring_id_foreign` FOREIGN KEY (`expenses_recurring_id`) REFERENCES `expenses_recurring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expenses` WRITE;
/*!40000 ALTER TABLE `expenses` DISABLE KEYS */;
INSERT INTO `expenses` VALUES (1,1,'Molestiae.','2022-01-06','Utah',617.00,2,NULL,NULL,11,'rejected','2022-10-28 07:30:12','2022-10-28 07:30:12',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,1,'Ad saepe eum ea.','2022-01-29','Pennsylvania',261.00,2,NULL,NULL,11,'approved','2022-10-28 07:30:12','2022-10-28 07:30:12',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,1,'Eveniet molestiae.','2022-04-18','Texas',214.00,2,NULL,NULL,11,'pending','2022-10-28 07:30:12','2022-10-28 07:30:12',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,1,'Dignissimos enim.','2022-10-04','Illinois',382.00,2,NULL,NULL,11,'approved','2022-10-28 07:30:12','2022-10-28 07:30:12',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,1,'Architecto et quas.','2022-04-19','Wisconsin',400.00,2,NULL,NULL,11,'rejected','2022-10-28 07:30:12','2022-10-28 07:30:12',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,2,'Excepturi quia quae.','2022-10-13','Kansas',917.00,7,NULL,NULL,24,'rejected','2022-10-28 07:30:15','2022-10-28 07:30:15',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(7,2,'Magnam quia non.','2022-06-19','Nebraska',276.00,7,NULL,NULL,24,'pending','2022-10-28 07:30:15','2022-10-28 07:30:15',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,2,'Et totam blanditiis.','2022-10-01','Wyoming',296.00,7,NULL,NULL,24,'pending','2022-10-28 07:30:15','2022-10-28 07:30:15',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(9,2,'Omnis fugiat ut.','2022-09-04','North Dakota',744.00,7,NULL,NULL,24,'rejected','2022-10-28 07:30:15','2022-10-28 07:30:15',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,2,'Quibusdam.','2022-10-24','Delaware',155.00,7,NULL,NULL,24,'approved','2022-10-28 07:30:15','2022-10-28 07:30:15',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(11,3,'Eum maxime numquam.','2022-07-06','Alaska',946.00,11,NULL,NULL,36,'approved','2022-10-28 07:30:19','2022-10-28 07:30:19',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12,3,'Reiciendis in ut.','2022-10-20','Indiana',580.00,11,NULL,NULL,36,'pending','2022-10-28 07:30:19','2022-10-28 07:30:19',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(13,3,'Sit est accusantium.','2022-06-27','Hawaii',890.00,11,NULL,NULL,36,'pending','2022-10-28 07:30:19','2022-10-28 07:30:19',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(14,3,'Quos consequatur.','2022-07-01','Mississippi',695.00,11,NULL,NULL,36,'pending','2022-10-28 07:30:19','2022-10-28 07:30:19',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(15,3,'Sapiente quia id.','2022-10-24','Missouri',199.00,11,NULL,NULL,36,'approved','2022-10-28 07:30:19','2022-10-28 07:30:19',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `expenses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expenses_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `expenses_category` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expenses_category_added_by_foreign` (`added_by`),
  KEY `expenses_category_last_updated_by_foreign` (`last_updated_by`),
  KEY `expenses_category_company_id_foreign` (`company_id`),
  CONSTRAINT `expenses_category_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_category_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_category_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expenses_category` WRITE;
/*!40000 ALTER TABLE `expenses_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `expenses_category` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expenses_category_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `expenses_category_roles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `expenses_category_id` bigint unsigned DEFAULT NULL,
  `role_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expenses_category_roles_expenses_category_id_foreign` (`expenses_category_id`),
  KEY `expenses_category_roles_role_id_foreign` (`role_id`),
  KEY `expenses_category_roles_company_id_foreign` (`company_id`),
  CONSTRAINT `expenses_category_roles_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_category_roles_expenses_category_id_foreign` FOREIGN KEY (`expenses_category_id`) REFERENCES `expenses_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_category_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expenses_category_roles` WRITE;
/*!40000 ALTER TABLE `expenses_category_roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `expenses_category_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expenses_recurring`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `expenses_recurring` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_id` bigint unsigned DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `created_by` int unsigned DEFAULT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `day_of_month` int DEFAULT '1',
  `day_of_week` int DEFAULT '1',
  `payment_method` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rotation` enum('monthly','weekly','bi-weekly','quarterly','half-yearly','annually','daily') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `billing_cycle` int DEFAULT NULL,
  `unlimited_recurring` tinyint(1) NOT NULL DEFAULT '0',
  `price` double NOT NULL,
  `bill` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `purchase_from` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expenses_recurring_category_id_foreign` (`category_id`),
  KEY `expenses_recurring_currency_id_foreign` (`currency_id`),
  KEY `expenses_recurring_project_id_foreign` (`project_id`),
  KEY `expenses_recurring_user_id_foreign` (`user_id`),
  KEY `expenses_recurring_created_by_foreign` (`created_by`),
  KEY `expenses_recurring_added_by_foreign` (`added_by`),
  KEY `expenses_recurring_last_updated_by_foreign` (`last_updated_by`),
  KEY `expenses_recurring_company_id_foreign` (`company_id`),
  CONSTRAINT `expenses_recurring_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `expenses_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expenses_recurring` WRITE;
/*!40000 ALTER TABLE `expenses_recurring` DISABLE KEYS */;
/*!40000 ALTER TABLE `expenses_recurring` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
INSERT INTO `failed_jobs` VALUES (1,'832a6365-f460-4dfb-bfc5-1106bf9a0c44','database','default','{\"uuid\":\"832a6365-f460-4dfb-bfc5-1106bf9a0c44\",\"displayName\":\"App\\\\Notifications\\\\ShiftScheduled\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Notifications\\\\SendQueuedNotifications\",\"command\":\"O:48:\\\"Illuminate\\\\Notifications\\\\SendQueuedNotifications\\\":3:{s:11:\\\"notifiables\\\";O:45:\\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\\":5:{s:5:\\\"class\\\";s:15:\\\"App\\\\Models\\\\User\\\";s:2:\\\"id\\\";a:1:{i:0;i:2;}s:9:\\\"relations\\\";a:6:{i:0;s:4:\\\"role\\\";i:1;s:13:\\\"clientDetails\\\";i:2;s:7:\\\"session\\\";i:3;s:14:\\\"employeeDetail\\\";i:4;s:26:\\\"employeeDetail.designation\\\";i:5;s:22:\\\"employeeDetail.company\\\";}s:10:\\\"connection\\\";s:5:\\\"mysql\\\";s:15:\\\"collectionClass\\\";N;}s:12:\\\"notification\\\";O:32:\\\"App\\\\Notifications\\\\ShiftScheduled\\\":3:{s:21:\\\"employeeShiftSchedule\\\";O:45:\\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\\":5:{s:5:\\\"class\\\";s:32:\\\"App\\\\Models\\\\EmployeeShiftSchedule\\\";s:2:\\\"id\\\";i:421;s:9:\\\"relations\\\";a:9:{i:0;s:5:\\\"shift\\\";i:1;s:13:\\\"shift.company\\\";i:2;s:4:\\\"user\\\";i:3;s:9:\\\"user.role\\\";i:4;s:18:\\\"user.clientDetails\\\";i:5;s:12:\\\"user.session\\\";i:6;s:19:\\\"user.employeeDetail\\\";i:7;s:31:\\\"user.employeeDetail.designation\\\";i:8;s:27:\\\"user.employeeDetail.company\\\";}s:10:\\\"connection\\\";s:5:\\\"mysql\\\";s:15:\\\"collectionClass\\\";N;}s:10:\\\"\\u0000*\\u0000company\\\";O:45:\\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\\":5:{s:5:\\\"class\\\";s:18:\\\"App\\\\Models\\\\Company\\\";s:2:\\\"id\\\";i:1;s:9:\\\"relations\\\";a:0:{}s:10:\\\"connection\\\";s:5:\\\"mysql\\\";s:15:\\\"collectionClass\\\";N;}s:2:\\\"id\\\";s:36:\\\"02e0b782-69b5-4586-b9a1-9e1602c353cc\\\";}s:8:\\\"channels\\\";a:1:{i:0;s:4:\\\"mail\\\";}}\"},\"sentry_trace_parent_data\":\"c7ed112d592b4de3b86931395cc5e598-4172832221a84878-1\"}','Illuminate\\Database\\Eloquent\\ModelNotFoundException: No query results for model [App\\Models\\EmployeeShiftSchedule]. in /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Database/Eloquent/Builder.php:588\nStack trace:\n#0 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/SerializesAndRestoresModelIdentifiers.php(108): Illuminate\\Database\\Eloquent\\Builder->firstOrFail()\n#1 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/SerializesAndRestoresModelIdentifiers.php(61): Illuminate\\Notifications\\Notification->restoreModel(Object(Illuminate\\Contracts\\Database\\ModelIdentifier))\n#2 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/SerializesModels.php(126): Illuminate\\Notifications\\Notification->getRestoredPropertyValue(Object(Illuminate\\Contracts\\Database\\ModelIdentifier))\n#3 [internal function]: Illuminate\\Notifications\\Notification->__unserialize(Array)\n#4 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(97): unserialize(\'O:48:\"Illuminat...\')\n#5 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(60): Illuminate\\Queue\\CallQueuedHandler->getCommand(Array)\n#6 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#7 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(425): Illuminate\\Queue\\Jobs\\Job->fire()\n#8 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(375): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#9 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(326): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#10 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(150): Illuminate\\Queue\\Worker->runNextJob(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#11 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(134): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#12 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#13 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#14 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#15 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#16 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/Container.php(651): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#17 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Console/Command.php(144): Illuminate\\Container\\Container->call(Array)\n#18 /Users/abhinav/htdocs/worksuite-new/vendor/symfony/console/Command/Command.php(291): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#19 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Console/Command.php(126): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#20 /Users/abhinav/htdocs/worksuite-new/vendor/symfony/console/Application.php(1002): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#21 /Users/abhinav/htdocs/worksuite-new/vendor/symfony/console/Application.php(299): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#22 /Users/abhinav/htdocs/worksuite-new/vendor/symfony/console/Application.php(171): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#23 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Console/Application.php(102): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#24 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(155): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#25 /Users/abhinav/htdocs/worksuite-new/artisan(37): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#26 {main}','2022-10-31 03:48:59'),(2,'4cd9b523-70ec-4ec3-b83d-286d58409239','database','default','{\"uuid\":\"4cd9b523-70ec-4ec3-b83d-286d58409239\",\"displayName\":\"App\\\\Notifications\\\\ShiftScheduled\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Notifications\\\\SendQueuedNotifications\",\"command\":\"O:48:\\\"Illuminate\\\\Notifications\\\\SendQueuedNotifications\\\":3:{s:11:\\\"notifiables\\\";O:45:\\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\\":5:{s:5:\\\"class\\\";s:15:\\\"App\\\\Models\\\\User\\\";s:2:\\\"id\\\";a:1:{i:0;i:2;}s:9:\\\"relations\\\";a:6:{i:0;s:4:\\\"role\\\";i:1;s:13:\\\"clientDetails\\\";i:2;s:7:\\\"session\\\";i:3;s:14:\\\"employeeDetail\\\";i:4;s:26:\\\"employeeDetail.designation\\\";i:5;s:22:\\\"employeeDetail.company\\\";}s:10:\\\"connection\\\";s:5:\\\"mysql\\\";s:15:\\\"collectionClass\\\";N;}s:12:\\\"notification\\\";O:32:\\\"App\\\\Notifications\\\\ShiftScheduled\\\":3:{s:21:\\\"employeeShiftSchedule\\\";O:45:\\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\\":5:{s:5:\\\"class\\\";s:32:\\\"App\\\\Models\\\\EmployeeShiftSchedule\\\";s:2:\\\"id\\\";i:421;s:9:\\\"relations\\\";a:9:{i:0;s:5:\\\"shift\\\";i:1;s:13:\\\"shift.company\\\";i:2;s:4:\\\"user\\\";i:3;s:9:\\\"user.role\\\";i:4;s:18:\\\"user.clientDetails\\\";i:5;s:12:\\\"user.session\\\";i:6;s:19:\\\"user.employeeDetail\\\";i:7;s:31:\\\"user.employeeDetail.designation\\\";i:8;s:27:\\\"user.employeeDetail.company\\\";}s:10:\\\"connection\\\";s:5:\\\"mysql\\\";s:15:\\\"collectionClass\\\";N;}s:10:\\\"\\u0000*\\u0000company\\\";O:45:\\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\\":5:{s:5:\\\"class\\\";s:18:\\\"App\\\\Models\\\\Company\\\";s:2:\\\"id\\\";i:1;s:9:\\\"relations\\\";a:0:{}s:10:\\\"connection\\\";s:5:\\\"mysql\\\";s:15:\\\"collectionClass\\\";N;}s:2:\\\"id\\\";s:36:\\\"02e0b782-69b5-4586-b9a1-9e1602c353cc\\\";}s:8:\\\"channels\\\";a:1:{i:0;s:8:\\\"database\\\";}}\"},\"sentry_trace_parent_data\":\"c7ed112d592b4de3b86931395cc5e598-4172832221a84878-1\"}','Illuminate\\Database\\Eloquent\\ModelNotFoundException: No query results for model [App\\Models\\EmployeeShiftSchedule]. in /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Database/Eloquent/Builder.php:588\nStack trace:\n#0 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/SerializesAndRestoresModelIdentifiers.php(108): Illuminate\\Database\\Eloquent\\Builder->firstOrFail()\n#1 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/SerializesAndRestoresModelIdentifiers.php(61): Illuminate\\Notifications\\Notification->restoreModel(Object(Illuminate\\Contracts\\Database\\ModelIdentifier))\n#2 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/SerializesModels.php(126): Illuminate\\Notifications\\Notification->getRestoredPropertyValue(Object(Illuminate\\Contracts\\Database\\ModelIdentifier))\n#3 [internal function]: Illuminate\\Notifications\\Notification->__unserialize(Array)\n#4 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(97): unserialize(\'O:48:\"Illuminat...\')\n#5 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(60): Illuminate\\Queue\\CallQueuedHandler->getCommand(Array)\n#6 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#7 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(425): Illuminate\\Queue\\Jobs\\Job->fire()\n#8 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(375): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#9 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(326): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#10 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(150): Illuminate\\Queue\\Worker->runNextJob(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#11 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(134): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#12 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#13 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#14 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#15 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#16 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/Container.php(651): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#17 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Console/Command.php(144): Illuminate\\Container\\Container->call(Array)\n#18 /Users/abhinav/htdocs/worksuite-new/vendor/symfony/console/Command/Command.php(291): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#19 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Console/Command.php(126): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#20 /Users/abhinav/htdocs/worksuite-new/vendor/symfony/console/Application.php(1002): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#21 /Users/abhinav/htdocs/worksuite-new/vendor/symfony/console/Application.php(299): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#22 /Users/abhinav/htdocs/worksuite-new/vendor/symfony/console/Application.php(171): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#23 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Console/Application.php(102): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#24 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(155): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#25 /Users/abhinav/htdocs/worksuite-new/artisan(37): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#26 {main}','2022-10-31 03:49:00'),(3,'cebd471b-31d1-4566-92ef-a228ad2c7b2a','database','default','{\"uuid\":\"cebd471b-31d1-4566-92ef-a228ad2c7b2a\",\"displayName\":\"App\\\\Notifications\\\\ShiftScheduled\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Notifications\\\\SendQueuedNotifications\",\"command\":\"O:48:\\\"Illuminate\\\\Notifications\\\\SendQueuedNotifications\\\":3:{s:11:\\\"notifiables\\\";O:45:\\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\\":5:{s:5:\\\"class\\\";s:15:\\\"App\\\\Models\\\\User\\\";s:2:\\\"id\\\";a:1:{i:0;i:2;}s:9:\\\"relations\\\";a:6:{i:0;s:4:\\\"role\\\";i:1;s:13:\\\"clientDetails\\\";i:2;s:7:\\\"session\\\";i:3;s:14:\\\"employeeDetail\\\";i:4;s:26:\\\"employeeDetail.designation\\\";i:5;s:22:\\\"employeeDetail.company\\\";}s:10:\\\"connection\\\";s:5:\\\"mysql\\\";s:15:\\\"collectionClass\\\";N;}s:12:\\\"notification\\\";O:32:\\\"App\\\\Notifications\\\\ShiftScheduled\\\":3:{s:21:\\\"employeeShiftSchedule\\\";O:45:\\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\\":5:{s:5:\\\"class\\\";s:32:\\\"App\\\\Models\\\\EmployeeShiftSchedule\\\";s:2:\\\"id\\\";i:422;s:9:\\\"relations\\\";a:9:{i:0;s:5:\\\"shift\\\";i:1;s:13:\\\"shift.company\\\";i:2;s:4:\\\"user\\\";i:3;s:9:\\\"user.role\\\";i:4;s:18:\\\"user.clientDetails\\\";i:5;s:12:\\\"user.session\\\";i:6;s:19:\\\"user.employeeDetail\\\";i:7;s:31:\\\"user.employeeDetail.designation\\\";i:8;s:27:\\\"user.employeeDetail.company\\\";}s:10:\\\"connection\\\";s:5:\\\"mysql\\\";s:15:\\\"collectionClass\\\";N;}s:10:\\\"\\u0000*\\u0000company\\\";O:45:\\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\\":5:{s:5:\\\"class\\\";s:18:\\\"App\\\\Models\\\\Company\\\";s:2:\\\"id\\\";i:1;s:9:\\\"relations\\\";a:0:{}s:10:\\\"connection\\\";s:5:\\\"mysql\\\";s:15:\\\"collectionClass\\\";N;}s:2:\\\"id\\\";s:36:\\\"3a730e64-e8c0-4dbd-af07-3491b2e0259e\\\";}s:8:\\\"channels\\\";a:1:{i:0;s:4:\\\"mail\\\";}}\"},\"sentry_trace_parent_data\":\"173c451c43814d8591abbdf7d0ba812b-f9c4de43be1641a2-1\"}','Illuminate\\Database\\Eloquent\\ModelNotFoundException: No query results for model [App\\Models\\EmployeeShiftSchedule]. in /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Database/Eloquent/Builder.php:588\nStack trace:\n#0 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/SerializesAndRestoresModelIdentifiers.php(108): Illuminate\\Database\\Eloquent\\Builder->firstOrFail()\n#1 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/SerializesAndRestoresModelIdentifiers.php(61): Illuminate\\Notifications\\Notification->restoreModel(Object(Illuminate\\Contracts\\Database\\ModelIdentifier))\n#2 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/SerializesModels.php(126): Illuminate\\Notifications\\Notification->getRestoredPropertyValue(Object(Illuminate\\Contracts\\Database\\ModelIdentifier))\n#3 [internal function]: Illuminate\\Notifications\\Notification->__unserialize(Array)\n#4 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(97): unserialize(\'O:48:\"Illuminat...\')\n#5 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(60): Illuminate\\Queue\\CallQueuedHandler->getCommand(Array)\n#6 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#7 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(425): Illuminate\\Queue\\Jobs\\Job->fire()\n#8 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(375): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#9 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(326): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#10 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(150): Illuminate\\Queue\\Worker->runNextJob(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#11 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(134): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#12 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#13 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#14 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#15 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#16 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/Container.php(651): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#17 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Console/Command.php(144): Illuminate\\Container\\Container->call(Array)\n#18 /Users/abhinav/htdocs/worksuite-new/vendor/symfony/console/Command/Command.php(291): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#19 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Console/Command.php(126): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#20 /Users/abhinav/htdocs/worksuite-new/vendor/symfony/console/Application.php(1002): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#21 /Users/abhinav/htdocs/worksuite-new/vendor/symfony/console/Application.php(299): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#22 /Users/abhinav/htdocs/worksuite-new/vendor/symfony/console/Application.php(171): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#23 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Console/Application.php(102): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#24 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(155): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#25 /Users/abhinav/htdocs/worksuite-new/artisan(37): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#26 {main}','2022-10-31 03:49:00'),(4,'30314b1a-8aa4-4521-9865-550e29863584','database','default','{\"uuid\":\"30314b1a-8aa4-4521-9865-550e29863584\",\"displayName\":\"App\\\\Notifications\\\\ShiftScheduled\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Notifications\\\\SendQueuedNotifications\",\"command\":\"O:48:\\\"Illuminate\\\\Notifications\\\\SendQueuedNotifications\\\":3:{s:11:\\\"notifiables\\\";O:45:\\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\\":5:{s:5:\\\"class\\\";s:15:\\\"App\\\\Models\\\\User\\\";s:2:\\\"id\\\";a:1:{i:0;i:2;}s:9:\\\"relations\\\";a:6:{i:0;s:4:\\\"role\\\";i:1;s:13:\\\"clientDetails\\\";i:2;s:7:\\\"session\\\";i:3;s:14:\\\"employeeDetail\\\";i:4;s:26:\\\"employeeDetail.designation\\\";i:5;s:22:\\\"employeeDetail.company\\\";}s:10:\\\"connection\\\";s:5:\\\"mysql\\\";s:15:\\\"collectionClass\\\";N;}s:12:\\\"notification\\\";O:32:\\\"App\\\\Notifications\\\\ShiftScheduled\\\":3:{s:21:\\\"employeeShiftSchedule\\\";O:45:\\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\\":5:{s:5:\\\"class\\\";s:32:\\\"App\\\\Models\\\\EmployeeShiftSchedule\\\";s:2:\\\"id\\\";i:422;s:9:\\\"relations\\\";a:9:{i:0;s:5:\\\"shift\\\";i:1;s:13:\\\"shift.company\\\";i:2;s:4:\\\"user\\\";i:3;s:9:\\\"user.role\\\";i:4;s:18:\\\"user.clientDetails\\\";i:5;s:12:\\\"user.session\\\";i:6;s:19:\\\"user.employeeDetail\\\";i:7;s:31:\\\"user.employeeDetail.designation\\\";i:8;s:27:\\\"user.employeeDetail.company\\\";}s:10:\\\"connection\\\";s:5:\\\"mysql\\\";s:15:\\\"collectionClass\\\";N;}s:10:\\\"\\u0000*\\u0000company\\\";O:45:\\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\\":5:{s:5:\\\"class\\\";s:18:\\\"App\\\\Models\\\\Company\\\";s:2:\\\"id\\\";i:1;s:9:\\\"relations\\\";a:0:{}s:10:\\\"connection\\\";s:5:\\\"mysql\\\";s:15:\\\"collectionClass\\\";N;}s:2:\\\"id\\\";s:36:\\\"3a730e64-e8c0-4dbd-af07-3491b2e0259e\\\";}s:8:\\\"channels\\\";a:1:{i:0;s:8:\\\"database\\\";}}\"},\"sentry_trace_parent_data\":\"173c451c43814d8591abbdf7d0ba812b-f9c4de43be1641a2-1\"}','Illuminate\\Database\\Eloquent\\ModelNotFoundException: No query results for model [App\\Models\\EmployeeShiftSchedule]. in /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Database/Eloquent/Builder.php:588\nStack trace:\n#0 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/SerializesAndRestoresModelIdentifiers.php(108): Illuminate\\Database\\Eloquent\\Builder->firstOrFail()\n#1 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/SerializesAndRestoresModelIdentifiers.php(61): Illuminate\\Notifications\\Notification->restoreModel(Object(Illuminate\\Contracts\\Database\\ModelIdentifier))\n#2 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/SerializesModels.php(126): Illuminate\\Notifications\\Notification->getRestoredPropertyValue(Object(Illuminate\\Contracts\\Database\\ModelIdentifier))\n#3 [internal function]: Illuminate\\Notifications\\Notification->__unserialize(Array)\n#4 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(97): unserialize(\'O:48:\"Illuminat...\')\n#5 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(60): Illuminate\\Queue\\CallQueuedHandler->getCommand(Array)\n#6 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#7 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(425): Illuminate\\Queue\\Jobs\\Job->fire()\n#8 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(375): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#9 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(326): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#10 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(150): Illuminate\\Queue\\Worker->runNextJob(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#11 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(134): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#12 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#13 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#14 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#15 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#16 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Container/Container.php(651): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#17 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Console/Command.php(144): Illuminate\\Container\\Container->call(Array)\n#18 /Users/abhinav/htdocs/worksuite-new/vendor/symfony/console/Command/Command.php(291): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#19 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Console/Command.php(126): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#20 /Users/abhinav/htdocs/worksuite-new/vendor/symfony/console/Application.php(1002): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#21 /Users/abhinav/htdocs/worksuite-new/vendor/symfony/console/Application.php(299): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#22 /Users/abhinav/htdocs/worksuite-new/vendor/symfony/console/Application.php(171): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#23 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Console/Application.php(102): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#24 /Users/abhinav/htdocs/worksuite-new/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(155): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#25 /Users/abhinav/htdocs/worksuite-new/artisan(37): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#26 {main}','2022-10-31 03:49:01');
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `faq_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `faq_id` bigint unsigned NOT NULL,
  `filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `google_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dropbox_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `faq_files_user_id_foreign` (`user_id`),
  KEY `faq_files_faq_id_foreign` (`faq_id`),
  CONSTRAINT `faq_files_faq_id_foreign` FOREIGN KEY (`faq_id`) REFERENCES `faqs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `faq_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `faq_files` WRITE;
/*!40000 ALTER TABLE `faq_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `faq_category_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `faqs_faq_category_id_foreign` (`faq_category_id`),
  CONSTRAINT `faqs_faq_category_id_foreign` FOREIGN KEY (`faq_category_id`) REFERENCES `faq_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `features`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `features` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `language_setting_id` int unsigned DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('image','icon','task','bills','team','apps') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'image',
  `front_feature_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `features_language_setting_id_foreign` (`language_setting_id`),
  KEY `features_front_feature_id_foreign` (`front_feature_id`),
  CONSTRAINT `features_front_feature_id_foreign` FOREIGN KEY (`front_feature_id`) REFERENCES `front_features` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `features_language_setting_id_foreign` FOREIGN KEY (`language_setting_id`) REFERENCES `language_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `features` WRITE;
/*!40000 ALTER TABLE `features` DISABLE KEYS */;
INSERT INTO `features` VALUES (1,NULL,'Track Projects','<span style=\"color: rgb(68, 68, 68); font-family: Lato, sans-serif; font-size: 16px; text-align: center;\">Keep a track of all your projects in the most simple way.</span>',NULL,'fas fa-desktop','task',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(2,NULL,'Add Members','<span style=\"color: rgb(68, 68, 68); font-family: Lato, sans-serif; font-size: 16px; text-align: center;\">Add members to your projects and keep them in sync with the progress.</span>',NULL,'fas fa-users','task',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(3,NULL,'Assign Tasks','<span style=\"color: rgb(68, 68, 68); font-family: Lato, sans-serif; font-size: 16px; text-align: center;\">Your website is fully responsive, it will work on any device, desktop, tablet and mobile.</span>',NULL,'fas fa-list','task',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(4,NULL,'Estimates','<span style=\"color: rgb(68, 68, 68); font-family: Lato, sans-serif; font-size: 16px; text-align: center;\">Create estimates how much project can cost and send to your clients.</span>',NULL,'fas fa-calculator','bills',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(5,NULL,'Invoices','<span style=\"color: rgb(68, 68, 68); font-family: Lato, sans-serif; font-size: 16px; text-align: center;\">Simple and professional invoices can be download in form of PDF.</span>',NULL,'far fa-file-alt','bills',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(6,NULL,'Payments','<span style=\"color: rgb(68, 68, 68); font-family: Lato, sans-serif; font-size: 16px; text-align: center;\">Track payments done by clients in the payment section.</span>',NULL,'fas fa-money-bill-alt','bills',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(7,NULL,'Tickets','<span style=\"color: rgb(68, 68, 68); font-family: Lato, sans-serif; font-size: 16px; text-align: center;\">When someone is facing a problem, they can raise a ticket for their problems. Admin can assign the tickets to respective department agents.</span>',NULL,'fas fa-ticket-alt','team',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(8,NULL,'Leaves','<span style=\"color: rgb(68, 68, 68); font-family: Lato, sans-serif; font-size: 16px; text-align: center;\">Employees can apply for the multiple leaves from their panel. Admin can approve or reject the leave applications.</span>',NULL,'fas fa-ban','team',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(9,NULL,'Attendance','<span style=\"color: rgb(68, 68, 68); font-family: Lato, sans-serif; font-size: 16px; text-align: center;\">Attendance module allows employees to clock-in and clock-out, right from their dashboard. Admin can track the attendance of the team.</span>',NULL,'far fa-check-circle','team',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(10,NULL,'OneSignal',NULL,NULL,NULL,'apps',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(11,NULL,'Slack',NULL,NULL,NULL,'apps',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(12,NULL,'Paypal',NULL,NULL,NULL,'apps',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(13,NULL,'Meet Your Business Needs','<p>Manage your projects and your talent in a single system, resulting in empowered teams, satisfied clients, and increased profitability.</p><ul class=\"list1 border-top pt-5 mt-5\">\r\n                            <li class=\"mb-3\">\r\n                                Keep a track of all your projects in most simple way.\r\n                            </li>\r\n                            <li class=\"mb-3\">\r\n                                Assign tasks to project members and track the status.\r\n                            </li>\r\n                            <li class=\"mb-3\">\r\n                                Add members to your projects and keep them in sync  with the progress.\r\n                            </li>\r\n                        </ul>',NULL,NULL,'image',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(14,NULL,'Analyse Your Workflow','<p>Reports section to analyse what\'s working and what\'s not for your business</p><ul class=\"list1 border-top pt-5 mt-5\">\r\n                            <li class=\"mb-3\">\r\n                                It Shows how much you earned and how much you spent.\r\n                            </li>\r\n                            <li class=\"mb-3\">\r\n                                Tiket report shows you Open vs Closed tickets.\r\n                            </li>\r\n                            <li class=\"mb-3\">\r\n                                It creates task report to track completed vs pending tasks.\r\n                            </li>\r\n                        </ul>',NULL,NULL,'image',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(15,NULL,'Manage your support tickets efficiently','<p>Whether someone\'s internet is not working, someone is facing issue with housekeeping or need something regarding their work they can raise a ticket for all their problems.</p><ul class=\"list1 border-top pt-5 mt-5\"><li class=\"mb-3\">Admin can assign the tickets to respective department agents.</li></ul>',NULL,NULL,'image',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(16,NULL,'Responsive','Your website works on any device: desktop, tablet or mobile.',NULL,'fas fa-desktop','icon',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(17,NULL,'Customizable','You can easily read, edit, and write your own code, or change everything.',NULL,'fas fa-wrench','icon',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(18,NULL,'UI Elements','There is a bunch of useful and necessary elements for developing your website.',NULL,'fas fa-cubes','icon',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(19,NULL,'Clean Code','You can find our code well organized, commented and readable.',NULL,'fas fa-code','icon',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(20,NULL,'Documented','As you can see in the source code, we provided a comprehensive documentation.',NULL,'far fa-file-alt','icon',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(21,NULL,'Free Updates','When you purchase this template, you\'ll freely receive future updates.',NULL,'fas fa-download','icon',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10');
/*!40000 ALTER TABLE `features` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `file_storage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `file_storage` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `path` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` int unsigned NOT NULL,
  `storage_location` enum('local','aws_s3') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'local',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_storage_company_id_foreign` (`company_id`),
  CONSTRAINT `file_storage_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `file_storage` WRITE;
/*!40000 ALTER TABLE `file_storage` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_storage` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `file_storage_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `file_storage_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `filesystem` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `auth_keys` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` enum('enabled','disabled') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disabled',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `file_storage_settings` WRITE;
/*!40000 ALTER TABLE `file_storage_settings` DISABLE KEYS */;
INSERT INTO `file_storage_settings` VALUES (1,'local',NULL,'enabled','2022-10-28 07:30:06','2022-10-28 07:30:06');
/*!40000 ALTER TABLE `file_storage_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `flags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `capital` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `continent` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `flags` WRITE;
/*!40000 ALTER TABLE `flags` DISABLE KEYS */;
INSERT INTO `flags` VALUES (1,'Kabul','af','Asia','Afghanistan'),(2,'Mariehamn','ax','Europe','Aland Islands'),(3,'Tirana','al','Europe','Albania'),(4,'Algiers','dz','Africa','Algeria'),(5,'Pago Pago','as','Oceania','American Samoa'),(6,'Andorra la Vella','ad','Europe','Andorra'),(7,'Luanda','ao','Africa','Angola'),(8,'The Valley','ai','North America','Anguilla'),(9,'','aq','','Antarctica'),(10,'St. John\'s','ag','North America','Antigua and Barbuda'),(11,'Buenos Aires','ar','South America','Argentina'),(12,'Yerevan','am','Asia','Armenia'),(13,'Oranjestad','aw','South America','Aruba'),(14,'Georgetown','ac','Africa','Ascension Island'),(15,'Canberra','au','Oceania','Australia'),(16,'Vienna','at','Europe','Austria'),(17,'Baku','az','Asia','Azerbaijan'),(18,'Nassau','bs','North America','Bahamas'),(19,'Manama','bh','Asia','Bahrain'),(20,'Dhaka','bd','Asia','Bangladesh'),(21,'Bridgetown','bb','North America','Barbados'),(22,'Minsk','by','Europe','Belarus'),(23,'Brussels','be','Europe','Belgium'),(24,'Belmopan','bz','North America','Belize'),(25,'Porto-Novo','bj','Africa','Benin'),(26,'Hamilton','bm','North America','Bermuda'),(27,'Thimphu','bt','Asia','Bhutan'),(28,'Sucre','bo','South America','Bolivia'),(29,'Kralendijk','bq','South America','Bonaire, Sint Eustatius and Saba'),(30,'Sarajevo','ba','Europe','Bosnia and Herzegovina'),(31,'Gaborone','bw','Africa','Botswana'),(32,'','bv','','Bouvet Island'),(33,'Brasília','br','South America','Brazil'),(34,'Diego Garcia','io','Asia','British Indian Ocean Territory'),(35,'Bandar Seri Begawan','bn','Asia','Brunei Darussalam'),(36,'Sofia','bg','Europe','Bulgaria'),(37,'Ouagadougou','bf','Africa','Burkina Faso'),(38,'Bujumbura','bi','Africa','Burundi'),(39,'Praia','cv','Africa','Cabo Verde'),(40,'Phnom Penh','kh','Asia','Cambodia'),(41,'Yaoundé','cm','Africa','Cameroon'),(42,'Ottawa','ca','North America','Canada'),(43,'','ic','','Canary Islands'),(44,'','es-ct','','Catalonia'),(45,'George Town','ky','North America','Cayman Islands'),(46,'Bangui','cf','Africa','Central African Republic'),(47,'','cefta','','Central European Free Trade Agreement'),(48,'','ea','','Ceuta & Melilla'),(49,'N\'Djamena','td','Africa','Chad'),(50,'Santiago','cl','South America','Chile'),(51,'Beijing','cn','Asia','China'),(52,'Flying Fish Cove','cx','Asia','Christmas Island'),(53,'','cp','','Clipperton Island'),(54,'West Island','cc','Asia','Cocos (Keeling) Islands'),(55,'Bogotá','co','South America','Colombia'),(56,'Moroni','km','Africa','Comoros'),(57,'Avarua','ck','Oceania','Cook Islands'),(58,'San José','cr','North America','Costa Rica'),(59,'Zagreb','hr','Europe','Croatia'),(60,'Havana','cu','North America','Cuba'),(61,'Willemstad','cw','South America','Curaçao'),(62,'Nicosia','cy','Europe','Cyprus'),(63,'Prague','cz','Europe','Czech Republic'),(64,'Yamoussoukro','ci','Africa','Côte d\'Ivoire'),(65,'Kinshasa','cd','Africa','Democratic Republic of the Congo'),(66,'Copenhagen','dk','Europe','Denmark'),(67,'','dg','','Diego Garcia'),(68,'Djibouti','dj','Africa','Djibouti'),(69,'Roseau','dm','North America','Dominica'),(70,'Santo Domingo','do','North America','Dominican Republic'),(71,'Quito','ec','South America','Ecuador'),(72,'Cairo','eg','Africa','Egypt'),(73,'San Salvador','sv','North America','El Salvador'),(74,'London','gb-eng','Europe','England'),(75,'Malabo','gq','Africa','Equatorial Guinea'),(76,'Asmara','er','Africa','Eritrea'),(77,'Tallinn','ee','Europe','Estonia'),(78,'Lobamba, Mbabane','sz','Africa','Eswatini'),(79,'Addis Ababa','et','Africa','Ethiopia'),(80,'','eu','','Europe'),(81,'Stanley','fk','South America','Falkland Islands'),(82,'Tórshavn','fo','Europe','Faroe Islands'),(83,'Palikir','fm','Oceania','Federated States of Micronesia'),(84,'Suva','fj','Oceania','Fiji'),(85,'Helsinki','fi','Europe','Finland'),(86,'Paris','fr','Europe','France'),(87,'Cayenne','gf','South America','French Guiana'),(88,'Papeete','pf','Oceania','French Polynesia'),(89,'Saint-Pierre, Réunion','tf','Africa','French Southern Territories'),(90,'Libreville','ga','Africa','Gabon'),(91,'','es-ga','','Galicia'),(92,'Banjul','gm','Africa','Gambia'),(93,'Tbilisi','ge','Asia','Georgia'),(94,'Berlin','de','Europe','Germany'),(95,'Accra','gh','Africa','Ghana'),(96,'Gibraltar','gi','Europe','Gibraltar'),(97,'Athens','gr','Europe','Greece'),(98,'Nuuk','gl','North America','Greenland'),(99,'St. George\'s','gd','North America','Grenada'),(100,'Basse-Terre','gp','North America','Guadeloupe'),(101,'Hagåtña','gu','Oceania','Guam'),(102,'Guatemala City','gt','North America','Guatemala'),(103,'Saint Peter Port','gg','Europe','Guernsey'),(104,'Conakry','gn','Africa','Guinea'),(105,'Bissau','gw','Africa','Guinea-Bissau'),(106,'Georgetown','gy','South America','Guyana'),(107,'Port-au-Prince','ht','North America','Haiti'),(108,'','hm','','Heard Island and McDonald Islands'),(109,'Vatican City','va','Europe','Holy See'),(110,'Tegucigalpa','hn','North America','Honduras'),(111,'Hong Kong','hk','Asia','Hong Kong'),(112,'Budapest','hu','Europe','Hungary'),(113,'Reykjavik','is','Europe','Iceland'),(114,'New Delhi','in','Asia','India'),(115,'Jakarta','id','Asia','Indonesia'),(116,'Tehran','ir','Asia','Iran'),(117,'Baghdad','iq','Asia','Iraq'),(118,'Dublin','ie','Europe','Ireland'),(119,'Douglas','im','Europe','Isle of Man'),(120,'Jerusalem','il','Asia','Israel'),(121,'Rome','it','Europe','Italy'),(122,'Kingston','jm','North America','Jamaica'),(123,'Tokyo','jp','Asia','Japan'),(124,'Saint Helier','je','Europe','Jersey'),(125,'Amman','jo','Asia','Jordan'),(126,'Astana','kz','Asia','Kazakhstan'),(127,'Nairobi','ke','Africa','Kenya'),(128,'South Tarawa','ki','Oceania','Kiribati'),(129,'Pristina','xk','Europe','Kosovo'),(130,'Kuwait City','kw','Asia','Kuwait'),(131,'Bishkek','kg','Asia','Kyrgyzstan'),(132,'Vientiane','la','Asia','Laos'),(133,'Riga','lv','Europe','Latvia'),(134,'Beirut','lb','Asia','Lebanon'),(135,'Maseru','ls','Africa','Lesotho'),(136,'Monrovia','lr','Africa','Liberia'),(137,'Tripoli','ly','Africa','Libya'),(138,'Vaduz','li','Europe','Liechtenstein'),(139,'Vilnius','lt','Europe','Lithuania'),(140,'Luxembourg City','lu','Europe','Luxembourg'),(141,'Macau','mo','Asia','Macau'),(142,'Antananarivo','mg','Africa','Madagascar'),(143,'Lilongwe','mw','Africa','Malawi'),(144,'Kuala Lumpur','my','Asia','Malaysia'),(145,'Malé','mv','Asia','Maldives'),(146,'Bamako','ml','Africa','Mali'),(147,'Valletta','mt','Europe','Malta'),(148,'Majuro','mh','Oceania','Marshall Islands'),(149,'Fort-de-France','mq','North America','Martinique'),(150,'Nouakchott','mr','Africa','Mauritania'),(151,'Port Louis','mu','Africa','Mauritius'),(152,'Mamoudzou','yt','Africa','Mayotte'),(153,'Mexico City','mx','North America','Mexico'),(154,'Chișinău','md','Europe','Moldova'),(155,'Monaco','mc','Europe','Monaco'),(156,'Ulaanbaatar','mn','Asia','Mongolia'),(157,'Podgorica','me','Europe','Montenegro'),(158,'Little Bay, Brades, Plymouth','ms','North America','Montserrat'),(159,'Rabat','ma','Africa','Morocco'),(160,'Maputo','mz','Africa','Mozambique'),(161,'Naypyidaw','mm','Asia','Myanmar'),(162,'Windhoek','na','Africa','Namibia'),(163,'Yaren District','nr','Oceania','Nauru'),(164,'Kathmandu','np','Asia','Nepal'),(165,'Amsterdam','nl','Europe','Netherlands'),(166,'Nouméa','nc','Oceania','New Caledonia'),(167,'Wellington','nz','Oceania','New Zealand'),(168,'Managua','ni','North America','Nicaragua'),(169,'Niamey','ne','Africa','Niger'),(170,'Abuja','ng','Africa','Nigeria'),(171,'Alofi','nu','Oceania','Niue'),(172,'Kingston','nf','Oceania','Norfolk Island'),(173,'Pyongyang','kp','Asia','North Korea'),(174,'Skopje','mk','Europe','North Macedonia'),(175,'Belfast','gb-nir','Europe','Northern Ireland'),(176,'Saipan','mp','Oceania','Northern Mariana Islands'),(177,'Oslo','no','Europe','Norway'),(178,'Muscat','om','Asia','Oman'),(179,'Islamabad','pk','Asia','Pakistan'),(180,'Ngerulmud','pw','Oceania','Palau'),(181,'Panama City','pa','North America','Panama'),(182,'Port Moresby','pg','Oceania','Papua New Guinea'),(183,'Asunción','py','South America','Paraguay'),(184,'Lima','pe','South America','Peru'),(185,'Manila','ph','Asia','Philippines'),(186,'Adamstown','pn','Oceania','Pitcairn'),(187,'Warsaw','pl','Europe','Poland'),(188,'Lisbon','pt','Europe','Portugal'),(189,'San Juan','pr','North America','Puerto Rico'),(190,'Doha','qa','Asia','Qatar'),(191,'Brazzaville','cg','Africa','Republic of the Congo'),(192,'Bucharest','ro','Europe','Romania'),(193,'Moscow','ru','Europe','Russia'),(194,'Kigali','rw','Africa','Rwanda'),(195,'Saint-Denis','re','Africa','Réunion'),(196,'Gustavia','bl','North America','Saint Barthélemy'),(197,'Jamestown','sh','Africa','Saint Helena, Ascension and Tristan da Cunha'),(198,'Basseterre','kn','North America','Saint Kitts and Nevis'),(199,'Castries','lc','North America','Saint Lucia'),(200,'Marigot','mf','North America','Saint Martin'),(201,'Saint-Pierre','pm','North America','Saint Pierre and Miquelon'),(202,'Kingstown','vc','North America','Saint Vincent and the Grenadines'),(203,'Apia','ws','Oceania','Samoa'),(204,'San Marino','sm','Europe','San Marino'),(205,'São Tomé','st','Africa','Sao Tome and Principe'),(206,'Riyadh','sa','Asia','Saudi Arabia'),(207,'Edinburgh','gb-sct','Europe','Scotland'),(208,'Dakar','sn','Africa','Senegal'),(209,'Belgrade','rs','Europe','Serbia'),(210,'Victoria','sc','Africa','Seychelles'),(211,'Freetown','sl','Africa','Sierra Leone'),(212,'Singapore','sg','Asia','Singapore'),(213,'Philipsburg','sx','North America','Sint Maarten'),(214,'Bratislava','sk','Europe','Slovakia'),(215,'Ljubljana','si','Europe','Slovenia'),(216,'Honiara','sb','Oceania','Solomon Islands'),(217,'Mogadishu','so','Africa','Somalia'),(218,'Pretoria','za','Africa','South Africa'),(219,'King Edward Point','gs','Antarctica','South Georgia and the South Sandwich Islands'),(220,'Seoul','kr','Asia','South Korea'),(221,'Juba','ss','Africa','South Sudan'),(222,'Madrid','es','Europe','Spain'),(223,'Sri Jayawardenepura Kotte, Colombo','lk','Asia','Sri Lanka'),(224,'Ramallah','ps','Asia','State of Palestine'),(225,'Khartoum','sd','Africa','Sudan'),(226,'Paramaribo','sr','South America','Suriname'),(227,'Longyearbyen','sj','Europe','Svalbard and Jan Mayen'),(228,'Stockholm','se','Europe','Sweden'),(229,'Bern','ch','Europe','Switzerland'),(230,'Damascus','sy','Asia','Syria'),(231,'Taipei','tw','Asia','Taiwan'),(232,'Dushanbe','tj','Asia','Tajikistan'),(233,'Dodoma','tz','Africa','Tanzania'),(234,'Bangkok','th','Asia','Thailand'),(235,'Dili','tl','Asia','Timor-Leste'),(236,'Lomé','tg','Africa','Togo'),(237,'Nukunonu, Atafu,Tokelau','tk','Oceania','Tokelau'),(238,'Nukuʻalofa','to','Oceania','Tonga'),(239,'Port of Spain','tt','South America','Trinidad and Tobago'),(240,'','ta','','Tristan da Cunha'),(241,'Tunis','tn','Africa','Tunisia'),(242,'Ankara','tr','Asia','Turkey'),(243,'Ashgabat','tm','Asia','Turkmenistan'),(244,'Cockburn Town','tc','North America','Turks and Caicos Islands'),(245,'Funafuti','tv','Oceania','Tuvalu'),(246,'Kampala','ug','Africa','Uganda'),(247,'Kiev','ua','Europe','Ukraine'),(248,'Abu Dhabi','ae','Asia','United Arab Emirates'),(249,'London','gb','Europe','United Kingdom'),(250,'','un','','United Nations'),(251,'Washington, D.C.','um','North America','United States Minor Outlying Islands'),(252,'Washington, D.C.','us','North America','United States of America'),(253,'','xx','','Unknown'),(254,'Montevideo','uy','South America','Uruguay'),(255,'Tashkent','uz','Asia','Uzbekistan'),(256,'Port Vila','vu','Oceania','Vanuatu'),(257,'Caracas','ve','South America','Venezuela'),(258,'Hanoi','vn','Asia','Vietnam'),(259,'Road Town','vg','North America','Virgin Islands (British)'),(260,'Charlotte Amalie','vi','North America','Virgin Islands (U.S.)'),(261,'Cardiff','gb-wls','Europe','Wales'),(262,'Mata-Utu','wf','Oceania','Wallis and Futuna'),(263,'Laayoune','eh','Africa','Western Sahara'),(264,'Sana\'a','ye','Asia','Yemen'),(265,'Lusaka','zm','Africa','Zambia'),(266,'Harare','zw','Africa','Zimbabwe');
/*!40000 ALTER TABLE `flags` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `footer_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `footer_menu` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `video_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `video_embed` text COLLATE utf8mb4_unicode_ci,
  `file_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('header','footer','both') COLLATE utf8mb4_unicode_ci DEFAULT 'footer',
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci DEFAULT 'active',
  `language_setting_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `footer_menu_language_setting_id_foreign` (`language_setting_id`),
  CONSTRAINT `footer_menu_language_setting_id_foreign` FOREIGN KEY (`language_setting_id`) REFERENCES `language_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `footer_menu` WRITE;
/*!40000 ALTER TABLE `footer_menu` DISABLE KEYS */;
INSERT INTO `footer_menu` VALUES (1,'Terms of use','terms-of-use','<div><b><span style=\"font-size: 14px;\"><span style=\"font-size: 14px;\">T</span><span style=\"font-size: 14px;\">ERMS OF USE FOR WORKSUITE.BIZ</span></span></b></div><div><br></div><div>The use of any product, service or feature (the \"Materials\") available through the internet web sites accessible at Worksuite.com (the \"Web Site\") by any user of the Web Site (\"You\" or \"Your\" hereafter) shall be governed by the following terms of use:</div><div>This Web Site is provided by Worksuite, a partnership awaiting registration with Government of India, and shall be used for informational purposes only. By using the Web Site or downloading Materials from the Web Site, You hereby agree to abide by the terms and conditions set forth in this Terms of Use. In the event of You not agreeing to these terms and conditions, You are requested by Worksuite not to use the Web Site or download Materials from the Web Site. This Web Site, including all Materials present (excluding any applicable third party materials), is the property of Worksuite and is copyrighted and protected by worldwide copyright laws and treaty provisions. You hereby agree to comply with all copyright laws worldwide in Your use of this Web Site and to prevent any unauthorized copying of the Materials. Worksuite does not grant any express or implied rights under any patents, trademarks, copyrights or trade secret information.</div><div>Worksuite has business relationships with many customers, suppliers, governments, and others. For convenience and simplicity, words like joint venture, partnership, and partner are used to indicate business relationships involving common activities and interests, and those words may not indicate precise legal relationships.</div><div><br></div><div><b><span style=\"font-size: 14px;\">LIMITED LICENSE:</span></b></div><div><br></div><div>Subject to the terms and conditions set forth in these Terms of Use, Worksuite grants You a non-exclusive, non-transferable, limited right to access, use and display this Web Site and the Materials thereon. You agree not to interrupt or attempt to interrupt the operation of the Web Site in any manner. Unless otherwise specified, the Web Site is for Your personal and non-commercial use. You shall not modify, copy, distribute, transmit, display, perform, reproduce, publish, license, create derivative works from, transfer, or sell any information, software, products or services obtained from this Web Site.</div><div><br></div><div><b><span style=\"font-size: 14px;\">THIRD PARTY CONTENT</span></b></div><div>The Web Site makes information of third parties available, including articles, analyst reports, news reports, and company information, including any regulatory authority, content licensed under Content Licensed under Creative Commons Attribution License, and other data from external sources (the \"Third Party Content\"). You acknowledge and agree that the Third Party Content is not created or endorsed by Worksuite. The provision of Third Party Content is for general informational purposes only and does not constitute a recommendation or solicitation to purchase or sell any securities or shares or to make any other type of investment or investment decision. In addition, the Third Party Content is not intended to provide tax, legal or investment advice. You acknowledge that the Third Party Content provided to You is obtained from sources believed to be reliable, but that no guarantees are made by Worksuite or the providers of the Third Party Content as to its accuracy, completeness, timeliness. You agree not to hold Worksuite, any business offering products or services through the Web Site or any provider of Third Party Content liable for any investment decision or other transaction You may make based on Your reliance on or use of such data, or any liability that may arise due to delays or interruptions in the delivery of the Third Party Content for any reason</div><div>By using any Third Party Content, You may leave this Web Site and be directed to an external website, or to a website maintained by an entity other than Worksuite. If You decide to visit any such site, You do so at Your own risk and it is Your responsibility to take all protective measures to guard against viruses or any other destructive elements. Worksuite makes no warranty or representation regarding and does not endorse, any linked web sites or the information appearing thereon or any of the products or services described thereon. Links do not imply that Worksuite or this Web Site sponsors, endorses, is affiliated or associated with, or is legally authorized to use any trademark, trade name, logo or copyright symbol displayed in or accessible through the links, or that any linked site is authorized to use any trademark, trade name, logo or copyright symbol of Worksuite or any of its affiliates or subsidiaries. You hereby expressly acknowledge and agree that the linked sites are not under the control of Worksuite and Worksuite is not responsible for the contents of any linked site or any link contained in a linked site, or any changes or updates to such sites. Worksuite is not responsible for webcasting or any other form of transmission received from any linked site. Worksuite is providing these links to You only as a convenience, and the inclusion of any link shall not be construed to imply endorsement by Worksuite in any manner of the website.</div><div><br></div><div><br></div><div><b><span style=\"font-size: 14px;\">NO WARRANTIES</span></b></div><div>THIS WEB SITE, THE INFORMATION AND MATERIALS ON THE SITE, AND ANY SOFTWARE MADE AVAILABLE ON THE WEB SITE, ARE PROVIDED \"AS IS\" WITHOUT ANY REPRESENTATION OR WARRANTY, EXPRESS OR IMPLIED, OF ANY KIND, INCLUDING, BUT NOT LIMITED TO, WARRANTIES OF MERCHANTABILITY, NON INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE. THERE IS NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, REGARDING THIRD PARTY CONTENT. INSPITE OF FROIDEN BEST ENDEAVOURS, THERE IS NO WARRANTY ON BEHALF OF FROIDEN THAT THIS WEB SITE WILL BE FREE OF ANY COMPUTER VIRUSES. SOME JURISDICTIONS DO NOT ALLOW FOR THE EXCLUSION OF IMPLIED WARRANTIES, SO THE ABOVE EXCLUSIONS MAY NOT APPLY TO YOU.</div><div>LIMITATION OF DAMAGES:</div><div>IN NO EVENT SHALL FROIDEN OR ANY OF ITS SUBSIDIARIES OR AFFILIATES BE LIABLE TO ANY ENTITY FOR ANY DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL OR OTHER DAMAGES (INCLUDING, WITHOUT LIMITATION, ANY LOST PROFITS, BUSINESS INTERRUPTION, LOSS OF INFORMATION OR PROGRAMS OR OTHER DATA ON YOUR INFORMATION HANDLING SYSTEM) THAT ARE RELATED TO THE USE OF, OR THE INABILITY TO USE, THE CONTENT, MATERIALS, AND FUNCTIONS OF THIS WEB SITE OR ANY LINKED WEB SITE, EVEN IF FROIDEN IS EXPRESSLY ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.</div><div><br></div><div><b><span style=\"font-size: 14px;\">DISCLAIMER:</span></b></div><div>THE WEB SITE MAY CONTAIN INACCURACIES AND TYPOGRAPHICAL AND CLERICAL ERRORS. FROIDEN EXPRESSLY DISCLAIMS ANY OBLIGATION(S) TO UPDATE THIS WEBSITE OR ANY OF THE MATERIALS ON THIS WEBSITE. FROIDEN DOES NOT WARRANT THE ACCURACY OR COMPLETENESS OF THE MATERIALS OR THE RELIABILITY OF ANY ADVICE, OPINION, STATEMENT OR OTHER INFORMATION DISPLAYED OR DISTRIBUTED THROUGH THE WEB SITE. YOU ACKNOWLEDGE THAT ANY RELIANCE ON ANY SUCH OPINION, ADVICE, STATEMENT, MEMORANDUM, OR INFORMATION SHALL BE AT YOUR SOLE RISK. FROIDEN RESERVES THE RIGHT, IN ITS SOLE DISCRETION, TO CORRECT ANY ERRORS OR OMISSIONS IN ANY PORTION OF THE WEB SITE. FROIDEN MAY MAKE ANY OTHER CHANGES TO THE WEB SITE, THE MATERIALS AND THE PRODUCTS, PROGRAMS, SERVICES OR PRICES (IF ANY) DESCRIBED IN THE WEB SITE AT ANY TIME WITHOUT NOTICE. THIS WEB SITE IS FOR INFORMATIONAL PURPOSES ONLY AND SHOULD NOT BE CONSTRUED AS TECHNICAL ADVICE OF ANY MANNER.</div><div>UNLAWFUL AND/OR PROHIBITED USE OF THE WEB SITE</div><div>As a condition of Your use of the Web Site, You shall not use the Web Site for any purpose(s) that is unlawful or prohibited by the Terms of Use. You shall not use the Web Site in any manner that could damage, disable, overburden, or impair any Worksuite server, or the network(s) connected to any Worksuite server, or interfere with any other party\'s use and enjoyment of any services associated with the Web Site. You shall not attempt to gain unauthorized access to any section of the Web Site, other accounts, computer systems or networks connected to any Worksuite server or to any of the services associated with the Web Site, through hacking, password mining or any other means. You shall not obtain or attempt to obtain any Materials or information through any means not intentionally made available through the Web Site.</div><div><br></div><div><b><span style=\"font-size: 14px;\">INDEMNITY:</span></b></div><div>You agree to indemnify and hold harmless Worksuite, its subsidiaries and affiliates from any claim, cost, expense, judgment or other loss relating to Your use of this Web Site in any manner, including without limitation of the foregoing, any action You take which is in violation of the terms and conditions of these Terms of Use and against any applicable law.</div><div><br></div><div><b><span style=\"font-size: 14px;\">CHANGES:</span></b></div><div>Worksuite reserves the rights, at its sole discretion, to change, modify, add or remove any portion of these Terms of Use in whole or in part, at any time. Changes in these Terms of Use will be effective when notice of such change is posted. Your continued use of the Web Site after any changes to these Terms of Use are posted will be considered acceptance of those changes. Worksuite may terminate, change, suspend or discontinue any aspect of the Web Site, including the availability of any feature(s) of the Web Site, at any time. Worksuite may also impose limits on certain features and services or restrict Your access to certain sections or all of the Web Site without notice or liability. You hereby acknowledge and agree that Worksuite may terminate the authorization, rights, and license given above at any point of time at its own sole discretion, and upon such termination; You shall immediately destroy all Materials.</div><div><br></div><div><br></div><div><b><span style=\"font-size: 14px;\">INTERNATIONAL USERS AND CHOICE OF LAW:</span></b></div><div>This Site is controlled, operated, and administered by Worksuite from within India. Worksuite makes no representation that Materials on this Web Site are appropriate or available for use at any other location(s) outside India. Any access to this Web Site from territories where their contents are illegal is prohibited. You may not use the Web Site or export the Materials in violation of any applicable export laws and regulations. If You access this Web Site from a location outside India, You are responsible for compliance with all local laws.</div><div>These Terms of Use shall be governed by the laws of India,Terms of Use for worksuite.biz</div><div>The use of any product, service or feature (the \"Materials\") available through the internet web sites accessible at Worksuite.com (the \"Web Site\") by any user of the Web Site (\"You\" or \"Your\" hereafter) shall be governed by the following terms of use:</div><div>This Web Site is provided by Worksuite, a partnership awaiting registration with Government of India, and shall be used for informational purposes only. By using the Web Site or downloading Materials from the Web Site, You hereby agree to abide by the terms and conditions set forth in this Terms of Use. In the event of You not agreeing to these terms and conditions, You are requested by Worksuite not to use the Web Site or download Materials from the Web Site. This Web Site, including all Materials present (excluding any applicable third party materials), is the property of Worksuite and is copyrighted and protected by worldwide copyright laws and treaty provisions. You hereby agree to comply with all copyright laws worldwide in Your use of this Web Site and to prevent any unauthorized copying of the Materials. Worksuite does not grant any express or implied rights under any patents, trademarks, copyrights or trade secret information.</div><div>Worksuite has business relationships with many customers, suppliers, governments, and others. For convenience and simplicity, words like joint venture, partnership, and partner are used to indicate business relationships involving common activities and interests, and those words may not indicate precise legal relationships.</div><div><br></div><div><b><span style=\"font-size: 14px;\">LIMITED LICENSE:</span></b></div><div>Subject to the terms and conditions set forth in these Terms of Use, Worksuite grants You a non-exclusive, non-transferable, limited right to access, use and display this Web Site and the Materials thereon. You agree not to interrupt or attempt to interrupt the operation of the Web Site in any manner. Unless otherwise specified, the Web Site is for Your personal and non-commercial use. You shall not modify, copy, distribute, transmit, display, perform, reproduce, publish, license, create derivative works from, transfer, or sell any information, software, products or services obtained from this Web Site.</div><div><br></div><div><b><span style=\"font-size: 14px;\">THIRD-PARTY CONTENT</span></b></div><div>The Web Site makes information of third parties available, including articles, analyst reports, news reports, and company information, including any regulatory authority, content licensed under Content Licensed under Creative Commons Attribution License, and other data from external sources (the \"Third Party Content\"). You acknowledge and agree that the Third Party Content is not created or endorsed by Worksuite. The provision of Third Party Content is for general informational purposes only and does not constitute a recommendation or solicitation to purchase or sell any securities or shares or to make any other type of investment or investment decision. In addition, the Third Party Content is not intended to provide tax, legal or investment advice. You acknowledge that the Third Party Content provided to You is obtained from sources believed to be reliable, but that no guarantees are made by Worksuite or the providers of the Third Party Content as to its accuracy, completeness, timeliness. You agree not to hold Worksuite, any business offering products or services through the Web Site or any provider of Third Party Content liable for any investment decision or other transaction You may make based on Your reliance on or use of such data, or any liability that may arise due to delays or interruptions in the delivery of the Third Party Content for any reason</div><div>By using any Third Party Content, You may leave this Web Site and be directed to an external website, or to a website maintained by an entity other than Worksuite. If You decide to visit any such site, You do so at Your own risk and it is Your responsibility to take all protective measures to guard against viruses or any other destructive elements. Worksuite makes no warranty or representation regarding, and does not endorse, any linked web sites or the information appearing thereon or any of the products or services described thereon. Links do not imply that Worksuite or this Web Site sponsors, endorses, is affiliated or associated with, or is legally authorized to use any trademark, trade name, logo or copyright symbol displayed in or accessible through the links, or that any linked site is authorized to use any trademark, trade name, logo or copyright symbol of Worksuite or any of its affiliates or subsidiaries. You hereby expressly acknowledge and agree that the linked sites are not under the control of Worksuite and Worksuite is not responsible for the contents of any linked site or any link contained in a linked site, or any changes or updates to such sites. Worksuite is not responsible for webcasting or any other form of transmission received from any linked site. Worksuite is providing these links to You only as a convenience, and the inclusion of any link shall not be construed to imply endorsement by Worksuite in any manner of the website.</div><div><br></div><div><b><span style=\"font-size: 14px;\">NO WARRANTIES</span></b></div><div>THIS WEB SITE, THE INFORMATION AND MATERIALS ON THE SITE, AND ANY SOFTWARE MADE AVAILABLE ON THE WEB SITE, ARE PROVIDED \"AS IS\" WITHOUT ANY REPRESENTATION OR WARRANTY, EXPRESS OR IMPLIED, OF ANY KIND, INCLUDING, BUT NOT LIMITED TO, WARRANTIES OF MERCHANTABILITY, NON INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE. THERE IS NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, REGARDING THIRD PARTY CONTENT. INSPITE OF FROIDEN BEST ENDEAVOURS, THERE IS NO WARRANTY ON BEHALF OF FROIDEN THAT THIS WEB SITE WILL BE FREE OF ANY COMPUTER VIRUSES. SOME JURISDICTIONS DO NOT ALLOW FOR THE EXCLUSION OF IMPLIED WARRANTIES, SO THE ABOVE EXCLUSIONS MAY NOT APPLY TO YOU.</div><div>LIMITATION OF DAMAGES:</div><div>IN NO EVENT SHALL FROIDEN OR ANY OF ITS SUBSIDIARIES OR AFFILIATES BE LIABLE TO ANY ENTITY FOR ANY DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL OR OTHER DAMAGES (INCLUDING, WITHOUT LIMITATION, ANY LOST PROFITS, BUSINESS INTERRUPTION, LOSS OF INFORMATION OR PROGRAMS OR OTHER DATA ON YOUR INFORMATION HANDLING SYSTEM) THAT ARE RELATED TO THE USE OF, OR THE INABILITY TO USE, THE CONTENT, MATERIALS, AND FUNCTIONS OF THIS WEB SITE OR ANY LINKED WEB SITE, EVEN IF FROIDEN IS EXPRESSLY ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.</div><div><br></div><div><b><span style=\"font-size: 14px;\">DISCLAIMER:</span></b></div><div><span style=\"font-size: 12px;\">THE WEB SITE MAY CONTAIN INACCURACIES AND TYPOGRAPHICAL AND CLERICAL ERRORS. FROIDEN EXPRESSLY DISCLAIMS ANY OBLIGATION(S) TO UPDATE THIS WEBSITE OR ANY OF THE MATERIALS ON THIS WEBSITE. FROIDEN DOES NOT WARRANT THE ACCURACY OR COMPLETENESS OF THE MATERIALS OR THE RELIABILITY OF ANY ADVICE, OPINION, STATEMENT OR OTHER INFORMATION DISPLAYED OR DISTRIBUTED THROUGH THE WEB SITE. YOU ACKNOWLEDGE THAT ANY RELIANCE ON ANY SUCH OPINION, ADVICE, STATEMENT, MEMORANDUM, OR INFORMATION SHALL BE AT YOUR SOLE RISK. FROIDEN RESERVES THE RIGHT, IN ITS SOLE DISCRETION, TO CORRECT ANY ERRORS OR OMISSIONS IN ANY PORTION OF THE WEB SITE. FROIDEN MAY MAKE ANY OTHER CHANGES TO THE WEB SITE, THE MATERIALS AND THE PRODUCTS, PROGRAMS, SERVICES OR PRICES (IF ANY) DESCRIBED IN THE WEB SITE AT ANY TIME WITHOUT NOTICE. THIS WEB SITE IS FOR INFORMATIONAL PURPOSES ONLY AND SHOULD NOT BE CONSTRUED AS TECHNICAL ADVICE OF ANY MANNER.</span></div><div><span style=\"font-size: 12px;\">UNLAWFUL AND/OR PROHIBITED USE OF THE WEB SITE</span></div><div>As a condition of Your use of the Web Site, You shall not use the Web Site for any purpose(s) that is unlawful or prohibited by the Terms of Use. You shall not use the Web Site in any manner that could damage, disable, overburden, or impair any Worksuite server, or the network(s) connected to any Worksuite server, or interfere with any other party\'s use and enjoyment of any services associated with the Web Site. You shall not attempt to gain unauthorized access to any section of the Web Site, other accounts, computer systems or networks connected to any Worksuite server or to any of the services associated with the Web Site, through hacking, password mining or any other means. You shall not obtain or attempt to obtain any materials or information through any means not intentionally made available through the Web Site.</div><div><br></div><div><b><span style=\"font-size: 14px;\">INDEMNITY:</span></b></div><div>You agree to indemnify and hold harmless Worksuite, its subsidiaries and affiliates from any claim, cost, expense, judgment or other loss relating to Your use of this Web Site in any manner, including without limitation of the foregoing, any action You take which is in violation of the terms and conditions of these Terms of Use and against any applicable law.</div><div><br></div><div><b><span style=\"font-size: 14px;\">CHANGES:</span></b></div><div>Worksuite reserves the rights, at its sole discretion, to change, modify, add or remove any portion of these Terms of Use in whole or in part, at any time. Changes in these Terms of Use will be effective when notice of such change is posted. Your continued use of the Web Site after any changes to these Terms of Use are posted will be considered acceptance of those changes. Worksuite may terminate, change, suspend or discontinue any aspect of the Web Site, including the availability of any feature(s) of the Web Site, at any time. Worksuite may also impose limits on certain features and services or restrict Your access to certain sections or all of the Web Site without notice or liability. You hereby acknowledge and agree that Worksuite may terminate the authorization, rights, and license given above at any point of time at its own sole discretion, and upon such termination; You shall immediately destroy all Materials.</div><div><br></div><div><b><span style=\"font-size: 14px;\">INTERNATIONAL USERS AND CHOICE OF LAW:</span></b></div><div>This Site is controlled, operated, and administered by Worksuite from within India. Worksuite makes no representation that Materials on this Web Site are appropriate or available for use at any other location(s) outside India. Any access to this Web Site from territories where their contents are illegal is prohibited. You may not use the Web Site or export the Materials in violation of any applicable export laws and regulations. If You access this Web Site from a location outside India, You are responsible for compliance with all local laws.</div><div>These Terms of Use shall be governed by the laws of India, without giving effect to its conflict of laws provisions. You agree that the appropriate court(s) in Bangalore, India, will have the exclusive jurisdiction to resolve all disputes arising under these Terms of Use and You hereby consent to personal jurisdiction in such forum.</div><div>These Terms of Use constitute the entire agreement between Worksuite and You with respect to Your use of the Web Site. Any claim You may have with respect to Your use of the Web Site must be commenced within one (1) year of the cause of action. If any provision(s) of this Terms of Use is held by a court of competent jurisdiction to be contrary to law then such provision(s) shall be severed from this Terms of Use and the other remaining provisions of this Terms of Use shall remain in full force and effect. without giving effect to its conflict of laws provisions. You agree that the appropriate court(s) in Bangalore, India, will have the exclusive jurisdiction to resolve all disputes arising under these Terms of Use and You hereby consent to personal jurisdiction in such forum.</div><div>These Terms of Use constitute the entire agreement between Worksuite and You with respect to Your use of the Web Site. Any claim You may have with respect to Your use of the Web Site must be commenced within one (1) year of the cause of action. If any provision(s) of this Terms of Use is held by a court of competent jurisdiction to be contrary to law then such provision(s) shall be severed from this Terms of Use and the other remaining provisions of this Terms of Use shall remain in full force and effect.</div>',NULL,NULL,NULL,NULL,NULL,'footer','active',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(2,'Privacy Policy','privacy-policy','<div><b><span style=\"font-size: 14px;\">WHAT DO WE DO WITH YOUR INFORMATION?</span></b></div><div>When you purchase something from our store, as part of the buying and selling process, we collect the personal information you give us such as your name, address, and email address.</div><div><br></div><div>When you browse our store, we also automatically receive your computer’s internet protocol (IP) address in order to provide us with information that helps us learn about your browser and operating system.</div><div><b><br></b></div><div><b>How do you get my consent?</b></div><div>When you provide us with personal information to complete a transaction, verify your credit card, place an order, arrange for a delivery or return a purchase, we imply that you consent to our collecting it and using it for that specific reason only.</div><div><br></div><div>If we ask for your personal information for a secondary reason, like marketing, we will either ask you directly for your expressed consent, or provide you with an opportunity to say no.</div><div><br></div><div><b>How do I withdraw my consent?</b></div><div>If after you opt-in, you change your mind, you may withdraw your consent for us to contact you, for the continued collection, use or disclosure of your information, at any time, by contacting us at <b>support@worksuite.biz</b> or mailing us at my address</div><div><br></div><div><b><span style=\"font-size: 14px;\">DISCLOSURE</span></b></div><div>We may disclose your personal information if we are required by law to do so or if you violate our Terms of Service.</div><div><br></div><div><b><span style=\"font-size: 14px;\">PAYMENT</span></b></div><div>We use Razorpay for processing payments. We/Razorpay do not store your card data on their servers. The data is encrypted through the Payment Card Industry Data Security Standard (PCI-DSS) when processing payment. Your purchase transaction data is only used as long as is necessary to complete your purchase transaction. After that is complete, your purchase transaction information is not saved.</div><div><br></div><div>Our payment gateway adheres to the standards set by PCI-DSS as managed by the PCI Security Standards Council, which is a joint effort of brands like Visa, MasterCard, American Express, and Discover.</div><div><br></div><div>PCI-DSS requirements help ensure the secure handling of credit card information by our store and its service providers.</div><div><br></div><div>For more insight, you may also want to read terms and conditions of Razorpay on https://razorpay.com</div><div><b><br></b></div><div><b><span style=\"font-size: 14px;\">THIRD-PARTY SERVICES</span></b></div><div>In general, the third-party providers used by us will only collect, use, and disclose your information to the extent necessary to allow them to perform the services they provide to us.</div><div><br></div><div>However, certain third-party service providers, such as payment gateways and other payment transaction processors, have their own privacy policies with respect to the information we are required to provide to them for your purchase-related transactions.</div><div><br></div><div>For these providers, we recommend that you read their privacy policies so you can understand the manner in which your personal information will be handled by these providers.</div><div><br></div><div>In particular, remember that certain providers may be located in or have facilities that are located in a different jurisdiction than either you or us. So if you elect to proceed with a transaction that involves the services of a third-party service provider, then your information may become subject to the laws of the jurisdiction(s) in which that service provider or its facilities are located.</div><div><br></div><div>Once you leave our store’s website or are redirected to a third-party website or application, you are no longer governed by this Privacy Policy or our website’s Terms of Service.</div><div><br></div><div><b><span style=\"font-size: 14px;\">Links</span></b></div><div>When you click on links on our store, they may direct you away from our site. We are not responsible for the privacy practices of other sites and encourage you to read their privacy statements.</div><div><br></div><div><b><span style=\"font-size: 14px;\">SECURITY</span></b></div><div>To protect your personal information, we take reasonable precautions and follow industry best practices to make sure it is not inappropriately lost, misused, accessed, disclosed, altered or destroyed.</div><div><br></div><div><b><span style=\"font-size: 14px;\">COOKIES</span></b></div><div>We use cookies to maintain session of your user. It is not used to personally identify you on other websites.</div><div><br></div><div><b><span style=\"font-size: 14px;\">AGE OF CONSENT</span></b></div><div>By using this site, you represent that you are at least the age of majority in your state or province of residence, or that you are the age of majority in your state or province of residence and you have given us your consent to allow any of your minor dependents to use this site.</div><div><br></div><div><b><span style=\"font-size: 14px;\">CHANGES TO THIS PRIVACY POLICY</span></b></div><div>We reserve the right to modify this privacy policy at any time, so please review it frequently. Changes and clarifications will take effect immediately upon their posting on the website. If we make material changes to this policy, we will notify you here that it has been updated, so that you are aware of what information we collect, how we use it, and under what circumstances, if any, we use and/or disclose it.</div><div><br></div><div>If our store is acquired or merged with another company, your information may be transferred to the new owners so that we may continue to sell products to you.</div><div><br></div><div><b><span style=\"font-size: 14px;\">QUESTIONS AND CONTACT INFORMATION</span></b></div><div>If you would like to: access, correct, amend or delete any personal information we have about you, register a complaint, or simply want more information contact our Privacy Compliance Officer at <b>contactus@worksuite.biz</b> or by mail at <i><b>your address here</b></i></div>',NULL,NULL,NULL,NULL,NULL,'footer','active',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10');
/*!40000 ALTER TABLE `footer_menu` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `front_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `front_clients` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language_setting_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `front_clients_language_setting_id_foreign` (`language_setting_id`),
  CONSTRAINT `front_clients_language_setting_id_foreign` FOREIGN KEY (`language_setting_id`) REFERENCES `language_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `front_clients` WRITE;
/*!40000 ALTER TABLE `front_clients` DISABLE KEYS */;
INSERT INTO `front_clients` VALUES (1,'Client 1',NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(2,'Client 2',NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(3,'Client 3',NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(4,'Client 4',NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10');
/*!40000 ALTER TABLE `front_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `front_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `front_details` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `get_started_show` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `sign_in_show` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `address` text COLLATE utf8mb4_unicode_ci,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `social_links` text COLLATE utf8mb4_unicode_ci,
  `primary_color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_css` longtext COLLATE utf8mb4_unicode_ci,
  `custom_css_theme_two` longtext COLLATE utf8mb4_unicode_ci,
  `locale` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'en',
  `contact_html` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `front_details` WRITE;
/*!40000 ALTER TABLE `front_details` DISABLE KEYS */;
INSERT INTO `front_details` VALUES (1,'yes','yes','4868  Ben Street Lansing Michigan 48906','+91 1234567890','company@example.com','[{\"name\":\"facebook\",\"link\":\"https:\\/\\/facebook.com\"},{\"name\":\"twitter\",\"link\":\"https:\\/\\/twitter.com\"},{\"name\":\"instagram\",\"link\":\"https:\\/\\/instagram.com\"},{\"name\":\"dribbble\",\"link\":\"https:\\/\\/dribbble.com\"},{\"name\":\"youtube\",\"link\":\"https:\\/\\/www.youtube.com\"}]','#e94033',NULL,NULL,'en',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10');
/*!40000 ALTER TABLE `front_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `front_faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `front_faqs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `question` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language_setting_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `front_faqs_language_setting_id_foreign` (`language_setting_id`),
  CONSTRAINT `front_faqs_language_setting_id_foreign` FOREIGN KEY (`language_setting_id`) REFERENCES `language_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `front_faqs` WRITE;
/*!40000 ALTER TABLE `front_faqs` DISABLE KEYS */;
INSERT INTO `front_faqs` VALUES (1,'Can i see demo?','<span style=\"color: rgb(68, 68, 68); font-family: Lato, sans-serif; font-size: 16px;\">Yes, definitely. We would be happy to demonstrate you Worksuite through a web conference at your convenience. Please submit a query on our contact us page or drop a mail to our mail id worksuite@froiden.com.</span>',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(2,'How can i update app?','<span style=\"color: rgb(68, 68, 68); font-family: Lato, sans-serif; font-size: 16px;\">Yes, definitely. We would be happy to demonstrate you Worksuite through a web conference at your convenience. Please submit a query on our contact us page or drop a mail to our mail id worksuite@froiden.com.</span>',NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10');
/*!40000 ALTER TABLE `front_faqs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `front_features`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `front_features` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `language_setting_id` int unsigned DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('enable','disable') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'enable',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `front_features_language_setting_id_foreign` (`language_setting_id`),
  CONSTRAINT `front_features_language_setting_id_foreign` FOREIGN KEY (`language_setting_id`) REFERENCES `language_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `front_features` WRITE;
/*!40000 ALTER TABLE `front_features` DISABLE KEYS */;
/*!40000 ALTER TABLE `front_features` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `front_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `front_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `widget_code` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `front_widgets` WRITE;
/*!40000 ALTER TABLE `front_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `front_widgets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `gdpr_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gdpr_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `enable_gdpr` tinyint(1) NOT NULL DEFAULT '0',
  `show_customer_area` tinyint(1) NOT NULL DEFAULT '0',
  `show_customer_footer` tinyint(1) NOT NULL DEFAULT '0',
  `top_information_block` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `enable_export` tinyint(1) NOT NULL DEFAULT '0',
  `data_removal` tinyint(1) NOT NULL DEFAULT '0',
  `lead_removal_public_form` tinyint(1) NOT NULL DEFAULT '0',
  `terms_customer_footer` tinyint(1) NOT NULL DEFAULT '0',
  `terms` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `policy` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `public_lead_edit` tinyint(1) NOT NULL DEFAULT '0',
  `consent_customer` tinyint(1) NOT NULL DEFAULT '0',
  `consent_leads` tinyint(1) NOT NULL DEFAULT '0',
  `consent_block` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `gdpr_settings` WRITE;
/*!40000 ALTER TABLE `gdpr_settings` DISABLE KEYS */;
INSERT INTO `gdpr_settings` VALUES (1,0,0,0,NULL,0,0,0,0,NULL,NULL,0,0,0,NULL,'2022-10-28 07:30:06','2022-10-28 07:30:06');
/*!40000 ALTER TABLE `gdpr_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `global_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_symbol` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `exchange_rate` double DEFAULT NULL,
  `usd_price` double DEFAULT NULL,
  `is_cryptocurrency` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `currency_position` enum('front','behind') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'front',
  `status` enum('enable','disable') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'enable',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `global_currencies` WRITE;
/*!40000 ALTER TABLE `global_currencies` DISABLE KEYS */;
INSERT INTO `global_currencies` VALUES (1,'Dollars','$','USD',NULL,NULL,'no','front','enable',NULL,NULL,NULL),(2,'Pounds','£','GBP',NULL,NULL,'no','front','enable',NULL,NULL,NULL),(3,'Euros','€','EUR',NULL,NULL,'no','front','enable',NULL,NULL,NULL),(4,'Rupee','₹','INR',NULL,NULL,'no','front','enable',NULL,NULL,NULL);
/*!40000 ALTER TABLE `global_currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `global_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `global_app_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `login_background` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo_background_color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sidebar_logo_style` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locale` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `purchase_code` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supported_until` timestamp NULL DEFAULT NULL,
  `last_license_verified_at` timestamp NULL DEFAULT NULL,
  `google_recaptcha_status` enum('active','deactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `google_recaptcha_v2_status` enum('active','deactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `google_recaptcha_v2_site_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_recaptcha_v2_secret_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_recaptcha_v3_status` enum('active','deactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `google_recaptcha_v3_site_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_recaptcha_v3_secret_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_debug` tinyint(1) NOT NULL DEFAULT '0',
  `currency_converter_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_key_version` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'free',
  `light_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `moment_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'DD-MM-YYYY',
  `timezone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Asia/Kolkata',
  `rtl` tinyint(1) NOT NULL DEFAULT '0',
  `license_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hide_cron_message` tinyint(1) NOT NULL DEFAULT '0',
  `system_update` tinyint(1) NOT NULL DEFAULT '1',
  `show_review_modal` tinyint(1) NOT NULL DEFAULT '1',
  `last_cron_run` timestamp NULL DEFAULT NULL,
  `favicon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auth_theme` enum('dark','light') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'light',
  `session_driver` enum('file','database') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'database',
  `allowed_file_types` text COLLATE utf8mb4_unicode_ci,
  `allowed_file_size` int NOT NULL DEFAULT '10',
  `show_update_popup` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `company_email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_id` bigint unsigned DEFAULT NULL,
  `date_format` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'd-m-Y',
  `date_picker_format` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time_format` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h:i a',
  `latitude` decimal(10,8) NOT NULL DEFAULT '26.91243360',
  `longitude` decimal(11,8) NOT NULL DEFAULT '75.78727090',
  `active_theme` enum('default','custom') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `last_updated_by` int unsigned DEFAULT NULL,
  `google_map_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rounded_theme` tinyint(1) NOT NULL,
  `front_design` tinyint(1) NOT NULL DEFAULT '1',
  `email_verification` tinyint(1) NOT NULL DEFAULT '1',
  `logo_front` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `login_ui` tinyint(1) NOT NULL,
  `auth_css` longtext COLLATE utf8mb4_unicode_ci,
  `auth_css_theme_two` longtext COLLATE utf8mb4_unicode_ci,
  `new_company_locale` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `frontend_disable` tinyint(1) NOT NULL DEFAULT '0',
  `setup_homepage` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `custom_homepage_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expired_message` text COLLATE utf8mb4_unicode_ci,
  `enable_register` tinyint(1) NOT NULL DEFAULT '1',
  `registration_open` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `global_settings_currency_id_foreign` (`currency_id`),
  KEY `global_settings_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `global_settings_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `global_currencies` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `global_settings_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `global_settings` WRITE;
/*!40000 ALTER TABLE `global_settings` DISABLE KEYS */;
INSERT INTO `global_settings` VALUES (1,'Worksuite',NULL,NULL,'#FFFFFF','square','en',NULL,NULL,NULL,'deactive','deactive',NULL,NULL,'deactive',NULL,NULL,0,'','free',NULL,'DD-MM-YYYY','Asia/Kolkata',0,NULL,0,1,1,NULL,NULL,'light','database','image/*,application/vnd.ms-excel,application/vnd.openxmlformats-officedocument.wordprocessingml.document,application/docx,application/pdf,text/plain,application/msword,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/zip,application/x-zip-compressed, application/x-compressed, multipart/x-zip,.xlsx,video/x-flv,video/mp4,application/x-mpegURL,video/MP2T,video/3gpp,video/quicktime,video/x-msvideo,video/x-ms-wmv,application/sla,.stl',10,1,'2022-10-28 07:30:07','2022-10-31 02:28:46','',NULL,NULL,NULL,1,'d-m-Y',NULL,'h:i a',26.91243360,75.78727090,'default',NULL,'',0,1,1,NULL,0,NULL,NULL,NULL,0,'default',NULL,NULL,1,1);
/*!40000 ALTER TABLE `global_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `google_calendar_modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `google_calendar_modules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `lead_status` tinyint(1) NOT NULL DEFAULT '0',
  `leave_status` tinyint(1) NOT NULL DEFAULT '0',
  `invoice_status` tinyint(1) NOT NULL DEFAULT '0',
  `contract_status` tinyint(1) NOT NULL DEFAULT '0',
  `task_status` tinyint(1) NOT NULL DEFAULT '0',
  `event_status` tinyint(1) NOT NULL DEFAULT '0',
  `holiday_status` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `google_calendar_modules_company_id_foreign` (`company_id`),
  CONSTRAINT `google_calendar_modules_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `google_calendar_modules` WRITE;
/*!40000 ALTER TABLE `google_calendar_modules` DISABLE KEYS */;
INSERT INTO `google_calendar_modules` VALUES (1,1,0,0,0,0,0,0,0,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(2,2,0,0,0,0,0,0,0,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(3,3,0,0,0,0,0,0,0,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(4,4,0,0,0,0,0,0,0,'2022-10-28 07:34:33','2022-10-28 07:34:33');
/*!40000 ALTER TABLE `google_calendar_modules` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `holidays` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `date` date NOT NULL,
  `occassion` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `event_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `holidays_date_index` (`date`),
  KEY `holidays_added_by_foreign` (`added_by`),
  KEY `holidays_last_updated_by_foreign` (`last_updated_by`),
  KEY `holidays_company_id_foreign` (`company_id`),
  CONSTRAINT `holidays_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `holidays_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `holidays_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `holidays` WRITE;
/*!40000 ALTER TABLE `holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `holidays` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_item_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `invoice_item_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_item_images_invoice_item_id_foreign` (`invoice_item_id`),
  CONSTRAINT `invoice_item_images_invoice_item_id_foreign` FOREIGN KEY (`invoice_item_id`) REFERENCES `invoice_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_item_images` WRITE;
/*!40000 ALTER TABLE `invoice_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` int unsigned NOT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_summary` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` enum('item','discount','tax') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `quantity` double(16,2) NOT NULL,
  `unit_price` double(16,2) NOT NULL,
  `amount` double(16,2) NOT NULL,
  `taxes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_items_invoice_id_foreign` (`invoice_id`),
  CONSTRAINT `invoice_items_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_items` WRITE;
/*!40000 ALTER TABLE `invoice_items` DISABLE KEYS */;
INSERT INTO `invoice_items` VALUES (1,1,'maxime',NULL,'item',14.00,1962.00,27468.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(2,1,'incidunt',NULL,'item',16.00,1152.00,18432.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(3,2,'possimus',NULL,'item',20.00,1101.00,22020.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(4,2,'consequatur',NULL,'item',20.00,1192.00,23840.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(5,3,'est',NULL,'item',11.00,1501.00,16511.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(6,3,'autem',NULL,'item',7.00,1221.00,8547.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(7,4,'cupiditate',NULL,'item',13.00,1746.00,22698.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(8,4,'soluta',NULL,'item',16.00,1480.00,23680.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(9,5,'eaque',NULL,'item',11.00,1797.00,19767.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(10,5,'doloribus',NULL,'item',10.00,1330.00,13300.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(11,6,'autem',NULL,'item',18.00,1208.00,21744.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(12,6,'quidem',NULL,'item',17.00,1798.00,30566.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(13,7,'vero',NULL,'item',9.00,1098.00,9882.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(14,7,'suscipit',NULL,'item',11.00,1622.00,17842.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(15,8,'eum',NULL,'item',3.00,1223.00,3669.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(16,8,'molestiae',NULL,'item',6.00,1711.00,10266.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(17,9,'eius',NULL,'item',15.00,1888.00,28320.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(18,9,'voluptates',NULL,'item',1.00,1670.00,1670.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(19,10,'voluptates',NULL,'item',20.00,1875.00,37500.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(20,10,'exercitationem',NULL,'item',8.00,1276.00,10208.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(21,11,'pariatur',NULL,'item',14.00,1004.00,14056.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(22,11,'reiciendis',NULL,'item',18.00,1538.00,27684.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(23,12,'a',NULL,'item',4.00,1799.00,7196.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(24,12,'et',NULL,'item',4.00,1416.00,5664.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(25,13,'iure',NULL,'item',2.00,1405.00,2810.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(26,13,'aut',NULL,'item',9.00,1451.00,13059.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(27,14,'quo',NULL,'item',8.00,1490.00,11920.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(28,14,'aliquid',NULL,'item',18.00,1813.00,32634.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(29,15,'in',NULL,'item',8.00,1137.00,9096.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(30,15,'minus',NULL,'item',15.00,1461.00,21915.00,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(31,16,'exercitationem',NULL,'item',10.00,1837.00,18370.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(32,16,'recusandae',NULL,'item',19.00,1238.00,23522.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(33,17,'similique',NULL,'item',9.00,1932.00,17388.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(34,17,'molestiae',NULL,'item',1.00,1069.00,1069.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(35,18,'sit',NULL,'item',15.00,1071.00,16065.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(36,18,'ipsum',NULL,'item',3.00,1954.00,5862.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(37,19,'quis',NULL,'item',14.00,1230.00,17220.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(38,19,'magnam',NULL,'item',2.00,1254.00,2508.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(39,20,'quaerat',NULL,'item',3.00,1867.00,5601.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(40,20,'inventore',NULL,'item',10.00,1809.00,18090.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(41,21,'sint',NULL,'item',9.00,1586.00,14274.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(42,21,'minus',NULL,'item',1.00,1675.00,1675.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(43,22,'ea',NULL,'item',10.00,1119.00,11190.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(44,22,'quia',NULL,'item',12.00,1010.00,12120.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(45,23,'vel',NULL,'item',9.00,1183.00,10647.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(46,23,'accusantium',NULL,'item',12.00,1394.00,16728.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(47,24,'delectus',NULL,'item',14.00,1761.00,24654.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(48,24,'similique',NULL,'item',11.00,1862.00,20482.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(49,25,'maxime',NULL,'item',11.00,1452.00,15972.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(50,25,'autem',NULL,'item',20.00,1288.00,25760.00,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(51,26,'error',NULL,'item',2.00,1018.00,2036.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(52,26,'voluptates',NULL,'item',8.00,1398.00,11184.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(53,27,'natus',NULL,'item',10.00,1043.00,10430.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(54,27,'quis',NULL,'item',3.00,1227.00,3681.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(55,28,'totam',NULL,'item',8.00,1271.00,10168.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(56,28,'totam',NULL,'item',8.00,1582.00,12656.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(57,29,'aut',NULL,'item',6.00,1921.00,11526.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(58,29,'sunt',NULL,'item',16.00,1423.00,22768.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(59,30,'vitae',NULL,'item',2.00,1915.00,3830.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(60,30,'rem',NULL,'item',16.00,1210.00,19360.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(61,31,'omnis',NULL,'item',4.00,1043.00,4172.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(62,31,'quia',NULL,'item',2.00,1543.00,3086.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(63,32,'iste',NULL,'item',6.00,1083.00,6498.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(64,32,'quo',NULL,'item',18.00,1522.00,27396.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(65,33,'reprehenderit',NULL,'item',9.00,1466.00,13194.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(66,33,'ut',NULL,'item',11.00,1307.00,14377.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(67,34,'rerum',NULL,'item',15.00,1694.00,25410.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(68,34,'laborum',NULL,'item',16.00,1018.00,16288.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(69,35,'doloremque',NULL,'item',12.00,1332.00,15984.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(70,35,'et',NULL,'item',7.00,1435.00,10045.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(71,36,'recusandae',NULL,'item',10.00,1225.00,12250.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(72,36,'sed',NULL,'item',15.00,1868.00,28020.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(73,37,'saepe',NULL,'item',15.00,1148.00,17220.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(74,37,'nisi',NULL,'item',12.00,1630.00,19560.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(75,38,'voluptatibus',NULL,'item',3.00,1784.00,5352.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(76,38,'non',NULL,'item',10.00,1666.00,16660.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(77,39,'velit',NULL,'item',6.00,1836.00,11016.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(78,39,'ea',NULL,'item',11.00,1817.00,19987.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(79,40,'repellendus',NULL,'item',14.00,1005.00,14070.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(80,40,'iusto',NULL,'item',20.00,1417.00,28340.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(81,41,'facilis',NULL,'item',20.00,1726.00,34520.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(82,41,'non',NULL,'item',18.00,1592.00,28656.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(83,42,'quas',NULL,'item',13.00,1159.00,15067.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(84,42,'delectus',NULL,'item',13.00,1895.00,24635.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(85,43,'ea',NULL,'item',12.00,1117.00,13404.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(86,43,'quia',NULL,'item',18.00,1026.00,18468.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(87,44,'repellat',NULL,'item',15.00,1012.00,15180.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(88,44,'cumque',NULL,'item',7.00,1501.00,10507.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(89,45,'porro',NULL,'item',11.00,1225.00,13475.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(90,45,'non',NULL,'item',17.00,1267.00,21539.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(91,46,'repellat',NULL,'item',15.00,1679.00,25185.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(92,46,'quos',NULL,'item',13.00,1090.00,14170.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(93,47,'debitis',NULL,'item',7.00,1503.00,10521.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(94,47,'aliquid',NULL,'item',7.00,1374.00,9618.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(95,48,'consectetur',NULL,'item',12.00,1748.00,20976.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(96,48,'et',NULL,'item',5.00,1965.00,9825.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(97,49,'in',NULL,'item',13.00,1074.00,13962.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(98,49,'qui',NULL,'item',19.00,1480.00,28120.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(99,50,'quae',NULL,'item',14.00,1347.00,18858.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(100,50,'aut',NULL,'item',2.00,1474.00,2948.00,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(101,51,'quae',NULL,'item',4.00,1927.00,7708.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(102,51,'dolores',NULL,'item',3.00,1886.00,5658.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(103,52,'dolores',NULL,'item',20.00,1431.00,28620.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(104,52,'rerum',NULL,'item',15.00,1226.00,18390.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(105,53,'eligendi',NULL,'item',11.00,1668.00,18348.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(106,53,'rerum',NULL,'item',5.00,1927.00,9635.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(107,54,'dolores',NULL,'item',10.00,1800.00,18000.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(108,54,'repellendus',NULL,'item',9.00,1277.00,11493.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(109,55,'quia',NULL,'item',4.00,1118.00,4472.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(110,55,'nesciunt',NULL,'item',13.00,1084.00,14092.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(111,56,'excepturi',NULL,'item',4.00,1387.00,5548.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(112,56,'eius',NULL,'item',10.00,1359.00,13590.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(113,57,'rerum',NULL,'item',19.00,1949.00,37031.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(114,57,'ratione',NULL,'item',16.00,1815.00,29040.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(115,58,'eum',NULL,'item',11.00,1280.00,14080.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(116,58,'culpa',NULL,'item',19.00,1916.00,36404.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(117,59,'sit',NULL,'item',14.00,1700.00,23800.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(118,59,'quia',NULL,'item',10.00,1530.00,15300.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(119,60,'tempore',NULL,'item',8.00,1312.00,10496.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(120,60,'minima',NULL,'item',16.00,1642.00,26272.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(121,61,'eveniet',NULL,'item',4.00,1145.00,4580.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(122,61,'modi',NULL,'item',17.00,1569.00,26673.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(123,62,'corporis',NULL,'item',3.00,1868.00,5604.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(124,62,'nemo',NULL,'item',3.00,1208.00,3624.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(125,63,'veritatis',NULL,'item',16.00,1705.00,27280.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(126,63,'qui',NULL,'item',12.00,1895.00,22740.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(127,64,'magnam',NULL,'item',9.00,1706.00,15354.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(128,64,'voluptatem',NULL,'item',9.00,1264.00,11376.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(129,65,'qui',NULL,'item',13.00,1563.00,20319.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(130,65,'animi',NULL,'item',2.00,1054.00,2108.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(131,66,'quod',NULL,'item',17.00,1383.00,23511.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(132,66,'eius',NULL,'item',8.00,1642.00,13136.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(133,67,'magni',NULL,'item',19.00,1530.00,29070.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(134,67,'qui',NULL,'item',13.00,1990.00,25870.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(135,68,'cumque',NULL,'item',16.00,1015.00,16240.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(136,68,'quas',NULL,'item',1.00,1819.00,1819.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(137,69,'aut',NULL,'item',18.00,1837.00,33066.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(138,69,'dicta',NULL,'item',15.00,1829.00,27435.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(139,70,'fuga',NULL,'item',3.00,1171.00,3513.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(140,70,'nihil',NULL,'item',11.00,1108.00,12188.00,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(141,71,'at',NULL,'item',3.00,1890.00,5670.00,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(142,71,'earum',NULL,'item',11.00,1606.00,17666.00,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(143,72,'veniam',NULL,'item',4.00,1757.00,7028.00,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(144,72,'corporis',NULL,'item',2.00,1598.00,3196.00,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(145,73,'voluptas',NULL,'item',11.00,1477.00,16247.00,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(146,73,'eveniet',NULL,'item',8.00,1834.00,14672.00,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(147,74,'ut',NULL,'item',19.00,1997.00,37943.00,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(148,74,'sit',NULL,'item',20.00,1854.00,37080.00,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(149,75,'maiores',NULL,'item',3.00,1730.00,5190.00,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(150,75,'et',NULL,'item',2.00,1508.00,3016.00,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19');
/*!40000 ALTER TABLE `invoice_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_recurring`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_recurring` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `created_by` int unsigned DEFAULT NULL,
  `issue_date` date NOT NULL,
  `due_date` date NOT NULL,
  `sub_total` double NOT NULL DEFAULT '0',
  `total` double NOT NULL DEFAULT '0',
  `discount` double NOT NULL DEFAULT '0',
  `discount_type` enum('percent','fixed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'percent',
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_original_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `show_shipping_address` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `day_of_month` int DEFAULT '1',
  `day_of_week` int DEFAULT '1',
  `payment_method` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rotation` enum('monthly','weekly','bi-weekly','quarterly','half-yearly','annually','daily') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `billing_cycle` int DEFAULT NULL,
  `client_can_stop` tinyint(1) NOT NULL DEFAULT '1',
  `unlimited_recurring` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` datetime DEFAULT NULL,
  `shipping_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `calculate_tax` enum('after_discount','before_discount') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'after_discount',
  PRIMARY KEY (`id`),
  KEY `invoice_recurring_currency_id_foreign` (`currency_id`),
  KEY `invoice_recurring_project_id_foreign` (`project_id`),
  KEY `invoice_recurring_client_id_foreign` (`client_id`),
  KEY `invoice_recurring_user_id_foreign` (`user_id`),
  KEY `invoice_recurring_created_by_foreign` (`created_by`),
  KEY `invoice_recurring_added_by_foreign` (`added_by`),
  KEY `invoice_recurring_last_updated_by_foreign` (`last_updated_by`),
  KEY `invoice_recurring_company_id_foreign` (`company_id`),
  CONSTRAINT `invoice_recurring_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_recurring` WRITE;
/*!40000 ALTER TABLE `invoice_recurring` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice_recurring` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_recurring_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_recurring_item_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `invoice_recurring_item_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_recurring_item_images_invoice_recurring_item_id_foreign` (`invoice_recurring_item_id`),
  CONSTRAINT `invoice_recurring_item_images_invoice_recurring_item_id_foreign` FOREIGN KEY (`invoice_recurring_item_id`) REFERENCES `invoice_recurring_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_recurring_item_images` WRITE;
/*!40000 ALTER TABLE `invoice_recurring_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice_recurring_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_recurring_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_recurring_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `invoice_recurring_id` bigint unsigned NOT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` double NOT NULL,
  `unit_price` double NOT NULL,
  `amount` double NOT NULL,
  `taxes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` enum('item','discount','tax') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `item_summary` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_recurring_items_invoice_recurring_id_foreign` (`invoice_recurring_id`),
  CONSTRAINT `invoice_recurring_items_invoice_recurring_id_foreign` FOREIGN KEY (`invoice_recurring_id`) REFERENCES `invoice_recurring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_recurring_items` WRITE;
/*!40000 ALTER TABLE `invoice_recurring_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice_recurring_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `invoice_prefix` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_digit` int unsigned NOT NULL DEFAULT '3',
  `estimate_prefix` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'EST',
  `estimate_digit` int unsigned NOT NULL DEFAULT '3',
  `credit_note_prefix` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'CN',
  `credit_note_digit` int unsigned NOT NULL DEFAULT '3',
  `template` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `due_after` int NOT NULL,
  `invoice_terms` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `estimate_terms` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `gst_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_gst` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `logo` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hsn_sac_code_show` tinyint(1) NOT NULL DEFAULT '0',
  `locale` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'en',
  `send_reminder` int NOT NULL DEFAULT '0',
  `reminder` enum('after','every') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `send_reminder_after` int NOT NULL DEFAULT '0',
  `tax_calculation_msg` tinyint(1) NOT NULL DEFAULT '0',
  `show_project` int NOT NULL DEFAULT '0',
  `show_client_name` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `show_client_email` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `show_client_phone` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `show_client_company_address` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `show_client_company_name` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `invoice_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `invoice_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_settings` WRITE;
/*!40000 ALTER TABLE `invoice_settings` DISABLE KEYS */;
INSERT INTO `invoice_settings` VALUES (1,1,'INV',3,'EST',3,'CN',3,'invoice-5',15,'Thank you for your business.',NULL,NULL,'no','2022-10-28 07:30:08','2022-10-28 07:30:08',NULL,0,'en',0,NULL,0,0,0,'yes','yes','yes','yes','yes'),(2,2,'INV',3,'EST',3,'CN',3,'invoice-5',15,'Thank you for your business.',NULL,NULL,'no','2022-10-28 07:30:09','2022-10-28 07:30:09',NULL,0,'en',0,NULL,0,0,0,'yes','yes','yes','yes','yes'),(3,3,'INV',3,'EST',3,'CN',3,'invoice-5',15,'Thank you for your business.',NULL,NULL,'no','2022-10-28 07:30:10','2022-10-28 07:30:10',NULL,0,'en',0,NULL,0,0,0,'yes','yes','yes','yes','yes'),(4,4,'INV',3,'EST',3,'CN',3,'invoice-5',15,'Thank you for your business.',NULL,NULL,'no','2022-10-28 07:34:32','2022-10-28 07:34:32',NULL,0,'en',0,NULL,0,0,0,'yes','yes','yes','yes','yes');
/*!40000 ALTER TABLE `invoice_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `invoice_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `issue_date` date NOT NULL,
  `due_date` date NOT NULL,
  `sub_total` double(16,2) NOT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `discount_type` enum('percent','fixed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'percent',
  `total` double(16,2) NOT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `status` enum('paid','unpaid','partial','canceled','draft') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unpaid',
  `recurring` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `billing_cycle` int DEFAULT NULL,
  `billing_interval` int DEFAULT NULL,
  `billing_frequency` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_original_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `credit_note` tinyint(1) NOT NULL DEFAULT '0',
  `show_shipping_address` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `estimate_id` int unsigned DEFAULT NULL,
  `send_status` tinyint(1) NOT NULL DEFAULT '1',
  `due_amount` double(8,2) NOT NULL DEFAULT '0.00',
  `parent_id` int unsigned DEFAULT NULL,
  `invoice_recurring_id` bigint unsigned DEFAULT NULL,
  `created_by` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `hash` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `calculate_tax` enum('after_discount','before_discount') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'after_discount',
  `company_address_id` bigint unsigned DEFAULT NULL,
  `event_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `custom_invoice_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `invoices_invoice_number_company_id_unique` (`invoice_number`,`company_id`),
  KEY `invoices_project_id_foreign` (`project_id`),
  KEY `invoices_client_id_foreign` (`client_id`),
  KEY `invoices_order_id_foreign` (`order_id`),
  KEY `invoices_due_date_index` (`due_date`),
  KEY `invoices_currency_id_foreign` (`currency_id`),
  KEY `invoices_estimate_id_foreign` (`estimate_id`),
  KEY `invoices_parent_id_foreign` (`parent_id`),
  KEY `invoices_invoice_recurring_id_foreign` (`invoice_recurring_id`),
  KEY `invoices_created_by_foreign` (`created_by`),
  KEY `invoices_added_by_foreign` (`added_by`),
  KEY `invoices_last_updated_by_foreign` (`last_updated_by`),
  KEY `invoices_company_address_id_foreign` (`company_address_id`),
  KEY `invoices_company_id_foreign` (`company_id`),
  CONSTRAINT `invoices_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoices_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_company_address_id_foreign` FOREIGN KEY (`company_address_id`) REFERENCES `company_addresses` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoices_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `invoices_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_estimate_id_foreign` FOREIGN KEY (`estimate_id`) REFERENCES `estimates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_invoice_recurring_id_foreign` FOREIGN KEY (`invoice_recurring_id`) REFERENCES `invoice_recurring` (`id`) ON DELETE SET NULL,
  CONSTRAINT `invoices_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoices_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoices_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
INSERT INTO `invoices` VALUES (1,1,1,7,NULL,'1','2022-09-28','2022-10-08',45900.00,0,'percent',45900.00,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,1,45900.00,NULL,NULL,NULL,NULL,NULL,'KaJp2X2gPMjJPNiQt2B5ovGuhmM6lw7K','after_discount',NULL,NULL,'INV#001'),(2,1,1,7,NULL,'2','2022-09-02','2022-09-12',45860.00,0,'percent',45860.00,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,1,45860.00,NULL,NULL,NULL,NULL,NULL,'yxGUcCDrHBkYKpAfnF5EOJvGzneLyDhj','after_discount',NULL,NULL,'INV#002'),(3,1,1,7,NULL,'3','2022-09-11','2022-09-21',25058.00,0,'percent',25058.00,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'exu4Bz2STLKOwm5aTztvs2TVtWfw6IgA','after_discount',NULL,NULL,'INV#003'),(4,1,1,7,NULL,'4','2022-09-25','2022-10-05',46378.00,0,'percent',46378.00,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'BiafqvWMkVeOExlOvU7iYk7vQyvqrXvG','after_discount',NULL,NULL,'INV#004'),(5,1,1,7,NULL,'5','2022-09-19','2022-09-29',33067.00,0,'percent',33067.00,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'OKtSpHVToxRqwCViKFDJfSsfCGo4DVqU','after_discount',NULL,NULL,'INV#005'),(6,1,2,7,NULL,'6','2022-09-22','2022-10-02',52310.00,0,'percent',52310.00,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,1,52310.00,NULL,NULL,NULL,NULL,NULL,'1nPNJKKoHgRpSMerjlyLd1GIya1PBof2','after_discount',NULL,NULL,'INV#006'),(7,1,2,7,NULL,'7','2022-09-24','2022-10-04',27724.00,0,'percent',27724.00,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,1,27724.00,NULL,NULL,NULL,NULL,NULL,'L0znuvQ8iTU5pIYr35yWDWpUwwW98yvf','after_discount',NULL,NULL,'INV#007'),(8,1,2,7,NULL,'8','2022-09-14','2022-09-24',13935.00,0,'percent',13935.00,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,1,13935.00,NULL,NULL,NULL,NULL,NULL,'LH0DpCPuEgThHKKbQpISBOXnipVJO8vK','after_discount',NULL,NULL,'INV#008'),(9,1,2,7,NULL,'9','2022-09-19','2022-09-29',29990.00,0,'percent',29990.00,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'td4OmPEaGAr9GVa2I9yfcNxvGFlSGYdO','after_discount',NULL,NULL,'INV#009'),(10,1,2,7,NULL,'10','2022-09-24','2022-10-04',47708.00,0,'percent',47708.00,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'QFUHYYm4vTsVnwNeuZI0Ecmsp3Vly3Pb','after_discount',NULL,NULL,'INV#010'),(11,1,3,8,NULL,'11','2022-09-20','2022-09-30',41740.00,0,'percent',41740.00,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'if7uCdvU5EZKjSdMDtaTzBa6KPM5S7Fj','after_discount',NULL,NULL,'INV#011'),(12,1,3,8,NULL,'12','2022-09-22','2022-10-02',12860.00,0,'percent',12860.00,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,1,12860.00,NULL,NULL,NULL,NULL,NULL,'NcPbZ5zqP43ua6X2V4Sy2dy5hi6xocJ8','after_discount',NULL,NULL,'INV#012'),(13,1,3,8,NULL,'13','2022-09-16','2022-09-26',15869.00,0,'percent',15869.00,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'AnwwYU17EGSajUA7aTojOvXdS3cLhjlq','after_discount',NULL,NULL,'INV#013'),(14,1,3,8,NULL,'14','2022-09-06','2022-09-16',44554.00,0,'percent',44554.00,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'e1Isa5kRgvhumGnPT1GZaAoXWM2AC2hb','after_discount',NULL,NULL,'INV#014'),(15,1,3,8,NULL,'15','2022-09-04','2022-09-14',31011.00,0,'percent',31011.00,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'lF6sPg9kmlGgXx64yqbES1VG7OO6wuWk','after_discount',NULL,NULL,'INV#015'),(16,1,4,7,NULL,'16','2022-09-26','2022-10-06',41892.00,0,'percent',41892.00,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'QW2YMJZj1VsF8oLvWYfxlQzvmhYotXWT','after_discount',NULL,NULL,'INV#016'),(17,1,4,7,NULL,'17','2022-09-26','2022-10-06',18457.00,0,'percent',18457.00,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,1,18457.00,NULL,NULL,NULL,NULL,NULL,'yanGIk8ZQA2khljv6RdtnNhvdHWSgapY','after_discount',NULL,NULL,'INV#017'),(18,1,4,7,NULL,'18','2022-09-24','2022-10-04',21927.00,0,'percent',21927.00,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'G4jWsw9uYf7md6HX52Pb66pTpdYgnzAq','after_discount',NULL,NULL,'INV#018'),(19,1,4,7,NULL,'19','2022-09-14','2022-09-24',19728.00,0,'percent',19728.00,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,1,19728.00,NULL,NULL,NULL,NULL,NULL,'4l7CU4mcq0NcBlXiretbAY3kWXpuuw9e','after_discount',NULL,NULL,'INV#019'),(20,1,4,7,NULL,'20','2022-09-29','2022-10-09',23691.00,0,'percent',23691.00,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,1,23691.00,NULL,NULL,NULL,NULL,NULL,'gef9PPxiIldN8nTADmP2hPhV2qWhkMgf','after_discount',NULL,NULL,'INV#020'),(21,1,5,5,NULL,'21','2022-09-22','2022-10-02',15949.00,0,'percent',15949.00,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,1,15949.00,NULL,NULL,NULL,NULL,NULL,'EStSd9TkTx3Hajv5EwF2LXWTMHRiSdcK','after_discount',NULL,NULL,'INV#021'),(22,1,5,5,NULL,'22','2022-09-11','2022-09-21',23310.00,0,'percent',23310.00,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,1,23310.00,NULL,NULL,NULL,NULL,NULL,'Urh4hsiVmVE0F8K8iv0i2klTJW2NXdCZ','after_discount',NULL,NULL,'INV#022'),(23,1,5,5,NULL,'23','2022-09-24','2022-10-04',27375.00,0,'percent',27375.00,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,1,27375.00,NULL,NULL,NULL,NULL,NULL,'FwEVJM89lRiNQaeNvL5Ymq585cAHyNUC','after_discount',NULL,NULL,'INV#023'),(24,1,5,5,NULL,'24','2022-09-30','2022-10-10',45136.00,0,'percent',45136.00,1,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,1,45136.00,NULL,NULL,NULL,NULL,NULL,'Xjs1102QdK7t6omN2hCxDtergY7xxqM4','after_discount',NULL,NULL,'INV#024'),(25,1,5,5,NULL,'25','2022-09-29','2022-10-09',41732.00,0,'percent',41732.00,1,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'QT02fVqBtr18AgejoIm3vHCEWXbR69TP','after_discount',NULL,NULL,'INV#025'),(26,2,6,20,NULL,'26','2022-09-07','2022-09-17',13220.00,0,'percent',13220.00,5,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'SFKz3DdRB9nkZ1iSUvJ2SLxb4kvoz8CJ','after_discount',NULL,NULL,'INV#026'),(27,2,6,20,NULL,'27','2022-09-25','2022-10-05',14111.00,0,'percent',14111.00,5,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,14111.00,NULL,NULL,NULL,NULL,NULL,'Kba9gF8KKdbDt8BxKs7X9Vh0UNXwXxMW','after_discount',NULL,NULL,'INV#027'),(28,2,6,20,NULL,'28','2022-09-11','2022-09-21',22824.00,0,'percent',22824.00,5,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'FcH8ds16MK28FQ3xA2a0qA87oqwm335n','after_discount',NULL,NULL,'INV#028'),(29,2,6,20,NULL,'29','2022-09-15','2022-09-25',34294.00,0,'percent',34294.00,5,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,34294.00,NULL,NULL,NULL,NULL,NULL,'zPoo2H9FZmek6h8VmyM8uuebi967gvcb','after_discount',NULL,NULL,'INV#029'),(30,2,6,20,NULL,'30','2022-09-19','2022-09-29',23190.00,0,'percent',23190.00,5,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'VrNL46mJoxD1snPv9z3iNhhCABPB5k7E','after_discount',NULL,NULL,'INV#030'),(31,2,7,21,NULL,'31','2022-09-27','2022-10-07',7258.00,0,'percent',7258.00,5,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,7258.00,NULL,NULL,NULL,NULL,NULL,'8n6BmmIXzDxIGH1oSjHhBlEhbBoOHFPN','after_discount',NULL,NULL,'INV#031'),(32,2,7,21,NULL,'32','2022-09-26','2022-10-06',33894.00,0,'percent',33894.00,5,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,33894.00,NULL,NULL,NULL,NULL,NULL,'bOWLE0Ia8I9uEiNYEUECNJJADelmJCGX','after_discount',NULL,NULL,'INV#032'),(33,2,7,21,NULL,'33','2022-09-29','2022-10-09',27571.00,0,'percent',27571.00,5,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'KkSp2vlbxYwbpteSYhJi5po26ECk2vGd','after_discount',NULL,NULL,'INV#033'),(34,2,7,21,NULL,'34','2022-09-12','2022-09-22',41698.00,0,'percent',41698.00,5,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'Wn3nmsipXKuPNTO3ZL7tESuAlLI2PIpw','after_discount',NULL,NULL,'INV#034'),(35,2,7,21,NULL,'35','2022-09-02','2022-09-12',26029.00,0,'percent',26029.00,5,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'SglvHEzLPJCyqkSnPcTDEJ77rMJRVemv','after_discount',NULL,NULL,'INV#035'),(36,2,8,18,NULL,'36','2022-09-19','2022-09-29',40270.00,0,'percent',40270.00,5,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'Zn0HXaOaSHMXBH0RBR7TWK7NTe2Rd2DM','after_discount',NULL,NULL,'INV#036'),(37,2,8,18,NULL,'37','2022-09-25','2022-10-05',36780.00,0,'percent',36780.00,5,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'OsaCQFHa2cIPf2VwYaNRBQW0nJhHn3nI','after_discount',NULL,NULL,'INV#037'),(38,2,8,18,NULL,'38','2022-09-10','2022-09-20',22012.00,0,'percent',22012.00,5,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,22012.00,NULL,NULL,NULL,NULL,NULL,'bhLstObgK5y0LeWGMN73Y7D7KS4pU2bM','after_discount',NULL,NULL,'INV#038'),(39,2,8,18,NULL,'39','2022-09-28','2022-10-08',31003.00,0,'percent',31003.00,5,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,31003.00,NULL,NULL,NULL,NULL,NULL,'WSrUT5vqrm1PDOFfx9a5PajUK6TZk8Dz','after_discount',NULL,NULL,'INV#039'),(40,2,8,18,NULL,'40','2022-09-13','2022-09-23',42410.00,0,'percent',42410.00,5,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'vkGc28UTqfPm7brlpkKRJY2R8mHZTgjI','after_discount',NULL,NULL,'INV#040'),(41,2,9,21,NULL,'41','2022-09-16','2022-09-26',63176.00,0,'percent',63176.00,5,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,63176.00,NULL,NULL,NULL,NULL,NULL,'mo9iTGxyJpAeF1MijLazNRWWCDgktLOx','after_discount',NULL,NULL,'INV#041'),(42,2,9,21,NULL,'42','2022-09-25','2022-10-05',39702.00,0,'percent',39702.00,5,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'aOB7v41JZmn9ASq63ajLUXGA6mYYTRic','after_discount',NULL,NULL,'INV#042'),(43,2,9,21,NULL,'43','2022-09-09','2022-09-19',31872.00,0,'percent',31872.00,5,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'AgmoW5UzrRMW6pv16gTdubdJhOqQZdAJ','after_discount',NULL,NULL,'INV#043'),(44,2,9,21,NULL,'44','2022-09-19','2022-09-29',25687.00,0,'percent',25687.00,5,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'n6bjlCRu7nIolpG69cXzSzeJnF82kVll','after_discount',NULL,NULL,'INV#044'),(45,2,9,21,NULL,'45','2022-09-03','2022-09-13',35014.00,0,'percent',35014.00,5,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,35014.00,NULL,NULL,NULL,NULL,NULL,'KvvRgOBnTYgxC8UhDxnx0roZeN7AMr7n','after_discount',NULL,NULL,'INV#045'),(46,2,10,20,NULL,'46','2022-09-16','2022-09-26',39355.00,0,'percent',39355.00,5,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'7AZCi8TdanVoGIipi0RyaZTrXZ2GJ0sx','after_discount',NULL,NULL,'INV#046'),(47,2,10,20,NULL,'47','2022-09-07','2022-09-17',20139.00,0,'percent',20139.00,5,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'yaSehs4jp4J64r61wsOH3TwAOkLo7nSp','after_discount',NULL,NULL,'INV#047'),(48,2,10,20,NULL,'48','2022-09-20','2022-09-30',30801.00,0,'percent',30801.00,5,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,30801.00,NULL,NULL,NULL,NULL,NULL,'wTY8BNaoJrWoC2EChBi8XMorBAGxjaLf','after_discount',NULL,NULL,'INV#048'),(49,2,10,20,NULL,'49','2022-09-24','2022-10-04',42082.00,0,'percent',42082.00,5,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,42082.00,NULL,NULL,NULL,NULL,NULL,'CIVkQlAHbiG5C8YvNdGmsseBdJH9hJXF','after_discount',NULL,NULL,'INV#049'),(50,2,10,20,NULL,'50','2022-09-11','2022-09-21',21806.00,0,'percent',21806.00,5,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'FogDjrgFaFejJUkzAbt2nBgZMTqSqozE','after_discount',NULL,NULL,'INV#050'),(51,3,11,35,NULL,'51','2022-09-21','2022-10-01',13366.00,0,'percent',13366.00,9,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,13366.00,NULL,NULL,NULL,NULL,NULL,'vkRgHmIITpJCB86a1qP9ICefyf90MxZ2','after_discount',NULL,NULL,'INV#051'),(52,3,11,35,NULL,'52','2022-09-02','2022-09-12',47010.00,0,'percent',47010.00,9,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,47010.00,NULL,NULL,NULL,NULL,NULL,'ncSqCFVPkhXvsNBl6cv0z2Xuqq8dSuAi','after_discount',NULL,NULL,'INV#052'),(53,3,11,35,NULL,'53','2022-09-23','2022-10-03',27983.00,0,'percent',27983.00,9,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,27983.00,NULL,NULL,NULL,NULL,NULL,'FCjs9HYyW6hTYblDqukodLa2FUqqo84o','after_discount',NULL,NULL,'INV#053'),(54,3,11,35,NULL,'54','2022-09-22','2022-10-02',29493.00,0,'percent',29493.00,9,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,29493.00,NULL,NULL,NULL,NULL,NULL,'jkXXrB59bWM19pxf5e8VzWhoARurG1jj','after_discount',NULL,NULL,'INV#054'),(55,3,11,35,NULL,'55','2022-09-29','2022-10-09',18564.00,0,'percent',18564.00,9,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,18564.00,NULL,NULL,NULL,NULL,NULL,'apBchg6Yad3SqB7uGk8W8BaIlF8FAh0c','after_discount',NULL,NULL,'INV#055'),(56,3,12,35,NULL,'56','2022-09-23','2022-10-03',19138.00,0,'percent',19138.00,9,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,19138.00,NULL,NULL,NULL,NULL,NULL,'kDH92oD5Z2b0K3LLfb4FlkJfkTZF9zkD','after_discount',NULL,NULL,'INV#056'),(57,3,12,35,NULL,'57','2022-09-17','2022-09-27',66071.00,0,'percent',66071.00,9,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,66071.00,NULL,NULL,NULL,NULL,NULL,'c4GAqOlQKXVQC6z8Hsa1xs3zhD7JeTQC','after_discount',NULL,NULL,'INV#057'),(58,3,12,35,NULL,'58','2022-09-10','2022-09-20',50484.00,0,'percent',50484.00,9,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,50484.00,NULL,NULL,NULL,NULL,NULL,'48fZEBWGlW0gbgK736S1NCjljnXY4gOv','after_discount',NULL,NULL,'INV#058'),(59,3,12,35,NULL,'59','2022-09-29','2022-10-09',39100.00,0,'percent',39100.00,9,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'jgGNGaYbKNVqqxX384B06lPIuSNs63dI','after_discount',NULL,NULL,'INV#059'),(60,3,12,35,NULL,'60','2022-09-25','2022-10-05',36768.00,0,'percent',36768.00,9,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'GpHbGilv7PCYbJw6n0isphGUsXFuGRIE','after_discount',NULL,NULL,'INV#060'),(61,3,13,32,NULL,'61','2022-09-27','2022-10-07',31253.00,0,'percent',31253.00,9,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'NHifO3JAJ9WLSiD07Gpjjd2S2BlMi7R1','after_discount',NULL,NULL,'INV#061'),(62,3,13,32,NULL,'62','2022-09-22','2022-10-02',9228.00,0,'percent',9228.00,9,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'amyoTOHyhGj8kKyw4dRxPHHhpsbUpjdx','after_discount',NULL,NULL,'INV#062'),(63,3,13,32,NULL,'63','2022-09-29','2022-10-09',50020.00,0,'percent',50020.00,9,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,50020.00,NULL,NULL,NULL,NULL,NULL,'YM0u6qBCbOzTsnCvpDgnm5FZGAOlWWdA','after_discount',NULL,NULL,'INV#063'),(64,3,13,32,NULL,'64','2022-09-15','2022-09-25',26730.00,0,'percent',26730.00,9,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'E84eV8wjwiQtVPoUx8ljbkEbyLe48dJw','after_discount',NULL,NULL,'INV#064'),(65,3,13,32,NULL,'65','2022-09-04','2022-09-14',22427.00,0,'percent',22427.00,9,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,22427.00,NULL,NULL,NULL,NULL,NULL,'wNKdVP2IXBTpt40vV7ReYNcwPO5AZiy8','after_discount',NULL,NULL,'INV#065'),(66,3,14,35,NULL,'66','2022-09-28','2022-10-08',36647.00,0,'percent',36647.00,9,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'ydcD7jkwCiuODET7obLHmX4cNgD4JZdK','after_discount',NULL,NULL,'INV#066'),(67,3,14,35,NULL,'67','2022-09-16','2022-09-26',54940.00,0,'percent',54940.00,9,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'v7YaZCCPVrGrDlxLrWNEytCbhw88SQVl','after_discount',NULL,NULL,'INV#067'),(68,3,14,35,NULL,'68','2022-09-18','2022-09-28',18059.00,0,'percent',18059.00,9,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'jA5esj08pUVNARIF1sXHQWC89C0SwDw0','after_discount',NULL,NULL,'INV#068'),(69,3,14,35,NULL,'69','2022-09-19','2022-09-29',60501.00,0,'percent',60501.00,9,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,60501.00,NULL,NULL,NULL,NULL,NULL,'Vf7jvqSpeTLC8wp7hikNUHYztwJoC9rA','after_discount',NULL,NULL,'INV#069'),(70,3,14,35,NULL,'70','2022-09-15','2022-09-25',15701.00,0,'percent',15701.00,9,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'9EmX4eXSFf0XQZjj2JyHKX3WlMhdLNfg','after_discount',NULL,NULL,'INV#070'),(71,3,15,35,NULL,'71','2022-09-19','2022-09-29',23336.00,0,'percent',23336.00,9,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'VeC53BPi8B6QH2RIGPsqVQM09IcQa64W','after_discount',NULL,NULL,'INV#071'),(72,3,15,35,NULL,'72','2022-09-04','2022-09-14',10224.00,0,'percent',10224.00,9,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,1,10224.00,NULL,NULL,NULL,NULL,NULL,'74R2rx6PFxGAvE4JLWxIRmSo5b135bqV','after_discount',NULL,NULL,'INV#072'),(73,3,15,35,NULL,'73','2022-09-26','2022-10-06',30919.00,0,'percent',30919.00,9,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,1,30919.00,NULL,NULL,NULL,NULL,NULL,'vRmDsAOstplK96HfbmC9ObF6uXVC5JrE','after_discount',NULL,NULL,'INV#073'),(74,3,15,35,NULL,'74','2022-09-30','2022-10-10',75023.00,0,'percent',75023.00,9,'unpaid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,1,75023.00,NULL,NULL,NULL,NULL,NULL,'AiDSbLmGe3hKGFGT8dDLAXnNNRD81Hv7','after_discount',NULL,NULL,'INV#074'),(75,3,15,35,NULL,'75','2022-09-19','2022-09-29',8206.00,0,'percent',8206.00,9,'paid','no',NULL,NULL,NULL,NULL,NULL,NULL,0,'no','2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,1,0.00,NULL,NULL,NULL,NULL,NULL,'VYo6zNe4NVHCx3YpNS0ud7DAYoH5pTrJ','after_discount',NULL,NULL,'INV#075');
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `issues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `issues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `status` enum('pending','resolved') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `issues_user_id_foreign` (`user_id`),
  KEY `issues_project_id_foreign` (`project_id`),
  KEY `issues_company_id_foreign` (`company_id`),
  CONSTRAINT `issues_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `issues_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `issues_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `issues` WRITE;
/*!40000 ALTER TABLE `issues` DISABLE KEYS */;
/*!40000 ALTER TABLE `issues` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `job_batches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `job_batches` (
  `id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `job_batches` WRITE;
/*!40000 ALTER TABLE `job_batches` DISABLE KEYS */;
/*!40000 ALTER TABLE `job_batches` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
INSERT INTO `jobs` VALUES (8,'default','{\"uuid\":\"08d5994b-9db6-4dee-bcc7-21fbdea9dd6f\",\"displayName\":\"Illuminate\\\\Foundation\\\\Console\\\\QueuedCommand\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Foundation\\\\Console\\\\QueuedCommand\",\"command\":\"O:43:\\\"Illuminate\\\\Foundation\\\\Console\\\\QueuedCommand\\\":10:{s:7:\\\"\\u0000*\\u0000data\\\";a:2:{i:0;s:10:\\\"backup:run\\\";i:1;a:2:{s:9:\\\"--only-db\\\";b:1;s:23:\\\"--disable-notifications\\\";b:1;}}s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"},\"sentry_trace_parent_data\":\"164911d4afaf4cb3b660a76c93ff657f-cac53179f75149a0-1\"}',1,1667207948,1667207475,1667207475);
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `knowledge_base_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `knowledge_base_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `knowledge_base_id` int unsigned NOT NULL,
  `filename` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` text COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `knowledge_base_files_knowledge_base_id_foreign` (`knowledge_base_id`),
  KEY `knowledge_base_files_added_by_foreign` (`added_by`),
  KEY `knowledge_base_files_last_updated_by_foreign` (`last_updated_by`),
  KEY `knowledge_base_files_company_id_foreign` (`company_id`),
  CONSTRAINT `knowledge_base_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `knowledge_base_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `knowledge_base_files_knowledge_base_id_foreign` FOREIGN KEY (`knowledge_base_id`) REFERENCES `knowledge_bases` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `knowledge_base_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `knowledge_base_files` WRITE;
/*!40000 ALTER TABLE `knowledge_base_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `knowledge_base_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `knowledge_bases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `knowledge_bases` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `heading` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `to` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'employee',
  `category_id` int unsigned DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `knowledge_bases_category_id_foreign` (`category_id`),
  KEY `knowledge_bases_company_id_foreign` (`company_id`),
  CONSTRAINT `knowledge_bases_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `knowledge_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `knowledge_bases_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `knowledge_bases` WRITE;
/*!40000 ALTER TABLE `knowledge_bases` DISABLE KEYS */;
/*!40000 ALTER TABLE `knowledge_bases` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `knowledge_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `knowledge_categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `knowledge_categories_company_id_foreign` (`company_id`),
  CONSTRAINT `knowledge_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `knowledge_categories` WRITE;
/*!40000 ALTER TABLE `knowledge_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `knowledge_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `language_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `language_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `language_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('enabled','disabled') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `flag_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `language_settings` WRITE;
/*!40000 ALTER TABLE `language_settings` DISABLE KEYS */;
INSERT INTO `language_settings` VALUES (1,'en','English','enabled',NULL,NULL,'en'),(2,'ar','Arabic','disabled',NULL,NULL,'ar'),(3,'de','German','disabled',NULL,NULL,'de'),(4,'es','Spanish','disabled',NULL,NULL,'es'),(5,'et','Estonian','disabled',NULL,NULL,'et'),(6,'fa','Farsi','disabled',NULL,NULL,'fa'),(7,'fr','French','disabled',NULL,NULL,'fr'),(8,'gr','Greek','disabled',NULL,NULL,'gr'),(9,'it','Italian','disabled',NULL,NULL,'it'),(10,'nl','Dutch','disabled',NULL,NULL,'nl'),(11,'pl','Polish','disabled',NULL,NULL,'pl'),(12,'pt','Portuguese','disabled',NULL,NULL,'pt'),(13,'pt-br','Portuguese (Brazil)','disabled',NULL,NULL,'pt-br'),(14,'ro','Romanian','disabled',NULL,NULL,'ro'),(15,'ru','Russian','disabled',NULL,NULL,'ru'),(16,'tr','Turkish','disabled',NULL,NULL,'tr'),(17,'zh-CN','Chinese (S)','disabled',NULL,NULL,'zh-CN'),(18,'zh-TW','Chinese (T)','disabled',NULL,NULL,'zh-TW');
/*!40000 ALTER TABLE `language_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_agents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_agents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `status` enum('enabled','disabled') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'enabled',
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_agents_user_id_foreign` (`user_id`),
  KEY `lead_agents_added_by_foreign` (`added_by`),
  KEY `lead_agents_last_updated_by_foreign` (`last_updated_by`),
  KEY `lead_agents_company_id_foreign` (`company_id`),
  CONSTRAINT `lead_agents_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_agents_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_agents_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_agents_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_agents` WRITE;
/*!40000 ALTER TABLE `lead_agents` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_agents` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_category` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_category_added_by_foreign` (`added_by`),
  KEY `lead_category_last_updated_by_foreign` (`last_updated_by`),
  KEY `lead_category_company_id_foreign` (`company_id`),
  CONSTRAINT `lead_category_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_category_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_category_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_category` WRITE;
/*!40000 ALTER TABLE `lead_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_category` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_custom_forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_custom_forms` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `custom_fields_id` int unsigned DEFAULT NULL,
  `field_display_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_order` int NOT NULL,
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_custom_forms_custom_fields_id_foreign` (`custom_fields_id`),
  KEY `lead_custom_forms_added_by_foreign` (`added_by`),
  KEY `lead_custom_forms_last_updated_by_foreign` (`last_updated_by`),
  KEY `lead_custom_forms_company_id_foreign` (`company_id`),
  CONSTRAINT `lead_custom_forms_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_custom_forms_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_custom_forms_custom_fields_id_foreign` FOREIGN KEY (`custom_fields_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_custom_forms_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_custom_forms` WRITE;
/*!40000 ALTER TABLE `lead_custom_forms` DISABLE KEYS */;
INSERT INTO `lead_custom_forms` VALUES (1,1,NULL,'Name','name',1,'active',1,NULL,NULL,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(2,1,NULL,'Email','email',2,'active',1,NULL,NULL,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(3,1,NULL,'Company Name','company_name',3,'active',0,NULL,NULL,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(4,1,NULL,'Website','website',4,'active',0,NULL,NULL,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(5,1,NULL,'Address','address',5,'active',0,NULL,NULL,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(6,1,NULL,'Mobile','mobile',6,'active',0,NULL,NULL,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(7,1,NULL,'Message','message',7,'active',0,NULL,NULL,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(8,1,NULL,'City','city',1,'active',0,NULL,NULL,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(9,1,NULL,'State','state',2,'active',0,NULL,NULL,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(10,1,NULL,'Country','country',3,'active',0,NULL,NULL,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(11,1,NULL,'Postal Code','postal_code',4,'active',0,NULL,NULL,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(12,2,NULL,'Name','name',1,'active',1,NULL,NULL,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(13,2,NULL,'Email','email',2,'active',1,NULL,NULL,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(14,2,NULL,'Company Name','company_name',3,'active',0,NULL,NULL,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(15,2,NULL,'Website','website',4,'active',0,NULL,NULL,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(16,2,NULL,'Address','address',5,'active',0,NULL,NULL,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(17,2,NULL,'Mobile','mobile',6,'active',0,NULL,NULL,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(18,2,NULL,'Message','message',7,'active',0,NULL,NULL,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(19,2,NULL,'City','city',1,'active',0,NULL,NULL,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(20,2,NULL,'State','state',2,'active',0,NULL,NULL,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(21,2,NULL,'Country','country',3,'active',0,NULL,NULL,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(22,2,NULL,'Postal Code','postal_code',4,'active',0,NULL,NULL,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(23,3,NULL,'Name','name',1,'active',1,NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(24,3,NULL,'Email','email',2,'active',1,NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(25,3,NULL,'Company Name','company_name',3,'active',0,NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(26,3,NULL,'Website','website',4,'active',0,NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(27,3,NULL,'Address','address',5,'active',0,NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(28,3,NULL,'Mobile','mobile',6,'active',0,NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(29,3,NULL,'Message','message',7,'active',0,NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(30,3,NULL,'City','city',1,'active',0,NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(31,3,NULL,'State','state',2,'active',0,NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(32,3,NULL,'Country','country',3,'active',0,NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(33,3,NULL,'Postal Code','postal_code',4,'active',0,NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(34,4,NULL,'Name','name',1,'active',1,1,1,'2022-10-28 07:34:32','2022-10-28 07:34:32'),(35,4,NULL,'Email','email',2,'active',1,1,1,'2022-10-28 07:34:32','2022-10-28 07:34:32'),(36,4,NULL,'Company Name','company_name',3,'active',0,1,1,'2022-10-28 07:34:32','2022-10-28 07:34:32'),(37,4,NULL,'Website','website',4,'active',0,1,1,'2022-10-28 07:34:32','2022-10-28 07:34:32'),(38,4,NULL,'Address','address',5,'active',0,1,1,'2022-10-28 07:34:32','2022-10-28 07:34:32'),(39,4,NULL,'Mobile','mobile',6,'active',0,1,1,'2022-10-28 07:34:32','2022-10-28 07:34:32'),(40,4,NULL,'Message','message',7,'active',0,1,1,'2022-10-28 07:34:32','2022-10-28 07:34:32'),(41,4,NULL,'City','city',1,'active',0,1,1,'2022-10-28 07:34:32','2022-10-28 07:34:32'),(42,4,NULL,'State','state',2,'active',0,1,1,'2022-10-28 07:34:32','2022-10-28 07:34:32'),(43,4,NULL,'Country','country',3,'active',0,1,1,'2022-10-28 07:34:32','2022-10-28 07:34:32'),(44,4,NULL,'Postal Code','postal_code',4,'active',0,1,1,'2022-10-28 07:34:32','2022-10-28 07:34:32');
/*!40000 ALTER TABLE `lead_custom_forms` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `filename` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `google_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dropbox_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_files_lead_id_foreign` (`lead_id`),
  KEY `lead_files_user_id_foreign` (`user_id`),
  KEY `lead_files_added_by_foreign` (`added_by`),
  KEY `lead_files_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_files_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_files` WRITE;
/*!40000 ALTER TABLE `lead_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_follow_up`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_follow_up` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` int unsigned NOT NULL,
  `remark` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `next_follow_up_date` datetime DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `event_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `send_reminder` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `remind_time` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `remind_type` enum('minute','hour','day') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_follow_up_lead_id_foreign` (`lead_id`),
  KEY `lead_follow_up_added_by_foreign` (`added_by`),
  KEY `lead_follow_up_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_follow_up_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_follow_up_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_follow_up_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_follow_up` WRITE;
/*!40000 ALTER TABLE `lead_follow_up` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_follow_up` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` int unsigned DEFAULT NULL,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `member_id` int unsigned DEFAULT NULL,
  `is_lead_show` tinyint(1) NOT NULL DEFAULT '0',
  `ask_password` tinyint(1) NOT NULL DEFAULT '0',
  `details` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_notes_lead_id_foreign` (`lead_id`),
  KEY `lead_notes_member_id_foreign` (`member_id`),
  KEY `lead_notes_added_by_foreign` (`added_by`),
  KEY `lead_notes_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_notes_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_notes_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_notes_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_notes_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_notes` WRITE;
/*!40000 ALTER TABLE `lead_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_sources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_sources` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `lead_sources_type_company_id_unique` (`type`,`company_id`),
  KEY `lead_sources_added_by_foreign` (`added_by`),
  KEY `lead_sources_last_updated_by_foreign` (`last_updated_by`),
  KEY `lead_sources_company_id_foreign` (`company_id`),
  CONSTRAINT `lead_sources_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_sources_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_sources_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_sources` WRITE;
/*!40000 ALTER TABLE `lead_sources` DISABLE KEYS */;
INSERT INTO `lead_sources` VALUES (1,1,'email',NULL,NULL,NULL,NULL),(2,1,'google',NULL,NULL,NULL,NULL),(3,1,'facebook',NULL,NULL,NULL,NULL),(4,1,'friend',NULL,NULL,NULL,NULL),(5,1,'direct visit',NULL,NULL,NULL,NULL),(6,1,'tv ad',NULL,NULL,NULL,NULL),(7,2,'email',NULL,NULL,NULL,NULL),(8,2,'google',NULL,NULL,NULL,NULL),(9,2,'facebook',NULL,NULL,NULL,NULL),(10,2,'friend',NULL,NULL,NULL,NULL),(11,2,'direct visit',NULL,NULL,NULL,NULL),(12,2,'tv ad',NULL,NULL,NULL,NULL),(13,3,'email',NULL,NULL,NULL,NULL),(14,3,'google',NULL,NULL,NULL,NULL),(15,3,'facebook',NULL,NULL,NULL,NULL),(16,3,'friend',NULL,NULL,NULL,NULL),(17,3,'direct visit',NULL,NULL,NULL,NULL),(18,3,'tv ad',NULL,NULL,NULL,NULL),(19,4,'email',NULL,NULL,NULL,NULL),(20,4,'google',NULL,NULL,NULL,NULL),(21,4,'facebook',NULL,NULL,NULL,NULL),(22,4,'friend',NULL,NULL,NULL,NULL),(23,4,'direct visit',NULL,NULL,NULL,NULL),(24,4,'tv ad',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `lead_sources` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_status` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` int NOT NULL,
  `default` tinyint(1) NOT NULL,
  `label_color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#ff0000',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `lead_status_type_company_id_unique` (`type`,`company_id`),
  KEY `lead_status_company_id_foreign` (`company_id`),
  CONSTRAINT `lead_status_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_status` WRITE;
/*!40000 ALTER TABLE `lead_status` DISABLE KEYS */;
INSERT INTO `lead_status` VALUES (1,1,'pending',1,1,'#FFE700','2022-10-28 07:30:08','2022-10-28 07:30:08'),(2,1,'inprocess',2,0,'#009EFF','2022-10-28 07:30:08','2022-10-28 07:30:08'),(3,1,'converted',3,0,'#1FAE07','2022-10-28 07:30:08','2022-10-28 07:30:08'),(4,2,'pending',1,1,'#FFE700','2022-10-28 07:30:09','2022-10-28 07:30:09'),(5,2,'inprocess',2,0,'#009EFF','2022-10-28 07:30:09','2022-10-28 07:30:09'),(6,2,'converted',3,0,'#1FAE07','2022-10-28 07:30:09','2022-10-28 07:30:09'),(7,3,'pending',1,1,'#FFE700','2022-10-28 07:30:10','2022-10-28 07:30:10'),(8,3,'inprocess',2,0,'#009EFF','2022-10-28 07:30:10','2022-10-28 07:30:10'),(9,3,'converted',3,0,'#1FAE07','2022-10-28 07:30:10','2022-10-28 07:30:10'),(10,4,'pending',1,1,'#FFE700','2022-10-28 07:34:32','2022-10-28 07:34:32'),(11,4,'inprocess',2,0,'#009EFF','2022-10-28 07:34:32','2022-10-28 07:34:32'),(12,4,'converted',3,0,'#1FAE07','2022-10-28 07:34:32','2022-10-28 07:34:32');
/*!40000 ALTER TABLE `lead_status` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_user_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_user_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `lead_note_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_user_notes_user_id_foreign` (`user_id`),
  KEY `lead_user_notes_lead_note_id_foreign` (`lead_note_id`),
  CONSTRAINT `lead_user_notes_lead_note_id_foreign` FOREIGN KEY (`lead_note_id`) REFERENCES `lead_notes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_user_notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_user_notes` WRITE;
/*!40000 ALTER TABLE `lead_user_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_user_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `leads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `leads` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `client_id` int DEFAULT NULL,
  `source_id` int DEFAULT NULL,
  `status_id` int DEFAULT NULL,
  `column_priority` int NOT NULL,
  `agent_id` bigint unsigned DEFAULT NULL,
  `company_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `salutation` enum('mr','mrs','miss','dr','sir','madam') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cell` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `office` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `next_follow_up` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `value` double DEFAULT '0',
  `currency_id` int unsigned DEFAULT NULL,
  `category_id` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `hash` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leads_agent_id_foreign` (`agent_id`),
  KEY `leads_currency_id_foreign` (`currency_id`),
  KEY `leads_category_id_foreign` (`category_id`),
  KEY `leads_added_by_foreign` (`added_by`),
  KEY `leads_last_updated_by_foreign` (`last_updated_by`),
  KEY `leads_company_id_foreign` (`company_id`),
  CONSTRAINT `leads_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leads_agent_id_foreign` FOREIGN KEY (`agent_id`) REFERENCES `lead_agents` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leads_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `lead_category` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leads_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leads_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leads_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `leads` WRITE;
/*!40000 ALTER TABLE `leads` DISABLE KEYS */;
INSERT INTO `leads` VALUES (1,1,NULL,NULL,1,0,NULL,'Test Lead','www.testing.com','www.testing.com',NULL,'Test client','testing@test.com','123456789',NULL,NULL,NULL,NULL,NULL,NULL,'Quas consectetur, tempor incidunt, aliquid voluptatem, velit mollit et illum, adipisicing ea officia aliquam placeat','yes',0,NULL,NULL,NULL,NULL,'foUyNTTAGG5UzBNJdFt77tiuUa83hmI4','2022-10-28 07:30:12','2022-10-28 07:30:12'),(2,1,NULL,4,2,0,NULL,'Stark-Williamson',NULL,'573 Abshire Gardens\nEast Karellemouth, RI 77728-1206',NULL,'Yasmeen Prosacco','pacocha.cheyanne@mraz.com','19469571',NULL,NULL,NULL,NULL,NULL,NULL,'I get it home?\' when it saw Alice. It looked good-natured, she thought: still it was a very small cake, on which the cook was busily stirring the soup, and seemed not to be a queer thing, to be.','yes',0,NULL,NULL,NULL,NULL,'1IFvhUmicKBaYuOZTDdIs10VMHtVrPWO','2022-10-28 07:30:12','2022-10-28 07:30:12'),(3,1,NULL,3,2,0,NULL,'Erdman, Hartmann and Lockman',NULL,'23106 Hand Ridges Apt. 640\nWest Ella, CO 30443-6732',NULL,'Eloy Prohaska','citlalli.kulas@mertz.com','86664498',NULL,NULL,NULL,NULL,NULL,NULL,'Caterpillar. Alice thought she had asked it aloud; and in despair she put them into a pig,\' Alice quietly said, just as she went on, \'\"--found it advisable to go with the Queen, who had meanwhile.','yes',0,NULL,NULL,NULL,NULL,'ZRJo1FIyIqX1alPXuFeNVPK1D7vIiTA9','2022-10-28 07:30:12','2022-10-28 07:30:12'),(4,1,NULL,2,3,0,NULL,'Schuster-Hessel',NULL,'403 Marlon Valley\nDeshaunland, NE 14404-0867',NULL,'Prof. Frederic Treutel','mafalda.mertz@feest.com','26803402',NULL,NULL,NULL,NULL,NULL,NULL,'Queen\'s hedgehog just now, only it ran away when it grunted again, and did not look at the Queen, \'and he shall tell you how the game began. Alice gave a sudden burst of tears, until there was a.','yes',0,NULL,NULL,NULL,NULL,'OikWsphxVWpV2hcOKYvZIpEsKxtz4k6b','2022-10-28 07:30:12','2022-10-28 07:30:12'),(5,1,NULL,5,3,0,NULL,'Ryan-Doyle',NULL,'51896 Murray Plaza\nKimfurt, IL 73530-4133',NULL,'Mr. Mason Balistreri II','whitney56@ohara.com','95996580',NULL,NULL,NULL,NULL,NULL,NULL,'It was so ordered about by mice and rabbits. I almost think I can say.\' This was quite out of its little eyes, but it is.\' \'Then you keep moving round, I suppose?\' said Alice. \'I mean what I eat\" is.','yes',0,NULL,NULL,NULL,NULL,'UCcuHmKOp3jFnlGSSMNAABYHCX4ue5MU','2022-10-28 07:30:12','2022-10-28 07:30:12'),(6,1,NULL,3,1,0,NULL,'Lynch, Schuppe and Auer',NULL,'67031 Howard Ferry\nFreddieshire, ID 44411',NULL,'Ciara Schuster','njohnson@gmail.com','93064318',NULL,NULL,NULL,NULL,NULL,NULL,'Queen, pointing to Alice an excellent opportunity for making her escape; so she felt a little ledge of rock, and, as the soldiers did. After these came the royal children; there were a Duck and a.','yes',0,NULL,NULL,NULL,NULL,'fgAh50CnbRrJR6y7OrTSbtAQWWzs0Ms1','2022-10-28 07:30:12','2022-10-28 07:30:12'),(7,2,NULL,NULL,4,0,NULL,'Test Lead','www.testing.com','www.testing.com',NULL,'Test client','testing@test.com','123456789',NULL,NULL,NULL,NULL,NULL,NULL,'Quas consectetur, tempor incidunt, aliquid voluptatem, velit mollit et illum, adipisicing ea officia aliquam placeat','yes',0,NULL,NULL,NULL,NULL,'VuDcSHAUj9WvNnbNnXtGkrLfM5CDkITU','2022-10-28 07:30:16','2022-10-28 07:30:16'),(8,2,NULL,11,6,0,NULL,'Padberg-Reichel',NULL,'728 Larue Wells Apt. 894\nWest Mattie, FL 19710',NULL,'Prof. Angela Nitzsche DDS','alysson.lubowitz@hotmail.com','15360901',NULL,NULL,NULL,NULL,NULL,NULL,'What happened to me! I\'LL soon make you grow taller, and the Queen had ordered. They very soon had to sing this:-- \'Beautiful Soup, so rich and green, Waiting in a confused way, \'Prizes! Prizes!\'.','yes',0,NULL,NULL,NULL,NULL,'YCoLYYSSuVjMHNZoNdpYS7TKE8bWR5Pe','2022-10-28 07:30:16','2022-10-28 07:30:16'),(9,2,NULL,12,4,0,NULL,'Corkery-Grady',NULL,'3002 Dena Walks\nLake Hilbertbury, IN 12385-1383',NULL,'Mohamed Prohaska','osborne.lubowitz@stehr.com','68210474',NULL,NULL,NULL,NULL,NULL,NULL,'March Hare. \'I didn\'t know how to begin.\' For, you see, Alice had been looking at Alice for some time with the next moment she appeared on the back. At last the Mouse, in a more subdued tone, and.','yes',0,NULL,NULL,NULL,NULL,'cPZsiqF0Sb9Wey60FZTsLLt6j51DInlr','2022-10-28 07:30:16','2022-10-28 07:30:16'),(10,2,NULL,11,4,0,NULL,'Flatley-Krajcik',NULL,'66542 Purdy Light\nVitafort, ND 56705-4775',NULL,'Madelynn Keebler','ispinka@blick.net','38084459',NULL,NULL,NULL,NULL,NULL,NULL,'I suppose it were nine o\'clock in the same year for such dainties would not join the dance? Will you, won\'t you, will you, won\'t you, will you, won\'t you, will you, old fellow?\' The Mock Turtle.','yes',0,NULL,NULL,NULL,NULL,'Dw78rQ3m2ofJ1u6NZ6JYX82OdpTbRz6B','2022-10-28 07:30:16','2022-10-28 07:30:16'),(11,2,NULL,11,4,0,NULL,'McDermott, Steuber and Towne',NULL,'85159 Macejkovic Valley Apt. 041\nDimitriton, MN 94685-5119',NULL,'Cordelia Mayert','kfisher@berge.net','77837816',NULL,NULL,NULL,NULL,NULL,NULL,'King sharply. \'Do you take me for a minute, while Alice thought to herself that perhaps it was over at last, and managed to put it right; \'not that it was labelled \'ORANGE MARMALADE\', but to get.','yes',0,NULL,NULL,NULL,NULL,'ZtdmECLwcevhA3S5wCjUdHx4aac1MpN8','2022-10-28 07:30:16','2022-10-28 07:30:16'),(12,2,NULL,7,5,0,NULL,'Mills, Friesen and Keeling',NULL,'32479 Heaven Via\nVictoriafort, OK 06489-7444',NULL,'Miss May Prosacco PhD','kcartwright@metz.org','27852049',NULL,NULL,NULL,NULL,NULL,NULL,'Bill\'s got the other--Bill! fetch it back!\' \'And who is Dinah, if I only wish people knew that: then they wouldn\'t be in before the trial\'s over!\' thought Alice. \'Now we shall have some fun now!\'.','yes',0,NULL,NULL,NULL,NULL,'CpTACK54LROQCQixaWIpOWCYKWsd49DA','2022-10-28 07:30:16','2022-10-28 07:30:16'),(13,3,NULL,NULL,7,0,NULL,'Test Lead','www.testing.com','www.testing.com',NULL,'Test client','testing@test.com','123456789',NULL,NULL,NULL,NULL,NULL,NULL,'Quas consectetur, tempor incidunt, aliquid voluptatem, velit mollit et illum, adipisicing ea officia aliquam placeat','yes',0,NULL,NULL,NULL,NULL,'IJGE3Y7hYqElCx70765Df0zyIRcvcn3o','2022-10-28 07:30:19','2022-10-28 07:30:19'),(14,3,NULL,18,9,0,NULL,'Leffler PLC',NULL,'8896 Mante Cliff Apt. 911\nEllischester, MN 16995-9332',NULL,'Mrs. Marta Ferry II','nienow.norris@yahoo.com','24509141',NULL,NULL,NULL,NULL,NULL,NULL,'ALL RETURNED FROM HIM TO YOU,\"\' said Alice. \'Well, then,\' the Cat said, waving its right paw round, \'lives a March Hare. \'Then it doesn\'t matter much,\' thought Alice, as she could not remember ever.','yes',0,NULL,NULL,NULL,NULL,'BhUCShnMR2zQV5x8SNalisx9KCHP8wKY','2022-10-28 07:30:19','2022-10-28 07:30:19'),(15,3,NULL,14,8,0,NULL,'Runolfsdottir, Torp and Gorczany',NULL,'814 Carmelo Glens\nOkunevafort, WA 53436',NULL,'Eleanora Lind','jerde.joany@gmail.com','59926591',NULL,NULL,NULL,NULL,NULL,NULL,'Queen will hear you! You see, she came up to her full size by this time.) \'You\'re nothing but the cook till his eyes very wide on hearing this; but all he SAID was, \'Why is a raven like a frog; and.','yes',0,NULL,NULL,NULL,NULL,'PUf2VHz5tssvNp9qZ8A5QR8BKV6KKPRo','2022-10-28 07:30:19','2022-10-28 07:30:19'),(16,3,NULL,16,8,0,NULL,'Aufderhar LLC',NULL,'92829 Arnulfo Lock Suite 468\nMelbaburgh, NE 07076',NULL,'Ruth Kilback','dledner@koch.com','41249420',NULL,NULL,NULL,NULL,NULL,NULL,'I\'d nearly forgotten that I\'ve got to grow to my jaw, Has lasted the rest of the room again, no wonder she felt a little bottle that stood near the right words,\' said poor Alice, who was talking.','yes',0,NULL,NULL,NULL,NULL,'HeCjY1koZiKl2uOzG1FGrHUpO4LZRhtj','2022-10-28 07:30:19','2022-10-28 07:30:19'),(17,3,NULL,14,7,0,NULL,'Kreiger, Yundt and Mills',NULL,'14878 Santos Motorway Suite 642\nWilfredberg, RI 36554',NULL,'Macey Johnston I','xgerhold@dubuque.com','74611792',NULL,NULL,NULL,NULL,NULL,NULL,'The twelve jurors were all writing very busily on slates. \'What are they doing?\' Alice whispered to the little creature down, and the words a little, half expecting to see what was the only one way.','yes',0,NULL,NULL,NULL,NULL,'rPDaaOKSremLZCR9ytcNeJlTpk9kN5XY','2022-10-28 07:30:19','2022-10-28 07:30:19'),(18,3,NULL,17,9,0,NULL,'Crona-Kub',NULL,'771 Kiehn Squares\nWest Eldon, NY 95779-1276',NULL,'Scarlett Ullrich','osinski.brenda@gorczany.com','7408957',NULL,NULL,NULL,NULL,NULL,NULL,'CHAPTER VIII. The Queen\'s argument was, that if you drink much from a bottle marked \'poison,\' it is almost certain to disagree with you, sooner or later. However, this bottle does. I do hope it\'ll.','yes',0,NULL,NULL,NULL,NULL,'xChAsLkHzGtwX5mzcVBZd1MErIxoA68d','2022-10-28 07:30:19','2022-10-28 07:30:19');
/*!40000 ALTER TABLE `leads` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `leave_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `leave_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `manager_permission` enum('pre-approve','approved','cannot-approve') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pre-approve',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leave_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `leave_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `leave_settings` WRITE;
/*!40000 ALTER TABLE `leave_settings` DISABLE KEYS */;
INSERT INTO `leave_settings` VALUES (1,1,'pre-approve','2022-10-28 07:30:08','2022-10-28 07:30:08'),(2,2,'pre-approve','2022-10-28 07:30:09','2022-10-28 07:30:09'),(3,3,'pre-approve','2022-10-28 07:30:10','2022-10-28 07:30:10'),(4,4,'pre-approve','2022-10-28 07:34:33','2022-10-28 07:34:33');
/*!40000 ALTER TABLE `leave_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `leave_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `leave_types` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `type_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `no_of_leaves` int NOT NULL DEFAULT '5',
  `paid` tinyint(1) NOT NULL DEFAULT '1',
  `monthly_limit` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leave_types_company_id_foreign` (`company_id`),
  CONSTRAINT `leave_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `leave_types` WRITE;
/*!40000 ALTER TABLE `leave_types` DISABLE KEYS */;
INSERT INTO `leave_types` VALUES (1,1,'Casual','#16813D',5,1,0,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(2,1,'Sick','#DB1313',5,1,0,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(3,1,'Earned','#B078C6',5,1,0,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(4,2,'Casual','#16813D',5,1,0,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(5,2,'Sick','#DB1313',5,1,0,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(6,2,'Earned','#B078C6',5,1,0,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(7,3,'Casual','#16813D',5,1,0,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(8,3,'Sick','#DB1313',5,1,0,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(9,3,'Earned','#B078C6',5,1,0,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(10,4,'Casual','#16813D',5,1,0,'2022-10-28 07:34:33','2022-10-28 07:34:33'),(11,4,'Sick','#DB1313',5,1,0,'2022-10-28 07:34:33','2022-10-28 07:34:33'),(12,4,'Earned','#B078C6',5,1,0,'2022-10-28 07:34:33','2022-10-28 07:34:33');
/*!40000 ALTER TABLE `leave_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `leaves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `leaves` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `leave_type_id` int unsigned NOT NULL,
  `duration` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `leave_date` date NOT NULL,
  `reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('approved','pending','rejected') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `reject_reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `paid` tinyint(1) NOT NULL DEFAULT '0',
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `event_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `approved_by` int unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `half_day_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `manager_status_permission` enum('pre-approve','approved') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approve_reason` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `leaves_user_id_foreign` (`user_id`),
  KEY `leaves_leave_type_id_foreign` (`leave_type_id`),
  KEY `leaves_leave_date_index` (`leave_date`),
  KEY `leaves_added_by_foreign` (`added_by`),
  KEY `leaves_last_updated_by_foreign` (`last_updated_by`),
  KEY `leaves_approved_by_foreign` (`approved_by`),
  KEY `leaves_company_id_foreign` (`company_id`),
  CONSTRAINT `leaves_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leaves_approved_by_foreign` FOREIGN KEY (`approved_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leaves_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leaves_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leaves_leave_type_id_foreign` FOREIGN KEY (`leave_type_id`) REFERENCES `leave_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leaves_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `leaves` WRITE;
/*!40000 ALTER TABLE `leaves` DISABLE KEYS */;
INSERT INTO `leaves` VALUES (1,1,12,2,'single','2022-04-13','She went on at last, and they repeated their arguments to her, And mentioned me to introduce it.\' \'I don\'t like it, yer honour, at all, at all!\' \'Do as I get it home?\' when it saw mine coming!\' \'How.','pending',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,NULL),(2,1,12,2,'single','2022-07-23','Which way?\', holding her hand on the slate. \'Herald, read the accusation!\' said the Cat, \'or you wouldn\'t squeeze so.\' said the Hatter, and, just as if nothing had happened. \'How am I to do it! Oh.','rejected',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,NULL),(3,1,12,2,'single','2022-07-06','You MUST have meant some mischief, or else you\'d have signed your name like an honest man.\' There was certainly too much of a muchness?\' \'Really, now you ask me,\' said Alice, who felt ready to sink.','pending',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,NULL),(4,1,12,2,'single','2022-06-20','White Rabbit blew three blasts on the second verse of the legs of the e--e--evening, Beautiful, beautiful Soup!\' CHAPTER XI. Who Stole the Tarts? The King looked anxiously round, to make out what it.','pending',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,NULL),(5,1,12,2,'single','2022-06-10','Alice did not much larger than a real nose; also its eyes again, to see anything; then she remembered the number of executions the Queen was silent. The King laid his hand upon her knee, and the.','approved',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,NULL),(6,2,16,5,'single','2022-08-05','VERY tired of being such a capital one for catching mice you can\'t help that,\' said the Duchess; \'and that\'s the queerest thing about it.\' \'She\'s in prison,\' the Queen ordering off her knowledge, as.','approved',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16',NULL,NULL),(7,2,16,5,'single','2022-09-07','NOT, being made entirely of cardboard.) \'All right, so far,\' said the King. Here one of the shepherd boy--and the sneeze of the baby?\' said the Caterpillar; and it said nothing. \'Perhaps it doesn\'t.','rejected',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16',NULL,NULL),(8,2,16,5,'single','2022-03-18','Hatter, \'or you\'ll be telling me next that you couldn\'t cut off a head unless there was generally a frog or a watch to take out of its little eyes, but it is.\' \'Then you should say \"With what.','approved',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16',NULL,NULL),(9,2,16,5,'single','2022-05-13','And she began looking at the window, and on both sides of the crowd below, and there they lay on the Duchess\'s cook. She carried the pepper-box in her lessons in the same solemn tone, only changing.','approved',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16',NULL,NULL),(10,2,16,5,'single','2022-06-27','But if I\'m not particular as to the three gardeners instantly jumped up, and reduced the answer to shillings and pence. \'Take off your hat,\' the King had said that day. \'A likely story indeed!\' said.','approved',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16',NULL,NULL),(11,3,29,7,'single','2022-05-26','I needn\'t be afraid of it. Presently the Rabbit asked. \'No, I didn\'t,\' said Alice: \'she\'s so extremely--\' Just then she walked up towards it rather timidly, saying to herself, \'Why, they\'re only a.','rejected',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,NULL),(12,3,29,7,'single','2022-01-12','I\'ve often seen a cat without a cat! It\'s the most curious thing I ever was at the top of his teacup instead of onions.\' Seven flung down his face, as long as it can\'t possibly make me grow large.','pending',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,NULL),(13,3,29,7,'single','2022-01-23','Puss,\' she began, in rather a complaining tone, \'and they all crowded round it, panting, and asking, \'But who has won?\' This question the Dodo in an offended tone, \'so I should think!\' (Dinah was.','rejected',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,NULL),(14,3,29,7,'single','2022-01-14','Alice as he spoke, and then Alice dodged behind a great letter, nearly as she could do, lying down with her head!\' the Queen had only one who got any advantage from the Queen said to herself, \'the.','approved',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,NULL),(15,3,29,7,'single','2022-07-03','I look like one, but it is.\' \'Then you shouldn\'t talk,\' said the Footman, \'and that for the accident of the other queer noises, would change (she knew) to the Dormouse, who seemed to be two people!.','approved',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,NULL);
/*!40000 ALTER TABLE `leaves` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `log_time_for`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `log_time_for` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `log_time_for` enum('project','task') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'project',
  `auto_timer_stop` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `approval_required` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `log_time_for_company_id_foreign` (`company_id`),
  CONSTRAINT `log_time_for_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `log_time_for` WRITE;
/*!40000 ALTER TABLE `log_time_for` DISABLE KEYS */;
INSERT INTO `log_time_for` VALUES (1,1,'project','no',0,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(2,2,'project','no',0,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(3,3,'project','no',0,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(4,4,'project','no',0,'2022-10-28 07:34:33','2022-10-28 07:34:33');
/*!40000 ALTER TABLE `log_time_for` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ltm_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ltm_translations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `status` int NOT NULL DEFAULT '0',
  `locale` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `group` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ltm_translations` WRITE;
/*!40000 ALTER TABLE `ltm_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ltm_translations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `menu_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `main_menu` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `default_main_menu` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `setting_menu` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `default_setting_menu` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `menu_settings` WRITE;
/*!40000 ALTER TABLE `menu_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `menu_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `translate_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `route` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `setting_menu` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `message_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `message_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `allow_client_admin` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `allow_client_employee` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `restrict_client` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `message_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `message_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `message_settings` WRITE;
/*!40000 ALTER TABLE `message_settings` DISABLE KEYS */;
INSERT INTO `message_settings` VALUES (1,1,'no','no','no','2022-10-28 07:30:08','2022-10-28 07:30:08'),(2,2,'no','no','no','2022-10-28 07:30:09','2022-10-28 07:30:09'),(3,3,'no','no','no','2022-10-28 07:30:10','2022-10-28 07:30:10'),(4,4,'no','no','no','2022-10-28 07:34:33','2022-10-28 07:34:33');
/*!40000 ALTER TABLE `message_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=663 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_04_02_193005_create_translations_table',1),(2,'2014_10_12_000000_create_users_table',1),(3,'2014_10_12_100000_create_password_resets_table',1),(4,'2016_06_20_112951_create_user_chat_table',1),(5,'2017_03_23_110416_add_column_users_table',1),(6,'2017_03_23_111036_create_client_details_table',1),(7,'2017_03_23_112028_create_client_contacts_table',1),(8,'2017_03_23_112353_create_employee_details_table',1),(9,'2017_03_23_114438_create_organisation_settings_table',1),(10,'2017_03_23_122646_create_project_category_table',1),(11,'2017_03_23_123601_create_projects_table',1),(12,'2017_03_23_125424_create_project_members_table',1),(13,'2017_03_23_125625_create_project_time_logs_table',1),(14,'2017_03_23_130413_create_project_files_table',1),(15,'2017_03_24_051800_create_tasks_table',1),(16,'2017_03_24_054355_create_notices_table',1),(17,'2017_03_24_055005_create_conversation_table',1),(18,'2017_03_24_055539_create_conversation_reply_table',1),(19,'2017_03_24_055859_create_invoices_table',1),(20,'2017_03_24_060421_create_invoice_items_table',1),(21,'2017_03_24_060751_create_quotations_table',1),(22,'2017_03_24_061241_create_quotation_items_table',1),(23,'2017_03_24_061505_create_sticky_notes_table',1),(24,'2017_03_24_064541_create_issues_table',1),(25,'2017_03_29_123858_entrust_setup_tables',1),(26,'2017_04_04_193158_AddColumnsProjectFilesTable',1),(27,'2017_04_05_063103_change_clientid_projectid_invoice_table',1),(28,'2017_04_06_051401_add_discount_column_invoice_table',1),(29,'2017_04_06_054728_add_status_column_issues_table',1),(30,'2017_04_08_152902_add_total_hours_column_time_log_table',1),(31,'2017_04_18_095809_create_project_activity_table',1),(32,'2017_04_18_103815_create_user_activities_table',1),(33,'2017_04_19_101519_create_email_notification_settings_table',1),(34,'2017_04_20_185211_add_colour_column_sticky_notes_table',1),(35,'2017_04_28_114154_create_notifications_table',1),(36,'2017_05_03_131016_add_project_completion_field_projects',1),(37,'2017_05_03_174333_create_currencies_table',1),(38,'2017_05_05_124330_create_module_settings_table',1),(39,'2017_05_05_233111_add_status_column_invoices',1),(40,'2017_05_11_140502_add_currency_symbol_column_invoices',1),(41,'2017_05_11_170244_add_currency_id_column_organisation_settings_table',1),(42,'2017_05_22_172748_add_timezone_column_settings_table',1),(43,'2017_05_24_120216_create_smtp_settings_table',1),(44,'2017_05_31_112158_create_universal_search_table',1),(45,'2017_06_22_131112_add_locale_organisation_settings_table',1),(46,'2017_07_13_091922_add_calculate_task_progress_column_project_table',1),(47,'2017_07_20_093528_on_delete_setnull_timelog',1),(48,'2017_07_21_120958_create_theme_settings_table',1),(49,'2017_07_24_113657_add_link_color_column_theme_settings_table',1),(50,'2017_07_24_123050_add_login_background_organisation_settings_table',1),(51,'2017_07_27_101351_add_column_type_invoice_items_table',1),(52,'2017_07_28_102010_create_estimates_table',1),(53,'2017_07_28_103230_create_estimate_items_table',1),(54,'2017_08_04_064431_create_payments_table',1),(55,'2017_08_05_103940_create_payment_gateway_credential_table',1),(56,'2017_08_08_055908_add_enable_paypal_column_payment_gateway_table',1),(57,'2017_08_09_054230_create_expenses_table',1),(58,'2017_08_21_065430_add_exchange_rate_column_currency_table',1),(59,'2017_08_21_131318_create_invoice_setting_table',1),(60,'2017_08_22_055908_add_expense_email_setting_to_email_notification_setting_table',1),(61,'2017_08_28_110759_add_recurring_columns_in_invoice_table',1),(62,'2017_08_30_061016_add_plan_id_to_payments_table',1),(63,'2017_08_30_093400_create_settings_table',1),(64,'2017_08_30_123956_add_slack_username_column_employee_details_table',1),(65,'2017_08_30_133725_add_send_slack_column_email_notification_settings_table',1),(66,'2017_09_01_060715_add_stipe_column_to_payment_credentials_table',1),(67,'2017_09_01_090124_add_customer_id_column_to_payments_table',1),(68,'2017_09_02_084049_add_locale_column_users_table',1),(69,'2017_09_14_095429_create_ticket_reply_templates_table',1),(70,'2017_09_14_095815_create_ticket_types_table',1),(71,'2017_09_14_100400_create_ticket_groups_table',1),(72,'2017_09_14_100530_create_ticket_tag_list_table',1),(73,'2017_09_14_114900_create_ticket_channels_table',1),(74,'2017_09_14_115003_create_ticket_agent_groups_table',1),(75,'2017_09_14_115004_create_tickets_table',1),(76,'2017_09_14_115005_create_ticket_tags_table',1),(77,'2017_09_18_064917_add_status_column_ticket_agent_group_table',1),(78,'2017_09_24_101700_create_ticket_replies_table',1),(79,'2017_09_25_060229_drop_description_column_ticket_table',1),(80,'2017_09_25_072611_add_deleted_at_column_tickets',1),(81,'2017_09_25_072627_add_deleted_at_column_ticket_reply',1),(82,'2017_10_03_094922_ticket_notification_migration',1),(83,'2017_10_03_134003_add_latitude_longitude_column',1),(84,'2017_10_12_111741_create_attendance_setting_table',1),(85,'2017_10_13_051909_create_attendance_table',1),(86,'2017_10_26_051335_add_mail_from_email_column_smtp_settings_table',1),(87,'2017_10_26_112253_add_office_open_days_column_attendance_settings_table',1),(88,'2017_11_01_054603_add_columns_to_client_details',1),(89,'2017_11_02_045542_change_on_cascade_project_members',1),(90,'2017_11_07_054438_add_project_admin_column_project_table',1),(91,'2017_11_07_125619_remove_project_admin_role',1),(92,'2017_11_08_045549_make_project_id_nullable_tasks_table',1),(93,'2017_11_09_071318_create_taskboard_columns_table',1),(94,'2017_11_09_092817_add_column_tasks_table',1),(95,'2017_11_20_070830_create_custom_fields_table',1),(96,'2017_11_20_071758_create_custom_fields__data_table',1),(97,'2017_11_22_071535_create_events_table',1),(98,'2017_11_23_065323_add_cryptocurrency_columns',1),(99,'2017_11_24_103957_create_event_attendees_table',1),(100,'2017_12_07_034433_change cascade users in time log table',1),(101,'2017_12_12_071823_create_modules_table',1),(102,'2017_12_12_073501_add_module_id_column_permissions_table',1),(103,'2017_12_21_114839_change_upload_folder',1),(104,'2017_12_28_112910_create_leave_types_table',1),(105,'2017_12_30_184422_create_leaves_table',1),(106,'2018_01_02_122442_add_leaves_notification_setting',1),(107,'2018_01_05_062543_add_user_css_column_theme_settings',1),(108,'2018_01_09_180937_add_task_completed_notification_setting',1),(109,'2018_01_29_073527_create_message_setting_table',1),(110,'2018_04_12_100452_add_dropbox_link_column_project_files_table',1),(111,'2018_04_12_123243_create_file_storage_table',1),(112,'2018_04_13_072732_create_groups_table',1),(113,'2018_04_13_092757_create_employee_groups_table',1),(114,'2018_04_17_113657_set_attendance_late_column_default',1),(115,'2018_05_07_065407_alter_invoice_id_null_payments',1),(116,'2018_05_07_065557_add_currency_id_column_payments_table',1),(117,'2018_05_08_064539_add_note_column_invoices',1),(118,'2018_05_15_072536_add_project_id_column_payments',1),(119,'2018_05_28_094515_set_gateway_column_null_payments_table',1),(120,'2018_05_29_070343_change_completed_on_column_to_datetime',1),(121,'2018_05_29_114402_populate_file_storage_settings_table',1),(122,'2018_05_30_051128_add_google_url_to_project_files_table',1),(123,'2018_06_05_092136_create_sub_tasks_table',1),(124,'2018_06_06_091511_create_task_comments_table',1),(125,'2018_06_11_054204_create_push_subscriptions_table',1),(126,'2018_06_14_094059_create_taxes_table',1),(127,'2018_06_18_065034_add_tax_id_column_invoice_items_table',1),(128,'2018_06_18_071442_add_discount_column_invoice_items_table',1),(129,'2018_06_21_052408_change_default_taskboard_columns',1),(130,'2018_06_26_160023_add_leave_count_column_leave_types_table',1),(131,'2018_06_27_072813_add_leaves_start_from_column',1),(132,'2018_06_27_075233_add_joining_date_column',1),(133,'2018_06_27_113713_add_gender_column_users_table',1),(134,'2018_06_28_054604_add_client_view_task_column_project_table',1),(135,'2018_06_28_191256_create_language_settings_table',1),(136,'2018_06_29_060331_add_active_theme_column_settings',1),(137,'2018_06_29_081128_add_manual_timelog_column_project_timelog',1),(138,'2018_06_29_104709_seed_languages',1),(139,'2018_08_02_121259_add_minutes_column_time_log_table',1),(140,'2018_08_22_103829_add_leaves_module',1),(141,'2018_08_22_104302_add_leaves_permissions',1),(142,'2018_08_27_114329_add_module_list_in_module_settings',1),(143,'2018_08_30_065158_add_status_column_users_table',1),(144,'2018_08_31_095814_create_lead_table',1),(145,'2018_08_31_095815_create_lead_source_table',1),(146,'2018_08_31_095815_create_lead_status_table',1),(147,'2018_08_31_095816_create_lead_follow_up_table',1),(148,'2018_09_04_095158_alter_lead_table',1),(149,'2018_09_04_095816_add_lead_module',1),(150,'2018_09_05_102010_create_proposal_table',1),(151,'2018_09_05_113230_create_proposal_items_table',1),(152,'2018_09_07_051239_alter_lead_website_table',1),(153,'2018_09_15_174026_add_default_lead_settings',1),(154,'2018_09_17_045718_add_leads_permission',1),(155,'2018_09_19_091643_add_remarks_to_payments_table',1),(156,'2018_09_19_100708_create_products_table',1),(157,'2018_09_21_095816_create_offline_payment_method_table',1),(158,'2018_09_25_065158_alter_payment_table',1),(159,'2018_09_28_110029_create_log_time_for_table',1),(160,'2018_09_28_965158_alter_project_time_log_table',1),(161,'2018_10_08_091643_alter_project_table',1),(162,'2018_10_08_110029_create_lead_files_table',1),(163,'2018_10_10_110029_create_holidays_table',1),(164,'2018_10_10_123601_create_project_templates_table',1),(165,'2018_10_10_125424_create_project_template_members_table',1),(166,'2018_10_10_135816_add_holiday_module',1),(167,'2018_10_10_251800_create_project_template_tasks_table',1),(168,'2018_10_16_095816_add_holiday_module_detail',1),(169,'2018_10_17_081757_remove_config_datatable_file',1),(170,'2018_10_17_965158_alter_leads_address_table',1),(171,'2018_10_17_965168_alter_leads_phone_table',1),(172,'2018_10_18_091643_alter_attendance_setting_table',1),(173,'2018_10_19_045718_add_holidays_permission',1),(174,'2018_10_20_094413_add_products_module',1),(175,'2018_10_20_094504_add_products_permissions',1),(176,'2018_10_21_051239_alter_holiday_website_table',1),(177,'2018_10_24_071300_add_file_column_to_invoices_table',1),(178,'2018_10_24_965158_alter_employee_detail_table',1),(179,'2018_10_29_965158_alter_attendance_setting_default_table',1),(180,'2018_11_10_071300_alter_user_table',1),(181,'2018_11_10_122646_create_task_category_table',1),(182,'2018_11_30_965158_alter_invoice_item_table',1),(183,'2018_12_12_965158_alter_invoice_estimate_response_table',1),(184,'2018_12_14_094504_add_expenses_permissions',1),(185,'2018_12_14_194504_add_expenses_permissions_detail',1),(186,'2018_12_20_1065158_alter_company_setting_table',1),(187,'2018_12_20_965158_alter_estimate_quantity_table',1),(188,'2018_12_27_074504_check_verify_purchase_file',1),(189,'2018_12_28_075730_create_push_notification_settings_table',1),(190,'2018_12_28_082056_add_send_push_column_email_notification_table',1),(191,'2018_12_28_123245_add_onesignal_player_id_column_users_table',1),(192,'2019_01_02_1065158_alter_module_setting_table',1),(193,'2019_01_02_2065158_insert_module_setting_client_table',1),(194,'2019_01_04_110029_create_employee_docs_table',1),(195,'2019_01_21_1065158_alter_task_creator_table',1),(196,'2019_02_06_1065158_alter_attendance_check_table',1),(197,'2019_02_11_1065158_alter_log_time_for_table',1),(198,'2019_02_12_2065158_insert_module_setting_client_task_table',1),(199,'2019_02_13_110029_create_skills_table',1),(200,'2019_02_13_130029_create_employee_skills_table',1),(201,'2019_02_15_1065158_alter_employee_end_date_table',1),(202,'2019_02_15_1165158_alter_custom_status_table',1),(203,'2019_02_20_074848_create_jobs_table',1),(204,'2019_02_22_1165158_add_company_currency_api_google_api',1),(205,'2019_03_11_965158_alter_expenses_quantity_table',1),(206,'2019_04_03_965158_alter_project_deadline_table',1),(207,'2019_04_04_074848_alter_invoice_setting_table',1),(208,'2019_04_04_075848_alter_client_Details_table',1),(209,'2019_04_10_075848_alter_setting_task_table',1),(210,'2019_04_10_122921_add_weather_key_column',1),(211,'2019_04_12_100242_add_columns_projects_table',1),(212,'2019_04_15_115700_add_budget_columns_projects_table',1),(213,'2019_04_17_070105_create_project_milestones_table',1),(214,'2019_04_23_062017_add_item_summary_column_invoice_item_table',1),(215,'2019_04_23_083812_add_invoice_created_column_project_milestones_table',1),(216,'2019_04_23_101747_add_milestone_id_column_tasks_table',1),(217,'2019_06_04_180628_change_project_budget_field_type',1),(218,'2019_06_07_070913_add_tax_id_column_estimate_items_table',1),(219,'2019_06_07_080053_add_discount_column_estimates_table',1),(220,'2019_07_01_192543_change_size_price_in_double',1),(221,'2019_07_02_072314_add_description_column_products_table',1),(222,'2019_07_15_110127_add_project_id_column_in_expenses_table',1),(223,'2019_08_13_073129_update_settings_add_envato_key',1),(224,'2019_08_13_073129_update_settings_add_support_key',1),(225,'2019_08_16_080219_change_price_size_proposal',1),(226,'2019_08_17_072443_add_datepicker_format_column_in_settings',1),(227,'2019_08_19_000000_create_failed_jobs_table',1),(228,'2019_08_19_085009_add_google_recaptcha_columns_in_organisation_settings_table',1),(229,'2019_08_19_120826_add_app_debug_column_in_organisation_settings_table',1),(230,'2019_08_22_055908_add_invoice_email_setting_to_email_notification_setting_table',1),(231,'2019_08_22_121805_add_external_link_column_project_files_table',1),(232,'2019_08_26_120718_add_offline_method_id_column_payments_table',1),(233,'2019_08_28_081847_update_smtp_setting_verified',1),(234,'2019_08_29_140115_make_smtp_type_nullable',1),(235,'2019_08_30_102114_add_reminder_fields_in_events_table',1),(236,'2019_09_03_103533_add_razorpay_column',1),(237,'2019_09_04_115714_add_recurring_task_id_column_in_tasks_table',1),(238,'2019_09_05_061308_create_project_settings_table',1),(239,'2019_09_09_045256_add_estimate_number_column_in_estimates_table',1),(240,'2019_09_09_081030_add_rounded_theme_column',1),(241,'2019_09_09_115714_add_cron_job_message_hide_table',1),(242,'2019_09_10_1074848_create_designation_table',1),(243,'2019_09_10_111909_add_columns_in_invoice_settings_table',1),(244,'2019_09_10_115714_add_team_field_employee_table',1),(245,'2019_09_10_161408_create_credit_note_table',1),(246,'2019_09_10_161418_create_credit_note_item_table',1),(247,'2019_09_10_161428_add_credit_note_column_in_invoices_table',1),(248,'2019_09_14_074854_add_status_column_projects_table',1),(249,'2019_09_16_101138_create_gdpr_settings_table',1),(250,'2019_09_17_091214_create_removal_requests_table',1),(251,'2019_09_18_191957_add_payments_module_clients',1),(252,'2019_09_25_095015_create_removal_requests_lead_table',1),(253,'2019_09_25_183130_create_dashboard_widgets_table',1),(254,'2019_09_27_212735_add_timelog_module_clients',1),(255,'2019_10_04_101818_add_paypal_mode_in_payment_gateway_credentials_table',1),(256,'2019_10_10_115133_alter_status_column_in_estimates_table',1),(257,'2019_10_14_060314_create_accept_estimates_table',1),(258,'2019_10_14_090840_alter_project_id_column_in_invoices_table',1),(259,'2019_10_14_110606_add_estimate_id_column_in_invoices_table',1),(260,'2019_10_15_052931_create_contract_types_table',1),(261,'2019_10_15_052932_create_contracts_table',1),(262,'2019_10_15_084310_add_contract_module_in_module_settings',1),(263,'2019_10_15_115655_create_contract_signs_table',1),(264,'2019_10_15_120940_create_invoice_credit_note_pivot_table',1),(265,'2019_10_17_051544_create_contract_discussions_table',1),(266,'2019_10_18_045028_alter_credit_note_status_in_credit_notes_table',1),(267,'2019_10_21_130413_create_task_files_table',1),(268,'2019_10_21_230413_create_ticket_files_table',1),(269,'2019_10_22_063419_add_dependent_task_id_in_tasks_table',1),(270,'2019_10_23_122412_create_contract_renews_table',1),(271,'2019_10_24_045038_add_column_module_type_in_universal_search_table',1),(272,'2019_10_24_120220_add_origin_amount_column_in_contracts_table',1),(273,'2019_10_30_045045_add_column_invoice_item_table',1),(274,'2019_10_30_122412_create_lead_agent_table',1),(275,'2019_10_31_045055_add_column_credit_note_item_table',1),(276,'2019_10_31_045065_add_column_estimate_item_table',1),(277,'2019_11_01_045075_add_column_products_table',1),(278,'2019_11_01_142619_add_column_to_in_notices_table',1),(279,'2019_11_05_082637_add_client_id_in_invoices_table',1),(280,'2019_11_07_082637_add_purchase_allow_in_product_table',1),(281,'2019_11_12_054145_add_system_update_column_in_organisation_settings_table',1),(282,'2019_11_13_054155_add_employee_id_column_in_employee_details_table',1),(283,'2019_11_14_054145_add_discount_column_in_proposal_table',1),(284,'2019_11_14_064145_add_tax_column_in_proposal_item_table',1),(285,'2019_11_21_064155_add_task_module_in_module_setting_table',1),(286,'2019_12_01_115133_alter_invoice_status_table',1),(287,'2019_12_09_171149_make_taxes_nullable_propsal_items_table',1),(288,'2019_12_18_115133_alter_proposal_items_table',1),(289,'2019_12_19_115850_add_timelogs_client_modules',1),(290,'2019_12_20_143625_add_logo_background_color_column_settings_table',1),(291,'2020_01_09_100241_add_client_id_credit_note_table',1),(292,'2020_01_09_105514_set_default_status_credit_note_open',1),(293,'2020_01_09_121406_add_task_reminder_columns',1),(294,'2020_01_22_122009_add_is_private_column_tasks_table',1),(295,'2020_01_23_062328_create_task_history_table',1),(296,'2020_01_24_134008_add_default_task_status_column_organisation_settings',1),(297,'2020_01_27_122145_create_pusher_settings_table',1),(298,'2020_02_01_101914_update_settings_review',1),(299,'2020_02_04_061753_add_team_id_field_in_projects_table',1),(300,'2020_02_04_132100_add_contracts_permission',1),(301,'2020_02_10_093726_create_table_menu',1),(302,'2020_02_14_102832_create_task_users_table',1),(303,'2020_02_17_143257_add_slug_email_notification_table',1),(304,'2020_02_21_121956_update_storage_settings_to_local',1),(305,'2020_02_24_060416_update_invoice_setting_logo',1),(306,'2020_03_11_054833_add_shipping_address_field_in_client_details_table',1),(307,'2020_03_11_085729_add_show_shipping_field_in_invoices_table',1),(308,'2020_03_17_411909_alter_invocie_number_in_invoice_table',1),(309,'2020_03_19_112832_create_project_template_task_users_table',1),(310,'2020_03_20_2065158_insert_modules_setting_client_table',1),(311,'2020_03_23_185549_make_message_nullable_ticket_reply_table',1),(312,'2020_04_06_130331_create_discussion_categories_table',1),(313,'2020_04_06_132027_create_discussions_table',1),(314,'2020_04_06_133759_create_discussion_replies_table',1),(315,'2020_04_08_094325_add_best_answer_id_discussions_table',1),(316,'2020_04_08_125803_add_discussion_reply_email_notification_settings_table',1),(317,'2020_04_09_102411_add_last_reply_by_discussions_table',1),(318,'2020_04_12_2065158_insert_contract_employee_modules_setting_table',1),(319,'2020_04_14_144941_add_last_login_column_users_table',1),(320,'2020_04_20_083724_add_hourly_rate_project_timelogs',1),(321,'2020_04_20_114349_add_hourly_rate_project_members',1),(322,'2020_04_20_173833_add_project_id_value_for_tasks_timelogs',1),(323,'2020_04_23_124301_add_billable_column_tasks_table',1),(324,'2020_04_24_115049_add_approved_invoice_id_column_project_time_logs',1),(325,'2020_04_24_122510_add_approval_required_column_log_time_for',1),(326,'2020_05_13_070505_change_earning_by_minutes_timelogs',1),(327,'2020_05_13_113533_add_receipt_column_payments_table',1),(328,'2020_05_19_114539_add_custom_field_groups',1),(329,'2020_05_20_131017_change_project_team_id_cascade',1),(330,'2020_05_21_041143_create_social_auth_settings_table',1),(331,'2020_05_26_084027_add_column_expenses_table',1),(332,'2020_05_30_093624_add_send_status_column_invoices_table',1),(333,'2020_06_01_080620_add_send_status_column_estimates_table',1),(334,'2020_06_02_160923_add_email_notifications_column_users_table',1),(335,'2020_06_15_100530_create_task_tag_list_table',1),(336,'2020_06_15_116005_create_task_tags_table',1),(337,'2020_06_16_160933_alter_date_format_table',1),(338,'2020_06_20_030225_alter_task_tags_to_label_table',1),(339,'2020_06_26_131840_add_column_priority_column_leads_table',1),(340,'2020_06_29_141051_create_sessions_table',1),(341,'2020_07_06_171614_add_phone_country_code_column_users_table',1),(342,'2020_07_07_2065158_insert_module_setting_client_expense_payment_table',1),(343,'2020_07_08_2065258_enter_lead_status_id_table',1),(344,'2020_07_08_2931840_add_column_category_id_in_template_task_table',1),(345,'2020_07_15_112558_add_default_currency_projects',1),(346,'2020_07_16_583130_alter_dashboard_widgets_table',1),(347,'2020_07_21_583130_add_due_amount_column_in_invoice_table',1),(348,'2020_08_13_114705_set_task_category_id_column_null',1),(349,'2020_08_19_051839_create_employee_leave_quotas_table',1),(350,'2020_08_25_081839_add_columns_in_notices_table',1),(351,'2020_08_25_081839_alter_leads_value_table',1),(352,'2020_08_28_081839_add_columns_parent_in_invoice_table',1),(353,'2020_09_17_114705_set_credit_note_amount',1),(354,'2020_09_17_196005_create_task_notes_table',1),(355,'2020_09_18_104145_add_estimate_fields_tasks_table',1),(356,'2020_09_24_522646_create_expenses_category_table',1),(357,'2020_09_28_054230_create_expenses_recurring_table',1),(358,'2020_10_06_522646_create_product_category_table',1),(359,'2020_10_07_522646_create_pinned_table',1),(360,'2020_10_15_054230_create_invoice_recurring_table',1),(361,'2020_10_20_094043_add_dashboard_clock_column_organisation_setting_table',1),(362,'2020_10_29_111515_add_companylogo_address_column_in_contracts_table',1),(363,'2020_11_02_130413_create_contract_files_table',1),(364,'2020_11_17_115634_add_lead_custom_field_group',1),(365,'2020_11_18_065533_create_lead_custom_forms_table',1),(366,'2020_11_18_083624_add_city_state_to_client_details',1),(367,'2020_11_18_090244_add_city_state_to_leads_table',1),(368,'2020_11_19_063807_add_city_state_column_in_contracts_table',1),(369,'2020_11_19_091349_alter_country_cell_column_in_client_details',1),(370,'2020_11_20_104942_create_lead_category_table',1),(371,'2020_11_23_052427_add_category_id_column_in_leads_table',1),(372,'2020_11_25_114705_cancel_status_estimate',1),(373,'2020_11_27_092136_create_project_template_sub_tasks_table',1),(374,'2020_12_01_092136_create_notice_view_table',1),(375,'2020_12_02_055908_add_product_purchase_email_notification_setting_table',1),(376,'2020_12_03_065533_create_ticket_custom_forms_table',1),(377,'2020_12_04_114305_create_client_category_table',1),(378,'2020_12_08_075308_create_project_rating_table',1),(379,'2020_12_08_082101_add_paid_column_in_leave_types',1),(380,'2020_12_08_110140_add_paid_column_in_leaves_table',1),(381,'2020_12_21_072055_create_permission_types_table',1),(382,'2020_12_21_072058_create_user_permissions_table',1),(383,'2020_12_21_132255_add_user_permisisons',1),(384,'2020_12_22_071337_add_owned_by_added_by_last_updated_by_columns',1),(385,'2020_12_28_200000_add_two_factor_columns_to_users_table',1),(386,'2020_12_30_101513_add_owned_by_added_by_last_updated_by_columns_projects',1),(387,'2021_01_11_110041_add_owned_by_added_by_last_updated_by_columns_tasks',1),(388,'2021_01_18_084827_add_estimate_terms_column_invoice_settings',1),(389,'2021_01_19_060745_add_slug_new_product_purchase_in_email_notification_table',1),(390,'2021_01_29_152503_lead_custom_field_name_change',1),(391,'2021_02_05_055908_add_lead_proposal_email_setting',1),(392,'2021_02_05_114041_create_user_taskboard_settings_table',1),(393,'2021_02_08_115655_create_proposal_signs_table',1),(394,'2021_02_15_085425_modify_status_column_in_projects_table',1),(395,'2021_02_15_135533_alter_lead_custom_forms_table',1),(396,'2021_02_16_082106_add_mobile_column_in_tickets_table',1),(397,'2021_02_16_100313_add_added_by_last_updated_by_columns_to_events_table',1),(398,'2021_02_16_102604_add_added_by_last_updated_by_columns_to_products_table',1),(399,'2021_02_16_102906_add_added_by_last_updated_by_columns_to_notices_table',1),(400,'2021_02_17_122943_change_client_details_foreign_table',1),(401,'2021_02_19_102125_add_salutation_column_to_leads_table',1),(402,'2021_02_20_185545_add_owned_by_added_by_last_updated_by_columns_invoices',1),(403,'2021_02_22_101316_add_owned_by_added_by_last_updated_by_columns_payments',1),(404,'2021_02_23_173243_add_column_length_column',1),(405,'2021_02_24_084749_add_owned_by_added_by_last_updated_by_columns_estimates',1),(406,'2021_02_25_052941_add_owned_by_added_by_last_updated_by_columns_leads',1),(407,'2021_02_26_092320_create_currency_format_settings_table',1),(408,'2021_02_26_092817_add_sac_code_invoice_table',1),(409,'2021_02_27_070155_add_added_by_last_updated_by_columns_to_leaves_table',1),(410,'2021_02_28_095653_add_owned_by_added_by_last_updated_by_columns_expenses',1),(411,'2021_03_01_133056_create_user_leadboard_settings_table',1),(412,'2021_03_03_071758_add_owned_by_added_by_last_updated_by_columns_tinelogs',1),(413,'2021_03_03_130641_add_moment_format_column_settings_table',1),(414,'2021_03_04_060745_add_new_for_null_slug_email_notification_table',1),(415,'2021_03_08_022302_add_added_by_last_updated_by_columns_to_holidays_table',1),(416,'2021_03_09_123344_add_owned_by_added_by_last_updated_by_columns_contracts',1),(417,'2021_03_11_070400_update_contract_type_cascade',1),(418,'2021_03_15_112622_add_owned_by_added_by_last_updated_by_columns_attendance',1),(419,'2021_03_15_145533_add_last_cron_run_in_organisation_settings_table',1),(420,'2021_03_19_091501_add_favicon_in_organisation_settings_table',1),(421,'2021_03_19_123557_add_owned_by_added_by_last_updated_by_columns_tickets',1),(422,'2021_04_06_111105_sync_default_role_permission',1),(423,'2021_04_08_021853_add_owned_by_added_by_last_updated_by_columns_invoice_recurring',1),(424,'2021_04_14_080502_add_decription_column_in_proposals_table',1),(425,'2021_05_01_220324_add_dashboard_permissions',1),(426,'2021_05_03_055859_add_owned_by_added_by_last_updated_by_columns_credit_notes_table',1),(427,'2021_05_17_133302_reset_theme_default_colors',1),(428,'2021_05_26_102905_craete_client_notes_table',1),(429,'2021_05_30_174638_craete_project_notes_table',1),(430,'2021_05_31_050747_add_send_reminder_in_invoice_setting_table',1),(431,'2021_05_31_102117_task_share_unique_hash',1),(432,'2021_06_03_104606_add_owned_by_added_by_last_updated_by_columns_project_ratings',1),(433,'2021_06_07_132858_create_user_invitations_table',1),(434,'2021_06_08_072201_add_close_date_in_ticket_table',1),(435,'2021_06_09_101110_remove_visible_rating_employee_column_from_projects_table',1),(436,'2021_06_16_185748_add_dark_theme_column_users_table',1),(437,'2021_06_24_185748_add_column_payment_gateway_credentials_table',1),(438,'2021_06_29_104606_add_manage_project_template_permission',1),(439,'2021_07_07_093528_alter_userid_on_project_template_member',1),(440,'2021_07_20_102117_invoice_client_fix',1),(441,'2021_07_23_181545_add_status_column_to_slack_settings_table',1),(442,'2021_07_25_041851_add_report_permissions',1),(443,'2021_08_04_171200_add_mail_connection_column_email_settings',1),(444,'2021_08_06_085318_remove_on_delete_cascade_from_category_id_on_products_table',1),(445,'2021_08_10_081641_change_default_value_of_paypal_and_stripe_on_payment_gateway_credentials_table',1),(446,'2021_08_10_092728_add_allowed_permission_column_permissions_table',1),(447,'2021_08_10_092728_alter_allowed_permission_column_permissions_table',1),(448,'2021_08_13_094921_change_notification_notifications_table',1),(449,'2021_08_16_161256_set_discussion_category_id_null_on_category_delete',1),(450,'2021_08_17_095756_change_details_columns_type_to_longtext_on_client_note_and_project_note_tables',1),(451,'2021_08_19_174641_change_text_longtext',1),(452,'2021_08_20_100009_change_hourly_rate_double',1),(453,'2021_08_20_121027_add_dashboard_module_permission',1),(454,'2021_08_23_125630_create_orders_table',1),(455,'2021_08_26_120755_add_order_id_column_to_payments_table',1),(456,'2021_08_27_100840_add_order_id_to_invoices_table',1),(457,'2021_08_31_071303_add_failed_status_on_payments_table',1),(458,'2021_09_01_124609_add_order_module_and_permissions',1),(459,'2021_09_02_080343_add_hash_columns',1),(460,'2021_09_02_182736_add_notice_module_clients',1),(461,'2021_09_03_182020_add_default_permissions',1),(462,'2021_09_06_182020_change_dashboard_widget_name',1),(463,'2021_09_07_084452_delete_notices_module_from_client',1),(464,'2021_09_08_142150_add_payment_gateway_response_column_to_payment_table',1),(465,'2021_09_09_085024_add_taskboard_message_pusher_settings',1),(466,'2021_09_14_162221_add_payload_id_to_payments_table',1),(467,'2021_09_15_072728_copy_credit_notes_invoice_table_data_to_payments_table',1),(468,'2021_09_15_190915_add_column_calculate_tax',1),(469,'2021_09_17_115037_remove_credit_notes_invoice_table',1),(470,'2021_09_20_095509_alter_and_add_payment_gateways_credentials',1),(471,'2021_09_22_045939_change_subtask_in_notifications_table',1),(472,'2021_09_22_085009_change_google_recaptcha_columns_in_organisation_settings_table',1),(473,'2021_09_24_083220_add_currency_id_to_contracts_table',1),(474,'2021_09_24_100722_add_view_hourly_rate_permission',1),(475,'2021_09_29_071418_add_salutation_column_on_users_table',1),(476,'2021_09_29_075245_add_lead_status_change_permission',1),(477,'2021_09_30_130413_attendance_setting_alert',1),(478,'2021_10_01_074809_add_leave_change_permission',1),(479,'2021_10_03_190531_add_sidebar_logo_style_column_global_settings',1),(480,'2021_10_04_045942_add_2fa_columns_on_users_table',1),(481,'2021_10_04_130413_create_expenses_category_roles_table',1),(482,'2021_10_05_064140_change_date_null_in_task_table',1),(483,'2021_10_05_130413_custom_field_group_change_table',1),(484,'2021_10_06_130413_create_sub_task_files_table',1),(485,'2021_10_11_092617_add_session_driver_column_organisation_settings',1),(486,'2021_10_12_062814_change_authenticate_via_column',1),(487,'2021_10_12_073058_make_email_nullable_users_table',1),(488,'2021_10_12_121613_add_approve_reject_leaves_permissions',1),(489,'2021_10_13_103621_add_client_signup_columns_settings_table',1),(490,'2021_10_14_073904_add_admin_approval_column_users_table',1),(491,'2021_10_16_113306_add_two_factor_confirmed_column_users_table',1),(492,'2021_10_18_131815_allow_gender_null',1),(493,'2021_10_21_104332_add_employee_owned_permissions',1),(494,'2021_10_26_175349_change_ticket_permissions',1),(495,'2021_10_28_120427_add_recurring_columns_tasks',1),(496,'2021_11_11_145726_add_allowed_file_types_column',1),(497,'2021_11_13_063519_add_paystack_to_payment_gateway_credentials',1),(498,'2021_11_16_105840_change_product_sub_cat_relation',1),(499,'2021_11_17_111317_add_mollie_to_payment_gateway_credentials',1),(500,'2021_11_17_173210_create_company_addresses_table',1),(501,'2021_11_18_053337_add_tax_calculation_msg_to_invoice_settings_table',1),(502,'2021_11_19_115843_add_project_type_column_projects',1),(503,'2021_11_22_114532_move_gst_to_compane_address',1),(504,'2021_11_24_093356_add_payfast_to_payment_gateway_credentials',1),(505,'2021_11_24_093619_create_invoice_item_images_table',1),(506,'2021_11_25_134531_fix_timelog_time',1),(507,'2021_11_26_063416_add_authorize_to_payment_gateway_credentials',1),(508,'2021_11_29_060348_create_discussion_files_table',1),(509,'2021_11_30_063441_add_square_to_payment_gateway_credentials',1),(510,'2021_12_08_100451_add_image_column_to_products_table',1),(511,'2021_12_10_112406_add_permission_sync_column_users_table',1),(512,'2021_12_13_070928_add_proposal_items_images_table',1),(513,'2021_12_14_112039_add_location_column_company_addresses',1),(514,'2021_12_15_090905_create_recurring_invoice_item_images_table',1),(515,'2021_12_15_112911_add_recurring_expense_permission',1),(516,'2021_12_17_041814_create_job_batches_table',1),(517,'2021_12_20_053945_add_order_item_image_table',1),(518,'2021_12_21_044934_add_google_event_id_to_several_tables',1),(519,'2021_12_21_064709_add_title_field_in_client_contact_table',1),(520,'2021_12_21_121710_create_google_calendar_modules_table',1),(521,'2021_12_23_102347_change_clock_out_ip_make_nullable_to_attendances_table',1),(522,'2021_12_24_045226_add_paystack_mode_to_payment_gateway_credentials',1),(523,'2021_12_24_085109_add_save_location_column_attendance_settings',1),(524,'2021_12_27_065645_create_knowledgebase_categories_table',1),(525,'2021_12_27_090829_create_knowledge_bases_table',1),(526,'2021_12_28_112808_add_module_knowledgebase_and_permissions',1),(527,'2021_12_29_124232_add_lead_notes_table',1),(528,'2021_12_30_082542_add_added_by_column_knowledge_base_table',1),(529,'2022_01_03_090136_add_downloadable_to_products_table',1),(530,'2022_01_03_103014_create_database_backup_settings_table',1),(531,'2022_01_03_125020_add_product_id_to_order_items_table',1),(532,'2022_01_06_053854_set_product_description_to_nullable_in_products_table',1),(533,'2022_01_06_093627_add_default_permission_to_knowledge_bases_table',1),(534,'2022_01_11_104355_create_translate_settings_table',1),(535,'2022_01_13_080729_add_flutterwave_to_payment_gateway_credentials',1),(536,'2022_01_14_122713_add_change_role_permission',1),(537,'2022_01_15_055907_create_product_files_table',1),(538,'2022_01_19_112914_create_client_docs_table',1),(539,'2022_01_31_090302_add_missing_permissions_to_admin_role',1),(540,'2022_01_31_111358_change_reference_column_to_lead_notes_table',1),(541,'2022_02_01_104951_add_role_permissions_settings_permission',1),(542,'2022_02_01_113853_fix_permission_types',1),(543,'2022_02_03_065848_add_order_notification_to_email_notification_settings_table',1),(544,'2022_02_03_095618_change_quantity_type_in_order_items_table',1),(545,'2022_02_06_150726_add_product_custom_field_group',1),(546,'2022_02_07_175605_create_project_time_log_breaks_table',1),(547,'2022_02_09_084910_add_two_columns_in_sub_tasks_table',1),(548,'2022_02_10_083543_add_description_column_to_estimates_table',1),(549,'2022_02_11_182041_change_discussion_category_permission',1),(550,'2022_02_14_061344_add_birth_date_in_employee_detail_table',1),(551,'2022_02_14_101407_add_data_in_dashboard_widgets_table',1),(552,'2022_02_14_133011_remove_edit_project_file_permission',1),(553,'2022_02_14_180229_make_lead_email_nullable',1),(554,'2022_02_15_111216_update_notice_permissions',1),(555,'2022_02_15_151924_remove_product_file_permission',1),(556,'2022_02_16_063017_add_user_notification_to_email_notification_settings_table',1),(557,'2022_02_16_072041_remove_lead_file_permission',1),(558,'2022_02_16_173650_add_english_language',1),(559,'2022_02_17_083521_update_order_status_to_orders_table',1),(560,'2022_02_18_102942_create_emergency_contacts_table',1),(561,'2022_02_21_061830_add_emergency_contact_module_and_permission',1),(562,'2022_02_22_170153_add_item_summary_column_credit_note',1),(563,'2022_02_24_070325_add_allowed_file_size_global',1),(564,'2022_02_25_095712_add_discout_to_orders_table',1),(565,'2022_03_01_173825_add_approve_expense_permission',1),(566,'2022_03_03_024807_modify_signature_column_on_proposal_signs_table',1),(567,'2022_03_04_055054_add_few_fields_in_lead_follow_up_table',1),(568,'2022_03_07_053249_add_flutterwave_webhook_secret_hash_to_payment_gateway_credentials_table',1),(569,'2022_03_08_063640_add_added_by_and_updated_by_columns_to_ticket_agent_groups_table',1),(570,'2022_03_09_060457_add_several_fields_to_lead_custom_forms_table',1),(571,'2022_03_10_094321_add_unassigned_task_permission',1),(572,'2022_03_15_104220_add_several_fields_to_invoice_settings_table',1),(573,'2022_03_16_060139_add_missing_hash_in_invoices_table',1),(574,'2022_03_16_093939_change_chat_length',1),(575,'2022_03_22_101553_remove_html_tags_in_products',1),(576,'2022_03_28_081634_create_ticket_email_settings_table',1),(577,'2022_03_30_075758_add_imap_columns_tickets_table',1),(578,'2022_04_06_050532_create_files_table',1),(579,'2022_04_11_094350_add_company_address_id_to_orders_table',1),(580,'2022_04_20_173756_change_milestone_cost_limit',1),(581,'2022_04_21_074927_add_currency_key_version_column',1),(582,'2022_04_22_054036_add_view_earning_permission_timelogs',1),(583,'2022_04_22_102709_create_employee_shifts_table',1),(584,'2022_04_25_085447_ad_missing_admin_permissions',1),(585,'2022_05_03_180927_add_soft_delete_tax',1),(586,'2022_05_04_060741_fix_delete_cacade_recur_invoice',1),(587,'2022_05_06_065647_create_employee_shift_change_requests_table',1),(588,'2022_05_06_100620_add_location_column_in_attendance',1),(589,'2022_05_17_095236_add_show_clock_in_button_in_attendace_table',1),(590,'2022_05_23_062159_add_project_show_in_invoice_setting_table',1),(591,'2022_05_25_064410_add_column_employee_details_table',1),(592,'2022_05_25_072526_add_custom_fields_id_to_lead_custom_form_table',1),(593,'2022_05_27_002220_add_custom_fields_id_to_ticket_custom_form_table',1),(594,'2022_05_31_070019_add_ticket_to_custom_field_groups',1),(595,'2022_06_09_114831_add_view_shift_roster_permission',1),(596,'2022_06_13_084344_add_google_calender_status_to_users_table',1),(597,'2022_06_20_102221_add_private_dashboard_type_to_dashboard_widgets_table',1),(598,'2022_06_20_102234_add_date_in_project_milestones_table',1),(599,'2022_06_20_202945_add_shift_time_columns_attendance_table',1),(600,'2022_06_21_051915_add_reminder_and_send_reminder_after_column_to_invoice_settings_table',1),(601,'2022_06_22_072625_add_shift_time_columns_employee_shift_schedule_table',1),(602,'2022_06_23_124453_add_default_status_in_calendar_view_employee_details_table',1),(603,'2022_06_24_084953_add_project_id_column_to_task_label_list',1),(604,'2022_06_28_045956_add_column_to_message_setting_table',1),(605,'2022_07_01_063756_add_app_name_column_organisation_settings_table',1),(606,'2022_07_01_111241_add_parent_id_column_to_teams',1),(607,'2022_07_04_092625_change_date_format_in_organization_setting_table',1),(608,'2022_07_11_051015_add_timelog_to_cutom_field_groups',1),(609,'2022_07_13_115914_add_remark_column_shift',1),(610,'2022_07_13_191406_add_custom_invoice_number_column_invoices',1),(611,'2022_07_14_203040_remove_dashboards_employee_type',1),(612,'2022_07_19_144705_add_week_timelog_widget_setting_private_dashboard',1),(613,'2022_07_22_073943_update_settings_add_license_type',1),(614,'2022_07_24_115433_add_expense_report_permission',1),(615,'2022_07_25_122923_add_task_soft_delete',1),(616,'2022_07_25_141508_add_today_attendance_widget_hr_dashbaord',1),(617,'2022_07_28_043824_add_export_column_custom_fields_table',1),(618,'2022_07_28_175448_create_knowledge_base_files_table',1),(619,'2022_07_29_101111_add_indexes_to_table_columns',1),(620,'2022_08_01_104602_add_columns_to_employee_details',1),(621,'2022_08_02_113623_add_external_link_column_knowledge_base_files_table',1),(622,'2022_08_02_121434_add_timestamps_knowledge_base_files_table',1),(623,'2022_08_03_103344_add_auto_clock_in_column_to_attendance_settings_table',1),(624,'2022_08_04_075744_add_approved_columns_on_leaves',1),(625,'2022_08_04_122512_add_columns_in_leave_types',1),(626,'2022_08_04_184937_add_half_day_type_in_leaves_table',1),(627,'2018_01_01_000000_create_worksuite_new_table',1),(628,'2022_07_04_111754_add_project_short_code_column_project_table',2),(629,'2022_07_14_063826_contract_templates',2),(630,'2022_07_22_042424_create_proposal_templates_table',2),(631,'2022_08_03_101616_create_event_files_table',2),(632,'2022_08_12_000000_create_other_migration_till_date_table',2),(633,'2022_08_13_070443_add_task_unique_id_column_tasks_table',2),(634,'2022_08_18_120924_create_task_settings_table',2),(635,'2022_08_19_100314_add_leave_widget_in_dashboard_widget_table',2),(636,'2022_08_19_115209_create_project_status_settings_table',2),(637,'2022_08_22_104028_knowledge_heading_missing',2),(638,'2022_08_23_065943_change_status_type_projects_table',2),(639,'2022_08_24_122345_add_lead_widget_in_dashboard_widget_table',2),(640,'2022_08_25_085025_add_other_location_to_attendances_table',2),(641,'2022_08_25_123713_add_work_from_home_widget_in_dashboard_widgets_table',2),(642,'2022_08_26_042542_remove_on_delete_cascade_from_invoice_recurring_id_to_invoices',2),(643,'2022_08_26_053139_add_parent_id_column_designation_table',2),(644,'2022_08_29_064339_add_added_by_to_project_template',2),(645,'2022_08_29_103443_add_flag_code_column_to_language_settings',2),(646,'2022_09_00_000000_create_company_table',2),(647,'2022_09_01_000000_add_company_id_in_all_table',2),(648,'2022_09_01_060824_create_appreciations_table',2),(649,'2022_09_01_083053_create_global_settings_table',2),(650,'2022_09_02_151515_create_flags_table',2),(651,'2022_09_05_064405_add_miro_board_column_in_project_table',2),(652,'2022_09_07_172743_add_lead_status_column_to_permissions',2),(653,'2022_09_13_075642_add_customised_permission_column',2),(654,'2022_09_13_075642_create_leave_settings_table',2),(655,'2022_09_16_071005_add_headcount_and_joining_vs_attrition_widget_in_dashboard_widget_table',2),(656,'2022_09_16_105720_update_permission_of_client_and_employee_document',2),(657,'2022_09_19_124014_add_delete_approve_leave_in_permission_table',2),(658,'2022_09_23_053942_update_type_of_hsn_sac_code_to_proposal_template_items',2),(659,'2022_09_23_181722_add_approve_reason_column_to_leaves_table',2),(660,'2022_10_03_080325_create_super_admin_tables_table',2),(661,'2022_10_19_112953_create_user_auths_table',2),(662,'2022_10_09_155207_add_custom_year_to_companies_table',3);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `module_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `module_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `module_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('admin','employee','client') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'admin',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `module_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `module_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=265 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `module_settings` WRITE;
/*!40000 ALTER TABLE `module_settings` DISABLE KEYS */;
INSERT INTO `module_settings` VALUES (1,1,'projects','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(2,1,'messages','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(3,1,'notices','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(4,1,'leads','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(5,1,'invoices','active','client','2022-10-28 07:30:08','2022-10-28 07:30:08'),(6,1,'projects','active','client','2022-10-28 07:30:08','2022-10-28 07:30:08'),(7,1,'clients','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(8,1,'projects','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(9,1,'tickets','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(10,1,'invoices','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(11,1,'estimates','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(12,1,'events','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(13,1,'messages','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(14,1,'tasks','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(15,1,'timelogs','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(16,1,'contracts','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(17,1,'notices','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(18,1,'payments','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(19,1,'orders','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(20,1,'knowledgebase','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(21,1,'employees','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(22,1,'attendance','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(23,1,'expenses','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(24,1,'leaves','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(25,1,'leads','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(26,1,'holidays','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(27,1,'products','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(28,1,'reports','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(29,1,'settings','active','admin','2022-10-28 07:30:08','2022-10-28 07:30:08'),(30,1,'clients','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(31,1,'projects','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(32,1,'tickets','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(33,1,'invoices','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(34,1,'estimates','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(35,1,'events','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(36,1,'messages','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(37,1,'tasks','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(38,1,'timelogs','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(39,1,'contracts','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(40,1,'notices','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(41,1,'payments','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(42,1,'orders','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(43,1,'knowledgebase','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(44,1,'employees','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(45,1,'attendance','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(46,1,'expenses','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(47,1,'leaves','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(48,1,'leads','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(49,1,'holidays','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(50,1,'products','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(51,1,'reports','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(52,1,'settings','active','employee','2022-10-28 07:30:08','2022-10-28 07:30:08'),(53,1,'clients','active','client','2022-10-28 07:30:08','2022-10-28 07:30:08'),(54,1,'projects','active','client','2022-10-28 07:30:08','2022-10-28 07:30:08'),(55,1,'tickets','active','client','2022-10-28 07:30:08','2022-10-28 07:30:08'),(56,1,'invoices','active','client','2022-10-28 07:30:08','2022-10-28 07:30:08'),(57,1,'estimates','active','client','2022-10-28 07:30:08','2022-10-28 07:30:08'),(58,1,'events','active','client','2022-10-28 07:30:08','2022-10-28 07:30:08'),(59,1,'messages','active','client','2022-10-28 07:30:08','2022-10-28 07:30:08'),(60,1,'tasks','active','client','2022-10-28 07:30:08','2022-10-28 07:30:08'),(61,1,'timelogs','active','client','2022-10-28 07:30:08','2022-10-28 07:30:08'),(62,1,'contracts','active','client','2022-10-28 07:30:08','2022-10-28 07:30:08'),(63,1,'notices','active','client','2022-10-28 07:30:08','2022-10-28 07:30:08'),(64,1,'payments','active','client','2022-10-28 07:30:08','2022-10-28 07:30:08'),(65,1,'orders','active','client','2022-10-28 07:30:08','2022-10-28 07:30:08'),(66,1,'knowledgebase','active','client','2022-10-28 07:30:08','2022-10-28 07:30:08'),(67,2,'projects','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(68,2,'messages','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(69,2,'notices','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(70,2,'leads','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(71,2,'invoices','active','client','2022-10-28 07:30:09','2022-10-28 07:30:09'),(72,2,'projects','active','client','2022-10-28 07:30:09','2022-10-28 07:30:09'),(73,2,'clients','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(74,2,'projects','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(75,2,'tickets','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(76,2,'invoices','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(77,2,'estimates','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(78,2,'events','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(79,2,'messages','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(80,2,'tasks','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(81,2,'timelogs','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(82,2,'contracts','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(83,2,'notices','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(84,2,'payments','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(85,2,'orders','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(86,2,'knowledgebase','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(87,2,'employees','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(88,2,'attendance','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(89,2,'expenses','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(90,2,'leaves','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(91,2,'leads','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(92,2,'holidays','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(93,2,'products','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(94,2,'reports','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(95,2,'settings','active','admin','2022-10-28 07:30:09','2022-10-28 07:30:09'),(96,2,'clients','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(97,2,'projects','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(98,2,'tickets','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(99,2,'invoices','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(100,2,'estimates','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(101,2,'events','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(102,2,'messages','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(103,2,'tasks','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(104,2,'timelogs','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(105,2,'contracts','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(106,2,'notices','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(107,2,'payments','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(108,2,'orders','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(109,2,'knowledgebase','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(110,2,'employees','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(111,2,'attendance','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(112,2,'expenses','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(113,2,'leaves','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(114,2,'leads','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(115,2,'holidays','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(116,2,'products','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(117,2,'reports','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(118,2,'settings','active','employee','2022-10-28 07:30:09','2022-10-28 07:30:09'),(119,2,'clients','active','client','2022-10-28 07:30:09','2022-10-28 07:30:09'),(120,2,'projects','active','client','2022-10-28 07:30:09','2022-10-28 07:30:09'),(121,2,'tickets','active','client','2022-10-28 07:30:09','2022-10-28 07:30:09'),(122,2,'invoices','active','client','2022-10-28 07:30:09','2022-10-28 07:30:09'),(123,2,'estimates','active','client','2022-10-28 07:30:09','2022-10-28 07:30:09'),(124,2,'events','active','client','2022-10-28 07:30:09','2022-10-28 07:30:09'),(125,2,'messages','active','client','2022-10-28 07:30:09','2022-10-28 07:30:09'),(126,2,'tasks','active','client','2022-10-28 07:30:09','2022-10-28 07:30:09'),(127,2,'timelogs','active','client','2022-10-28 07:30:09','2022-10-28 07:30:09'),(128,2,'contracts','active','client','2022-10-28 07:30:09','2022-10-28 07:30:09'),(129,2,'notices','active','client','2022-10-28 07:30:09','2022-10-28 07:30:09'),(130,2,'payments','active','client','2022-10-28 07:30:09','2022-10-28 07:30:09'),(131,2,'orders','active','client','2022-10-28 07:30:09','2022-10-28 07:30:09'),(132,2,'knowledgebase','active','client','2022-10-28 07:30:09','2022-10-28 07:30:09'),(133,3,'projects','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(134,3,'messages','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(135,3,'notices','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(136,3,'leads','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(137,3,'invoices','active','client','2022-10-28 07:30:10','2022-10-28 07:30:10'),(138,3,'projects','active','client','2022-10-28 07:30:10','2022-10-28 07:30:10'),(139,3,'clients','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(140,3,'projects','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(141,3,'tickets','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(142,3,'invoices','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(143,3,'estimates','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(144,3,'events','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(145,3,'messages','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(146,3,'tasks','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(147,3,'timelogs','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(148,3,'contracts','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(149,3,'notices','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(150,3,'payments','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(151,3,'orders','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(152,3,'knowledgebase','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(153,3,'employees','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(154,3,'attendance','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(155,3,'expenses','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(156,3,'leaves','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(157,3,'leads','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(158,3,'holidays','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(159,3,'products','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(160,3,'reports','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(161,3,'settings','active','admin','2022-10-28 07:30:10','2022-10-28 07:30:10'),(162,3,'clients','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(163,3,'projects','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(164,3,'tickets','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(165,3,'invoices','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(166,3,'estimates','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(167,3,'events','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(168,3,'messages','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(169,3,'tasks','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(170,3,'timelogs','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(171,3,'contracts','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(172,3,'notices','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(173,3,'payments','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(174,3,'orders','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(175,3,'knowledgebase','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(176,3,'employees','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(177,3,'attendance','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(178,3,'expenses','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(179,3,'leaves','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(180,3,'leads','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(181,3,'holidays','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(182,3,'products','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(183,3,'reports','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(184,3,'settings','active','employee','2022-10-28 07:30:10','2022-10-28 07:30:10'),(185,3,'clients','active','client','2022-10-28 07:30:10','2022-10-28 07:30:10'),(186,3,'projects','active','client','2022-10-28 07:30:10','2022-10-28 07:30:10'),(187,3,'tickets','active','client','2022-10-28 07:30:10','2022-10-28 07:30:10'),(188,3,'invoices','active','client','2022-10-28 07:30:10','2022-10-28 07:30:10'),(189,3,'estimates','active','client','2022-10-28 07:30:10','2022-10-28 07:30:10'),(190,3,'events','active','client','2022-10-28 07:30:10','2022-10-28 07:30:10'),(191,3,'messages','active','client','2022-10-28 07:30:10','2022-10-28 07:30:10'),(192,3,'tasks','active','client','2022-10-28 07:30:10','2022-10-28 07:30:10'),(193,3,'timelogs','active','client','2022-10-28 07:30:10','2022-10-28 07:30:10'),(194,3,'contracts','active','client','2022-10-28 07:30:10','2022-10-28 07:30:10'),(195,3,'notices','active','client','2022-10-28 07:30:10','2022-10-28 07:30:10'),(196,3,'payments','active','client','2022-10-28 07:30:10','2022-10-28 07:30:10'),(197,3,'orders','active','client','2022-10-28 07:30:10','2022-10-28 07:30:10'),(198,3,'knowledgebase','active','client','2022-10-28 07:30:10','2022-10-28 07:30:10'),(199,4,'projects','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(200,4,'messages','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(201,4,'notices','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(202,4,'leads','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(203,4,'invoices','active','client','2022-10-28 07:34:33','2022-10-28 07:34:33'),(204,4,'projects','active','client','2022-10-28 07:34:33','2022-10-28 07:34:33'),(205,4,'clients','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(206,4,'projects','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(207,4,'tickets','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(208,4,'invoices','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(209,4,'estimates','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(210,4,'events','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(211,4,'messages','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(212,4,'tasks','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(213,4,'timelogs','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(214,4,'contracts','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(215,4,'notices','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(216,4,'payments','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(217,4,'orders','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(218,4,'knowledgebase','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(219,4,'employees','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(220,4,'attendance','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(221,4,'expenses','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(222,4,'leaves','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(223,4,'leads','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(224,4,'holidays','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(225,4,'products','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(226,4,'reports','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(227,4,'settings','active','admin','2022-10-28 07:34:33','2022-10-28 07:34:33'),(228,4,'clients','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(229,4,'projects','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(230,4,'tickets','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(231,4,'invoices','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(232,4,'estimates','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(233,4,'events','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(234,4,'messages','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(235,4,'tasks','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(236,4,'timelogs','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(237,4,'contracts','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(238,4,'notices','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(239,4,'payments','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(240,4,'orders','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(241,4,'knowledgebase','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(242,4,'employees','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(243,4,'attendance','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(244,4,'expenses','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(245,4,'leaves','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(246,4,'leads','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(247,4,'holidays','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(248,4,'products','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(249,4,'reports','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(250,4,'settings','active','employee','2022-10-28 07:34:33','2022-10-28 07:34:33'),(251,4,'clients','active','client','2022-10-28 07:34:33','2022-10-28 07:34:33'),(252,4,'projects','active','client','2022-10-28 07:34:33','2022-10-28 07:34:33'),(253,4,'tickets','active','client','2022-10-28 07:34:33','2022-10-28 07:34:33'),(254,4,'invoices','active','client','2022-10-28 07:34:33','2022-10-28 07:34:33'),(255,4,'estimates','active','client','2022-10-28 07:34:33','2022-10-28 07:34:33'),(256,4,'events','active','client','2022-10-28 07:34:33','2022-10-28 07:34:33'),(257,4,'messages','active','client','2022-10-28 07:34:33','2022-10-28 07:34:33'),(258,4,'tasks','active','client','2022-10-28 07:34:33','2022-10-28 07:34:33'),(259,4,'timelogs','active','client','2022-10-28 07:34:33','2022-10-28 07:34:33'),(260,4,'contracts','active','client','2022-10-28 07:34:33','2022-10-28 07:34:33'),(261,4,'notices','active','client','2022-10-28 07:34:33','2022-10-28 07:34:33'),(262,4,'payments','active','client','2022-10-28 07:34:33','2022-10-28 07:34:33'),(263,4,'orders','active','client','2022-10-28 07:34:33','2022-10-28 07:34:33'),(264,4,'knowledgebase','active','client','2022-10-28 07:34:33','2022-10-28 07:34:33');
/*!40000 ALTER TABLE `module_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `modules` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `module_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `modules` WRITE;
/*!40000 ALTER TABLE `modules` DISABLE KEYS */;
INSERT INTO `modules` VALUES (1,'clients',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07'),(2,'employees',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07'),(3,'projects','User can view the basic details of projects assigned to him even without any permission.','2022-10-28 07:30:07','2022-10-28 07:30:07'),(4,'attendance','User can view his own attendance even without any permission.','2022-10-28 07:30:07','2022-10-28 07:30:07'),(5,'tasks','User can view the tasks assigned to him even without any permission.','2022-10-28 07:30:07','2022-10-28 07:30:07'),(6,'estimates',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07'),(7,'invoices',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07'),(8,'payments',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07'),(9,'timelogs',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07'),(10,'tickets','User can view the tickets generated by him as default even without any permission.','2022-10-28 07:30:07','2022-10-28 07:30:07'),(11,'events','User can view the events to be attended by him as default even without any permission.','2022-10-28 07:30:07','2022-10-28 07:30:07'),(12,'notices',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07'),(13,'leaves','User can view the leaves applied by him as default even without any permission.','2022-10-28 07:30:07','2022-10-28 07:30:07'),(14,'leads',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07'),(15,'holidays',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07'),(16,'products',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07'),(17,'expenses','User can view and add(self expenses) the expenses as default even without any permission.','2022-10-28 07:30:07','2022-10-28 07:30:07'),(18,'contracts','User can view all contracts','2022-10-28 07:30:07','2022-10-28 07:30:07'),(19,'reports','User can manage permission of particular report','2022-10-28 07:30:07','2022-10-28 07:30:07'),(20,'settings','User can manage settings','2022-10-28 07:30:07','2022-10-28 07:30:07'),(21,'dashboards',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07'),(22,'orders',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07'),(23,'knowledgebase',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07');
/*!40000 ALTER TABLE `modules` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mollie_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mollie_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned NOT NULL,
  `package_id` bigint unsigned NOT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `package_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_date` date DEFAULT NULL,
  `next_pay_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mollie_invoices_company_id_foreign` (`company_id`),
  KEY `mollie_invoices_package_id_foreign` (`package_id`),
  CONSTRAINT `mollie_invoices_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `mollie_invoices_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mollie_invoices` WRITE;
/*!40000 ALTER TABLE `mollie_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `mollie_invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notice_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notice_views` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `notice_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `read` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notice_views_notice_id_foreign` (`notice_id`),
  KEY `notice_views_user_id_foreign` (`user_id`),
  KEY `notice_views_company_id_foreign` (`company_id`),
  CONSTRAINT `notice_views_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `notice_views_notice_id_foreign` FOREIGN KEY (`notice_id`) REFERENCES `notices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `notice_views_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notice_views` WRITE;
/*!40000 ALTER TABLE `notice_views` DISABLE KEYS */;
/*!40000 ALTER TABLE `notice_views` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notices` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `to` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'employee',
  `heading` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `department_id` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notices_department_id_foreign` (`department_id`),
  KEY `notices_added_by_foreign` (`added_by`),
  KEY `notices_last_updated_by_foreign` (`last_updated_by`),
  KEY `notices_company_id_foreign` (`company_id`),
  CONSTRAINT `notices_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `notices_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `notices_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `teams` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `notices_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notices` WRITE;
/*!40000 ALTER TABLE `notices` DISABLE KEYS */;
INSERT INTO `notices` VALUES (1,1,'employee','Alice, that she ought to be sure, she had got to the Gryphon. \'I.','Hatter added as an explanation. \'Oh, you\'re sure to kill it in asking riddles that have no answers.\' \'If you didn\'t sign it,\' said the King, \'unless it was impossible to say it any longer than that,\' said the Cat, \'or you wouldn\'t keep appearing and vanishing so suddenly: you make one quite giddy.\' \'All right,\' said the Dormouse turned out, and, by the way, and nothing seems to like her, down here, and I\'m I, and--oh dear, how puzzling it all came different!\' the Mock Turtle went on \'And how did you manage to do with you. Mind now!\' The poor little thing howled so, that Alice quite jumped; but she could see it trying in a sort of circle, (\'the exact shape doesn\'t matter,\' it said,) and then the other, saying, in a rather offended tone, \'so I can\'t be civil, you\'d better leave off,\' said the Mock Turtle replied in an offended tone, \'was, that the poor animal\'s feelings. \'I quite forgot how to get through was more and more sounds of broken glass, from which she had a head unless there.',NULL,NULL,NULL,'2022-10-07 09:06:19','2022-10-28 07:30:12'),(2,1,'employee','ARE you talking to?\' said one of them were animals, and some.','NOT be an old woman--but then--always to have him with them,\' the Mock Turtle to sing you a present of everything I\'ve said as yet.\' \'A cheap sort of idea that they could not swim. He sent them word I had our Dinah here, I know THAT well enough; don\'t be particular--Here, Bill! catch hold of this sort of way to change the subject,\' the March Hare interrupted, yawning. \'I\'m getting tired of sitting by her sister was reading, but it puzzled her a good character, But said I didn\'t!\' interrupted Alice. \'You must be,\' said the Lory hastily. \'I don\'t see,\' said the Duchess; \'I never was so much contradicted in her brother\'s Latin Grammar, \'A mouse--of a mouse--to a mouse--a mouse--O mouse!\') The Mouse did not like the look of the Rabbit\'s voice; and the March Hare: she thought of herself, \'I don\'t quite understand you,\' she said, without even waiting to put his mouth close to her: its face was quite a long argument with the words all coming different, and then I\'ll tell him--it was for.',NULL,NULL,NULL,'2022-10-26 21:27:41','2022-10-28 07:30:12'),(3,1,'employee','Alice, seriously, \'I\'ll have nothing more happened, she decided to.','Majesty,\' said Two, in a minute. Alice began in a sulky tone, as it left no mark on the slate. \'Herald, read the accusation!\' said the March Hare, \'that \"I like what I say,\' the Mock Turtle is.\' \'It\'s the thing at all. \'But perhaps he can\'t help that,\' said the Knave, \'I didn\'t mean it!\' pleaded poor Alice began to repeat it, but her head made her next remark. \'Then the words a little, \'From the Queen. \'You make me larger, it must be getting somewhere near the door, she walked off, leaving Alice alone with the bones and the Queen said--\' \'Get to your places!\' shouted the Queen. \'I haven\'t the slightest idea,\' said the Cat again, sitting on the English coast you find a number of bathing machines in the wood,\' continued the King. \'Nothing whatever,\' said Alice. \'What IS the fun?\' said Alice. \'Call it what you like,\' said the Mock Turtle, and to stand on their throne when they arrived, with a sigh: \'he taught Laughing and Grief, they used to do:-- \'How doth the little golden key and.',NULL,NULL,NULL,'2022-10-29 18:30:00','2022-10-28 07:30:12'),(4,1,'employee','Gryphon; and then treading on her face brightened up at the end.\'.','Dodo, a Lory and an old Crab took the regular course.\' \'What was THAT like?\' said Alice. \'Anything you like,\' said the youth, \'and your jaws are too weak For anything tougher than suet; Yet you balanced an eel on the floor, and a fall, and a Long Tale They were just beginning to see the Queen. \'Can you play croquet?\' The soldiers were always getting up and down in a very little use, as it lasted.) \'Then the eleventh day must have been ill.\' \'So they were,\' said the Duchess, as she swam lazily about in a very short time the Mouse had changed his mind, and was going to begin with.\' \'A barrowful will do, to begin with.\' \'A barrowful of WHAT?\' thought Alice; \'I might as well go in ringlets at all; and I\'m sure she\'s the best cat in the common way. So she stood still where she was in the flurry of the players to be seen--everything seemed to be sure, she had this fit) An obstacle that came between Him, and ourselves, and it. Don\'t let him know she liked them best, For this must be really.',NULL,NULL,NULL,'2022-10-31 18:30:00','2022-10-28 07:30:12'),(5,1,'employee','Hatter. He came in sight of the garden: the roses growing on it.','Alice noticed, had powdered hair that WOULD always get into the loveliest garden you ever saw. How she longed to get in?\' she repeated, aloud. \'I must go by the way, and the sound of many footsteps, and Alice thought this a very interesting dance to watch,\' said Alice, feeling very glad that it felt quite unhappy at the cook had disappeared. \'Never mind!\' said the Dormouse; \'--well in.\' This answer so confused poor Alice, \'to speak to this mouse? Everything is so out-of-the-way down here, that I should frighten them out of its mouth open, gazing up into the roof off.\' After a minute or two, looking for them, but they began running when they saw her, they hurried back to the voice of the Shark, But, when the White Rabbit put on his spectacles. \'Where shall I begin, please your Majesty,\' the Hatter went on, turning to Alice. \'Nothing,\' said Alice. \'Anything you like,\' said the Queen. \'Their heads are gone, if it makes rather a hard word, I will tell you my adventures--beginning from.',NULL,NULL,NULL,'2022-06-26 09:53:58','2022-10-28 07:30:12'),(6,2,'employee','Alice; \'it\'s laid for a minute or two to think this a very poor.','Queen to-day?\' \'I should have croqueted the Queen\'s absence, and were quite dry again, the cook and the second time round, she found that it had been. But her sister was reading, but it had lost something; and she said this, she looked down at them, and considered a little shriek, and went back for a minute, trying to explain it is all the time they were all locked; and when she looked at Two. Two began in a sorrowful tone, \'I\'m afraid I can\'t put it into his plate. Alice did not at all anxious to have any pepper in that soup!\' Alice said very humbly; \'I won\'t indeed!\' said the Cat, \'if you only walk long enough.\' Alice felt that she had plenty of time as she was out of a muchness\"--did you ever see such a long silence after this, and she was coming back to the Duchess: \'and the moral of that is--\"The more there is of mine, the less there is of yours.\"\' \'Oh, I BEG your pardon!\' she exclaimed in a sorrowful tone, \'I\'m afraid I\'ve offended it again!\' For the Mouse had changed his mind.',NULL,NULL,NULL,'2022-10-18 11:52:15','2022-10-28 07:30:16'),(7,2,'employee','Soup! Soup of the guinea-pigs cheered, and was going to be, from one.','Alice, as she could, \'If you can\'t take more.\' \'You mean you can\'t be Mabel, for I know all the way to hear it say, as it is.\' \'I quite agree with you,\' said the Mock Turtle sighed deeply, and drew the back of one flapper across his eyes. He looked at her as she had put the Lizard as she could do to hold it. As soon as she could, \'If you knew Time as well say,\' added the Queen. \'Well, I can\'t quite follow it as she passed; it was too much frightened to say than his first speech. \'You should learn not to make personal remarks,\' Alice said to the conclusion that it signifies much,\' she said aloud. \'I shall do nothing of tumbling down stairs! How brave they\'ll all think me at home! Why, I haven\'t been invited yet.\' \'You\'ll see me there,\' said the sage, as he wore his crown over the edge with each hand. \'And now which is which?\' she said to one of the court and got behind Alice as he spoke, and the shrill voice of the house opened, and a fall, and a fan! Quick, now!\' And Alice was.',NULL,NULL,NULL,'2022-04-11 23:01:30','2022-10-28 07:30:16'),(8,2,'employee','Alice had never had fits, my dear, YOU must cross-examine THIS.','She waited for some time in silence: at last the Dodo replied very readily: \'but that\'s because it stays the same solemn tone, only changing the order of the hall: in fact she was not otherwise than what it was just possible it had a vague sort of life! I do hope it\'ll make me grow larger, I can creep under the table: she opened it, and behind it, it occurred to her that she began thinking over all the same, the next verse,\' the Gryphon went on. \'I do,\' Alice said nothing; she had found her head was so long since she had been all the other arm curled round her at the other players, and shouting \'Off with her friend. When she got up this morning, but I THINK I can remember feeling a little startled when she had forgotten the Duchess was sitting on a little way forwards each time and a scroll of parchment in the middle. Alice kept her eyes to see if he thought it would all wash off in the court!\' and the executioner went off like an honest man.\' There was a large pool all round the.',NULL,NULL,NULL,'2022-10-03 20:09:09','2022-10-28 07:30:16'),(9,2,'employee','WAS a narrow escape!\' said Alice, timidly; \'some of the court. \'What.','Rabbit was still in existence; \'and now for the garden!\' and she felt that this could not be denied, so she waited. The Gryphon lifted up both its paws in surprise. \'What! Never heard of such a capital one for catching mice you can\'t take LESS,\' said the Duchess: \'flamingoes and mustard both bite. And the Gryphon repeated impatiently: \'it begins \"I passed by his garden.\"\' Alice did not like to be said. At last the Dodo managed it.) First it marked out a new idea to Alice, very much pleased at having found out that part.\' \'Well, at any rate he might answer questions.--How am I to get very tired of being upset, and their curls got entangled together. Alice was silent. The King laid his hand upon her knee, and the shrill voice of the mushroom, and raised herself to some tea and bread-and-butter, and then treading on my tail. See how eagerly the lobsters to the whiting,\' said the Hatter, \'I cut some more bread-and-butter--\' \'But what happens when one eats cake, but Alice had learnt.',NULL,NULL,NULL,'2022-10-28 18:30:00','2022-10-28 07:30:16'),(10,2,'employee','What happened to me! I\'LL soon make you a song?\' \'Oh, a song.','Presently she began thinking over all the children she knew she had never before seen a cat without a porpoise.\' \'Wouldn\'t it really?\' said Alice to find that the Mouse in the middle. Alice kept her waiting!\' Alice felt dreadfully puzzled. The Hatter\'s remark seemed to be sure, she had looked under it, and kept doubling itself up and down in a deep, hollow tone: \'sit down, both of you, and don\'t speak a word till I\'ve finished.\' So they had to ask any more HERE.\' \'But then,\' thought Alice, and, after waiting till she had to ask the question?\' said the Caterpillar. \'Not QUITE right, I\'m afraid,\' said Alice, (she had kept a piece of evidence we\'ve heard yet,\' said the Duchess, who seemed to be otherwise.\"\' \'I think you might do very well as she went on, \'that they\'d let Dinah stop in the pool rippling to the tarts on the hearth and grinning from ear to ear. \'Please would you like the tone of this ointment--one shilling the box-- Allow me to introduce it.\' \'I don\'t know what a dear.',NULL,NULL,NULL,'2022-11-01 18:30:00','2022-10-28 07:30:16'),(11,3,'employee','Alice. \'I\'m glad they\'ve begun asking riddles.--I believe I can.','She said the King replied. Here the Dormouse shook its head impatiently, and walked two and two, as the question was evidently meant for her. \'I wish the creatures wouldn\'t be in a thick wood. \'The first thing I\'ve got to do,\' said Alice desperately: \'he\'s perfectly idiotic!\' And she went on, looking anxiously about her. \'Oh, do let me hear the Rabbit asked. \'No, I give it up,\' Alice replied: \'what\'s the answer?\' \'I haven\'t the least notice of them say, \'Look out now, Five! Don\'t go splashing paint over me like a writing-desk?\' \'Come, we shall get on better.\' \'I\'d rather not,\' the Cat again, sitting on a three-legged stool in the way out of THIS!\' (Sounds of more energetic remedies--\' \'Speak English!\' said the Hatter. \'He won\'t stand beating. Now, if you like!\' the Duchess said after a few minutes to see how he can thoroughly enjoy The pepper when he sneezes; For he can thoroughly enjoy The pepper when he pleases!\' CHORUS. \'Wow! wow! wow!\' While the Owl and the procession moved on.',NULL,NULL,NULL,'2022-06-15 01:22:10','2022-10-28 07:30:19'),(12,3,'employee','Dodo suddenly called out in a low, weak voice. \'Now, I give it up,\'.','Gryphon is, look at all know whether it would all wash off in the lock, and to hear his history. I must have prizes.\' \'But who has won?\' This question the Dodo had paused as if it makes rather a hard word, I will prosecute YOU.--Come, I\'ll take no denial; We must have a trial: For really this morning I\'ve nothing to do: once or twice she had never heard before, \'Sure then I\'m here! Digging for apples, yer honour!\' \'Digging for apples, indeed!\' said Alice, \'but I must sugar my hair.\" As a duck with its wings. \'Serpent!\' screamed the Queen. \'Can you play croquet?\' The soldiers were silent, and looked anxiously round, to make out that she was saying, and the beak-- Pray how did you manage to do with you. Mind now!\' The poor little Lizard, Bill, was in the morning, just time to see that the cause of this remark, and thought to herself, \'if one only knew how to set them free, Exactly as we needn\'t try to find that she tipped over the list, feeling very glad to do anything but sit with its.',NULL,NULL,NULL,'2022-05-02 16:46:53','2022-10-28 07:30:19'),(13,3,'employee','Cat, and vanished. Alice was soon left alone. \'I wish the creatures.','But she did not look at a king,\' said Alice. \'What sort of present!\' thought Alice. One of the what?\' said the cook. \'Treacle,\' said the King sharply. \'Do you know that cats COULD grin.\' \'They all can,\' said the Gryphon. \'It\'s all about as it was getting very sleepy; \'and they all crowded round it, panting, and asking, \'But who has won?\' This question the Dodo solemnly, rising to its feet, ran round the neck of the other two were using it as well as she left her, leaning her head struck against the roof bear?--Mind that loose slate--Oh, it\'s coming down! Heads below!\' (a loud crash)--\'Now, who did that?--It was Bill, the Lizard) could not help thinking there MUST be more to come, so she went on in a great hurry, muttering to itself \'The Duchess! The Duchess! Oh my fur and whiskers! She\'ll get me executed, as sure as ferrets are ferrets! Where CAN I have done that?\' she thought. \'But everything\'s curious today. I think you\'d better leave off,\' said the Footman, \'and that for the pool.',NULL,NULL,NULL,'2022-11-03 18:30:00','2022-10-28 07:30:19'),(14,3,'employee','Majesty!\' the Duchess sneezed occasionally; and as he spoke.','King said to the Mock Turtle, \'Drive on, old fellow! Don\'t be all day about it!\' Last came a little of her head impatiently; and, turning to Alice as she could, for the immediate adoption of more broken glass.) \'Now tell me, please, which way it was over at last: \'and I do so like that curious song about the games now.\' CHAPTER X. The Lobster Quadrille is!\' \'No, indeed,\' said Alice. \'I\'ve read that in the other. \'I beg your pardon!\' cried Alice in a hurried nervous manner, smiling at everything that Alice could only see her. She is such a nice soft thing to get her head through the doorway; \'and even if my head would go round a deal faster than it does.\' \'Which would NOT be an advantage,\' said Alice, (she had grown up,\' she said to herself. At this the whole place around her became alive with the strange creatures of her voice. Nobody moved. \'Who cares for fish, Game, or any other dish? Who would not give all else for two Pennyworth only of beautiful Soup? Beau--ootiful Soo--oop!.',NULL,NULL,NULL,'2022-02-07 22:35:24','2022-10-28 07:30:19'),(15,3,'employee','On which Seven looked up and repeat \"\'TIS THE VOICE OF THE.','Alice, (she had grown in the beautiful garden, among the party. Some of the Mock Turtle angrily: \'really you are very dull!\' \'You ought to have him with them,\' the Mock Turtle; \'but it seems to be managed? I suppose I ought to be lost, as she couldn\'t answer either question, it didn\'t sound at all fairly,\' Alice began, in rather a handsome pig, I think.\' And she went on. \'I do,\' Alice said to Alice. \'Only a thimble,\' said Alice in a melancholy tone. \'Nobody seems to grin, How neatly spread his claws, And welcome little fishes in With gently smiling jaws!\' \'I\'m sure I\'m not Ada,\' she said, \'and see whether it\'s marked \"poison\" or not\'; for she had never heard of such a very little use without my shoulders. Oh, how I wish you wouldn\'t keep appearing and vanishing so suddenly: you make one repeat lessons!\' thought Alice; \'I might as well say,\' added the Gryphon; and then dipped suddenly down, so suddenly that Alice could hear the very middle of the moment she quite forgot you didn\'t.',NULL,NULL,NULL,'2022-10-27 00:20:29','2022-10-28 07:30:19');
/*!40000 ALTER TABLE `notices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notifications` (
  `id` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint unsigned NOT NULL,
  `data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
INSERT INTO `notifications` VALUES ('3b8a04f6-34bf-408c-870d-3494cb2351f7','App\\Notifications\\NewUser','App\\Models\\User',41,'{\"id\":41,\"company_id\":4,\"user_auth_id\":41,\"name\":\"Kaden Hood\",\"email\":\"bigagexy@mailinator.com\",\"image\":null,\"mobile\":null,\"gender\":null,\"salutation\":null,\"locale\":\"en\",\"status\":\"active\",\"login\":\"enable\",\"onesignal_player_id\":null,\"last_login\":null,\"email_notifications\":1,\"country_id\":null,\"dark_theme\":0,\"rtl\":0,\"admin_approval\":1,\"permission_sync\":1,\"google_calendar_status\":1,\"customised_permissions\":0,\"image_url\":\"https:\\/\\/www.gravatar.com\\/avatar\\/92cc048be0421e6b2c38adb467a33a1e.png?s=200&d=mp\",\"modules\":null,\"user_other_role\":true,\"role\":[{\"user_id\":41,\"role_id\":14},{\"user_id\":41,\"role_id\":15}],\"client_details\":null,\"session\":null,\"employee_detail\":{\"id\":22,\"company_id\":4,\"user_id\":41,\"employee_id\":\"EMP-41\",\"address\":null,\"hourly_rate\":null,\"slack_username\":null,\"department_id\":null,\"designation_id\":null,\"joining_date\":\"2022-10-28T18:34:33+00:00\",\"last_date\":null,\"added_by\":1,\"last_updated_by\":1,\"attendance_reminder\":null,\"date_of_birth\":null,\"calendar_view\":null,\"about_me\":null,\"reporting_to\":null,\"upcoming_birthday\":null,\"designation\":null,\"company\":{\"id\":4,\"company_name\":\"Jenkins Horn Trading\",\"app_name\":\"Jenkins Horn Trading\",\"company_email\":\"bymusihe@mailinator.com\",\"company_phone\":null,\"logo\":null,\"login_background\":null,\"address\":\"sdad\",\"website\":null,\"currency_id\":13,\"package_id\":1,\"package_type\":\"monthly\",\"timezone\":\"Africa\\/Abidjan\",\"date_format\":\"d-m-Y\",\"date_picker_format\":\"dd-mm-yyyy\",\"year_starts_from\":\"1\",\"moment_format\":\"DD-MM-YYYY\",\"time_format\":\"h:i a\",\"locale\":\"en\",\"latitude\":\"26.91243360\",\"longitude\":\"75.78727090\",\"leaves_start_from\":\"joining_date\",\"active_theme\":\"default\",\"status\":\"active\",\"last_updated_by\":1,\"google_map_key\":null,\"task_self\":\"yes\",\"rounded_theme\":1,\"logo_background_color\":\"#ffffff\",\"before_days\":0,\"after_days\":0,\"on_deadline\":\"yes\",\"default_task_status\":13,\"dashboard_clock\":1,\"ticket_form_google_captcha\":0,\"lead_form_google_captcha\":0,\"taskboard_length\":10,\"auth_theme\":\"light\",\"light_logo\":null,\"sidebar_logo_style\":\"square\",\"allow_client_signup\":0,\"admin_client_signup_approval\":0,\"google_calendar_status\":\"inactive\",\"google_client_id\":null,\"google_client_secret\":null,\"google_calendar_verification_status\":\"non_verified\",\"google_id\":null,\"name\":null,\"token\":null,\"hash\":\"WHoYMuFfEMj9FBgYRzMxPbLfZw1JyKWb\",\"last_login\":null,\"rtl\":0,\"stripe_id\":null,\"card_brand\":null,\"card_last_four\":null,\"trial_ends_at\":null,\"licence_expire_on\":null,\"logo_url\":\"https:\\/\\/worksuite-new.test\\/img\\/worksuite-logo.png\",\"login_background_url\":null,\"moment_date_format\":\"DD-MM-YYYY\",\"favicon_url\":\"https:\\/\\/worksuite-new.test\\/favicon.png\"}}}',NULL,'2022-10-31 03:48:59','2022-10-31 03:48:59'),('d85b4106-3573-4fc1-89ef-302862d80577','App\\Notifications\\ShiftScheduled','App\\Models\\User',2,'{\"user_id\":2,\"shift_id\":1,\"date\":\"2022-11-01T00:00:00.000000Z\"}',NULL,'2022-10-31 03:49:08','2022-10-31 03:49:08');
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `offline_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `offline_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned NOT NULL,
  `package_id` bigint unsigned NOT NULL,
  `package_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `offline_method_id` int unsigned DEFAULT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(12,2) unsigned NOT NULL,
  `pay_date` date NOT NULL,
  `next_pay_date` date DEFAULT NULL,
  `status` enum('paid','unpaid','pending') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `offline_invoices_company_id_foreign` (`company_id`),
  KEY `offline_invoices_package_id_foreign` (`package_id`),
  KEY `offline_invoices_offline_method_id_foreign` (`offline_method_id`),
  CONSTRAINT `offline_invoices_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `offline_invoices_offline_method_id_foreign` FOREIGN KEY (`offline_method_id`) REFERENCES `offline_payment_methods` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `offline_invoices_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `offline_invoices` WRITE;
/*!40000 ALTER TABLE `offline_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `offline_invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `offline_payment_methods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `offline_payment_methods` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'yes',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `offline_payment_methods_company_id_foreign` (`company_id`),
  CONSTRAINT `offline_payment_methods_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `offline_payment_methods` WRITE;
/*!40000 ALTER TABLE `offline_payment_methods` DISABLE KEYS */;
/*!40000 ALTER TABLE `offline_payment_methods` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `offline_plan_changes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `offline_plan_changes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned NOT NULL,
  `package_id` bigint unsigned NOT NULL,
  `package_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_id` bigint unsigned NOT NULL,
  `offline_method_id` int unsigned NOT NULL,
  `file_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('verified','pending','rejected') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `offline_plan_changes_company_id_foreign` (`company_id`),
  KEY `offline_plan_changes_package_id_foreign` (`package_id`),
  KEY `offline_plan_changes_invoice_id_foreign` (`invoice_id`),
  KEY `offline_plan_changes_offline_method_id_foreign` (`offline_method_id`),
  CONSTRAINT `offline_plan_changes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `offline_plan_changes_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `offline_invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `offline_plan_changes_offline_method_id_foreign` FOREIGN KEY (`offline_method_id`) REFERENCES `offline_payment_methods` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `offline_plan_changes_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `offline_plan_changes` WRITE;
/*!40000 ALTER TABLE `offline_plan_changes` DISABLE KEYS */;
/*!40000 ALTER TABLE `offline_plan_changes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `order_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_item_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_item_images_order_item_id_index` (`order_item_id`),
  CONSTRAINT `order_item_images_order_item_id_foreign` FOREIGN KEY (`order_item_id`) REFERENCES `order_items` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `order_item_images` WRITE;
/*!40000 ALTER TABLE `order_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `order_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `product_id` int unsigned DEFAULT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_summary` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` enum('item','discount','tax') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `quantity` double(16,2) NOT NULL,
  `unit_price` int NOT NULL,
  `amount` double(8,2) NOT NULL,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `taxes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_items_order_id_foreign` (`order_id`),
  KEY `order_items_product_id_foreign` (`product_id`),
  CONSTRAINT `order_items_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `order_items_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `order_items` WRITE;
/*!40000 ALTER TABLE `order_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned DEFAULT NULL,
  `order_date` date NOT NULL,
  `sub_total` double(8,2) NOT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `discount_type` enum('percent','fixed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'percent',
  `total` double(8,2) NOT NULL,
  `status` enum('pending','on-hold','failed','processing','completed','canceled','refunded') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `currency_id` int unsigned DEFAULT NULL,
  `show_shipping_address` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `note` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `company_address_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `orders_client_id_foreign` (`client_id`),
  KEY `orders_currency_id_foreign` (`currency_id`),
  KEY `orders_added_by_foreign` (`added_by`),
  KEY `orders_last_updated_by_foreign` (`last_updated_by`),
  KEY `orders_company_address_id_foreign` (`company_address_id`),
  KEY `orders_company_id_foreign` (`company_id`),
  CONSTRAINT `orders_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `orders_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `orders_company_address_id_foreign` FOREIGN KEY (`company_address_id`) REFERENCES `company_addresses` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `orders_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `orders_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `orders_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `package_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `package_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `no_of_days` int DEFAULT '30',
  `modules` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trial_message` text COLLATE utf8mb4_unicode_ci,
  `notification_before` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `package_settings` WRITE;
/*!40000 ALTER TABLE `package_settings` DISABLE KEYS */;
INSERT INTO `package_settings` VALUES (1,'inactive',30,'{\"1\":\"clients\",\"2\":\"employees\",\"3\":\"projects\",\"4\":\"attendance\",\"5\":\"tasks\",\"6\":\"estimates\",\"7\":\"invoices\",\"8\":\"payments\",\"9\":\"timelogs\",\"10\":\"tickets\",\"11\":\"events\",\"13\":\"notices\",\"13\":\"leaves\",\"15\":\"leads\",\"16\":\"holidays\",\"17\":\"products\",\"18\":\"expenses\",\"19\":\"contracts\",\"20\":\"reports\"}','Start 30 days free trial',NULL,'2022-10-28 07:30:07','2022-10-28 07:30:07');
/*!40000 ALTER TABLE `package_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency_id` bigint unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `max_storage_size` int NOT NULL,
  `max_file_size` int unsigned NOT NULL DEFAULT '0',
  `annual_price` decimal(8,2) NOT NULL DEFAULT '0.00',
  `monthly_price` decimal(8,2) NOT NULL DEFAULT '0.00',
  `billing_cycle` tinyint unsigned NOT NULL DEFAULT '0',
  `max_employees` int unsigned NOT NULL DEFAULT '0',
  `sort` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_in_package` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stripe_annual_plan_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_monthly_plan_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razorpay_annual_plan_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razorpay_monthly_plan_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `paystack_monthly_plan_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paystack_annual_plan_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL,
  `storage_unit` enum('gb','mb') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'mb',
  `is_recommended` tinyint(1) NOT NULL DEFAULT '0',
  `is_free` tinyint(1) NOT NULL DEFAULT '0',
  `is_auto_renew` tinyint(1) NOT NULL DEFAULT '0',
  `monthly_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '1',
  `annual_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `packages_currency_id_foreign` (`currency_id`),
  CONSTRAINT `packages_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `global_currencies` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `packages` WRITE;
/*!40000 ALTER TABLE `packages` DISABLE KEYS */;
INSERT INTO `packages` VALUES (1,NULL,'Default','Its a default package and cannot be deleted',0,0,0.00,0.00,0,20,'','{\"1\":\"clients\",\"2\":\"employees\",\"3\":\"projects\",\"4\":\"attendance\",\"5\":\"tasks\",\"6\":\"estimates\",\"7\":\"invoices\",\"8\":\"payments\",\"9\":\"timelogs\",\"10\":\"tickets\",\"11\":\"events\",\"12\":\"notices\",\"13\":\"leaves\",\"14\":\"leads\",\"15\":\"holidays\",\"16\":\"products\",\"17\":\"expenses\",\"18\":\"contracts\",\"19\":\"reports\",\"20\":\"settings\",\"21\":\"dashboards\",\"22\":\"orders\",\"23\":\"knowledgebase\"}','default_plan','default_plan',NULL,NULL,'yes',NULL,NULL,0,'mb',0,0,0,'1','1','2022-10-28 07:30:07','2022-10-28 07:30:07'),(2,NULL,'Trial','Its a trial package',0,0,0.00,0.00,0,20,'','{\"1\":\"clients\",\"2\":\"employees\",\"3\":\"projects\",\"4\":\"attendance\",\"5\":\"tasks\",\"6\":\"estimates\",\"7\":\"invoices\",\"8\":\"payments\",\"9\":\"timelogs\",\"10\":\"tickets\",\"11\":\"events\",\"13\":\"notices\",\"13\":\"leaves\",\"15\":\"leads\",\"16\":\"holidays\",\"17\":\"products\",\"18\":\"expenses\",\"19\":\"contracts\",\"20\":\"reports\"}','trial_plan','trial_plan',NULL,NULL,'',NULL,NULL,0,'mb',0,0,0,'1','1','2022-10-28 07:30:07','2022-10-28 07:30:07');
/*!40000 ALTER TABLE `packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`),
  KEY `password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payfast_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payfast_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `package_id` bigint unsigned DEFAULT NULL,
  `m_payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pf_payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payfast_plan` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_date` date DEFAULT NULL,
  `next_pay_date` date DEFAULT NULL,
  `signature` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payfast_invoices_company_id_foreign` (`company_id`),
  KEY `payfast_invoices_package_id_foreign` (`package_id`),
  CONSTRAINT `payfast_invoices_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `payfast_invoices_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payfast_invoices` WRITE;
/*!40000 ALTER TABLE `payfast_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `payfast_invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payment_gateway_credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_gateway_credentials` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `paypal_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `live_stripe_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_stripe_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_stripe_webhook_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `live_razorpay_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_razorpay_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razorpay_status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `paypal_mode` enum('sandbox','live') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sandbox',
  `sandbox_paypal_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sandbox_paypal_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_stripe_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_stripe_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_razorpay_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_razorpay_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_stripe_webhook_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_mode` enum('test','live') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'test',
  `razorpay_mode` enum('test','live') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'test',
  `paystack_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paystack_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paystack_merchant_email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paystack_status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'deactive',
  `paystack_mode` enum('sandbox','live') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sandbox',
  `test_paystack_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_paystack_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_paystack_merchant_email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paystack_payment_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'https://api.paystack.co',
  `mollie_api_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mollie_status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'deactive',
  `payfast_merchant_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payfast_merchant_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payfast_passphrase` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payfast_mode` enum('sandbox','live') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sandbox',
  `payfast_status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'deactive',
  `authorize_api_login_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authorize_transaction_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authorize_environment` enum('sandbox','live') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sandbox',
  `authorize_status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `square_application_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `square_access_token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `square_location_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `square_environment` enum('sandbox','production') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sandbox',
  `square_status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `flutterwave_status` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `flutterwave_mode` enum('sandbox','live') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sandbox',
  `test_flutterwave_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_flutterwave_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_flutterwave_hash` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_flutterwave_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_flutterwave_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_flutterwave_hash` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flutterwave_webhook_secret_hash` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_gateway_credentials_company_id_foreign` (`company_id`),
  CONSTRAINT `payment_gateway_credentials_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payment_gateway_credentials` WRITE;
/*!40000 ALTER TABLE `payment_gateway_credentials` DISABLE KEYS */;
INSERT INTO `payment_gateway_credentials` VALUES (1,1,NULL,NULL,'deactive',NULL,NULL,NULL,'deactive','2022-10-28 07:30:08','2022-10-28 07:30:08',NULL,NULL,'inactive','sandbox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'test','test',NULL,NULL,NULL,'deactive','sandbox',NULL,NULL,NULL,'https://api.paystack.co',NULL,'deactive',NULL,NULL,NULL,'sandbox','deactive',NULL,NULL,'sandbox','deactive',NULL,NULL,NULL,'sandbox','deactive','deactive','sandbox',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,2,NULL,NULL,'deactive',NULL,NULL,NULL,'deactive','2022-10-28 07:30:09','2022-10-28 07:30:09',NULL,NULL,'inactive','sandbox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'test','test',NULL,NULL,NULL,'deactive','sandbox',NULL,NULL,NULL,'https://api.paystack.co',NULL,'deactive',NULL,NULL,NULL,'sandbox','deactive',NULL,NULL,'sandbox','deactive',NULL,NULL,NULL,'sandbox','deactive','deactive','sandbox',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,3,NULL,NULL,'deactive',NULL,NULL,NULL,'deactive','2022-10-28 07:30:10','2022-10-28 07:30:10',NULL,NULL,'inactive','sandbox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'test','test',NULL,NULL,NULL,'deactive','sandbox',NULL,NULL,NULL,'https://api.paystack.co',NULL,'deactive',NULL,NULL,NULL,'sandbox','deactive',NULL,NULL,'sandbox','deactive',NULL,NULL,NULL,'sandbox','deactive','deactive','sandbox',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,4,NULL,NULL,'deactive',NULL,NULL,NULL,'deactive','2022-10-28 07:34:33','2022-10-28 07:34:33',NULL,NULL,'inactive','sandbox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'test','test',NULL,NULL,NULL,'deactive','sandbox',NULL,NULL,NULL,'https://api.paystack.co',NULL,'deactive',NULL,NULL,NULL,'sandbox','deactive',NULL,NULL,'sandbox','deactive',NULL,NULL,NULL,'sandbox','deactive','deactive','sandbox',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `payment_gateway_credentials` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `invoice_id` int unsigned DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `credit_notes_id` int unsigned DEFAULT NULL,
  `amount` double NOT NULL,
  `gateway` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `plan_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('complete','pending','failed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_on` datetime DEFAULT NULL,
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `offline_method_id` int unsigned DEFAULT NULL,
  `bill` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `payment_gateway_response` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'null = success',
  `payload_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `payments_plan_id_unique` (`plan_id`),
  UNIQUE KEY `payments_event_id_company_id_unique` (`event_id`,`company_id`),
  UNIQUE KEY `payments_transaction_id_company_id_unique` (`transaction_id`,`company_id`),
  KEY `payments_project_id_foreign` (`project_id`),
  KEY `payments_invoice_id_foreign` (`invoice_id`),
  KEY `payments_order_id_foreign` (`order_id`),
  KEY `payments_credit_notes_id_foreign` (`credit_notes_id`),
  KEY `payments_currency_id_foreign` (`currency_id`),
  KEY `payments_paid_on_index` (`paid_on`),
  KEY `payments_offline_method_id_foreign` (`offline_method_id`),
  KEY `payments_added_by_foreign` (`added_by`),
  KEY `payments_last_updated_by_foreign` (`last_updated_by`),
  KEY `payments_company_id_foreign` (`company_id`),
  CONSTRAINT `payments_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `payments_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `payments_credit_notes_id_foreign` FOREIGN KEY (`credit_notes_id`) REFERENCES `credit_notes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `payments_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `payments_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `payments_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `payments_offline_method_id_foreign` FOREIGN KEY (`offline_method_id`) REFERENCES `offline_payment_methods` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `payments_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `payments_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,1,1,3,NULL,NULL,25058,'Bank Transfer','eccbc87e4b5ce2fe28308fd9f2a7baf3',1,NULL,NULL,NULL,'complete','2022-10-12 09:15:06',NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,NULL,NULL,NULL,NULL,NULL),(2,1,1,4,NULL,NULL,46378,'Bank Transfer','a87ff679a2f3e71d9181a67b7542122c',1,NULL,NULL,NULL,'complete','2022-10-09 14:25:59',NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,NULL,NULL,NULL,NULL,NULL),(3,1,1,5,NULL,NULL,33067,'Bank Transfer','e4da3b7fbbce2345d7772b0674a318d5',1,NULL,NULL,NULL,'complete','2022-10-04 17:58:20',NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,NULL,NULL,NULL,NULL,NULL),(4,1,2,9,NULL,NULL,29990,'Bank Transfer','45c48cce2e2d7fbdea1afc51c7c6ad26',1,NULL,NULL,NULL,'complete','2022-10-15 11:24:26',NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,NULL,NULL,NULL,NULL,NULL),(5,1,2,10,NULL,NULL,47708,'Bank Transfer','d3d9446802a44259755d38e6d163e820',1,NULL,NULL,NULL,'complete','2022-10-21 11:22:04',NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,NULL,NULL,NULL,NULL,NULL),(6,1,3,11,NULL,NULL,41740,'Bank Transfer','6512bd43d9caa6e02c990b0a82652dca',1,NULL,NULL,NULL,'complete','2022-10-17 05:17:11',NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,NULL,NULL,NULL,NULL,NULL),(7,1,3,13,NULL,NULL,15869,'Bank Transfer','c51ce410c124a10e0db5e4b97fc2af39',1,NULL,NULL,NULL,'complete','2022-10-26 17:31:49',NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,NULL,NULL,NULL,NULL,NULL),(8,1,3,14,NULL,NULL,44554,'Bank Transfer','aab3238922bcc25a6f606eb525ffdc56',1,NULL,NULL,NULL,'complete','2022-10-16 23:18:18',NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,NULL,NULL,NULL,NULL,NULL),(9,1,3,15,NULL,NULL,31011,'Bank Transfer','9bf31c7ff062936a96d3c8bd1f8f2ff3',1,NULL,NULL,NULL,'complete','2022-10-19 09:28:27',NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,NULL,NULL,NULL,NULL,NULL),(10,1,4,16,NULL,NULL,41892,'Bank Transfer','c74d97b01eae257e44aa9d5bade97baf',1,NULL,NULL,NULL,'complete','2022-10-03 15:51:27',NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,NULL,NULL,NULL,NULL,NULL),(11,1,4,18,NULL,NULL,21927,'Bank Transfer','6f4922f45568161a8cdf4ad2299f6d23',1,NULL,NULL,NULL,'complete','2022-10-15 14:09:38',NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,NULL,NULL,NULL,NULL,NULL),(12,1,5,25,NULL,NULL,41732,'Bank Transfer','8e296a067a37563370ded05f5a3bf3ec',1,NULL,NULL,NULL,'complete','2022-10-22 23:15:33',NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,NULL,NULL,NULL,NULL,NULL),(13,2,6,26,NULL,NULL,13220,'Bank Transfer','4e732ced3463d06de0ca9a15b6153677',5,NULL,NULL,NULL,'complete','2022-10-14 19:26:26',NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,NULL,NULL,NULL,NULL,NULL),(14,2,6,28,NULL,NULL,22824,'Bank Transfer','33e75ff09dd601bbe69f351039152189',5,NULL,NULL,NULL,'complete','2022-10-28 19:21:19',NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,NULL,NULL,NULL,NULL,NULL),(15,2,6,30,NULL,NULL,23190,'Bank Transfer','34173cb38f07f89ddbebc2ac9128303f',5,NULL,NULL,NULL,'complete','2022-10-16 23:15:13',NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,NULL,NULL,NULL,NULL,NULL),(16,2,7,33,NULL,NULL,27571,'Bank Transfer','182be0c5cdcd5072bb1864cdee4d3d6e',5,NULL,NULL,NULL,'complete','2022-10-03 18:52:40',NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,NULL,NULL,NULL,NULL,NULL),(17,2,7,34,NULL,NULL,41698,'Bank Transfer','e369853df766fa44e1ed0ff613f563bd',5,NULL,NULL,NULL,'complete','2022-10-18 16:33:12',NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,NULL,NULL,NULL,NULL,NULL),(18,2,7,35,NULL,NULL,26029,'Bank Transfer','1c383cd30b7c298ab50293adfecb7b18',5,NULL,NULL,NULL,'complete','2022-10-05 22:48:20',NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,NULL,NULL,NULL,NULL,NULL),(19,2,8,36,NULL,NULL,40270,'Bank Transfer','19ca14e7ea6328a42e0eb13d585e4c22',5,NULL,NULL,NULL,'complete','2022-10-21 12:37:14',NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,NULL,NULL,NULL,NULL,NULL),(20,2,8,37,NULL,NULL,36780,'Bank Transfer','a5bfc9e07964f8dddeb95fc584cd965d',5,NULL,NULL,NULL,'complete','2022-10-06 18:54:39',NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,NULL,NULL,NULL,NULL,NULL),(21,2,8,40,NULL,NULL,42410,'Bank Transfer','d645920e395fedad7bbbed0eca3fe2e0',5,NULL,NULL,NULL,'complete','2022-10-12 12:29:31',NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,NULL,NULL,NULL,NULL,NULL),(22,2,9,42,NULL,NULL,39702,'Bank Transfer','a1d0c6e83f027327d8461063f4ac58a6',5,NULL,NULL,NULL,'complete','2022-10-17 22:27:30',NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,NULL,NULL,NULL,NULL,NULL),(23,2,9,43,NULL,NULL,31872,'Bank Transfer','17e62166fc8586dfa4d1bc0e1742c08b',5,NULL,NULL,NULL,'complete','2022-10-23 07:57:08',NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,NULL,NULL,NULL,NULL,NULL),(24,2,9,44,NULL,NULL,25687,'Bank Transfer','f7177163c833dff4b38fc8d2872f1ec6',5,NULL,NULL,NULL,'complete','2022-10-22 02:03:15',NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,NULL,NULL,NULL,NULL,NULL),(25,2,10,46,NULL,NULL,39355,'Bank Transfer','d9d4f495e875a2e075a1a4a6e1b9770f',5,NULL,NULL,NULL,'complete','2022-10-11 11:08:27',NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,NULL,NULL,NULL,NULL,NULL),(26,2,10,47,NULL,NULL,20139,'Bank Transfer','67c6a1e7ce56d3d6fa748ab6d9af3fd7',5,NULL,NULL,NULL,'complete','2022-10-14 20:46:08',NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,NULL,NULL,NULL,NULL,NULL),(27,2,10,50,NULL,NULL,21806,'Bank Transfer','c0c7c76d30bd3dcaefc96f40275bdc0a',5,NULL,NULL,NULL,'complete','2022-10-19 21:34:32',NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,NULL,NULL,NULL,NULL,NULL),(28,3,12,59,NULL,NULL,39100,'Bank Transfer','093f65e080a295f8076b1c5722a46aa2',9,NULL,NULL,NULL,'complete','2022-10-28 04:45:35',NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,NULL,NULL,NULL,NULL,NULL),(29,3,12,60,NULL,NULL,36768,'Bank Transfer','072b030ba126b2f4b2374f342be9ed44',9,NULL,NULL,NULL,'complete','2022-10-06 07:49:08',NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,NULL,NULL,NULL,NULL,NULL),(30,3,13,61,NULL,NULL,31253,'Bank Transfer','7f39f8317fbdb1988ef4c628eba02591',9,NULL,NULL,NULL,'complete','2022-10-24 14:14:27',NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,NULL,NULL,NULL,NULL,NULL),(31,3,13,62,NULL,NULL,9228,'Bank Transfer','44f683a84163b3523afe57c2e008bc8c',9,NULL,NULL,NULL,'complete','2022-10-25 02:36:51',NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,NULL,NULL,NULL,NULL,NULL),(32,3,13,64,NULL,NULL,26730,'Bank Transfer','ea5d2f1c4608232e07d3aa3d998e5135',9,NULL,NULL,NULL,'complete','2022-10-07 18:43:24',NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,NULL,NULL,NULL,NULL,NULL),(33,3,14,66,NULL,NULL,36647,'Bank Transfer','3295c76acbf4caaed33c36b1b5fc2cb1',9,NULL,NULL,NULL,'complete','2022-10-13 19:36:46',NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,NULL,NULL,NULL,NULL,NULL),(34,3,14,67,NULL,NULL,54940,'Bank Transfer','735b90b4568125ed6c3f678819b6e058',9,NULL,NULL,NULL,'complete','2022-10-18 11:37:03',NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,NULL,NULL,NULL,NULL,NULL),(35,3,14,68,NULL,NULL,18059,'Bank Transfer','a3f390d88e4c41f2747bfa2f1b5f87db',9,NULL,NULL,NULL,'complete','2022-10-15 06:09:32',NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,NULL,NULL,NULL,NULL,NULL),(36,3,14,70,NULL,NULL,15701,'Bank Transfer','7cbbc409ec990f19c78c75bd1e06f215',9,NULL,NULL,NULL,'complete','2022-10-15 02:58:41',NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,NULL,NULL,NULL,NULL,NULL),(37,3,15,71,NULL,NULL,23336,'Bank Transfer','e2c420d928d4bf8ce0ff2ec19b371514',9,NULL,NULL,NULL,'complete','2022-10-02 12:43:14',NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,NULL,NULL,NULL,NULL,NULL),(38,3,15,75,NULL,NULL,8206,'Bank Transfer','d09bf41544a3365a46c9077ebb5e35c3',9,NULL,NULL,NULL,'complete','2022-10-02 12:15:20',NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19',NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `paypal_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `paypal_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `package_id` bigint unsigned DEFAULT NULL,
  `sub_total` double DEFAULT NULL,
  `total` double DEFAULT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remarks` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_frequency` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_interval` int DEFAULT NULL,
  `paid_on` datetime DEFAULT NULL,
  `next_pay_date` datetime DEFAULT NULL,
  `recurring` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT 'no',
  `status` enum('paid','unpaid','pending') COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `plan_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `end_on` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `paypal_invoices_company_id_foreign` (`company_id`),
  KEY `paypal_invoices_currency_id_foreign` (`currency_id`),
  KEY `paypal_invoices_package_id_foreign` (`package_id`),
  CONSTRAINT `paypal_invoices_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `paypal_invoices_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `paypal_invoices_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `paypal_invoices` WRITE;
/*!40000 ALTER TABLE `paypal_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `paypal_invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `paystack_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `paystack_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned NOT NULL,
  `package_id` bigint unsigned NOT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_date` date DEFAULT NULL,
  `next_pay_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `paystack_invoices_company_id_foreign` (`company_id`),
  KEY `paystack_invoices_package_id_foreign` (`package_id`),
  CONSTRAINT `paystack_invoices_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `paystack_invoices_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `paystack_invoices` WRITE;
/*!40000 ALTER TABLE `paystack_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `paystack_invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permission_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `permission_role` (
  `permission_id` int unsigned NOT NULL,
  `role_id` int unsigned NOT NULL,
  `permission_type_id` bigint unsigned NOT NULL DEFAULT '5',
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `permission_role_role_id_foreign` (`role_id`),
  KEY `permission_role_permission_type_id_foreign` (`permission_type_id`),
  CONSTRAINT `permission_role_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `permission_role_permission_type_id_foreign` FOREIGN KEY (`permission_type_id`) REFERENCES `permission_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `permission_role_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permission_role` WRITE;
/*!40000 ALTER TABLE `permission_role` DISABLE KEYS */;
INSERT INTO `permission_role` VALUES (54,3,1),(54,4,1),(54,6,1),(54,7,1),(54,9,1),(54,10,1),(57,3,1),(57,4,1),(57,6,1),(57,7,1),(57,9,1),(57,10,1),(58,3,1),(58,4,1),(58,6,1),(58,7,1),(58,9,1),(58,10,1),(94,3,1),(94,6,1),(94,9,1),(96,3,1),(96,6,1),(96,9,1),(97,3,1),(97,6,1),(97,9,1),(104,3,1),(104,6,1),(104,9,1),(107,3,1),(107,6,1),(107,9,1),(108,3,1),(108,6,1),(108,9,1),(111,3,1),(111,4,1),(111,6,1),(111,7,1),(111,9,1),(111,10,1),(112,3,1),(112,4,1),(112,6,1),(112,7,1),(112,9,1),(112,10,1),(115,3,1),(115,4,1),(115,6,1),(115,7,1),(115,9,1),(115,10,1),(116,3,1),(116,4,1),(116,6,1),(116,7,1),(116,9,1),(116,10,1),(136,3,1),(136,6,1),(136,9,1),(138,3,1),(138,6,1),(138,9,1),(143,3,1),(143,4,1),(143,6,1),(143,7,1),(143,9,1),(143,10,1),(145,4,1),(145,7,1),(145,10,1),(146,3,1),(146,4,1),(146,6,1),(146,7,1),(146,9,1),(146,10,1),(160,3,1),(160,6,1),(160,9,1),(166,3,1),(166,6,1),(166,9,1),(168,3,1),(168,6,1),(168,9,1),(179,3,1),(179,6,1),(179,9,1),(184,3,1),(184,6,1),(184,9,1),(185,3,1),(185,6,1),(185,9,1),(211,3,1),(211,6,1),(211,9,1),(213,3,1),(213,6,1),(213,9,1),(214,3,1),(214,6,1),(214,9,1),(44,3,2),(44,6,2),(44,9,2),(48,3,2),(48,4,2),(48,6,2),(48,7,2),(48,9,2),(48,10,2),(91,3,2),(91,6,2),(91,9,2),(95,4,2),(95,7,2),(95,10,2),(124,4,2),(124,7,2),(124,10,2),(128,4,2),(128,7,2),(128,10,2),(133,4,2),(133,7,2),(133,10,2),(137,4,2),(137,7,2),(137,10,2),(152,3,2),(152,4,2),(152,6,2),(152,7,2),(152,9,2),(152,10,2),(157,3,2),(157,4,2),(157,6,2),(157,7,2),(157,9,2),(157,10,2),(219,4,2),(219,7,2),(219,10,2),(270,4,2),(270,7,2),(270,10,2),(95,3,3),(95,6,3),(95,9,3),(137,3,3),(137,6,3),(137,9,3),(144,3,3),(144,4,3),(144,6,3),(144,7,3),(144,9,3),(144,10,3),(145,3,3),(145,6,3),(145,9,3),(161,3,3),(161,6,3),(161,9,3),(167,3,3),(167,6,3),(167,9,3),(195,3,3),(195,6,3),(195,9,3),(212,3,3),(212,6,3),(212,9,3),(1,2,4),(1,5,4),(1,8,4),(2,2,4),(2,5,4),(2,8,4),(3,2,4),(3,5,4),(3,8,4),(4,2,4),(4,5,4),(4,8,4),(5,2,4),(5,5,4),(5,8,4),(6,2,4),(6,5,4),(6,8,4),(7,2,4),(7,5,4),(7,8,4),(8,2,4),(8,5,4),(8,8,4),(9,2,4),(9,5,4),(9,8,4),(10,2,4),(10,5,4),(10,8,4),(11,2,4),(11,5,4),(11,8,4),(12,2,4),(12,5,4),(12,8,4),(13,2,4),(13,5,4),(13,8,4),(14,2,4),(14,5,4),(14,8,4),(15,2,4),(15,5,4),(15,8,4),(16,2,4),(16,5,4),(16,8,4),(17,2,4),(17,5,4),(17,8,4),(18,2,4),(18,5,4),(18,8,4),(19,2,4),(19,5,4),(19,8,4),(20,2,4),(20,5,4),(20,8,4),(21,2,4),(21,5,4),(21,8,4),(22,2,4),(22,5,4),(22,8,4),(23,2,4),(23,5,4),(23,8,4),(24,2,4),(24,5,4),(24,8,4),(25,2,4),(25,5,4),(25,8,4),(26,2,4),(26,5,4),(26,8,4),(27,2,4),(27,5,4),(27,8,4),(28,2,4),(28,5,4),(28,8,4),(29,2,4),(29,5,4),(29,8,4),(30,2,4),(30,5,4),(30,8,4),(31,2,4),(31,5,4),(31,8,4),(32,2,4),(32,5,4),(32,8,4),(33,2,4),(33,5,4),(33,8,4),(34,2,4),(34,5,4),(34,8,4),(35,2,4),(35,3,4),(35,5,4),(35,6,4),(35,8,4),(35,9,4),(36,2,4),(36,5,4),(36,8,4),(37,2,4),(37,5,4),(37,8,4),(38,2,4),(38,5,4),(38,8,4),(39,2,4),(39,5,4),(39,8,4),(40,2,4),(40,5,4),(40,8,4),(41,2,4),(41,5,4),(41,8,4),(42,2,4),(42,5,4),(42,8,4),(43,2,4),(43,5,4),(43,8,4),(44,2,4),(44,5,4),(44,8,4),(45,2,4),(45,5,4),(45,8,4),(46,2,4),(46,5,4),(46,8,4),(47,2,4),(47,5,4),(47,8,4),(48,2,4),(48,5,4),(48,8,4),(49,2,4),(49,5,4),(49,8,4),(50,2,4),(50,5,4),(50,8,4),(51,2,4),(51,5,4),(51,8,4),(52,2,4),(52,3,4),(52,4,4),(52,5,4),(52,6,4),(52,7,4),(52,8,4),(52,9,4),(52,10,4),(53,2,4),(53,3,4),(53,4,4),(53,5,4),(53,6,4),(53,7,4),(53,8,4),(53,9,4),(53,10,4),(54,2,4),(54,5,4),(54,8,4),(55,2,4),(55,3,4),(55,4,4),(55,5,4),(55,6,4),(55,7,4),(55,8,4),(55,9,4),(55,10,4),(56,2,4),(56,3,4),(56,4,4),(56,5,4),(56,6,4),(56,7,4),(56,8,4),(56,9,4),(56,10,4),(57,2,4),(57,5,4),(57,8,4),(58,2,4),(58,5,4),(58,8,4),(59,2,4),(59,5,4),(59,8,4),(60,2,4),(60,5,4),(60,8,4),(61,2,4),(61,5,4),(61,8,4),(62,2,4),(62,5,4),(62,8,4),(63,2,4),(63,5,4),(63,8,4),(64,2,4),(64,3,4),(64,4,4),(64,5,4),(64,6,4),(64,7,4),(64,8,4),(64,9,4),(64,10,4),(65,2,4),(65,5,4),(65,8,4),(66,2,4),(66,5,4),(66,8,4),(67,2,4),(67,5,4),(67,8,4),(68,2,4),(68,5,4),(68,8,4),(69,2,4),(69,5,4),(69,8,4),(70,2,4),(70,5,4),(70,8,4),(71,2,4),(71,5,4),(71,8,4),(72,2,4),(72,5,4),(72,8,4),(73,2,4),(73,3,4),(73,4,4),(73,5,4),(73,6,4),(73,7,4),(73,8,4),(73,9,4),(73,10,4),(74,2,4),(74,5,4),(74,8,4),(75,2,4),(75,3,4),(75,4,4),(75,5,4),(75,6,4),(75,7,4),(75,8,4),(75,9,4),(75,10,4),(76,2,4),(76,4,4),(76,5,4),(76,7,4),(76,8,4),(76,10,4),(77,2,4),(77,5,4),(77,8,4),(78,2,4),(78,4,4),(78,5,4),(78,7,4),(78,8,4),(78,10,4),(79,2,4),(79,5,4),(79,8,4),(80,2,4),(80,5,4),(80,8,4),(81,2,4),(81,3,4),(81,4,4),(81,5,4),(81,6,4),(81,7,4),(81,8,4),(81,9,4),(81,10,4),(82,2,4),(82,5,4),(82,8,4),(83,2,4),(83,5,4),(83,8,4),(84,2,4),(84,5,4),(84,8,4),(85,2,4),(85,5,4),(85,8,4),(86,2,4),(86,5,4),(86,8,4),(87,2,4),(87,5,4),(87,8,4),(88,2,4),(88,5,4),(88,8,4),(89,2,4),(89,5,4),(89,8,4),(90,2,4),(90,5,4),(90,8,4),(91,2,4),(91,5,4),(91,8,4),(92,2,4),(92,5,4),(92,8,4),(93,2,4),(93,5,4),(93,8,4),(94,2,4),(94,5,4),(94,8,4),(95,2,4),(95,5,4),(95,8,4),(96,2,4),(96,5,4),(96,8,4),(97,2,4),(97,5,4),(97,8,4),(98,2,4),(98,5,4),(98,8,4),(99,2,4),(99,5,4),(99,8,4),(100,2,4),(100,5,4),(100,8,4),(101,2,4),(101,5,4),(101,8,4),(102,2,4),(102,3,4),(102,4,4),(102,5,4),(102,6,4),(102,7,4),(102,8,4),(102,9,4),(102,10,4),(103,2,4),(103,3,4),(103,5,4),(103,6,4),(103,8,4),(103,9,4),(104,2,4),(104,5,4),(104,8,4),(105,2,4),(105,3,4),(105,4,4),(105,5,4),(105,6,4),(105,7,4),(105,8,4),(105,9,4),(105,10,4),(106,2,4),(106,3,4),(106,5,4),(106,6,4),(106,8,4),(106,9,4),(107,2,4),(107,5,4),(107,8,4),(108,2,4),(108,5,4),(108,8,4),(109,2,4),(109,3,4),(109,4,4),(109,5,4),(109,6,4),(109,7,4),(109,8,4),(109,9,4),(109,10,4),(110,2,4),(110,3,4),(110,4,4),(110,5,4),(110,6,4),(110,7,4),(110,8,4),(110,9,4),(110,10,4),(111,2,4),(111,5,4),(111,8,4),(112,2,4),(112,5,4),(112,8,4),(113,2,4),(113,3,4),(113,4,4),(113,5,4),(113,6,4),(113,7,4),(113,8,4),(113,9,4),(113,10,4),(114,2,4),(114,3,4),(114,4,4),(114,5,4),(114,6,4),(114,7,4),(114,8,4),(114,9,4),(114,10,4),(115,2,4),(115,5,4),(115,8,4),(116,2,4),(116,5,4),(116,8,4),(117,2,4),(117,5,4),(117,8,4),(118,2,4),(118,5,4),(118,8,4),(119,2,4),(119,5,4),(119,8,4),(120,2,4),(120,5,4),(120,8,4),(121,2,4),(121,5,4),(121,8,4),(122,2,4),(122,5,4),(122,8,4),(123,2,4),(123,5,4),(123,8,4),(124,2,4),(124,5,4),(124,8,4),(125,2,4),(125,5,4),(125,8,4),(126,2,4),(126,5,4),(126,8,4),(127,2,4),(127,5,4),(127,8,4),(128,2,4),(128,5,4),(128,8,4),(129,2,4),(129,5,4),(129,8,4),(130,2,4),(130,5,4),(130,8,4),(131,2,4),(131,5,4),(131,8,4),(132,2,4),(132,5,4),(132,8,4),(133,2,4),(133,5,4),(133,8,4),(134,2,4),(134,5,4),(134,8,4),(135,2,4),(135,5,4),(135,8,4),(136,2,4),(136,5,4),(136,8,4),(137,2,4),(137,5,4),(137,8,4),(138,2,4),(138,5,4),(138,8,4),(139,2,4),(139,5,4),(139,8,4),(140,2,4),(140,5,4),(140,8,4),(141,2,4),(141,5,4),(141,8,4),(142,2,4),(142,5,4),(142,8,4),(143,2,4),(143,5,4),(143,8,4),(144,2,4),(144,5,4),(144,8,4),(145,2,4),(145,5,4),(145,8,4),(146,2,4),(146,5,4),(146,8,4),(147,2,4),(147,5,4),(147,8,4),(148,2,4),(148,5,4),(148,8,4),(149,2,4),(149,5,4),(149,8,4),(150,2,4),(150,5,4),(150,8,4),(151,2,4),(151,5,4),(151,8,4),(152,2,4),(152,5,4),(152,8,4),(153,2,4),(153,5,4),(153,8,4),(154,2,4),(154,5,4),(154,8,4),(155,2,4),(155,5,4),(155,8,4),(156,2,4),(156,5,4),(156,8,4),(157,2,4),(157,5,4),(157,8,4),(158,2,4),(158,5,4),(158,8,4),(159,2,4),(159,5,4),(159,8,4),(160,2,4),(160,5,4),(160,8,4),(161,2,4),(161,5,4),(161,8,4),(162,2,4),(162,5,4),(162,8,4),(163,2,4),(163,5,4),(163,8,4),(164,2,4),(164,5,4),(164,8,4),(165,2,4),(165,5,4),(165,8,4),(166,2,4),(166,5,4),(166,8,4),(167,2,4),(167,5,4),(167,8,4),(168,2,4),(168,5,4),(168,8,4),(169,2,4),(169,5,4),(169,8,4),(170,2,4),(170,5,4),(170,8,4),(171,2,4),(171,5,4),(171,8,4),(172,2,4),(172,5,4),(172,8,4),(173,2,4),(173,5,4),(173,8,4),(174,2,4),(174,5,4),(174,8,4),(175,2,4),(175,5,4),(175,8,4),(176,2,4),(176,5,4),(176,8,4),(177,2,4),(177,5,4),(177,8,4),(178,2,4),(178,5,4),(178,8,4),(179,2,4),(179,5,4),(179,8,4),(180,2,4),(180,3,4),(180,5,4),(180,6,4),(180,8,4),(180,9,4),(181,2,4),(181,5,4),(181,8,4),(182,2,4),(182,3,4),(182,5,4),(182,6,4),(182,8,4),(182,9,4),(183,2,4),(183,3,4),(183,5,4),(183,6,4),(183,8,4),(183,9,4),(184,2,4),(184,5,4),(184,8,4),(185,2,4),(185,5,4),(185,8,4),(186,2,4),(186,5,4),(186,8,4),(187,2,4),(187,5,4),(187,8,4),(188,2,4),(188,5,4),(188,8,4),(189,2,4),(189,5,4),(189,8,4),(190,2,4),(190,5,4),(190,8,4),(191,2,4),(191,5,4),(191,8,4),(192,2,4),(192,5,4),(192,8,4),(193,2,4),(193,5,4),(193,8,4),(194,2,4),(194,5,4),(194,8,4),(195,2,4),(195,5,4),(195,8,4),(196,2,4),(196,5,4),(196,8,4),(197,2,4),(197,5,4),(197,8,4),(198,2,4),(198,5,4),(198,8,4),(199,2,4),(199,5,4),(199,8,4),(200,2,4),(200,5,4),(200,8,4),(201,2,4),(201,5,4),(201,8,4),(202,2,4),(202,3,4),(202,5,4),(202,6,4),(202,8,4),(202,9,4),(203,2,4),(203,5,4),(203,8,4),(204,2,4),(204,5,4),(204,8,4),(205,2,4),(205,5,4),(205,8,4),(206,2,4),(206,4,4),(206,5,4),(206,7,4),(206,8,4),(206,10,4),(207,2,4),(207,5,4),(207,8,4),(208,2,4),(208,5,4),(208,8,4),(209,2,4),(209,5,4),(209,8,4),(210,2,4),(210,5,4),(210,8,4),(211,2,4),(211,5,4),(211,8,4),(212,2,4),(212,5,4),(212,8,4),(213,2,4),(213,5,4),(213,8,4),(214,2,4),(214,5,4),(214,8,4),(215,2,4),(215,5,4),(215,8,4),(216,2,4),(216,5,4),(216,8,4),(217,2,4),(217,5,4),(217,8,4),(218,2,4),(218,5,4),(218,8,4),(219,2,4),(219,5,4),(219,8,4),(220,2,4),(220,5,4),(220,8,4),(221,2,4),(221,5,4),(221,8,4),(222,2,4),(222,5,4),(222,8,4),(223,2,4),(223,5,4),(223,8,4),(224,2,4),(224,4,4),(224,5,4),(224,7,4),(224,8,4),(224,10,4),(225,2,4),(225,5,4),(225,8,4),(226,2,4),(226,4,4),(226,5,4),(226,7,4),(226,8,4),(226,10,4),(227,2,4),(227,5,4),(227,8,4),(228,2,4),(228,5,4),(228,8,4),(229,2,4),(229,4,4),(229,5,4),(229,7,4),(229,8,4),(229,10,4),(230,2,4),(230,5,4),(230,8,4),(231,2,4),(231,5,4),(231,8,4),(232,2,4),(232,5,4),(232,8,4),(233,2,4),(233,5,4),(233,8,4),(234,2,4),(234,5,4),(234,8,4),(235,2,4),(235,5,4),(235,8,4),(236,2,4),(236,5,4),(236,8,4),(237,2,4),(237,5,4),(237,8,4),(238,2,4),(238,5,4),(238,8,4),(239,2,4),(239,5,4),(239,8,4),(240,2,4),(240,5,4),(240,8,4),(241,2,4),(241,5,4),(241,8,4),(242,2,4),(242,5,4),(242,8,4),(243,2,4),(243,5,4),(243,8,4),(244,2,4),(244,5,4),(244,8,4),(245,2,4),(245,5,4),(245,8,4),(246,2,4),(246,5,4),(246,8,4),(247,2,4),(247,5,4),(247,8,4),(248,2,4),(248,5,4),(248,8,4),(249,2,4),(249,5,4),(249,8,4),(250,2,4),(250,5,4),(250,8,4),(251,2,4),(251,5,4),(251,8,4),(252,2,4),(252,5,4),(252,8,4),(253,2,4),(253,5,4),(253,8,4),(254,2,4),(254,5,4),(254,8,4),(255,2,4),(255,5,4),(255,8,4),(256,2,4),(256,5,4),(256,8,4),(257,2,4),(257,5,4),(257,8,4),(258,2,4),(258,5,4),(258,8,4),(259,2,4),(259,5,4),(259,8,4),(260,2,4),(260,5,4),(260,8,4),(261,2,4),(261,5,4),(261,8,4),(262,2,4),(262,5,4),(262,8,4),(263,2,4),(263,5,4),(263,8,4),(264,2,4),(264,5,4),(264,8,4),(265,2,4),(265,5,4),(265,8,4),(266,2,4),(266,5,4),(266,8,4),(267,2,4),(267,5,4),(267,8,4),(268,2,4),(268,5,4),(268,8,4),(269,2,4),(269,5,4),(269,8,4),(270,2,4),(270,5,4),(270,8,4),(271,2,4),(271,5,4),(271,8,4),(272,2,4),(272,5,4),(272,8,4),(273,2,4),(273,5,4),(273,8,4),(274,2,4),(274,5,4),(274,8,4),(275,2,4),(275,5,4),(275,8,4),(276,2,4),(276,5,4),(276,8,4),(1,3,5),(1,4,5),(1,6,5),(1,7,5),(1,9,5),(1,10,5),(1,11,5),(1,12,5),(1,13,5),(1,14,5),(1,15,5),(1,16,5),(2,3,5),(2,4,5),(2,6,5),(2,7,5),(2,9,5),(2,10,5),(2,11,5),(2,12,5),(2,13,5),(2,14,5),(2,15,5),(2,16,5),(3,3,5),(3,4,5),(3,6,5),(3,7,5),(3,9,5),(3,10,5),(3,11,5),(3,12,5),(3,13,5),(3,14,5),(3,15,5),(3,16,5),(4,3,5),(4,4,5),(4,6,5),(4,7,5),(4,9,5),(4,10,5),(4,11,5),(4,12,5),(4,13,5),(4,14,5),(4,15,5),(4,16,5),(5,3,5),(5,4,5),(5,6,5),(5,7,5),(5,9,5),(5,10,5),(5,11,5),(5,12,5),(5,13,5),(5,14,5),(5,15,5),(5,16,5),(6,3,5),(6,4,5),(6,6,5),(6,7,5),(6,9,5),(6,10,5),(6,11,5),(6,12,5),(6,13,5),(6,14,5),(6,15,5),(6,16,5),(7,3,5),(7,4,5),(7,6,5),(7,7,5),(7,9,5),(7,10,5),(7,11,5),(7,12,5),(7,13,5),(7,14,5),(7,15,5),(7,16,5),(8,3,5),(8,4,5),(8,6,5),(8,7,5),(8,9,5),(8,10,5),(8,11,5),(8,12,5),(8,13,5),(8,14,5),(8,15,5),(8,16,5),(9,3,5),(9,4,5),(9,6,5),(9,7,5),(9,9,5),(9,10,5),(9,11,5),(9,12,5),(9,13,5),(9,14,5),(9,15,5),(9,16,5),(10,3,5),(10,4,5),(10,6,5),(10,7,5),(10,9,5),(10,10,5),(10,11,5),(10,12,5),(10,13,5),(10,14,5),(10,15,5),(10,16,5),(11,3,5),(11,4,5),(11,6,5),(11,7,5),(11,9,5),(11,10,5),(11,11,5),(11,12,5),(11,13,5),(11,14,5),(11,15,5),(11,16,5),(12,3,5),(12,4,5),(12,6,5),(12,7,5),(12,9,5),(12,10,5),(12,11,5),(12,12,5),(12,13,5),(12,14,5),(12,15,5),(12,16,5),(13,3,5),(13,4,5),(13,6,5),(13,7,5),(13,9,5),(13,10,5),(13,11,5),(13,12,5),(13,13,5),(13,14,5),(13,15,5),(13,16,5),(14,3,5),(14,4,5),(14,6,5),(14,7,5),(14,9,5),(14,10,5),(14,11,5),(14,12,5),(14,13,5),(14,14,5),(14,15,5),(14,16,5),(15,3,5),(15,4,5),(15,6,5),(15,7,5),(15,9,5),(15,10,5),(15,11,5),(15,12,5),(15,13,5),(15,14,5),(15,15,5),(15,16,5),(16,3,5),(16,4,5),(16,6,5),(16,7,5),(16,9,5),(16,10,5),(16,11,5),(16,12,5),(16,13,5),(16,14,5),(16,15,5),(16,16,5),(17,3,5),(17,4,5),(17,6,5),(17,7,5),(17,9,5),(17,10,5),(17,11,5),(17,12,5),(17,13,5),(17,14,5),(17,15,5),(17,16,5),(18,3,5),(18,4,5),(18,6,5),(18,7,5),(18,9,5),(18,10,5),(18,11,5),(18,12,5),(18,13,5),(18,14,5),(18,15,5),(18,16,5),(19,3,5),(19,4,5),(19,6,5),(19,7,5),(19,9,5),(19,10,5),(19,11,5),(19,12,5),(19,13,5),(19,14,5),(19,15,5),(19,16,5),(20,3,5),(20,4,5),(20,6,5),(20,7,5),(20,9,5),(20,10,5),(20,11,5),(20,12,5),(20,13,5),(20,14,5),(20,15,5),(20,16,5),(21,3,5),(21,4,5),(21,6,5),(21,7,5),(21,9,5),(21,10,5),(21,11,5),(21,12,5),(21,13,5),(21,14,5),(21,15,5),(21,16,5),(22,3,5),(22,4,5),(22,6,5),(22,7,5),(22,9,5),(22,10,5),(22,11,5),(22,12,5),(22,13,5),(22,14,5),(22,15,5),(22,16,5),(23,3,5),(23,4,5),(23,6,5),(23,7,5),(23,9,5),(23,10,5),(23,11,5),(23,12,5),(23,13,5),(23,14,5),(23,15,5),(23,16,5),(24,3,5),(24,4,5),(24,6,5),(24,7,5),(24,9,5),(24,10,5),(24,11,5),(24,12,5),(24,13,5),(24,14,5),(24,15,5),(24,16,5),(25,3,5),(25,4,5),(25,6,5),(25,7,5),(25,9,5),(25,10,5),(25,11,5),(25,12,5),(25,13,5),(25,14,5),(25,15,5),(25,16,5),(26,3,5),(26,4,5),(26,6,5),(26,7,5),(26,9,5),(26,10,5),(26,11,5),(26,12,5),(26,13,5),(26,14,5),(26,15,5),(26,16,5),(27,3,5),(27,4,5),(27,6,5),(27,7,5),(27,9,5),(27,10,5),(27,11,5),(27,12,5),(27,13,5),(27,14,5),(27,15,5),(27,16,5),(28,3,5),(28,4,5),(28,6,5),(28,7,5),(28,9,5),(28,10,5),(28,11,5),(28,12,5),(28,13,5),(28,14,5),(28,15,5),(28,16,5),(29,3,5),(29,4,5),(29,6,5),(29,7,5),(29,9,5),(29,10,5),(29,11,5),(29,12,5),(29,13,5),(29,14,5),(29,15,5),(29,16,5),(30,3,5),(30,4,5),(30,6,5),(30,7,5),(30,9,5),(30,10,5),(30,11,5),(30,12,5),(30,13,5),(30,14,5),(30,15,5),(30,16,5),(31,3,5),(31,4,5),(31,6,5),(31,7,5),(31,9,5),(31,10,5),(31,11,5),(31,12,5),(31,13,5),(31,14,5),(31,15,5),(31,16,5),(32,3,5),(32,4,5),(32,6,5),(32,7,5),(32,9,5),(32,10,5),(32,11,5),(32,12,5),(32,13,5),(32,14,5),(32,15,5),(32,16,5),(33,3,5),(33,4,5),(33,6,5),(33,7,5),(33,9,5),(33,10,5),(33,11,5),(33,12,5),(33,13,5),(33,14,5),(33,15,5),(33,16,5),(34,3,5),(34,4,5),(34,6,5),(34,7,5),(34,9,5),(34,10,5),(34,11,5),(34,12,5),(34,13,5),(34,14,5),(34,15,5),(34,16,5),(35,4,5),(35,7,5),(35,10,5),(35,11,5),(35,12,5),(35,13,5),(35,14,5),(35,15,5),(35,16,5),(36,3,5),(36,4,5),(36,6,5),(36,7,5),(36,9,5),(36,10,5),(36,11,5),(36,12,5),(36,13,5),(36,14,5),(36,15,5),(36,16,5),(37,3,5),(37,4,5),(37,6,5),(37,7,5),(37,9,5),(37,10,5),(37,11,5),(37,12,5),(37,13,5),(37,14,5),(37,15,5),(37,16,5),(38,3,5),(38,4,5),(38,6,5),(38,7,5),(38,9,5),(38,10,5),(38,11,5),(38,12,5),(38,13,5),(38,14,5),(38,15,5),(38,16,5),(39,3,5),(39,4,5),(39,6,5),(39,7,5),(39,9,5),(39,10,5),(39,11,5),(39,12,5),(39,13,5),(39,14,5),(39,15,5),(39,16,5),(40,3,5),(40,4,5),(40,6,5),(40,7,5),(40,9,5),(40,10,5),(40,11,5),(40,12,5),(40,13,5),(40,14,5),(40,15,5),(40,16,5),(41,3,5),(41,4,5),(41,6,5),(41,7,5),(41,9,5),(41,10,5),(41,11,5),(41,12,5),(41,13,5),(41,14,5),(41,15,5),(41,16,5),(42,3,5),(42,4,5),(42,6,5),(42,7,5),(42,9,5),(42,10,5),(42,11,5),(42,12,5),(42,13,5),(42,14,5),(42,15,5),(42,16,5),(43,3,5),(43,4,5),(43,6,5),(43,7,5),(43,9,5),(43,10,5),(43,11,5),(43,12,5),(43,13,5),(43,14,5),(43,15,5),(43,16,5),(44,4,5),(44,7,5),(44,10,5),(44,11,5),(44,12,5),(44,13,5),(44,14,5),(44,15,5),(44,16,5),(45,3,5),(45,4,5),(45,6,5),(45,7,5),(45,9,5),(45,10,5),(45,11,5),(45,12,5),(45,13,5),(45,14,5),(45,15,5),(45,16,5),(46,3,5),(46,4,5),(46,6,5),(46,7,5),(46,9,5),(46,10,5),(46,11,5),(46,12,5),(46,13,5),(46,14,5),(46,15,5),(46,16,5),(47,3,5),(47,4,5),(47,6,5),(47,7,5),(47,9,5),(47,10,5),(47,11,5),(47,12,5),(47,13,5),(47,14,5),(47,15,5),(47,16,5),(48,11,5),(48,12,5),(48,13,5),(48,14,5),(48,15,5),(48,16,5),(49,3,5),(49,4,5),(49,6,5),(49,7,5),(49,9,5),(49,10,5),(49,11,5),(49,12,5),(49,13,5),(49,14,5),(49,15,5),(49,16,5),(50,3,5),(50,4,5),(50,6,5),(50,7,5),(50,9,5),(50,10,5),(50,11,5),(50,12,5),(50,13,5),(50,14,5),(50,15,5),(50,16,5),(51,3,5),(51,4,5),(51,6,5),(51,7,5),(51,9,5),(51,10,5),(51,11,5),(51,12,5),(51,13,5),(51,14,5),(51,15,5),(51,16,5),(52,11,5),(52,12,5),(52,13,5),(52,14,5),(52,15,5),(52,16,5),(53,11,5),(53,12,5),(53,13,5),(53,14,5),(53,15,5),(53,16,5),(54,11,5),(54,12,5),(54,13,5),(54,14,5),(54,15,5),(54,16,5),(55,11,5),(55,12,5),(55,13,5),(55,14,5),(55,15,5),(55,16,5),(56,11,5),(56,12,5),(56,13,5),(56,14,5),(56,15,5),(56,16,5),(57,11,5),(57,12,5),(57,13,5),(57,14,5),(57,15,5),(57,16,5),(58,11,5),(58,12,5),(58,13,5),(58,14,5),(58,15,5),(58,16,5),(59,3,5),(59,4,5),(59,6,5),(59,7,5),(59,9,5),(59,10,5),(59,11,5),(59,12,5),(59,13,5),(59,14,5),(59,15,5),(59,16,5),(60,3,5),(60,4,5),(60,6,5),(60,7,5),(60,9,5),(60,10,5),(60,11,5),(60,12,5),(60,13,5),(60,14,5),(60,15,5),(60,16,5),(61,3,5),(61,4,5),(61,6,5),(61,7,5),(61,9,5),(61,10,5),(61,11,5),(61,12,5),(61,13,5),(61,14,5),(61,15,5),(61,16,5),(62,3,5),(62,4,5),(62,6,5),(62,7,5),(62,9,5),(62,10,5),(62,11,5),(62,12,5),(62,13,5),(62,14,5),(62,15,5),(62,16,5),(63,3,5),(63,4,5),(63,6,5),(63,7,5),(63,9,5),(63,10,5),(63,11,5),(63,12,5),(63,13,5),(63,14,5),(63,15,5),(63,16,5),(64,11,5),(64,12,5),(64,13,5),(64,14,5),(64,15,5),(64,16,5),(65,3,5),(65,4,5),(65,6,5),(65,7,5),(65,9,5),(65,10,5),(65,11,5),(65,12,5),(65,13,5),(65,14,5),(65,15,5),(65,16,5),(66,3,5),(66,4,5),(66,6,5),(66,7,5),(66,9,5),(66,10,5),(66,11,5),(66,12,5),(66,13,5),(66,14,5),(66,15,5),(66,16,5),(67,3,5),(67,4,5),(67,6,5),(67,7,5),(67,9,5),(67,10,5),(67,11,5),(67,12,5),(67,13,5),(67,14,5),(67,15,5),(67,16,5),(68,3,5),(68,4,5),(68,6,5),(68,7,5),(68,9,5),(68,10,5),(68,11,5),(68,12,5),(68,13,5),(68,14,5),(68,15,5),(68,16,5),(69,3,5),(69,4,5),(69,6,5),(69,7,5),(69,9,5),(69,10,5),(69,11,5),(69,12,5),(69,13,5),(69,14,5),(69,15,5),(69,16,5),(70,3,5),(70,4,5),(70,6,5),(70,7,5),(70,9,5),(70,10,5),(70,11,5),(70,12,5),(70,13,5),(70,14,5),(70,15,5),(70,16,5),(71,3,5),(71,4,5),(71,6,5),(71,7,5),(71,9,5),(71,10,5),(71,11,5),(71,12,5),(71,13,5),(71,14,5),(71,15,5),(71,16,5),(72,3,5),(72,4,5),(72,6,5),(72,7,5),(72,9,5),(72,10,5),(72,11,5),(72,12,5),(72,13,5),(72,14,5),(72,15,5),(72,16,5),(73,11,5),(73,12,5),(73,13,5),(73,14,5),(73,15,5),(73,16,5),(74,3,5),(74,4,5),(74,6,5),(74,7,5),(74,9,5),(74,10,5),(74,11,5),(74,12,5),(74,13,5),(74,14,5),(74,15,5),(74,16,5),(75,11,5),(75,12,5),(75,13,5),(75,14,5),(75,15,5),(75,16,5),(76,3,5),(76,6,5),(76,9,5),(76,11,5),(76,12,5),(76,13,5),(76,14,5),(76,15,5),(76,16,5),(77,3,5),(77,4,5),(77,6,5),(77,7,5),(77,9,5),(77,10,5),(77,11,5),(77,12,5),(77,13,5),(77,14,5),(77,15,5),(77,16,5),(78,3,5),(78,6,5),(78,9,5),(78,11,5),(78,12,5),(78,13,5),(78,14,5),(78,15,5),(78,16,5),(79,3,5),(79,4,5),(79,6,5),(79,7,5),(79,9,5),(79,10,5),(79,11,5),(79,12,5),(79,13,5),(79,14,5),(79,15,5),(79,16,5),(80,3,5),(80,4,5),(80,6,5),(80,7,5),(80,9,5),(80,10,5),(80,11,5),(80,12,5),(80,13,5),(80,14,5),(80,15,5),(80,16,5),(81,11,5),(81,12,5),(81,13,5),(81,14,5),(81,15,5),(81,16,5),(82,3,5),(82,4,5),(82,6,5),(82,7,5),(82,9,5),(82,10,5),(82,11,5),(82,12,5),(82,13,5),(82,14,5),(82,15,5),(82,16,5),(83,3,5),(83,4,5),(83,6,5),(83,7,5),(83,9,5),(83,10,5),(83,11,5),(83,12,5),(83,13,5),(83,14,5),(83,15,5),(83,16,5),(84,3,5),(84,4,5),(84,6,5),(84,7,5),(84,9,5),(84,10,5),(84,11,5),(84,12,5),(84,13,5),(84,14,5),(84,15,5),(84,16,5),(85,3,5),(85,4,5),(85,6,5),(85,7,5),(85,9,5),(85,10,5),(85,11,5),(85,12,5),(85,13,5),(85,14,5),(85,15,5),(85,16,5),(86,3,5),(86,4,5),(86,6,5),(86,7,5),(86,9,5),(86,10,5),(86,11,5),(86,12,5),(86,13,5),(86,14,5),(86,15,5),(86,16,5),(87,3,5),(87,4,5),(87,6,5),(87,7,5),(87,9,5),(87,10,5),(87,11,5),(87,12,5),(87,13,5),(87,14,5),(87,15,5),(87,16,5),(88,3,5),(88,4,5),(88,6,5),(88,7,5),(88,9,5),(88,10,5),(88,11,5),(88,12,5),(88,13,5),(88,14,5),(88,15,5),(88,16,5),(89,3,5),(89,4,5),(89,6,5),(89,7,5),(89,9,5),(89,10,5),(89,11,5),(89,12,5),(89,13,5),(89,14,5),(89,15,5),(89,16,5),(90,3,5),(90,4,5),(90,6,5),(90,7,5),(90,9,5),(90,10,5),(90,11,5),(90,12,5),(90,13,5),(90,14,5),(90,15,5),(90,16,5),(91,4,5),(91,7,5),(91,10,5),(91,11,5),(91,12,5),(91,13,5),(91,14,5),(91,15,5),(91,16,5),(92,3,5),(92,4,5),(92,6,5),(92,7,5),(92,9,5),(92,10,5),(92,11,5),(92,12,5),(92,13,5),(92,14,5),(92,15,5),(92,16,5),(93,3,5),(93,4,5),(93,6,5),(93,7,5),(93,9,5),(93,10,5),(93,11,5),(93,12,5),(93,13,5),(93,14,5),(93,15,5),(93,16,5),(94,4,5),(94,7,5),(94,10,5),(94,11,5),(94,12,5),(94,13,5),(94,14,5),(94,15,5),(94,16,5),(95,11,5),(95,12,5),(95,13,5),(95,14,5),(95,15,5),(95,16,5),(96,4,5),(96,7,5),(96,10,5),(96,11,5),(96,12,5),(96,13,5),(96,14,5),(96,15,5),(96,16,5),(97,4,5),(97,7,5),(97,10,5),(97,11,5),(97,12,5),(97,13,5),(97,14,5),(97,15,5),(97,16,5),(98,3,5),(98,4,5),(98,6,5),(98,7,5),(98,9,5),(98,10,5),(98,11,5),(98,12,5),(98,13,5),(98,14,5),(98,15,5),(98,16,5),(99,3,5),(99,4,5),(99,6,5),(99,7,5),(99,9,5),(99,10,5),(99,11,5),(99,12,5),(99,13,5),(99,14,5),(99,15,5),(99,16,5),(100,3,5),(100,4,5),(100,6,5),(100,7,5),(100,9,5),(100,10,5),(100,11,5),(100,12,5),(100,13,5),(100,14,5),(100,15,5),(100,16,5),(101,3,5),(101,4,5),(101,6,5),(101,7,5),(101,9,5),(101,10,5),(101,11,5),(101,12,5),(101,13,5),(101,14,5),(101,15,5),(101,16,5),(102,11,5),(102,12,5),(102,13,5),(102,14,5),(102,15,5),(102,16,5),(103,4,5),(103,7,5),(103,10,5),(103,11,5),(103,12,5),(103,13,5),(103,14,5),(103,15,5),(103,16,5),(104,4,5),(104,7,5),(104,10,5),(104,11,5),(104,12,5),(104,13,5),(104,14,5),(104,15,5),(104,16,5),(105,11,5),(105,12,5),(105,13,5),(105,14,5),(105,15,5),(105,16,5),(106,4,5),(106,7,5),(106,10,5),(106,11,5),(106,12,5),(106,13,5),(106,14,5),(106,15,5),(106,16,5),(107,4,5),(107,7,5),(107,10,5),(107,11,5),(107,12,5),(107,13,5),(107,14,5),(107,15,5),(107,16,5),(108,4,5),(108,7,5),(108,10,5),(108,11,5),(108,12,5),(108,13,5),(108,14,5),(108,15,5),(108,16,5),(109,11,5),(109,12,5),(109,13,5),(109,14,5),(109,15,5),(109,16,5),(110,11,5),(110,12,5),(110,13,5),(110,14,5),(110,15,5),(110,16,5),(111,11,5),(111,12,5),(111,13,5),(111,14,5),(111,15,5),(111,16,5),(112,11,5),(112,12,5),(112,13,5),(112,14,5),(112,15,5),(112,16,5),(113,11,5),(113,12,5),(113,13,5),(113,14,5),(113,15,5),(113,16,5),(114,11,5),(114,12,5),(114,13,5),(114,14,5),(114,15,5),(114,16,5),(115,11,5),(115,12,5),(115,13,5),(115,14,5),(115,15,5),(115,16,5),(116,11,5),(116,12,5),(116,13,5),(116,14,5),(116,15,5),(116,16,5),(117,3,5),(117,4,5),(117,6,5),(117,7,5),(117,9,5),(117,10,5),(117,11,5),(117,12,5),(117,13,5),(117,14,5),(117,15,5),(117,16,5),(118,3,5),(118,4,5),(118,6,5),(118,7,5),(118,9,5),(118,10,5),(118,11,5),(118,12,5),(118,13,5),(118,14,5),(118,15,5),(118,16,5),(119,3,5),(119,4,5),(119,6,5),(119,7,5),(119,9,5),(119,10,5),(119,11,5),(119,12,5),(119,13,5),(119,14,5),(119,15,5),(119,16,5),(120,3,5),(120,4,5),(120,6,5),(120,7,5),(120,9,5),(120,10,5),(120,11,5),(120,12,5),(120,13,5),(120,14,5),(120,15,5),(120,16,5),(121,3,5),(121,4,5),(121,6,5),(121,7,5),(121,9,5),(121,10,5),(121,11,5),(121,12,5),(121,13,5),(121,14,5),(121,15,5),(121,16,5),(122,3,5),(122,4,5),(122,6,5),(122,7,5),(122,9,5),(122,10,5),(122,11,5),(122,12,5),(122,13,5),(122,14,5),(122,15,5),(122,16,5),(123,3,5),(123,4,5),(123,6,5),(123,7,5),(123,9,5),(123,10,5),(123,11,5),(123,12,5),(123,13,5),(123,14,5),(123,15,5),(123,16,5),(124,3,5),(124,6,5),(124,9,5),(124,11,5),(124,12,5),(124,13,5),(124,14,5),(124,15,5),(124,16,5),(125,3,5),(125,4,5),(125,6,5),(125,7,5),(125,9,5),(125,10,5),(125,11,5),(125,12,5),(125,13,5),(125,14,5),(125,15,5),(125,16,5),(126,3,5),(126,4,5),(126,6,5),(126,7,5),(126,9,5),(126,10,5),(126,11,5),(126,12,5),(126,13,5),(126,14,5),(126,15,5),(126,16,5),(127,3,5),(127,4,5),(127,6,5),(127,7,5),(127,9,5),(127,10,5),(127,11,5),(127,12,5),(127,13,5),(127,14,5),(127,15,5),(127,16,5),(128,3,5),(128,6,5),(128,9,5),(128,11,5),(128,12,5),(128,13,5),(128,14,5),(128,15,5),(128,16,5),(129,3,5),(129,4,5),(129,6,5),(129,7,5),(129,9,5),(129,10,5),(129,11,5),(129,12,5),(129,13,5),(129,14,5),(129,15,5),(129,16,5),(130,3,5),(130,4,5),(130,6,5),(130,7,5),(130,9,5),(130,10,5),(130,11,5),(130,12,5),(130,13,5),(130,14,5),(130,15,5),(130,16,5),(131,3,5),(131,4,5),(131,6,5),(131,7,5),(131,9,5),(131,10,5),(131,11,5),(131,12,5),(131,13,5),(131,14,5),(131,15,5),(131,16,5),(132,3,5),(132,4,5),(132,6,5),(132,7,5),(132,9,5),(132,10,5),(132,11,5),(132,12,5),(132,13,5),(132,14,5),(132,15,5),(132,16,5),(133,3,5),(133,6,5),(133,9,5),(133,11,5),(133,12,5),(133,13,5),(133,14,5),(133,15,5),(133,16,5),(134,3,5),(134,4,5),(134,6,5),(134,7,5),(134,9,5),(134,10,5),(134,11,5),(134,12,5),(134,13,5),(134,14,5),(134,15,5),(134,16,5),(135,3,5),(135,4,5),(135,6,5),(135,7,5),(135,9,5),(135,10,5),(135,11,5),(135,12,5),(135,13,5),(135,14,5),(135,15,5),(135,16,5),(136,4,5),(136,7,5),(136,10,5),(136,11,5),(136,12,5),(136,13,5),(136,14,5),(136,15,5),(136,16,5),(137,11,5),(137,12,5),(137,13,5),(137,14,5),(137,15,5),(137,16,5),(138,4,5),(138,7,5),(138,10,5),(138,11,5),(138,12,5),(138,13,5),(138,14,5),(138,15,5),(138,16,5),(139,3,5),(139,4,5),(139,6,5),(139,7,5),(139,9,5),(139,10,5),(139,11,5),(139,12,5),(139,13,5),(139,14,5),(139,15,5),(139,16,5),(140,3,5),(140,4,5),(140,6,5),(140,7,5),(140,9,5),(140,10,5),(140,11,5),(140,12,5),(140,13,5),(140,14,5),(140,15,5),(140,16,5),(141,3,5),(141,4,5),(141,6,5),(141,7,5),(141,9,5),(141,10,5),(141,11,5),(141,12,5),(141,13,5),(141,14,5),(141,15,5),(141,16,5),(142,3,5),(142,4,5),(142,6,5),(142,7,5),(142,9,5),(142,10,5),(142,11,5),(142,12,5),(142,13,5),(142,14,5),(142,15,5),(142,16,5),(143,11,5),(143,12,5),(143,13,5),(143,14,5),(143,15,5),(143,16,5),(144,11,5),(144,12,5),(144,13,5),(144,14,5),(144,15,5),(144,16,5),(145,11,5),(145,12,5),(145,13,5),(145,14,5),(145,15,5),(145,16,5),(146,11,5),(146,12,5),(146,13,5),(146,14,5),(146,15,5),(146,16,5),(147,3,5),(147,4,5),(147,6,5),(147,7,5),(147,9,5),(147,10,5),(147,11,5),(147,12,5),(147,13,5),(147,14,5),(147,15,5),(147,16,5),(148,3,5),(148,4,5),(148,6,5),(148,7,5),(148,9,5),(148,10,5),(148,11,5),(148,12,5),(148,13,5),(148,14,5),(148,15,5),(148,16,5),(149,3,5),(149,4,5),(149,6,5),(149,7,5),(149,9,5),(149,10,5),(149,11,5),(149,12,5),(149,13,5),(149,14,5),(149,15,5),(149,16,5),(150,3,5),(150,4,5),(150,6,5),(150,7,5),(150,9,5),(150,10,5),(150,11,5),(150,12,5),(150,13,5),(150,14,5),(150,15,5),(150,16,5),(151,3,5),(151,4,5),(151,6,5),(151,7,5),(151,9,5),(151,10,5),(151,11,5),(151,12,5),(151,13,5),(151,14,5),(151,15,5),(151,16,5),(152,11,5),(152,12,5),(152,13,5),(152,14,5),(152,15,5),(152,16,5),(153,3,5),(153,4,5),(153,6,5),(153,7,5),(153,9,5),(153,10,5),(153,11,5),(153,12,5),(153,13,5),(153,14,5),(153,15,5),(153,16,5),(154,3,5),(154,4,5),(154,6,5),(154,7,5),(154,9,5),(154,10,5),(154,11,5),(154,12,5),(154,13,5),(154,14,5),(154,15,5),(154,16,5),(155,3,5),(155,4,5),(155,6,5),(155,7,5),(155,9,5),(155,10,5),(155,11,5),(155,12,5),(155,13,5),(155,14,5),(155,15,5),(155,16,5),(156,3,5),(156,4,5),(156,6,5),(156,7,5),(156,9,5),(156,10,5),(156,11,5),(156,12,5),(156,13,5),(156,14,5),(156,15,5),(156,16,5),(157,11,5),(157,12,5),(157,13,5),(157,14,5),(157,15,5),(157,16,5),(158,3,5),(158,4,5),(158,6,5),(158,7,5),(158,9,5),(158,10,5),(158,11,5),(158,12,5),(158,13,5),(158,14,5),(158,15,5),(158,16,5),(159,3,5),(159,4,5),(159,6,5),(159,7,5),(159,9,5),(159,10,5),(159,11,5),(159,12,5),(159,13,5),(159,14,5),(159,15,5),(159,16,5),(160,4,5),(160,7,5),(160,10,5),(160,11,5),(160,12,5),(160,13,5),(160,14,5),(160,15,5),(160,16,5),(161,4,5),(161,7,5),(161,10,5),(161,11,5),(161,12,5),(161,13,5),(161,14,5),(161,15,5),(161,16,5),(162,3,5),(162,4,5),(162,6,5),(162,7,5),(162,9,5),(162,10,5),(162,11,5),(162,12,5),(162,13,5),(162,14,5),(162,15,5),(162,16,5),(163,3,5),(163,4,5),(163,6,5),(163,7,5),(163,9,5),(163,10,5),(163,11,5),(163,12,5),(163,13,5),(163,14,5),(163,15,5),(163,16,5),(164,3,5),(164,4,5),(164,6,5),(164,7,5),(164,9,5),(164,10,5),(164,11,5),(164,12,5),(164,13,5),(164,14,5),(164,15,5),(164,16,5),(165,3,5),(165,4,5),(165,6,5),(165,7,5),(165,9,5),(165,10,5),(165,11,5),(165,12,5),(165,13,5),(165,14,5),(165,15,5),(165,16,5),(166,4,5),(166,7,5),(166,10,5),(166,11,5),(166,12,5),(166,13,5),(166,14,5),(166,15,5),(166,16,5),(167,4,5),(167,7,5),(167,10,5),(167,11,5),(167,12,5),(167,13,5),(167,14,5),(167,15,5),(167,16,5),(168,4,5),(168,7,5),(168,10,5),(168,11,5),(168,12,5),(168,13,5),(168,14,5),(168,15,5),(168,16,5),(169,3,5),(169,4,5),(169,6,5),(169,7,5),(169,9,5),(169,10,5),(169,11,5),(169,12,5),(169,13,5),(169,14,5),(169,15,5),(169,16,5),(170,3,5),(170,4,5),(170,6,5),(170,7,5),(170,9,5),(170,10,5),(170,11,5),(170,12,5),(170,13,5),(170,14,5),(170,15,5),(170,16,5),(171,3,5),(171,4,5),(171,6,5),(171,7,5),(171,9,5),(171,10,5),(171,11,5),(171,12,5),(171,13,5),(171,14,5),(171,15,5),(171,16,5),(172,3,5),(172,4,5),(172,6,5),(172,7,5),(172,9,5),(172,10,5),(172,11,5),(172,12,5),(172,13,5),(172,14,5),(172,15,5),(172,16,5),(173,3,5),(173,4,5),(173,6,5),(173,7,5),(173,9,5),(173,10,5),(173,11,5),(173,12,5),(173,13,5),(173,14,5),(173,15,5),(173,16,5),(174,3,5),(174,4,5),(174,6,5),(174,7,5),(174,9,5),(174,10,5),(174,11,5),(174,12,5),(174,13,5),(174,14,5),(174,15,5),(174,16,5),(175,3,5),(175,4,5),(175,6,5),(175,7,5),(175,9,5),(175,10,5),(175,11,5),(175,12,5),(175,13,5),(175,14,5),(175,15,5),(175,16,5),(176,3,5),(176,4,5),(176,6,5),(176,7,5),(176,9,5),(176,10,5),(176,11,5),(176,12,5),(176,13,5),(176,14,5),(176,15,5),(176,16,5),(177,3,5),(177,4,5),(177,6,5),(177,7,5),(177,9,5),(177,10,5),(177,11,5),(177,12,5),(177,13,5),(177,14,5),(177,15,5),(177,16,5),(178,3,5),(178,4,5),(178,6,5),(178,7,5),(178,9,5),(178,10,5),(178,11,5),(178,12,5),(178,13,5),(178,14,5),(178,15,5),(178,16,5),(179,4,5),(179,7,5),(179,10,5),(179,11,5),(179,12,5),(179,13,5),(179,14,5),(179,15,5),(179,16,5),(180,4,5),(180,7,5),(180,10,5),(180,11,5),(180,12,5),(180,13,5),(180,14,5),(180,15,5),(180,16,5),(181,3,5),(181,4,5),(181,6,5),(181,7,5),(181,9,5),(181,10,5),(181,11,5),(181,12,5),(181,13,5),(181,14,5),(181,15,5),(181,16,5),(182,4,5),(182,7,5),(182,10,5),(182,11,5),(182,12,5),(182,13,5),(182,14,5),(182,15,5),(182,16,5),(183,4,5),(183,7,5),(183,10,5),(183,11,5),(183,12,5),(183,13,5),(183,14,5),(183,15,5),(183,16,5),(184,4,5),(184,7,5),(184,10,5),(184,11,5),(184,12,5),(184,13,5),(184,14,5),(184,15,5),(184,16,5),(185,4,5),(185,7,5),(185,10,5),(185,11,5),(185,12,5),(185,13,5),(185,14,5),(185,15,5),(185,16,5),(186,3,5),(186,4,5),(186,6,5),(186,7,5),(186,9,5),(186,10,5),(186,11,5),(186,12,5),(186,13,5),(186,14,5),(186,15,5),(186,16,5),(187,3,5),(187,4,5),(187,6,5),(187,7,5),(187,9,5),(187,10,5),(187,11,5),(187,12,5),(187,13,5),(187,14,5),(187,15,5),(187,16,5),(188,3,5),(188,4,5),(188,6,5),(188,7,5),(188,9,5),(188,10,5),(188,11,5),(188,12,5),(188,13,5),(188,14,5),(188,15,5),(188,16,5),(189,3,5),(189,4,5),(189,6,5),(189,7,5),(189,9,5),(189,10,5),(189,11,5),(189,12,5),(189,13,5),(189,14,5),(189,15,5),(189,16,5),(190,3,5),(190,4,5),(190,6,5),(190,7,5),(190,9,5),(190,10,5),(190,11,5),(190,12,5),(190,13,5),(190,14,5),(190,15,5),(190,16,5),(191,3,5),(191,4,5),(191,6,5),(191,7,5),(191,9,5),(191,10,5),(191,11,5),(191,12,5),(191,13,5),(191,14,5),(191,15,5),(191,16,5),(192,3,5),(192,4,5),(192,6,5),(192,7,5),(192,9,5),(192,10,5),(192,11,5),(192,12,5),(192,13,5),(192,14,5),(192,15,5),(192,16,5),(193,3,5),(193,4,5),(193,6,5),(193,7,5),(193,9,5),(193,10,5),(193,11,5),(193,12,5),(193,13,5),(193,14,5),(193,15,5),(193,16,5),(194,3,5),(194,4,5),(194,6,5),(194,7,5),(194,9,5),(194,10,5),(194,11,5),(194,12,5),(194,13,5),(194,14,5),(194,15,5),(194,16,5),(195,4,5),(195,7,5),(195,10,5),(195,11,5),(195,12,5),(195,13,5),(195,14,5),(195,15,5),(195,16,5),(196,3,5),(196,4,5),(196,6,5),(196,7,5),(196,9,5),(196,10,5),(196,11,5),(196,12,5),(196,13,5),(196,14,5),(196,15,5),(196,16,5),(197,3,5),(197,4,5),(197,6,5),(197,7,5),(197,9,5),(197,10,5),(197,11,5),(197,12,5),(197,13,5),(197,14,5),(197,15,5),(197,16,5),(198,3,5),(198,4,5),(198,6,5),(198,7,5),(198,9,5),(198,10,5),(198,11,5),(198,12,5),(198,13,5),(198,14,5),(198,15,5),(198,16,5),(199,3,5),(199,4,5),(199,6,5),(199,7,5),(199,9,5),(199,10,5),(199,11,5),(199,12,5),(199,13,5),(199,14,5),(199,15,5),(199,16,5),(200,3,5),(200,4,5),(200,6,5),(200,7,5),(200,9,5),(200,10,5),(200,11,5),(200,12,5),(200,13,5),(200,14,5),(200,15,5),(200,16,5),(201,3,5),(201,4,5),(201,6,5),(201,7,5),(201,9,5),(201,10,5),(201,11,5),(201,12,5),(201,13,5),(201,14,5),(201,15,5),(201,16,5),(202,4,5),(202,7,5),(202,10,5),(202,11,5),(202,12,5),(202,13,5),(202,14,5),(202,15,5),(202,16,5),(203,3,5),(203,4,5),(203,6,5),(203,7,5),(203,9,5),(203,10,5),(203,11,5),(203,12,5),(203,13,5),(203,14,5),(203,15,5),(203,16,5),(204,3,5),(204,4,5),(204,6,5),(204,7,5),(204,9,5),(204,10,5),(204,11,5),(204,12,5),(204,13,5),(204,14,5),(204,15,5),(204,16,5),(205,3,5),(205,4,5),(205,6,5),(205,7,5),(205,9,5),(205,10,5),(205,11,5),(205,12,5),(205,13,5),(205,14,5),(205,15,5),(205,16,5),(206,3,5),(206,6,5),(206,9,5),(206,11,5),(206,12,5),(206,13,5),(206,14,5),(206,15,5),(206,16,5),(207,3,5),(207,4,5),(207,6,5),(207,7,5),(207,9,5),(207,10,5),(207,11,5),(207,12,5),(207,13,5),(207,14,5),(207,15,5),(207,16,5),(208,3,5),(208,4,5),(208,6,5),(208,7,5),(208,9,5),(208,10,5),(208,11,5),(208,12,5),(208,13,5),(208,14,5),(208,15,5),(208,16,5),(209,3,5),(209,4,5),(209,6,5),(209,7,5),(209,9,5),(209,10,5),(209,11,5),(209,12,5),(209,13,5),(209,14,5),(209,15,5),(209,16,5),(210,3,5),(210,4,5),(210,6,5),(210,7,5),(210,9,5),(210,10,5),(210,11,5),(210,12,5),(210,13,5),(210,14,5),(210,15,5),(210,16,5),(211,4,5),(211,7,5),(211,10,5),(211,11,5),(211,12,5),(211,13,5),(211,14,5),(211,15,5),(211,16,5),(212,4,5),(212,7,5),(212,10,5),(212,11,5),(212,12,5),(212,13,5),(212,14,5),(212,15,5),(212,16,5),(213,4,5),(213,7,5),(213,10,5),(213,11,5),(213,12,5),(213,13,5),(213,14,5),(213,15,5),(213,16,5),(214,4,5),(214,7,5),(214,10,5),(214,11,5),(214,12,5),(214,13,5),(214,14,5),(214,15,5),(214,16,5),(215,3,5),(215,4,5),(215,6,5),(215,7,5),(215,9,5),(215,10,5),(215,11,5),(215,12,5),(215,13,5),(215,14,5),(215,15,5),(215,16,5),(216,3,5),(216,4,5),(216,6,5),(216,7,5),(216,9,5),(216,10,5),(216,11,5),(216,12,5),(216,13,5),(216,14,5),(216,15,5),(216,16,5),(217,3,5),(217,4,5),(217,6,5),(217,7,5),(217,9,5),(217,10,5),(217,11,5),(217,12,5),(217,13,5),(217,14,5),(217,15,5),(217,16,5),(218,3,5),(218,4,5),(218,6,5),(218,7,5),(218,9,5),(218,10,5),(218,11,5),(218,12,5),(218,13,5),(218,14,5),(218,15,5),(218,16,5),(219,3,5),(219,6,5),(219,9,5),(219,11,5),(219,12,5),(219,13,5),(219,14,5),(219,15,5),(219,16,5),(220,3,5),(220,4,5),(220,6,5),(220,7,5),(220,9,5),(220,10,5),(220,11,5),(220,12,5),(220,13,5),(220,14,5),(220,15,5),(220,16,5),(221,3,5),(221,4,5),(221,6,5),(221,7,5),(221,9,5),(221,10,5),(221,11,5),(221,12,5),(221,13,5),(221,14,5),(221,15,5),(221,16,5),(222,3,5),(222,4,5),(222,6,5),(222,7,5),(222,9,5),(222,10,5),(222,11,5),(222,12,5),(222,13,5),(222,14,5),(222,15,5),(222,16,5),(223,3,5),(223,4,5),(223,6,5),(223,7,5),(223,9,5),(223,10,5),(223,11,5),(223,12,5),(223,13,5),(223,14,5),(223,15,5),(223,16,5),(224,3,5),(224,6,5),(224,9,5),(224,11,5),(224,12,5),(224,13,5),(224,14,5),(224,15,5),(224,16,5),(225,3,5),(225,4,5),(225,6,5),(225,7,5),(225,9,5),(225,10,5),(225,11,5),(225,12,5),(225,13,5),(225,14,5),(225,15,5),(225,16,5),(226,3,5),(226,6,5),(226,9,5),(226,11,5),(226,12,5),(226,13,5),(226,14,5),(226,15,5),(226,16,5),(227,3,5),(227,4,5),(227,6,5),(227,7,5),(227,9,5),(227,10,5),(227,11,5),(227,12,5),(227,13,5),(227,14,5),(227,15,5),(227,16,5),(228,3,5),(228,4,5),(228,6,5),(228,7,5),(228,9,5),(228,10,5),(228,11,5),(228,12,5),(228,13,5),(228,14,5),(228,15,5),(228,16,5),(229,3,5),(229,6,5),(229,9,5),(229,11,5),(229,12,5),(229,13,5),(229,14,5),(229,15,5),(229,16,5),(230,3,5),(230,4,5),(230,6,5),(230,7,5),(230,9,5),(230,10,5),(230,11,5),(230,12,5),(230,13,5),(230,14,5),(230,15,5),(230,16,5),(231,3,5),(231,4,5),(231,6,5),(231,7,5),(231,9,5),(231,10,5),(231,11,5),(231,12,5),(231,13,5),(231,14,5),(231,15,5),(231,16,5),(232,3,5),(232,4,5),(232,6,5),(232,7,5),(232,9,5),(232,10,5),(232,11,5),(232,12,5),(232,13,5),(232,14,5),(232,15,5),(232,16,5),(233,3,5),(233,4,5),(233,6,5),(233,7,5),(233,9,5),(233,10,5),(233,11,5),(233,12,5),(233,13,5),(233,14,5),(233,15,5),(233,16,5),(234,3,5),(234,4,5),(234,6,5),(234,7,5),(234,9,5),(234,10,5),(234,11,5),(234,12,5),(234,13,5),(234,14,5),(234,15,5),(234,16,5),(235,3,5),(235,4,5),(235,6,5),(235,7,5),(235,9,5),(235,10,5),(235,11,5),(235,12,5),(235,13,5),(235,14,5),(235,15,5),(235,16,5),(236,3,5),(236,4,5),(236,6,5),(236,7,5),(236,9,5),(236,10,5),(236,11,5),(236,12,5),(236,13,5),(236,14,5),(236,15,5),(236,16,5),(237,3,5),(237,4,5),(237,6,5),(237,7,5),(237,9,5),(237,10,5),(237,11,5),(237,12,5),(237,13,5),(237,14,5),(237,15,5),(237,16,5),(238,3,5),(238,4,5),(238,6,5),(238,7,5),(238,9,5),(238,10,5),(238,11,5),(238,12,5),(238,13,5),(238,14,5),(238,15,5),(238,16,5),(239,3,5),(239,4,5),(239,6,5),(239,7,5),(239,9,5),(239,10,5),(239,11,5),(239,12,5),(239,13,5),(239,14,5),(239,15,5),(239,16,5),(240,3,5),(240,4,5),(240,6,5),(240,7,5),(240,9,5),(240,10,5),(240,11,5),(240,12,5),(240,13,5),(240,14,5),(240,15,5),(240,16,5),(241,3,5),(241,4,5),(241,6,5),(241,7,5),(241,9,5),(241,10,5),(241,11,5),(241,12,5),(241,13,5),(241,14,5),(241,15,5),(241,16,5),(242,3,5),(242,4,5),(242,6,5),(242,7,5),(242,9,5),(242,10,5),(242,11,5),(242,12,5),(242,13,5),(242,14,5),(242,15,5),(242,16,5),(243,3,5),(243,4,5),(243,6,5),(243,7,5),(243,9,5),(243,10,5),(243,11,5),(243,12,5),(243,13,5),(243,14,5),(243,15,5),(243,16,5),(244,3,5),(244,4,5),(244,6,5),(244,7,5),(244,9,5),(244,10,5),(244,11,5),(244,12,5),(244,13,5),(244,14,5),(244,15,5),(244,16,5),(245,3,5),(245,4,5),(245,6,5),(245,7,5),(245,9,5),(245,10,5),(245,11,5),(245,12,5),(245,13,5),(245,14,5),(245,15,5),(245,16,5),(246,3,5),(246,4,5),(246,6,5),(246,7,5),(246,9,5),(246,10,5),(246,11,5),(246,12,5),(246,13,5),(246,14,5),(246,15,5),(246,16,5),(247,3,5),(247,4,5),(247,6,5),(247,7,5),(247,9,5),(247,10,5),(247,11,5),(247,12,5),(247,13,5),(247,14,5),(247,15,5),(247,16,5),(248,3,5),(248,4,5),(248,6,5),(248,7,5),(248,9,5),(248,10,5),(248,11,5),(248,12,5),(248,13,5),(248,14,5),(248,15,5),(248,16,5),(249,3,5),(249,4,5),(249,6,5),(249,7,5),(249,9,5),(249,10,5),(249,11,5),(249,12,5),(249,13,5),(249,14,5),(249,15,5),(249,16,5),(250,3,5),(250,4,5),(250,6,5),(250,7,5),(250,9,5),(250,10,5),(250,11,5),(250,12,5),(250,13,5),(250,14,5),(250,15,5),(250,16,5),(251,3,5),(251,4,5),(251,6,5),(251,7,5),(251,9,5),(251,10,5),(251,11,5),(251,12,5),(251,13,5),(251,14,5),(251,15,5),(251,16,5),(252,3,5),(252,4,5),(252,6,5),(252,7,5),(252,9,5),(252,10,5),(252,11,5),(252,12,5),(252,13,5),(252,14,5),(252,15,5),(252,16,5),(253,3,5),(253,4,5),(253,6,5),(253,7,5),(253,9,5),(253,10,5),(253,11,5),(253,12,5),(253,13,5),(253,14,5),(253,15,5),(253,16,5),(254,3,5),(254,4,5),(254,6,5),(254,7,5),(254,9,5),(254,10,5),(254,11,5),(254,12,5),(254,13,5),(254,14,5),(254,15,5),(254,16,5),(255,3,5),(255,4,5),(255,6,5),(255,7,5),(255,9,5),(255,10,5),(255,11,5),(255,12,5),(255,13,5),(255,14,5),(255,15,5),(255,16,5),(256,3,5),(256,4,5),(256,6,5),(256,7,5),(256,9,5),(256,10,5),(256,11,5),(256,12,5),(256,13,5),(256,14,5),(256,15,5),(256,16,5),(257,3,5),(257,4,5),(257,6,5),(257,7,5),(257,9,5),(257,10,5),(257,11,5),(257,12,5),(257,13,5),(257,14,5),(257,15,5),(257,16,5),(258,3,5),(258,4,5),(258,6,5),(258,7,5),(258,9,5),(258,10,5),(258,11,5),(258,12,5),(258,13,5),(258,14,5),(258,15,5),(258,16,5),(259,3,5),(259,4,5),(259,6,5),(259,7,5),(259,9,5),(259,10,5),(259,11,5),(259,12,5),(259,13,5),(259,14,5),(259,15,5),(259,16,5),(260,3,5),(260,4,5),(260,6,5),(260,7,5),(260,9,5),(260,10,5),(260,11,5),(260,12,5),(260,13,5),(260,14,5),(260,15,5),(260,16,5),(261,3,5),(261,4,5),(261,6,5),(261,7,5),(261,9,5),(261,10,5),(261,11,5),(261,12,5),(261,13,5),(261,14,5),(261,15,5),(261,16,5),(262,3,5),(262,4,5),(262,6,5),(262,7,5),(262,9,5),(262,10,5),(262,11,5),(262,12,5),(262,13,5),(262,14,5),(262,15,5),(262,16,5),(263,3,5),(263,4,5),(263,6,5),(263,7,5),(263,9,5),(263,10,5),(263,11,5),(263,12,5),(263,13,5),(263,14,5),(263,15,5),(263,16,5),(264,3,5),(264,4,5),(264,6,5),(264,7,5),(264,9,5),(264,10,5),(264,11,5),(264,12,5),(264,13,5),(264,14,5),(264,15,5),(264,16,5),(265,3,5),(265,4,5),(265,6,5),(265,7,5),(265,9,5),(265,10,5),(265,11,5),(265,12,5),(265,13,5),(265,14,5),(265,15,5),(265,16,5),(266,3,5),(266,4,5),(266,6,5),(266,7,5),(266,9,5),(266,10,5),(266,11,5),(266,12,5),(266,13,5),(266,14,5),(266,15,5),(266,16,5),(267,3,5),(267,4,5),(267,6,5),(267,7,5),(267,9,5),(267,10,5),(267,11,5),(267,12,5),(267,13,5),(267,14,5),(267,15,5),(267,16,5),(268,3,5),(268,4,5),(268,6,5),(268,7,5),(268,9,5),(268,10,5),(268,11,5),(268,12,5),(268,13,5),(268,14,5),(268,15,5),(268,16,5),(269,3,5),(269,4,5),(269,6,5),(269,7,5),(269,9,5),(269,10,5),(269,11,5),(269,12,5),(269,13,5),(269,14,5),(269,15,5),(269,16,5),(270,3,5),(270,6,5),(270,9,5),(270,11,5),(270,12,5),(270,13,5),(270,14,5),(270,15,5),(270,16,5),(271,3,5),(271,4,5),(271,6,5),(271,7,5),(271,9,5),(271,10,5),(271,11,5),(271,12,5),(271,13,5),(271,14,5),(271,15,5),(271,16,5),(272,3,5),(272,4,5),(272,6,5),(272,7,5),(272,9,5),(272,10,5),(272,11,5),(272,12,5),(272,13,5),(272,14,5),(272,15,5),(272,16,5),(273,3,5),(273,4,5),(273,6,5),(273,7,5),(273,9,5),(273,10,5),(273,11,5),(273,12,5),(273,13,5),(273,14,5),(273,15,5),(273,16,5),(274,3,5),(274,4,5),(274,6,5),(274,7,5),(274,9,5),(274,10,5),(274,11,5),(274,12,5),(274,13,5),(274,14,5),(274,15,5),(274,16,5),(275,3,5),(275,4,5),(275,6,5),(275,7,5),(275,9,5),(275,10,5),(275,11,5),(275,12,5),(275,13,5),(275,14,5),(275,15,5),(275,16,5),(276,3,5),(276,4,5),(276,6,5),(276,7,5),(276,9,5),(276,10,5),(276,11,5),(276,12,5),(276,13,5),(276,14,5),(276,15,5),(276,16,5);
/*!40000 ALTER TABLE `permission_role` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permission_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `permission_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permission_types` WRITE;
/*!40000 ALTER TABLE `permission_types` DISABLE KEYS */;
INSERT INTO `permission_types` VALUES (1,'added',NULL,NULL),(2,'owned',NULL,NULL),(3,'both',NULL,NULL),(4,'all',NULL,NULL),(5,'none',NULL,NULL);
/*!40000 ALTER TABLE `permission_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `permissions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_custom` tinyint(1) NOT NULL DEFAULT '0',
  `allowed_permissions` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_module_id_unique` (`name`,`module_id`),
  KEY `permissions_module_id_foreign` (`module_id`),
  CONSTRAINT `permissions_module_id_foreign` FOREIGN KEY (`module_id`) REFERENCES `modules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=277 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'add_clients','Add Clients',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"none\":5}'),(2,'view_clients','View Clients',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"none\":5}'),(3,'edit_clients','Edit Clients',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"none\":5}'),(4,'delete_clients','Delete Clients',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"none\":5}'),(5,'manage_client_category','Manage Client Category',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(6,'manage_client_subcategory','Manage Client Subcategory',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(7,'add_client_contacts','Add Client Contacts',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(8,'view_client_contacts','View Client Contacts',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(9,'edit_client_contacts','Edit Client Contacts',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(10,'delete_client_contacts','Delete Client Contacts',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(11,'add_client_note','Add Client Note',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(12,'view_client_note','View Client Note',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(13,'edit_client_note','Edit Client Note',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(14,'delete_client_note','Delete Client Note',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(15,'add_client_document','Add Client Document',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(16,'view_client_document','View Client Document',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(17,'edit_client_document','Edit Client Document',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(18,'delete_client_document','Delete Client Document',NULL,1,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(19,'add_employees','Add Employees',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"none\":5}'),(20,'view_employees','View Employees',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(21,'edit_employees','Edit Employees',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(22,'delete_employees','Delete Employees',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"none\":5}'),(23,'add_designation','Add Designation',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(24,'view_designation','View Designation',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(25,'edit_designation','Edit Designation',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(26,'delete_designation','Delete Designation',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(27,'add_department','Add Department',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(28,'view_department','View Department',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(29,'edit_department','Edit Department',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(30,'delete_department','Delete Department',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(31,'add_documents','Add Documents',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(32,'view_documents','View Documents',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(33,'edit_documents','Edit Documents',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(34,'delete_documents','Delete Documents',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(35,'view_leaves_taken','View Leaves Taken',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(36,'update_leaves_quota','Update Leaves Quota',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(37,'view_employee_tasks','View Employee Tasks',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(38,'view_employee_projects','View Employee Projects',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(39,'view_employee_timelogs','View Employee Timelogs',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(40,'change_employee_role','Change Employee Role',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(41,'manage_emergency_contact','Manage Emergency Contact',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(42,'manage_award','Manage Award',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(43,'add_appreciation','Add Appreciation',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(44,'view_appreciation','View Appreciation',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(45,'edit_appreciation','Edit Appreciation',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(46,'delete_appreciation','Delete Appreciation',NULL,2,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(47,'add_projects','Add Projects',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"none\":5}'),(48,'view_projects','View Projects',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(49,'edit_projects','Edit Projects',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(50,'delete_projects','Delete Projects',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(51,'manage_project_category','Manage Project Category',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(52,'view_project_files','View Project Files',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(53,'add_project_files','Add Project Files',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(54,'delete_project_files','Delete Project Files',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(55,'view_project_discussions','View Project Discussions',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(56,'add_project_discussions','Add Project Discussions',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(57,'edit_project_discussions','Edit Project Discussions',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(58,'delete_project_discussions','Delete Project Discussions',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(59,'manage_discussion_category','Manage Discussion Category',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(60,'view_project_milestones','View Project Milestones',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2, \"none\":5}'),(61,'add_project_milestones','Add Project Milestones',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(62,'edit_project_milestones','Edit Project Milestones',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2, \"none\":5}'),(63,'delete_project_milestones','Delete Project Milestones',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2, \"none\":5}'),(64,'view_project_members','View Project Members',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(65,'add_project_members','Add Project Members',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(66,'edit_project_members','Edit Project Members',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(67,'delete_project_members','Delete Project Members',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(68,'view_project_rating','View Project Rating',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(69,'add_project_rating','Add Project Rating',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(70,'edit_project_rating','Edit Project Rating',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(71,'delete_project_rating','Delete Project Rating',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(72,'view_project_budget','View Project Budget',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(73,'view_project_timelogs','View Project Timelogs',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(74,'view_project_expenses','View Project Expenses',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(75,'view_project_tasks','View Project Tasks',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(76,'view_project_invoices','View Project Invoices',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(77,'view_project_burndown_chart','View Project Burndown Chart',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(78,'view_project_payments','View Project Payments',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(79,'view_project_gantt_chart','View Project Gantt Chart',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(80,'add_project_note','Add Project Note',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(81,'view_project_note','View Project Note',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(82,'edit_project_note','Edit Project Note',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(83,'delete_project_note','Delete Project Note',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(84,'manage_project_template','Manage Project Template',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(85,'view_project_hourly_rates','View Project Hourly Rates',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(86,'create_public_project','Create Public Project',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(87,'view_miroboard','View Miroboard',NULL,3,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(88,'manage_employee_shifts','Manage Employee Shifts',NULL,4,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(89,'view_shift_roster','View Shift Roster',NULL,4,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"owned\":2, \"none\":5}'),(90,'add_attendance','Add Attendance',NULL,4,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"none\":5}'),(91,'view_attendance','View Attendance',NULL,4,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(92,'edit_attendance','Edit Attendance',NULL,4,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(93,'delete_attendance','Delete Attendance',NULL,4,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(94,'add_tasks','Add Tasks',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"none\":5}'),(95,'view_tasks','View Tasks',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(96,'edit_tasks','Edit Tasks',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(97,'delete_tasks','Delete Tasks',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(98,'view_task_category','View Task Category',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(99,'add_task_category','Add Task Category',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(100,'edit_task_category','Edit Task Category',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(101,'delete_task_category','Delete Task Category',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(102,'view_task_files','View Task Files',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(103,'add_task_files','Add Task Files',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(104,'delete_task_files','Delete Task Files',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(105,'view_sub_tasks','View Sub Tasks',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(106,'add_sub_tasks','Add Sub Tasks',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(107,'edit_sub_tasks','Edit Sub Tasks',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(108,'delete_sub_tasks','Delete Sub Tasks',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(109,'view_task_comments','View Task Comments',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(110,'add_task_comments','Add Task Comments',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(111,'edit_task_comments','Edit Task Comments',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(112,'delete_task_comments','Delete Task Comments',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(113,'view_task_notes','View Task Notes',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(114,'add_task_notes','Add Task Notes',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(115,'edit_task_notes','Edit Task Notes',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(116,'delete_task_notes','Delete Task Notes',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(117,'task_labels','Task Labels',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(118,'change_status','Change Status',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(119,'send_reminder','Send Reminder',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(120,'add_status','Add Status',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(121,'view_unassigned_tasks','View Unassigned Tasks',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(122,'create_unassigned_tasks','Create Unassigned Tasks',NULL,5,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(123,'add_estimates','Add Estimates',NULL,6,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"none\":5}'),(124,'view_estimates','View Estimates',NULL,6,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(125,'edit_estimates','Edit Estimates',NULL,6,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(126,'delete_estimates','Delete Estimates',NULL,6,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(127,'add_invoices','Add Invoices',NULL,7,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"none\":5}'),(128,'view_invoices','View Invoices',NULL,7,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(129,'edit_invoices','Edit Invoices',NULL,7,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(130,'delete_invoices','Delete Invoices',NULL,7,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(131,'manage_tax','Manage Tax',NULL,7,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(132,'add_payments','Add Payments',NULL,8,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"none\":5}'),(133,'view_payments','View Payments',NULL,8,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(134,'edit_payments','Edit Payments',NULL,8,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(135,'delete_payments','Delete Payments',NULL,8,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(136,'add_timelogs','Add Timelogs',NULL,9,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4,\"added\":1, \"none\":5}'),(137,'view_timelogs','View Timelogs',NULL,9,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(138,'edit_timelogs','Edit Timelogs',NULL,9,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(139,'delete_timelogs','Delete Timelogs',NULL,9,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(140,'approve_timelogs','Approve Timelogs',NULL,9,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(141,'manage_active_timelogs','Manage Active Timelogs',NULL,9,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(142,'view_timelog_earnings','View Timelog Earnings',NULL,9,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(143,'add_tickets','Add Tickets',NULL,10,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4,\"added\":1, \"none\":5}'),(144,'view_tickets','View Tickets',NULL,10,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(145,'edit_tickets','Edit Tickets',NULL,10,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(146,'delete_tickets','Delete Tickets',NULL,10,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(147,'manage_ticket_type','Manage Ticket Type',NULL,10,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(148,'manage_ticket_agent','Manage Ticket Agent',NULL,10,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(149,'manage_ticket_channel','Manage Ticket Channel',NULL,10,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(150,'manage_ticket_tags','Manage Ticket Tags',NULL,10,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(151,'add_events','Add Events',NULL,11,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"none\":5}'),(152,'view_events','View Events',NULL,11,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(153,'edit_events','Edit Events',NULL,11,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(154,'delete_events','Delete Events',NULL,11,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(155,'manage_recurring_invoice','Manage Recurring Invoice',NULL,11,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(156,'add_notice','Add Notice',NULL,12,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"none\":5}'),(157,'view_notice','View Notice',NULL,12,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(158,'edit_notice','Edit Notice',NULL,12,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(159,'delete_notice','Delete Notice',NULL,12,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(160,'add_leave','Add Leave',NULL,13,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"none\":5}'),(161,'view_leave','View Leave',NULL,13,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(162,'edit_leave','Edit Leave',NULL,13,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(163,'delete_leave','Delete Leave',NULL,13,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(164,'approve_or_reject_leaves','Approve Or Reject Leaves',NULL,13,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(165,'delete_approve_leaves','Delete Approve Leaves',NULL,13,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(166,'add_lead','Add Lead',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"none\":5}'),(167,'view_lead','View Lead',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(168,'edit_lead','Edit Lead',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(169,'delete_lead','Delete Lead',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(170,'view_lead_agents','View Lead Agents',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(171,'add_lead_agent','Add Lead Agent',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(172,'edit_lead_agent','Edit Lead Agent',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(173,'delete_lead_agent','Delete Lead Agent',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(174,'view_lead_category','View Lead Category',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(175,'add_lead_category','Add Lead Category',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(176,'edit_lead_category','Edit Lead Category',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(177,'delete_lead_category','Delete Lead Category',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(178,'manage_lead_custom_forms','Manage Lead Custom Forms',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(179,'view_lead_files','View Lead Files',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(180,'add_lead_files','Add Lead Files',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(181,'delete_lead_files','Delete Lead Files',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(182,'view_lead_follow_up','View Lead Follow Up',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(183,'add_lead_follow_up','Add Lead Follow Up',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(184,'edit_lead_follow_up','Edit Lead Follow Up',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(185,'delete_lead_follow_up','Delete Lead Follow Up',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(186,'view_lead_sources','View Lead Sources',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(187,'add_lead_sources','Add Lead Sources',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(188,'edit_lead_sources','Edit Lead Sources',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(189,'delete_lead_sources','Delete Lead Sources',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(190,'view_lead_proposals','View Lead Proposals',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(191,'add_lead_proposals','Add Lead Proposals',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(192,'edit_lead_proposals','Edit Lead Proposals',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(193,'delete_lead_proposals','Delete Lead Proposals',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(194,'manage_proposal_template','Manage Proposal Template',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(195,'change_lead_status','Change Lead Status',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(196,'add_lead_note','Add Lead Note',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(197,'view_lead_note','View Lead Note',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(198,'edit_lead_note','Edit Lead Note',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(199,'delete_lead_note','Delete Lead Note',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(200,'manage_lead_status','Manage Lead Status',NULL,14,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(201,'add_holiday','Add Holiday',NULL,15,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"none\":5}'),(202,'view_holiday','View Holiday',NULL,15,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"none\":5}'),(203,'edit_holiday','Edit Holiday',NULL,15,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"none\":5}'),(204,'delete_holiday','Delete Holiday',NULL,15,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"none\":5}'),(205,'add_product','Add Product',NULL,16,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"none\":5}'),(206,'view_product','View Product',NULL,16,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"none\":5}'),(207,'edit_product','Edit Product',NULL,16,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"none\":5}'),(208,'delete_product','Delete Product',NULL,16,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"none\":5}'),(209,'manage_product_category','Manage Product Category',NULL,16,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(210,'manage_product_sub_category','Manage Product Sub Category',NULL,16,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(211,'add_expenses','Add Expenses',NULL,17,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"none\":5}'),(212,'view_expenses','View Expenses',NULL,17,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(213,'edit_expenses','Edit Expenses',NULL,17,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(214,'delete_expenses','Delete Expenses',NULL,17,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(215,'manage_expense_category','Manage Expense Category',NULL,17,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(216,'manage_recurring_expense','Manage Recurring Expense',NULL,17,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(217,'approve_expenses','Approve Expenses',NULL,17,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(218,'add_contract','Add Contract',NULL,18,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"none\":5}'),(219,'view_contract','View Contract',NULL,18,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(220,'edit_contract','Edit Contract',NULL,18,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(221,'delete_contract','Delete Contract',NULL,18,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(222,'manage_contract_type','Manage Contract Type',NULL,18,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(223,'renew_contract','Renew Contract',NULL,18,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(224,'add_contract_discussion','Add Contract Discussion',NULL,18,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(225,'edit_contract_discussion','Edit Contract Discussion',NULL,18,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(226,'view_contract_discussion','View Contract Discussion',NULL,18,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(227,'delete_contract_discussion','Delete Contract Discussion',NULL,18,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(228,'add_contract_files','Add Contract Files',NULL,18,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(229,'view_contract_files','View Contract Files',NULL,18,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(230,'delete_contract_files','Delete Contract Files',NULL,18,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(231,'manage_contract_template','Manage Contract Template',NULL,18,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"none\":5}'),(232,'view_task_report','View Task Report',NULL,19,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(233,'view_time_log_report','View Time Log Report',NULL,19,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(234,'view_finance_report','View Finance Report',NULL,19,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(235,'view_income_expense_report','View Income Vs Expense Report',NULL,19,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(236,'view_leave_report','View Leave Report',NULL,19,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(237,'view_attendance_report','View Attendance Report',NULL,19,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(238,'view_expense_report','View Expense Report',NULL,19,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(239,'manage_company_setting','Manage Company Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(240,'manage_app_setting','Manage App Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(241,'manage_notification_setting','Manage Notification Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(242,'manage_currency_setting','Manage Currency Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(243,'manage_payment_setting','Manage Payment Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(244,'manage_finance_setting','Manage Finance Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(245,'manage_ticket_setting','Manage Ticket Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(246,'manage_project_setting','Manage Project Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(247,'manage_attendance_setting','Manage Attendance Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(248,'manage_leave_setting','Manage Leave Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(249,'manage_custom_field_setting','Manage Custom Field Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(250,'manage_message_setting','Manage Message Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(251,'manage_storage_setting','Manage Storage Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(252,'manage_language_setting','Manage Language Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(253,'manage_lead_setting','Manage Lead Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(254,'manage_time_log_setting','Manage Time Log Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(255,'manage_task_setting','Manage Task Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(256,'manage_social_login_setting','Manage Social Login Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(257,'manage_security_setting','Manage Security Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(258,'manage_gdpr_setting','Manage Gdpr Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(259,'manage_theme_setting','Manage Theme Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(260,'manage_role_permission_setting','Manage Role Permission Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(261,'manage_module_setting','Manage Module Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(262,'manage_google_calendar_setting','Manage Google Calendar Setting',NULL,20,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(263,'view_overview_dashboard','View Overview Dashboard',NULL,21,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(264,'view_project_dashboard','View Project Dashboard',NULL,21,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(265,'view_client_dashboard','View Client Dashboard',NULL,21,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(266,'view_hr_dashboard','View Hr Dashboard',NULL,21,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(267,'view_ticket_dashboard','View Ticket Dashboard',NULL,21,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(268,'view_finance_dashboard','View Finance Dashboard',NULL,21,'2022-10-28 07:30:07','2022-10-28 07:30:07',1,'{\"all\":4, \"none\":5}'),(269,'add_order','Add Order',NULL,22,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"none\":5}'),(270,'view_order','View Order',NULL,22,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(271,'edit_order','Edit Order',NULL,22,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(272,'delete_order','Delete Order',NULL,22,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"added\":1, \"owned\":2,\"both\":3, \"none\":5}'),(273,'add_knowledgebase','Add Knowledgebase',NULL,23,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4, \"none\":5}'),(274,'view_knowledgebase','View Knowledgebase',NULL,23,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4,\"added\":1,\"none\":5}'),(275,'edit_knowledgebase','Edit Knowledgebase',NULL,23,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4,\"added\":1,\"none\":5}'),(276,'delete_knowledgebase','Delete Knowledgebase',NULL,23,'2022-10-28 07:30:07','2022-10-28 07:30:07',0,'{\"all\":4,\"added\":1,\"none\":5}');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pinned`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pinned` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `task_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pinned_project_id_foreign` (`project_id`),
  KEY `pinned_task_id_foreign` (`task_id`),
  KEY `pinned_user_id_foreign` (`user_id`),
  KEY `pinned_company_id_foreign` (`company_id`),
  CONSTRAINT `pinned_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `pinned_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `pinned_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `pinned_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pinned` WRITE;
/*!40000 ALTER TABLE `pinned` DISABLE KEYS */;
/*!40000 ALTER TABLE `pinned` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_category` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_category_company_id_foreign` (`company_id`),
  CONSTRAINT `product_category_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_category` WRITE;
/*!40000 ALTER TABLE `product_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_category` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `product_id` int unsigned NOT NULL,
  `filename` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_files_product_id_foreign` (`product_id`),
  KEY `product_files_added_by_foreign` (`added_by`),
  KEY `product_files_last_updated_by_foreign` (`last_updated_by`),
  KEY `product_files_company_id_foreign` (`company_id`),
  CONSTRAINT `product_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `product_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `product_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `product_files_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_files` WRITE;
/*!40000 ALTER TABLE `product_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_sub_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_sub_category` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_id` bigint unsigned NOT NULL,
  `category_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_sub_category_category_id_foreign` (`category_id`),
  KEY `product_sub_category_company_id_foreign` (`company_id`),
  CONSTRAINT `product_sub_category_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `product_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `product_sub_category_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_sub_category` WRITE;
/*!40000 ALTER TABLE `product_sub_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_sub_category` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `taxes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allow_purchase` tinyint(1) NOT NULL DEFAULT '0',
  `downloadable` tinyint(1) NOT NULL DEFAULT '0',
  `downloadable_file` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `category_id` bigint unsigned DEFAULT NULL,
  `sub_category_id` bigint unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_added_by_foreign` (`added_by`),
  KEY `products_last_updated_by_foreign` (`last_updated_by`),
  KEY `products_company_id_foreign` (`company_id`),
  CONSTRAINT `products_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `product_category` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `products_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `products_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `product_sub_category` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,1,'Live Meeting','996',NULL,1,0,NULL,'Sit quis tempora aut. Quos quia architecto cum placeat facilis aut totam reprehenderit. Quia quia consequuntur ut ut repudiandae.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(2,1,'Document management System','707',NULL,1,0,NULL,'At temporibus autem voluptatum animi hic unde amet sint. Saepe consequatur hic voluptas. Ipsum totam debitis rem quas sequi amet ipsum.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(3,1,'User Management','239',NULL,1,0,NULL,'Et tenetur est aut officia sunt libero et. Possimus est dolore iure enim. Est magnam expedita voluptas sunt provident.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(4,1,'Restaurant Management','761',NULL,1,0,NULL,'Dolorem voluptate saepe tempore exercitationem. Laboriosam quod quia consequatur qui quibusdam a. Asperiores sit non blanditiis doloremque quos voluptas labore ratione.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(5,1,'Tars','976',NULL,1,0,NULL,'Voluptatem qui ratione veritatis quod. Impedit eum nulla id velit magnam qui iure corporis. Inventore voluptate error et voluptatum quis recusandae voluptates.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(6,2,'Server Installation','238',NULL,1,0,NULL,'Enim explicabo distinctio quae suscipit labore dolorem saepe. Assumenda at itaque eius dolor adipisci possimus.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(7,2,'Airline Reservation System','721',NULL,1,0,NULL,'Veritatis provident ratione dolor. Mollitia ratione alias qui ab. Amet deserunt aliquid nihil qui distinctio.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(8,2,'Chat Application','658',NULL,1,0,NULL,'Iure maxime saepe enim qui voluptas exercitationem ab. Beatae ratione animi est exercitationem. Corrupti veniam et inventore esse nostrum consequatur. Numquam sunt omnis debitis similique excepturi fugiat perferendis.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(9,2,'Cinema Ticket Booking System','413',NULL,1,0,NULL,'Molestias fuga ducimus magni aut dolorem quo vero. Dignissimos voluptatum mollitia cumque fugit rerum. Ut non qui et qui.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(10,2,'Project Management','819',NULL,1,0,NULL,'Nostrum sapiente nesciunt ea qui. Doloribus quisquam exercitationem quia commodi excepturi quia. Voluptas sed repellat sed.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:16','2022-10-28 07:30:16'),(11,3,'Document management System','372',NULL,1,0,NULL,'Quia ut maxime et corrupti officiis id. Quo sed aperiam aperiam similique omnis iure. Debitis consectetur sed ut enim reprehenderit temporibus debitis.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(12,3,'Identification System','505',NULL,1,0,NULL,'Vel sed sit vitae ut ipsum quaerat vero. Sed aliquam vel facilis alias. Quis sit et sunt vel. Molestiae aut nostrum provident non voluptates id.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(13,3,'Tars','615',NULL,1,0,NULL,'Neque recusandae reiciendis ut odit aut optio aliquid. Voluptatem vitae et ut perferendis laboriosam. Delectus accusamus alias magni saepe eveniet quidem quibusdam. Officia et illum culpa rerum tempora placeat.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(14,3,'Chat Application','297',NULL,1,0,NULL,'Distinctio a suscipit omnis minus beatae aut voluptatem veniam. Illo dignissimos unde quia. Repudiandae mollitia culpa eos quo animi.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(15,3,'Chat Application','719',NULL,1,0,NULL,'Ab repudiandae veniam similique aperiam culpa qui. Aut molestiae nostrum blanditiis veritatis eaque. Tempora id consequatur odit magnam est. Odit sint consequuntur at fuga dignissimos laborum quam. Eos placeat ipsam ipsa quod.',NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_activity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_activity` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int unsigned NOT NULL,
  `activity` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_activity_project_id_foreign` (`project_id`),
  KEY `project_activity_created_at_index` (`created_at`),
  CONSTRAINT `project_activity_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_activity` WRITE;
/*!40000 ALTER TABLE `project_activity` DISABLE KEYS */;
INSERT INTO `project_activity` VALUES (1,1,'Install Application added as new project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(2,1,'New member added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(3,1,'New task added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(4,2,'Identification System added as new project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(5,2,'New member added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(6,2,'New member added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(7,2,'New task added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(8,2,'New task added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(9,3,'Create Design Of Worksuite added as new project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(10,3,'New member added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(11,3,'New member added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(12,3,'New member added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(13,3,'New member added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(14,3,'New member added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(15,3,'New task added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(16,3,'New task added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(17,3,'New task added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(18,3,'New task added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(19,3,'New task added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(20,4,'User Management added as new project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(21,4,'New member added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(22,4,'New member added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(23,4,'New member added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(24,4,'New member added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(25,4,'New member added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(26,4,'New task added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(27,4,'New task added to the project.','2022-10-28 07:30:11','2022-10-28 07:30:11'),(28,4,'New task added to the project.','2022-10-28 07:30:12','2022-10-28 07:30:12'),(29,4,'New task added to the project.','2022-10-28 07:30:12','2022-10-28 07:30:12'),(30,4,'New task added to the project.','2022-10-28 07:30:12','2022-10-28 07:30:12'),(31,5,'User Management added as new project.','2022-10-28 07:30:12','2022-10-28 07:30:12'),(32,5,'New member added to the project.','2022-10-28 07:30:12','2022-10-28 07:30:12'),(33,5,'New member added to the project.','2022-10-28 07:30:12','2022-10-28 07:30:12'),(34,5,'New member added to the project.','2022-10-28 07:30:12','2022-10-28 07:30:12'),(35,5,'New member added to the project.','2022-10-28 07:30:12','2022-10-28 07:30:12'),(36,5,'New member added to the project.','2022-10-28 07:30:12','2022-10-28 07:30:12'),(37,5,'New task added to the project.','2022-10-28 07:30:12','2022-10-28 07:30:12'),(38,5,'New task added to the project.','2022-10-28 07:30:12','2022-10-28 07:30:12'),(39,5,'New task added to the project.','2022-10-28 07:30:12','2022-10-28 07:30:12'),(40,5,'New task added to the project.','2022-10-28 07:30:12','2022-10-28 07:30:12'),(41,5,'New task added to the project.','2022-10-28 07:30:12','2022-10-28 07:30:12'),(42,6,'Identification System added as new project.','2022-10-28 07:30:14','2022-10-28 07:30:14'),(43,6,'New member added to the project.','2022-10-28 07:30:14','2022-10-28 07:30:14'),(44,6,'New member added to the project.','2022-10-28 07:30:14','2022-10-28 07:30:14'),(45,6,'New member added to the project.','2022-10-28 07:30:14','2022-10-28 07:30:14'),(46,6,'New member added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(47,6,'New member added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(48,6,'New task added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(49,6,'New task added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(50,6,'New task added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(51,6,'New task added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(52,6,'New task added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(53,7,'Restaurant Management added as new project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(54,7,'New member added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(55,7,'New task added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(56,8,'Project Management added as new project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(57,8,'New member added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(58,8,'New member added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(59,8,'New member added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(60,8,'New member added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(61,8,'New task added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(62,8,'New task added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(63,8,'New task added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(64,8,'New task added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(65,9,'Document Management System added as new project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(66,9,'New member added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(67,9,'New member added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(68,9,'New task added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(69,9,'New task added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(70,10,'Document Management System added as new project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(71,10,'New member added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(72,10,'New member added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(73,10,'New member added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(74,10,'New task added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(75,10,'New task added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(76,10,'New task added to the project.','2022-10-28 07:30:15','2022-10-28 07:30:15'),(77,11,'Live Meeting added as new project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(78,11,'New member added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(79,11,'New member added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(80,11,'New member added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(81,11,'New task added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(82,11,'New task added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(83,11,'New task added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(84,12,'Install Application added as new project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(85,12,'New member added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(86,12,'New member added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(87,12,'New member added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(88,12,'New task added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(89,12,'New task added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(90,12,'New task added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(91,13,'Project Management added as new project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(92,13,'New member added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(93,13,'New member added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(94,13,'New member added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(95,13,'New task added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(96,13,'New task added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(97,13,'New task added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(98,14,'Create Design Of Worksuite added as new project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(99,14,'New member added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(100,14,'New task added to the project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(101,15,'Restaurant Management added as new project.','2022-10-28 07:30:18','2022-10-28 07:30:18'),(102,15,'New member added to the project.','2022-10-28 07:30:19','2022-10-28 07:30:19'),(103,15,'New member added to the project.','2022-10-28 07:30:19','2022-10-28 07:30:19'),(104,15,'New member added to the project.','2022-10-28 07:30:19','2022-10-28 07:30:19'),(105,15,'New member added to the project.','2022-10-28 07:30:19','2022-10-28 07:30:19'),(106,15,'New member added to the project.','2022-10-28 07:30:19','2022-10-28 07:30:19'),(107,15,'New task added to the project.','2022-10-28 07:30:19','2022-10-28 07:30:19'),(108,15,'New task added to the project.','2022-10-28 07:30:19','2022-10-28 07:30:19'),(109,15,'New task added to the project.','2022-10-28 07:30:19','2022-10-28 07:30:19'),(110,15,'New task added to the project.','2022-10-28 07:30:19','2022-10-28 07:30:19'),(111,15,'New task added to the project.','2022-10-28 07:30:19','2022-10-28 07:30:19');
/*!40000 ALTER TABLE `project_activity` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_category` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_category_added_by_foreign` (`added_by`),
  KEY `project_category_last_updated_by_foreign` (`last_updated_by`),
  KEY `project_category_company_id_foreign` (`company_id`),
  CONSTRAINT `project_category_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_category_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_category_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_category` WRITE;
/*!40000 ALTER TABLE `project_category` DISABLE KEYS */;
INSERT INTO `project_category` VALUES (1,1,'Laravel',NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(2,1,'Vuejs',NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(3,1,'React',NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(4,1,'Zend',NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(5,1,'CakePhp',NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(6,2,'Laravel',NULL,NULL,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(7,2,'Vuejs',NULL,NULL,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(8,2,'React',NULL,NULL,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(9,2,'Zend',NULL,NULL,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(10,2,'CakePhp',NULL,NULL,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(11,3,'Laravel',NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(12,3,'Vuejs',NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(13,3,'React',NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(14,3,'Zend',NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(15,3,'CakePhp',NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18');
/*!40000 ALTER TABLE `project_category` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `project_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `google_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dropbox_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_files_user_id_foreign` (`user_id`),
  KEY `project_files_project_id_foreign` (`project_id`),
  KEY `project_files_added_by_foreign` (`added_by`),
  KEY `project_files_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `project_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_files_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_files` WRITE;
/*!40000 ALTER TABLE `project_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_members` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `project_id` int unsigned NOT NULL,
  `hourly_rate` double NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_members_user_id_foreign` (`user_id`),
  KEY `project_members_project_id_foreign` (`project_id`),
  KEY `project_members_added_by_foreign` (`added_by`),
  KEY `project_members_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `project_members_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_members_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_members_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_members_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_members` WRITE;
/*!40000 ALTER TABLE `project_members` DISABLE KEYS */;
INSERT INTO `project_members` VALUES (1,3,1,74,2,2,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(2,10,2,63,2,2,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(3,10,2,63,2,2,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(4,2,3,27,2,2,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(5,14,3,98,2,2,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(6,13,3,61,2,2,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(7,10,3,63,2,2,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(8,13,3,61,2,2,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(9,10,4,63,2,2,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(10,10,4,63,2,2,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(11,2,4,27,2,2,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(12,11,4,40,2,2,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(13,2,4,27,2,2,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(14,2,5,27,2,2,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(15,14,5,98,2,2,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(16,3,5,74,2,2,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(17,11,5,40,2,2,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(18,13,5,61,2,2,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(19,25,6,80,15,15,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(20,16,6,92,15,15,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(21,16,6,92,15,15,'2022-10-28 07:30:14','2022-10-28 07:30:14'),(22,24,6,37,15,15,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(23,27,6,42,15,15,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(24,27,7,42,15,15,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(25,26,8,79,15,15,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(26,24,8,37,15,15,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(27,15,8,53,15,15,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(28,27,8,42,15,15,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(29,25,9,80,15,15,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(30,16,9,92,15,15,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(31,23,10,84,15,15,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(32,25,10,80,15,15,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(33,25,10,80,15,15,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(34,36,11,81,28,28,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(35,36,11,81,28,28,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(36,38,11,69,28,28,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(37,38,12,69,28,28,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(38,28,12,49,28,28,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(39,37,12,92,28,28,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(40,29,13,82,28,28,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(41,29,13,82,28,28,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(42,40,13,96,28,28,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(43,36,14,81,28,28,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(44,36,15,81,28,28,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(45,28,15,49,28,28,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(46,39,15,60,28,28,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(47,40,15,96,28,28,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(48,36,15,81,28,28,'2022-10-28 07:30:19','2022-10-28 07:30:19');
/*!40000 ALTER TABLE `project_members` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_milestones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_milestones` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int unsigned DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `milestone_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `summary` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cost` double(16,2) NOT NULL,
  `status` enum('complete','incomplete') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'incomplete',
  `invoice_created` tinyint(1) NOT NULL,
  `invoice_id` int DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_milestones_project_id_foreign` (`project_id`),
  KEY `project_milestones_currency_id_foreign` (`currency_id`),
  KEY `project_milestones_added_by_foreign` (`added_by`),
  KEY `project_milestones_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `project_milestones_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_milestones_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_milestones_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_milestones_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_milestones` WRITE;
/*!40000 ALTER TABLE `project_milestones` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_milestones` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int unsigned DEFAULT NULL,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `client_id` int unsigned DEFAULT NULL,
  `is_client_show` tinyint(1) NOT NULL DEFAULT '0',
  `ask_password` tinyint(1) NOT NULL DEFAULT '0',
  `details` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_notes_project_id_foreign` (`project_id`),
  KEY `project_notes_client_id_foreign` (`client_id`),
  KEY `project_notes_added_by_foreign` (`added_by`),
  KEY `project_notes_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `project_notes_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_notes_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_notes_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_notes_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_notes` WRITE;
/*!40000 ALTER TABLE `project_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_ratings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_ratings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int unsigned NOT NULL,
  `rating` double NOT NULL DEFAULT '0',
  `comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `user_id` int unsigned NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_ratings_project_id_foreign` (`project_id`),
  KEY `project_ratings_user_id_foreign` (`user_id`),
  KEY `project_ratings_added_by_foreign` (`added_by`),
  KEY `project_ratings_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `project_ratings_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_ratings_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_ratings_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_ratings_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_ratings` WRITE;
/*!40000 ALTER TABLE `project_ratings` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_ratings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `send_reminder` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remind_time` int NOT NULL,
  `remind_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remind_to` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '["admins","members"]',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `project_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_settings` WRITE;
/*!40000 ALTER TABLE `project_settings` DISABLE KEYS */;
INSERT INTO `project_settings` VALUES (1,1,'no',5,'days','[\"admins\",\"members\"]','2022-10-28 07:30:08','2022-10-28 07:30:08'),(2,2,'no',5,'days','[\"admins\",\"members\"]','2022-10-28 07:30:09','2022-10-28 07:30:09'),(3,3,'no',5,'days','[\"admins\",\"members\"]','2022-10-28 07:30:10','2022-10-28 07:30:10'),(4,4,'no',5,'days','[\"admins\",\"members\"]','2022-10-28 07:34:33','2022-10-28 07:34:33');
/*!40000 ALTER TABLE `project_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_status_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_status_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `status_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_status` enum('1','0') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_status_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `project_status_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_status_settings` WRITE;
/*!40000 ALTER TABLE `project_status_settings` DISABLE KEYS */;
INSERT INTO `project_status_settings` VALUES (1,1,'in progress','#00b5ff','active','1','2022-10-28 07:30:08','2022-10-28 07:30:08'),(2,1,'not started','#616e80','active','0','2022-10-28 07:30:08','2022-10-28 07:30:08'),(3,1,'on hold','#f5c308','active','0','2022-10-28 07:30:08','2022-10-28 07:30:08'),(4,1,'canceled','#d21010','active','0','2022-10-28 07:30:08','2022-10-28 07:30:08'),(5,1,'finished','#679c0d','active','0','2022-10-28 07:30:08','2022-10-28 07:30:08'),(6,2,'in progress','#00b5ff','active','1','2022-10-28 07:30:09','2022-10-28 07:30:09'),(7,2,'not started','#616e80','active','0','2022-10-28 07:30:09','2022-10-28 07:30:09'),(8,2,'on hold','#f5c308','active','0','2022-10-28 07:30:09','2022-10-28 07:30:09'),(9,2,'canceled','#d21010','active','0','2022-10-28 07:30:09','2022-10-28 07:30:09'),(10,2,'finished','#679c0d','active','0','2022-10-28 07:30:09','2022-10-28 07:30:09'),(11,3,'in progress','#00b5ff','active','1','2022-10-28 07:30:10','2022-10-28 07:30:10'),(12,3,'not started','#616e80','active','0','2022-10-28 07:30:10','2022-10-28 07:30:10'),(13,3,'on hold','#f5c308','active','0','2022-10-28 07:30:10','2022-10-28 07:30:10'),(14,3,'canceled','#d21010','active','0','2022-10-28 07:30:10','2022-10-28 07:30:10'),(15,3,'finished','#679c0d','active','0','2022-10-28 07:30:10','2022-10-28 07:30:10'),(16,4,'in progress','#00b5ff','active','1','2022-10-28 07:34:33','2022-10-28 07:34:33'),(17,4,'not started','#616e80','active','0','2022-10-28 07:34:33','2022-10-28 07:34:33'),(18,4,'on hold','#f5c308','active','0','2022-10-28 07:34:33','2022-10-28 07:34:33'),(19,4,'canceled','#d21010','active','0','2022-10-28 07:34:33','2022-10-28 07:34:33'),(20,4,'finished','#679c0d','active','0','2022-10-28 07:34:33','2022-10-28 07:34:33');
/*!40000 ALTER TABLE `project_status_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_template_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_template_members` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `project_template_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_template_members_user_id_foreign` (`user_id`),
  KEY `project_template_members_project_template_id_foreign` (`project_template_id`),
  CONSTRAINT `project_template_members_project_template_id_foreign` FOREIGN KEY (`project_template_id`) REFERENCES `project_templates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_template_members_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_template_members` WRITE;
/*!40000 ALTER TABLE `project_template_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_template_members` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_template_sub_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_template_sub_tasks` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `project_template_task_id` int unsigned NOT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_date` datetime DEFAULT NULL,
  `due_date` datetime DEFAULT NULL,
  `status` enum('incomplete','complete') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'incomplete',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_template_sub_tasks_project_template_task_id_foreign` (`project_template_task_id`),
  CONSTRAINT `project_template_sub_tasks_project_template_task_id_foreign` FOREIGN KEY (`project_template_task_id`) REFERENCES `project_template_tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_template_sub_tasks` WRITE;
/*!40000 ALTER TABLE `project_template_sub_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_template_sub_tasks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_template_task_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_template_task_users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `project_template_task_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_template_task_users_project_template_task_id_foreign` (`project_template_task_id`),
  KEY `project_template_task_users_user_id_foreign` (`user_id`),
  CONSTRAINT `project_template_task_users_project_template_task_id_foreign` FOREIGN KEY (`project_template_task_id`) REFERENCES `project_template_tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_template_task_users_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_template_task_users` WRITE;
/*!40000 ALTER TABLE `project_template_task_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_template_task_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_template_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_template_tasks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `heading` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `project_template_id` int unsigned NOT NULL,
  `priority` enum('low','medium','high') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'medium',
  `project_template_task_category_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_template_tasks_project_template_id_foreign` (`project_template_id`),
  KEY `project_template_tasks_project_template_task_category_id_foreign` (`project_template_task_category_id`),
  CONSTRAINT `project_template_tasks_project_template_id_foreign` FOREIGN KEY (`project_template_id`) REFERENCES `project_templates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_template_tasks_project_template_task_category_id_foreign` FOREIGN KEY (`project_template_task_category_id`) REFERENCES `task_category` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_template_tasks` WRITE;
/*!40000 ALTER TABLE `project_template_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_template_tasks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_templates` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned DEFAULT NULL,
  `project_summary` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `notes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `feedback` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `client_view_task` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `allow_client_notification` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `manual_timelog` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `added_by` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `project_templates_category_id_foreign` (`category_id`),
  KEY `project_templates_client_id_foreign` (`client_id`),
  KEY `project_templates_company_id_foreign` (`company_id`),
  CONSTRAINT `project_templates_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `project_category` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_templates_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_templates_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_templates` WRITE;
/*!40000 ALTER TABLE `project_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_time_log_breaks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_time_log_breaks` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_time_log_id` int unsigned DEFAULT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime DEFAULT NULL,
  `reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_hours` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_minutes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_time_log_breaks_project_time_log_id_foreign` (`project_time_log_id`),
  KEY `project_time_log_breaks_start_time_index` (`start_time`),
  KEY `project_time_log_breaks_end_time_index` (`end_time`),
  KEY `project_time_log_breaks_added_by_foreign` (`added_by`),
  KEY `project_time_log_breaks_last_updated_by_foreign` (`last_updated_by`),
  KEY `project_time_log_breaks_company_id_foreign` (`company_id`),
  CONSTRAINT `project_time_log_breaks_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_time_log_breaks_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_time_log_breaks_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_time_log_breaks_project_time_log_id_foreign` FOREIGN KEY (`project_time_log_id`) REFERENCES `project_time_logs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_time_log_breaks` WRITE;
/*!40000 ALTER TABLE `project_time_log_breaks` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_time_log_breaks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_time_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_time_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `task_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime DEFAULT NULL,
  `memo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_hours` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_minutes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `edited_by_user` int unsigned DEFAULT NULL,
  `hourly_rate` int NOT NULL,
  `earnings` int NOT NULL,
  `approved` tinyint(1) NOT NULL DEFAULT '1',
  `approved_by` int unsigned DEFAULT NULL,
  `invoice_id` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `total_break_minutes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_time_logs_project_id_foreign` (`project_id`),
  KEY `project_time_logs_task_id_foreign` (`task_id`),
  KEY `project_time_logs_user_id_foreign` (`user_id`),
  KEY `project_time_logs_start_time_index` (`start_time`),
  KEY `project_time_logs_end_time_index` (`end_time`),
  KEY `project_time_logs_edited_by_user_foreign` (`edited_by_user`),
  KEY `project_time_logs_approved_by_foreign` (`approved_by`),
  KEY `project_time_logs_invoice_id_foreign` (`invoice_id`),
  KEY `project_time_logs_added_by_foreign` (`added_by`),
  KEY `project_time_logs_last_updated_by_foreign` (`last_updated_by`),
  KEY `project_time_logs_company_id_foreign` (`company_id`),
  CONSTRAINT `project_time_logs_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_time_logs_approved_by_foreign` FOREIGN KEY (`approved_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_time_logs_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_time_logs_edited_by_user_foreign` FOREIGN KEY (`edited_by_user`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_time_logs_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_time_logs_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `project_time_logs_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_time_logs_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_time_logs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_time_logs` WRITE;
/*!40000 ALTER TABLE `project_time_logs` DISABLE KEYS */;
INSERT INTO `project_time_logs` VALUES (1,1,1,1,3,'2022-10-15 15:44:18','2022-10-15 19:44:18','working oneius','4','240',NULL,74,296,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(2,1,1,1,3,'2022-10-28 00:00:00','2022-10-28 04:00:00','working onmagni','4','240',NULL,74,296,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(3,1,1,1,3,'2022-10-24 07:32:15','2022-10-24 11:32:15','working ondistinctio','4','240',NULL,74,296,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(4,1,1,1,3,'2022-05-18 10:35:56','2022-05-18 12:35:56','working onexpedita','2','120',NULL,74,148,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(5,1,1,1,3,'2022-09-16 16:28:07','2022-09-16 20:28:07','working onmolestiae','4','240',NULL,74,296,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(6,1,1,1,3,'2022-11-03 00:00:00','2022-11-03 04:00:00','working ondolorum','4','240',NULL,74,296,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(7,1,1,1,3,'2022-10-18 10:33:04','2022-10-18 11:33:04','working onullam','1','60',NULL,74,74,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(8,1,1,1,3,'2022-11-01 00:00:00','2022-11-01 03:00:00','working onimpedit','3','180',NULL,74,222,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(9,1,1,1,3,'2022-11-01 00:00:00','2022-11-01 04:00:00','working ondolorem','4','240',NULL,74,296,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(10,1,1,1,3,'2022-11-02 00:00:00','2022-11-02 05:00:00','working onanimi','5','300',NULL,74,370,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(11,1,2,3,10,'2022-06-20 10:43:01','2022-06-20 15:43:01','working onrerum','5','300',NULL,63,315,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(12,1,2,3,10,'2022-10-09 06:13:53','2022-10-09 09:13:53','working onnon','3','180',NULL,63,189,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(13,1,2,3,10,'2022-11-03 00:00:00','2022-11-03 01:00:00','working onquae','1','60',NULL,63,63,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(14,1,2,3,10,'2022-10-20 17:16:06','2022-10-20 20:16:06','working onenim','3','180',NULL,63,189,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(15,1,2,3,10,'2022-10-28 00:00:00','2022-10-28 01:00:00','working onqui','1','60',NULL,63,63,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(16,1,2,3,10,'2022-10-22 05:36:12','2022-10-22 07:36:12','working onipsam','2','120',NULL,63,126,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(17,1,2,3,10,'2022-10-04 03:16:10','2022-10-04 06:16:10','working onunde','3','180',NULL,63,189,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(18,1,2,3,10,'2022-10-08 08:14:37','2022-10-08 10:14:37','working onsed','2','120',NULL,63,126,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(19,1,2,3,10,'2022-11-01 00:00:00','2022-11-01 03:00:00','working ondolor','3','180',NULL,63,189,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(20,1,2,3,10,'2022-10-29 00:00:00','2022-10-29 02:00:00','working onaut','2','120',NULL,63,126,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(21,1,3,8,2,'2022-11-02 00:00:00','2022-11-02 04:00:00','working onsimilique','4','240',NULL,27,108,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(22,1,3,8,2,'2022-02-16 00:06:00','2022-02-16 05:06:00','working onconsequatur','5','300',NULL,27,135,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(23,1,3,8,2,'2022-04-10 05:30:33','2022-04-10 08:30:33','working onblanditiis','3','180',NULL,27,81,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(24,1,3,8,2,'2022-10-15 14:43:19','2022-10-15 18:43:19','working oneaque','4','240',NULL,27,108,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(25,1,3,8,2,'2022-10-04 00:57:34','2022-10-04 03:57:34','working onnatus','3','180',NULL,27,81,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(26,1,3,8,2,'2022-02-17 17:06:16','2022-02-17 18:06:16','working onnisi','1','60',NULL,27,27,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(27,1,3,8,2,'2022-10-14 05:55:36','2022-10-14 10:55:36','working onsapiente','5','300',NULL,27,135,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(28,1,3,8,2,'2022-10-28 00:00:00','2022-10-28 01:00:00','working onet','1','60',NULL,27,27,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(29,1,3,8,2,'2022-10-28 00:00:00','2022-10-28 02:00:00','working onconsequuntur','2','120',NULL,27,54,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(30,1,3,8,2,'2022-10-21 06:47:39','2022-10-21 07:47:39','working onet','1','60',NULL,27,27,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(31,1,4,13,10,'2022-10-09 22:34:10','2022-10-10 01:34:10','working ondoloremque','3','180',NULL,63,189,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(32,1,4,13,10,'2022-11-03 00:00:00','2022-11-03 04:00:00','working onnon','4','240',NULL,63,252,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(33,1,4,13,10,'2022-10-30 00:00:00','2022-10-30 03:00:00','working onmolestiae','3','180',NULL,63,189,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(34,1,4,13,10,'2022-10-08 01:39:45','2022-10-08 04:39:45','working onpraesentium','3','180',NULL,63,189,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(35,1,4,13,10,'2022-09-28 15:37:43','2022-09-28 19:37:43','working onvoluptatem','4','240',NULL,63,252,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(36,1,4,13,10,'2022-10-31 00:00:00','2022-10-31 04:00:00','working onin','4','240',NULL,63,252,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(37,1,4,13,10,'2022-01-12 19:34:56','2022-01-13 00:34:56','working onpraesentium','5','300',NULL,63,315,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(38,1,4,13,10,'2022-08-17 20:17:31','2022-08-17 23:17:31','working onmolestias','3','180',NULL,63,189,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(39,1,4,13,10,'2022-02-22 04:20:16','2022-02-22 07:20:16','working onmolestiae','3','180',NULL,63,189,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(40,1,4,13,10,'2022-10-28 00:00:00','2022-10-28 04:00:00','working onasperiores','4','240',NULL,63,252,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(41,1,5,18,2,'2022-11-01 00:00:00','2022-11-01 05:00:00','working onquam','5','300',NULL,27,135,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(42,1,5,18,2,'2022-10-27 23:24:24','2022-10-28 00:24:24','working onrerum','1','60',NULL,27,27,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(43,1,5,18,2,'2022-10-01 18:58:19','2022-10-01 23:58:19','working onexpedita','5','300',NULL,27,135,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(44,1,5,18,2,'2022-11-01 00:00:00','2022-11-01 04:00:00','working oneum','4','240',NULL,27,108,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(45,1,5,18,2,'2022-05-13 06:43:19','2022-05-13 11:43:19','working onrerum','5','300',NULL,27,135,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(46,1,5,18,2,'2022-10-18 17:47:06','2022-10-18 20:47:06','working onquos','3','180',NULL,27,81,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(47,1,5,18,2,'2022-03-14 19:59:13','2022-03-14 21:59:13','working onveritatis','2','120',NULL,27,54,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(48,1,5,18,2,'2022-07-14 03:15:04','2022-07-14 08:15:04','working onquia','5','300',NULL,27,135,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(49,1,5,18,2,'2022-09-30 12:21:44','2022-09-30 15:21:44','working onreiciendis','3','180',NULL,27,81,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(50,1,5,18,2,'2022-06-03 22:35:53','2022-06-04 00:35:53','working onimpedit','2','120',NULL,27,54,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(51,2,6,23,25,'2022-10-15 01:24:21','2022-10-15 02:24:21','working ondicta','1','60',NULL,80,80,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(52,2,6,23,25,'2022-10-11 03:08:54','2022-10-11 06:08:54','working onet','3','180',NULL,80,240,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(53,2,6,23,25,'2022-10-24 21:06:57','2022-10-25 00:06:57','working onea','3','180',NULL,80,240,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(54,2,6,23,25,'2022-10-30 00:00:00','2022-10-30 03:00:00','working onvoluptates','3','180',NULL,80,240,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(55,2,6,23,25,'2022-10-26 21:05:23','2022-10-27 00:05:23','working onnam','3','180',NULL,80,240,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(56,2,6,23,25,'2022-10-23 21:51:19','2022-10-24 02:51:19','working onmagnam','5','300',NULL,80,400,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(57,2,6,23,25,'2022-10-05 19:01:15','2022-10-05 22:01:15','working onexplicabo','3','180',NULL,80,240,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(58,2,6,23,25,'2022-07-02 08:31:21','2022-07-02 12:31:21','working ondoloribus','4','240',NULL,80,320,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(59,2,6,23,25,'2022-02-14 10:35:17','2022-02-14 14:35:17','working onlibero','4','240',NULL,80,320,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(60,2,6,23,25,'2022-10-22 03:55:23','2022-10-22 06:55:23','working ontenetur','3','180',NULL,80,240,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(61,2,7,24,27,'2022-02-23 23:25:07','2022-02-24 00:25:07','working onad','1','60',NULL,42,42,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(62,2,7,24,27,'2022-07-25 11:18:49','2022-07-25 13:18:49','working onut','2','120',NULL,42,84,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(63,2,7,24,27,'2022-10-20 21:18:06','2022-10-20 22:18:06','working onsunt','1','60',NULL,42,42,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(64,2,7,24,27,'2022-10-07 03:49:16','2022-10-07 06:49:16','working onet','3','180',NULL,42,126,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(65,2,7,24,27,'2022-06-24 23:56:06','2022-06-25 03:56:06','working ondebitis','4','240',NULL,42,168,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(66,2,7,24,27,'2022-03-29 06:48:22','2022-03-29 07:48:22','working onbeatae','1','60',NULL,42,42,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(67,2,7,24,27,'2022-10-13 01:46:07','2022-10-13 05:46:07','working ontempora','4','240',NULL,42,168,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(68,2,7,24,27,'2022-10-12 12:06:28','2022-10-12 13:06:28','working onconsectetur','1','60',NULL,42,42,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(69,2,7,24,27,'2022-04-14 15:29:44','2022-04-14 20:29:44','working onsaepe','5','300',NULL,42,210,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(70,2,7,24,27,'2022-10-06 06:42:36','2022-10-06 08:42:36','working onoccaecati','2','120',NULL,42,84,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(71,2,8,28,26,'2022-10-04 02:15:46','2022-10-04 05:15:46','working onest','3','180',NULL,79,237,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(72,2,8,28,26,'2022-10-17 17:07:23','2022-10-17 20:07:23','working onea','3','180',NULL,79,237,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(73,2,8,28,26,'2022-02-07 13:50:41','2022-02-07 16:50:41','working onex','3','180',NULL,79,237,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(74,2,8,28,26,'2022-10-10 00:54:36','2022-10-10 05:54:36','working onut','5','300',NULL,79,395,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(75,2,8,28,26,'2022-01-02 21:09:07','2022-01-03 02:09:07','working onrepudiandae','5','300',NULL,79,395,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(76,2,8,28,26,'2022-07-05 06:32:00','2022-07-05 09:32:00','working onvoluptates','3','180',NULL,79,237,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(77,2,8,28,26,'2022-08-16 06:42:55','2022-08-16 10:42:55','working ondolorem','4','240',NULL,79,316,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(78,2,8,28,26,'2022-10-30 00:00:00','2022-10-30 05:00:00','working onenim','5','300',NULL,79,395,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(79,2,8,28,26,'2022-10-29 00:00:00','2022-10-29 04:00:00','working onqui','4','240',NULL,79,316,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(80,2,8,28,26,'2022-10-08 01:34:41','2022-10-08 03:34:41','working onnon','2','120',NULL,79,158,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(81,2,9,30,25,'2022-11-03 00:00:00','2022-11-03 02:00:00','working onprovident','2','120',NULL,80,160,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(82,2,9,30,25,'2022-11-01 00:00:00','2022-11-01 02:00:00','working ontenetur','2','120',NULL,80,160,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(83,2,9,30,25,'2022-10-28 00:00:00','2022-10-28 01:00:00','working onut','1','60',NULL,80,80,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(84,2,9,30,25,'2022-09-21 06:48:12','2022-09-21 08:48:12','working onsint','2','120',NULL,80,160,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(85,2,9,30,25,'2022-10-31 00:00:00','2022-10-31 03:00:00','working onsed','3','180',NULL,80,240,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(86,2,9,30,25,'2022-10-31 00:00:00','2022-10-31 01:00:00','working onarchitecto','1','60',NULL,80,80,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(87,2,9,30,25,'2022-11-02 00:00:00','2022-11-02 03:00:00','working onasperiores','3','180',NULL,80,240,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(88,2,9,30,25,'2022-03-31 21:45:11','2022-03-31 23:45:11','working onplaceat','2','120',NULL,80,160,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(89,2,9,30,25,'2022-09-30 00:06:51','2022-09-30 01:06:51','working onvoluptas','1','60',NULL,80,80,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(90,2,9,30,25,'2022-10-02 20:26:22','2022-10-02 23:26:22','working onearum','3','180',NULL,80,240,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(91,2,10,33,23,'2022-04-22 04:34:30','2022-04-22 07:34:30','working oneum','3','180',NULL,84,252,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(92,2,10,33,23,'2022-10-29 00:00:00','2022-10-29 05:00:00','working onarchitecto','5','300',NULL,84,420,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(93,2,10,33,23,'2022-10-28 00:00:00','2022-10-28 04:00:00','working ondeserunt','4','240',NULL,84,336,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(94,2,10,33,23,'2022-08-10 19:52:46','2022-08-10 20:52:46','working ondeleniti','1','60',NULL,84,84,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(95,2,10,33,23,'2022-10-28 00:00:00','2022-10-28 05:00:00','working onarchitecto','5','300',NULL,84,420,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(96,2,10,33,23,'2022-01-17 14:41:51','2022-01-17 19:41:51','working ondistinctio','5','300',NULL,84,420,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(97,2,10,33,23,'2022-01-10 08:47:34','2022-01-10 10:47:34','working onest','2','120',NULL,84,168,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(98,2,10,33,23,'2022-10-27 01:18:54','2022-10-27 02:18:54','working onsed','1','60',NULL,84,84,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(99,2,10,33,23,'2022-10-11 02:23:29','2022-10-11 04:23:29','working onet','2','120',NULL,84,168,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(100,2,10,33,23,'2022-10-29 00:00:00','2022-10-29 03:00:00','working onasperiores','3','180',NULL,84,252,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(101,3,11,36,36,'2022-10-27 22:43:16','2022-10-28 01:43:16','working onnobis','3','180',NULL,81,243,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(102,3,11,36,36,'2022-04-25 03:17:25','2022-04-25 06:17:25','working onharum','3','180',NULL,81,243,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(103,3,11,36,36,'2022-10-09 22:37:01','2022-10-09 23:37:01','working onmagnam','1','60',NULL,81,81,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(104,3,11,36,36,'2022-10-12 07:19:03','2022-10-12 10:19:03','working onsaepe','3','180',NULL,81,243,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(105,3,11,36,36,'2022-09-29 01:42:36','2022-09-29 04:42:36','working onest','3','180',NULL,81,243,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(106,3,11,36,36,'2022-10-27 02:15:40','2022-10-27 06:15:40','working onvel','4','240',NULL,81,324,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(107,3,11,36,36,'2022-10-21 20:58:24','2022-10-21 21:58:24','working onminus','1','60',NULL,81,81,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(108,3,11,36,36,'2022-10-25 10:38:34','2022-10-25 15:38:34','working onnon','5','300',NULL,81,405,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(109,3,11,36,36,'2022-10-28 00:00:00','2022-10-28 01:00:00','working onexplicabo','1','60',NULL,81,81,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(110,3,11,36,36,'2022-10-04 17:31:22','2022-10-04 21:31:22','working onminima','4','240',NULL,81,324,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(111,3,12,39,38,'2022-09-14 10:47:23','2022-09-14 12:47:23','working onperferendis','2','120',NULL,69,138,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(112,3,12,39,38,'2022-11-02 00:00:00','2022-11-02 05:00:00','working ondelectus','5','300',NULL,69,345,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(113,3,12,39,38,'2022-09-28 18:50:12','2022-09-28 23:50:12','working ondolorum','5','300',NULL,69,345,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(114,3,12,39,38,'2022-11-04 00:00:00','2022-11-04 04:00:00','working onquod','4','240',NULL,69,276,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(115,3,12,39,38,'2022-11-02 00:00:00','2022-11-02 01:00:00','working onimpedit','1','60',NULL,69,69,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(116,3,12,39,38,'2022-10-06 22:16:56','2022-10-07 01:16:56','working onin','3','180',NULL,69,207,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(117,3,12,39,38,'2022-07-31 07:34:36','2022-07-31 10:34:36','working onsapiente','3','180',NULL,69,207,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(118,3,12,39,38,'2022-11-02 00:00:00','2022-11-02 01:00:00','working ondolores','1','60',NULL,69,69,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(119,3,12,39,38,'2022-10-04 09:04:59','2022-10-04 10:04:59','working onipsum','1','60',NULL,69,69,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(120,3,12,39,38,'2022-10-23 21:20:54','2022-10-24 02:20:54','working onomnis','5','300',NULL,69,345,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(121,3,13,42,29,'2022-11-02 00:00:00','2022-11-02 05:00:00','working onvitae','5','300',NULL,82,410,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(122,3,13,42,29,'2022-11-02 00:00:00','2022-11-02 01:00:00','working onaut','1','60',NULL,82,82,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(123,3,13,42,29,'2022-10-06 05:43:33','2022-10-06 06:43:33','working onlibero','1','60',NULL,82,82,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(124,3,13,42,29,'2022-10-18 00:36:08','2022-10-18 02:36:08','working ondignissimos','2','120',NULL,82,164,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(125,3,13,42,29,'2022-10-30 00:00:00','2022-10-30 03:00:00','working onblanditiis','3','180',NULL,82,246,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(126,3,13,42,29,'2022-10-31 00:00:00','2022-10-31 04:00:00','working ona','4','240',NULL,82,328,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(127,3,13,42,29,'2022-10-30 00:00:00','2022-10-30 05:00:00','working onratione','5','300',NULL,82,410,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(128,3,13,42,29,'2022-10-28 00:00:00','2022-10-28 01:00:00','working onlaboriosam','1','60',NULL,82,82,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(129,3,13,42,29,'2022-07-22 13:32:29','2022-07-22 14:32:29','working onvoluptas','1','60',NULL,82,82,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(130,3,13,42,29,'2022-07-21 13:29:46','2022-07-21 15:29:46','working onvel','2','120',NULL,82,164,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(131,3,14,43,36,'2022-10-30 00:00:00','2022-10-30 02:00:00','working onat','2','120',NULL,81,162,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(132,3,14,43,36,'2022-10-31 00:00:00','2022-10-31 03:00:00','working onvoluptatem','3','180',NULL,81,243,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(133,3,14,43,36,'2022-11-02 00:00:00','2022-11-02 04:00:00','working onin','4','240',NULL,81,324,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(134,3,14,43,36,'2022-11-01 00:00:00','2022-11-01 05:00:00','working onratione','5','300',NULL,81,405,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(135,3,14,43,36,'2022-10-28 00:00:00','2022-10-28 04:00:00','working oninventore','4','240',NULL,81,324,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(136,3,14,43,36,'2022-10-28 00:00:00','2022-10-28 05:00:00','working ondelectus','5','300',NULL,81,405,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(137,3,14,43,36,'2022-04-18 19:06:08','2022-04-18 21:06:08','working onporro','2','120',NULL,81,162,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(138,3,14,43,36,'2022-03-16 20:51:43','2022-03-16 21:51:43','working oniure','1','60',NULL,81,81,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(139,3,14,43,36,'2022-10-29 00:00:00','2022-10-29 03:00:00','working onanimi','3','180',NULL,81,243,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(140,3,14,43,36,'2022-03-08 03:38:37','2022-03-08 05:38:37','working onet','2','120',NULL,81,162,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(141,3,15,48,36,'2022-10-31 00:00:00','2022-10-31 03:00:00','working onlabore','3','180',NULL,81,243,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(142,3,15,48,36,'2022-08-20 11:37:11','2022-08-20 12:37:11','working onaccusantium','1','60',NULL,81,81,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(143,3,15,48,36,'2022-09-30 18:17:41','2022-09-30 19:17:41','working onest','1','60',NULL,81,81,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(144,3,15,48,36,'2022-10-30 00:00:00','2022-10-30 01:00:00','working onaspernatur','1','60',NULL,81,81,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(145,3,15,48,36,'2022-11-02 00:00:00','2022-11-02 05:00:00','working onquidem','5','300',NULL,81,405,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(146,3,15,48,36,'2022-10-25 04:36:22','2022-10-25 06:36:22','working oneos','2','120',NULL,81,162,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(147,3,15,48,36,'2022-11-03 00:00:00','2022-11-03 05:00:00','working ondolorem','5','300',NULL,81,405,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(148,3,15,48,36,'2022-11-03 00:00:00','2022-11-03 04:00:00','working onaliquam','4','240',NULL,81,324,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(149,3,15,48,36,'2022-02-06 15:18:20','2022-02-06 18:18:20','working onipsam','3','180',NULL,81,243,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(150,3,15,48,36,'2022-05-03 17:11:07','2022-05-03 20:11:07','working onvelit','3','180',NULL,81,243,1,NULL,NULL,NULL,NULL,NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19');
/*!40000 ALTER TABLE `project_time_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `project_user_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_user_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `project_note_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_user_notes_user_id_foreign` (`user_id`),
  KEY `project_user_notes_project_note_id_foreign` (`project_note_id`),
  CONSTRAINT `project_user_notes_project_note_id_foreign` FOREIGN KEY (`project_note_id`) REFERENCES `project_notes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `project_user_notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `project_user_notes` WRITE;
/*!40000 ALTER TABLE `project_user_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_user_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `project_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `project_short_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `project_summary` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `project_admin` int unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `deadline` date DEFAULT NULL,
  `notes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `category_id` int unsigned DEFAULT NULL,
  `client_id` int unsigned DEFAULT NULL,
  `team_id` int unsigned DEFAULT NULL,
  `feedback` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `manual_timelog` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `client_view_task` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `allow_client_notification` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `completion_percent` tinyint NOT NULL,
  `calculate_task_progress` enum('true','false') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'true',
  `project_budget` double(20,2) DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `hours_allocated` double(8,2) DEFAULT NULL,
  `status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'in progress',
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `hash` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `public` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `enable_miroboard` tinyint(1) NOT NULL DEFAULT '0',
  `miro_board_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_access` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `projects_project_admin_foreign` (`project_admin`),
  KEY `projects_category_id_foreign` (`category_id`),
  KEY `projects_client_id_foreign` (`client_id`),
  KEY `projects_team_id_foreign` (`team_id`),
  KEY `projects_currency_id_foreign` (`currency_id`),
  KEY `projects_added_by_foreign` (`added_by`),
  KEY `projects_last_updated_by_foreign` (`last_updated_by`),
  KEY `projects_deleted_at_index` (`deleted_at`),
  KEY `projects_company_id_foreign` (`company_id`),
  CONSTRAINT `projects_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `projects_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `project_category` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `projects_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `projects_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `projects_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `projects_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `projects_project_admin_foreign` FOREIGN KEY (`project_admin`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `projects_team_id_foreign` FOREIGN KEY (`team_id`) REFERENCES `teams` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` VALUES (1,1,'Install Application','IA','Nulla praesentium corporis ea. Rem et tenetur rerum sed. Illum voluptatem et quis cum dolor distinctio minima. Nam qui ea et assumenda quos voluptatem maxime.',NULL,'2022-08-28','2022-12-28','Itaque commodi minima nihil velit quod et quia architecto. Veritatis sed vel aspernatur rem. Accusamus consequuntur sit exercitationem placeat. Architecto occaecati distinctio est quia aut.',1,7,NULL,'I ever heard!\' \'Yes, I think I could, if I was, I shouldn\'t want YOURS: I don\'t want to be?\' it asked. \'Oh, I\'m not Ada,\' she said, by way of speaking to a day-school, too,\' said Alice; \'that\'s not.','disable','disable','disable',98,'true',NULL,1,NULL,'in progress',2,NULL,'8fN9Jerx3mc7awQlBtmH10QYNbrhSueO',0,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,0,NULL,0),(2,1,'Identification System','IS','A ratione voluptatibus corrupti tenetur odit et. Et saepe est voluptas unde impedit voluptatibus cumque. Quis velit maxime eos laboriosam.',NULL,'2022-08-28','2022-12-28','Et totam doloribus dolores nam. Alias alias officiis ea. Sed veritatis dolores repellat beatae.',1,7,NULL,'While she was now the right thing to eat or drink something or other; but the Rabbit hastily interrupted. \'There\'s a great hurry. \'You did!\' said the Mock Turtle went on so long since she had found.','disable','disable','disable',90,'true',NULL,1,NULL,'in progress',2,NULL,'eBun6pC8kaVlCrk7qJtML8i6Ka0uYmPb',0,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,0,NULL,0),(3,1,'Create Design of worksuite','CDOW','Nihil corporis aut est in. Eum qui molestias aut tempore libero quidem voluptas. Pariatur qui rerum et dolor totam.',NULL,'2022-05-28','2022-09-28','Corporis omnis sed amet provident cumque aut necessitatibus. Quos voluptatem pariatur vel enim enim veritatis quam. Voluptatum consequatur itaque sed fuga. Aut et veritatis quae aperiam.',3,8,NULL,'It was high time to wash the things between whiles.\' \'Then you keep moving round, I suppose?\' said Alice. \'I mean what I say--that\'s the same size for ten minutes together!\' \'Can\'t remember WHAT.','disable','disable','disable',65,'true',NULL,1,NULL,'in progress',2,NULL,'nOwEiikGrwbUw3aDHbqBOEGOT4KCZR07',0,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,0,NULL,0),(4,1,'User Management','UM','Facilis dolorem voluptatum iure voluptatem. Consequuntur quidem eos rem dolores delectus laudantium quae. Reprehenderit earum molestiae dolore pariatur natus quis.',NULL,'2022-09-28','2023-01-28','Et est voluptatibus et qui facere mollitia. Magni expedita quia quia et temporibus et. Nisi eos deleniti nam sint beatae in et. Et asperiores et nulla aut.',2,7,NULL,'Alice thought), and it was over at last: \'and I do so like that curious song about the reason and all her knowledge of history, Alice had begun to dream that she did not venture to say it over).','disable','disable','disable',69,'true',NULL,1,NULL,'in progress',2,NULL,'a1VhgRMxplm3aMLYhwr3I6cPf3tB8FRK',0,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL,0,NULL,0),(5,1,'User Management','UM','Suscipit doloribus ipsam id iusto enim corrupti neque. Ipsam dignissimos nihil quae id error mollitia. Aut a nostrum tempora ullam corrupti corporis porro. Fuga ut repellendus eos autem debitis.',NULL,'2022-09-28','2023-01-28','Ex et et at eum laboriosam. Ipsam officia nihil eos est ea tenetur minus. Magnam ut eum deleniti non explicabo qui quibusdam qui. Minus laboriosam ipsam perspiciatis molestiae.',3,5,NULL,'King, \'that saves a world of trouble, you know, and he poured a little three-legged table, all made of solid glass; there was no time to avoid shrinking away altogether. \'That WAS a narrow escape!\'.','disable','disable','disable',76,'true',NULL,1,NULL,'in progress',2,NULL,'wQ2tM5UKbvjJvcaC3k4YuoepZamD59y3',0,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL,0,NULL,0),(6,2,'Identification System','IS','Et sed repellat rerum voluptatem. Rerum alias quidem non porro soluta ut qui iste. Ut neque quis sed ut nihil.',NULL,'2022-04-28','2022-08-28','Omnis consectetur eligendi illo consequatur ut quis est. Sed magni et qui eum laborum ipsum quia iusto. Porro quas quo eum quasi accusamus eius eaque.',9,20,NULL,'I don\'t remember where.\' \'Well, it must make me grow smaller, I can find them.\' As she said to the jury. They were just beginning to feel very queer to ME.\' \'You!\' said the Queen. \'Never!\' said the.','disable','disable','disable',74,'true',NULL,5,NULL,'in progress',15,NULL,'FX9aZX1NN2MnocZFR0vXEKcNbMlfAGBo',0,'2022-10-28 07:30:14','2022-10-28 07:30:14',NULL,0,NULL,0),(7,2,'Restaurant Management','RM','Quam rerum nulla ut tempore. Molestiae tempore ducimus ipsum minus enim est. Recusandae harum ut ullam ab.',NULL,'2022-08-28','2022-12-28','Pariatur assumenda quos dolores cupiditate consequatur odit molestiae. Sint aut et voluptate dolores. Facilis et asperiores quia enim error et. Cum adipisci illo nisi aut pariatur tempora voluptates.',8,21,NULL,'It quite makes my forehead ache!\' Alice watched the White Rabbit read:-- \'They told me you had been found and handed them round as prizes. There was a little pattering of feet on the bank, with her.','disable','disable','disable',79,'true',NULL,5,NULL,'in progress',15,NULL,'9NheoBcGYMqAx0Iixhf3pgymsMogSmco',0,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,0,NULL,0),(8,2,'Project Management','PM','Et cum amet voluptas sint aliquid ipsum et. Consequatur ipsum error et sit. Nobis porro tempora quo porro delectus. Expedita perspiciatis ut fugit quis.',NULL,'2022-07-28','2022-11-28','Ex officia veniam facere qui reprehenderit. Qui eum autem distinctio dolor. Consectetur natus laborum velit qui et tempore quia. Ullam laborum voluptatem libero voluptatum dolorum quam.',10,18,NULL,'SIT down,\' the King was the first day,\' said the March Hare said in a deep, hollow tone: \'sit down, both of you, and listen to her, \'if we had the door opened inwards, and Alice\'s first thought was.','disable','disable','disable',84,'true',NULL,5,NULL,'in progress',15,NULL,'2YO0IoSgWHNAlFGrRmSaF3dfQfsVJCiK',0,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,0,NULL,0),(9,2,'Document management System','DMS','Molestiae molestiae dolorem cupiditate ut inventore hic consectetur. Ex aperiam sed fugiat ut omnis. Quasi aut porro tenetur nihil. Cumque optio eum et et dolore. Qui non et vel quo sint ratione et.',NULL,'2022-08-28','2022-12-28','Consectetur rerum tenetur ex nihil alias possimus. Ut est incidunt porro facere cumque magnam. Itaque et et et assumenda molestias.',9,21,NULL,'In another minute there was mouth enough for it was YOUR table,\' said Alice; \'it\'s laid for a long and a large ring, with the words came very queer indeed:-- \'\'Tis the voice of the baby, the shriek.','disable','disable','disable',95,'true',NULL,5,NULL,'in progress',15,NULL,'FaJafmXj31iZg8t6uYoBd8vdxQh7hek3',0,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,0,NULL,0),(10,2,'Document management System','DMS','Voluptas omnis quis quia alias. Voluptate recusandae mollitia id impedit rem. Ut libero fuga harum eligendi odio aliquam inventore voluptas.',NULL,'2022-07-28','2022-11-28','Nam eos tempora labore repudiandae. Qui labore quasi et quibusdam. Libero adipisci rerum non ea recusandae. Vitae dolor corrupti ut eveniet maxime.',9,20,NULL,'Hatter. \'I deny it!\' said the last few minutes to see what was going on between the executioner, the King, \'unless it was an immense length of neck, which seemed to be a footman because he was.','disable','disable','disable',73,'true',NULL,5,NULL,'in progress',15,NULL,'gSifD234FkNdT6KQcBxXgp4M33UpsvF8',0,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL,0,NULL,0),(11,3,'Live Meeting','LM','Aperiam consectetur doloremque ipsam facere libero odit minus. Corrupti ut sapiente similique est. Suscipit totam animi consequatur minima.',NULL,'2022-09-28','2023-01-28','Quia libero maiores molestiae maiores necessitatibus. Pariatur tempora eos dolores expedita. Voluptas omnis aut sed dolore ipsum.',11,35,NULL,'The Hatter opened his eyes. \'I wasn\'t asleep,\' he said in a ring, and begged the Mouse was speaking, and this was her turn or not. \'Oh, PLEASE mind what you\'re talking about,\' said Alice. \'I\'ve read.','disable','disable','disable',52,'true',NULL,9,NULL,'in progress',28,NULL,'RBc5TE4EijV9bIZIW0BOF9x6KIUwafJD',0,'2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,0,NULL,0),(12,3,'Install Application','IA','Rerum occaecati id autem in earum aut voluptates. Velit laborum ut aliquid. Cupiditate aut occaecati totam non dolore dolorum minima. Fugiat inventore fuga numquam.',NULL,'2022-09-28','2023-01-28','Dolore nemo et cupiditate mollitia id. Odio rerum et natus deserunt illo asperiores cupiditate. Saepe corporis possimus iure consequuntur autem velit doloribus.',12,35,NULL,'VERY deeply with a table set out under a tree a few yards off. The Cat only grinned a little shriek, and went by without noticing her. Then followed the Knave of Hearts, who only bowed and smiled in.','disable','disable','disable',51,'true',NULL,9,NULL,'in progress',28,NULL,'rlpdjAYnYPsbVwh2YF5R4FPTsWep4gco',0,'2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,0,NULL,0),(13,3,'Project Management','PM','Dolor rem et explicabo consequatur. Tempore ex atque quisquam voluptatum. Deserunt error non eos et. Est reiciendis ut omnis.',NULL,'2022-09-28','2023-01-28','Autem est sed non aliquid. Et quis ut et voluptatum incidunt. Sint numquam reprehenderit blanditiis ut.',12,32,NULL,'Hatter: \'but you could see it written up somewhere.\' Down, down, down. There was exactly three inches high). \'But I\'m not the same, the next moment a shower of saucepans, plates, and dishes. The.','disable','disable','disable',99,'true',NULL,9,NULL,'in progress',28,NULL,'vz24mzPXRUFZm8QAEg0aikRN37SCWHcx',0,'2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,0,NULL,0),(14,3,'Create Design of worksuite','CDOW','Neque ipsa aliquid ut non in. Omnis nisi ipsum perferendis est. Ea aut officia recusandae est saepe et facere. Autem autem nam dolorem eligendi autem cum distinctio.',NULL,'2022-04-28','2022-08-28','Atque libero porro animi enim a aut et. Iste aliquid consequatur vero sunt consequuntur non. Unde non optio omnis odio qui.',15,35,NULL,'Alice said nothing: she had to stop and untwist it. After a while she ran, as well say,\' added the Dormouse. \'Fourteenth of March, I think you\'d better finish the story for yourself.\' \'No, please go.','disable','disable','disable',57,'true',NULL,9,NULL,'in progress',28,NULL,'Ov2QChdO1ElHlm34zvZFZ1cF9mCUPlBz',0,'2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,0,NULL,0),(15,3,'Restaurant Management','RM','Voluptatem quia quam iure illo mollitia. Fugit voluptate sequi reiciendis eius. Aut tempore id eum et ullam. Nostrum possimus neque possimus minus et. Vel consequatur omnis ut nulla cum.',NULL,'2022-07-28','2022-11-28','Dolores debitis tempora inventore consequatur et. Sapiente expedita asperiores autem incidunt sed. Hic sit maiores deleniti distinctio ea expedita veniam. Asperiores et beatae harum maiores sed saepe.',15,35,NULL,'She had not noticed before, and she swam lazily about in the world you fly, Like a tea-tray in the pool was getting quite crowded with the next moment a shower of saucepans, plates, and dishes. The.','disable','disable','disable',100,'true',NULL,9,NULL,'in progress',28,NULL,'wQv8kipBbk4afBxfxoIv7R1shP0nYPmK',0,'2022-10-28 07:30:18','2022-10-28 07:30:18',NULL,0,NULL,0);
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `proposal_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `proposal_item_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `proposal_item_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposal_item_images_proposal_item_id_foreign` (`proposal_item_id`),
  CONSTRAINT `proposal_item_images_proposal_item_id_foreign` FOREIGN KEY (`proposal_item_id`) REFERENCES `proposal_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `proposal_item_images` WRITE;
/*!40000 ALTER TABLE `proposal_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `proposal_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `proposal_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `proposal_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `proposal_id` int unsigned NOT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('item','discount','tax') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `quantity` double(16,2) NOT NULL,
  `unit_price` double(16,2) NOT NULL,
  `amount` double(16,2) NOT NULL,
  `item_summary` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `taxes` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposal_items_proposal_id_foreign` (`proposal_id`),
  CONSTRAINT `proposal_items_proposal_id_foreign` FOREIGN KEY (`proposal_id`) REFERENCES `proposals` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `proposal_items` WRITE;
/*!40000 ALTER TABLE `proposal_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `proposal_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `proposal_signs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `proposal_signs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `proposal_id` int unsigned NOT NULL,
  `full_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `signature` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposal_signs_proposal_id_foreign` (`proposal_id`),
  CONSTRAINT `proposal_signs_proposal_id_foreign` FOREIGN KEY (`proposal_id`) REFERENCES `proposals` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `proposal_signs` WRITE;
/*!40000 ALTER TABLE `proposal_signs` DISABLE KEYS */;
/*!40000 ALTER TABLE `proposal_signs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `proposal_template_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `proposal_template_item_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `proposal_template_item_id` int unsigned NOT NULL,
  `filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposal_template_item_images_proposal_template_item_id_foreign` (`proposal_template_item_id`),
  KEY `proposal_template_item_images_company_id_foreign` (`company_id`),
  CONSTRAINT `proposal_template_item_images_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `proposal_template_item_images_proposal_template_item_id_foreign` FOREIGN KEY (`proposal_template_item_id`) REFERENCES `proposal_template_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `proposal_template_item_images` WRITE;
/*!40000 ALTER TABLE `proposal_template_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `proposal_template_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `proposal_template_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `proposal_template_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `proposal_template_id` bigint unsigned NOT NULL,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('item','discount','tax') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `quantity` tinyint NOT NULL,
  `unit_price` double NOT NULL,
  `amount` double NOT NULL,
  `item_summary` text COLLATE utf8mb4_unicode_ci,
  `taxes` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposal_template_items_proposal_template_id_foreign` (`proposal_template_id`),
  KEY `proposal_template_items_company_id_foreign` (`company_id`),
  CONSTRAINT `proposal_template_items_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `proposal_template_items_proposal_template_id_foreign` FOREIGN KEY (`proposal_template_id`) REFERENCES `proposal_templates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `proposal_template_items` WRITE;
/*!40000 ALTER TABLE `proposal_template_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `proposal_template_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `proposal_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `proposal_templates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_total` double NOT NULL,
  `total` double NOT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `discount_type` enum('percent','fixed') COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount` double NOT NULL,
  `invoice_convert` tinyint(1) NOT NULL DEFAULT '0',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `client_comment` text COLLATE utf8mb4_unicode_ci,
  `signature_approval` tinyint(1) NOT NULL DEFAULT '1',
  `hash` text COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposal_templates_currency_id_foreign` (`currency_id`),
  KEY `proposal_templates_added_by_foreign` (`added_by`),
  KEY `proposal_templates_last_updated_by_foreign` (`last_updated_by`),
  KEY `proposal_templates_company_id_foreign` (`company_id`),
  CONSTRAINT `proposal_templates_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `proposal_templates_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `proposal_templates_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `proposal_templates_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `proposal_templates` WRITE;
/*!40000 ALTER TABLE `proposal_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `proposal_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `proposals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `proposals` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `lead_id` int unsigned NOT NULL,
  `valid_till` date NOT NULL,
  `sub_total` double(16,2) NOT NULL,
  `total` double(16,2) NOT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `discount_type` enum('percent','fixed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount` double NOT NULL,
  `invoice_convert` tinyint(1) NOT NULL DEFAULT '0',
  `status` enum('declined','accepted','waiting') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting',
  `note` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `client_comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `signature_approval` tinyint(1) NOT NULL DEFAULT '1',
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `hash` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `calculate_tax` enum('after_discount','before_discount') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'after_discount',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proposals_lead_id_foreign` (`lead_id`),
  KEY `proposals_currency_id_foreign` (`currency_id`),
  KEY `proposals_added_by_foreign` (`added_by`),
  KEY `proposals_last_updated_by_foreign` (`last_updated_by`),
  KEY `proposals_company_id_foreign` (`company_id`),
  CONSTRAINT `proposals_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `proposals_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `proposals_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `proposals_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `proposals_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `proposals` WRITE;
/*!40000 ALTER TABLE `proposals` DISABLE KEYS */;
/*!40000 ALTER TABLE `proposals` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purpose_consent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purpose_consent` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purpose_consent` WRITE;
/*!40000 ALTER TABLE `purpose_consent` DISABLE KEYS */;
/*!40000 ALTER TABLE `purpose_consent` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purpose_consent_leads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purpose_consent_leads` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` int unsigned NOT NULL,
  `purpose_consent_id` int unsigned NOT NULL,
  `status` enum('agree','disagree') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'agree',
  `ip` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `updated_by_id` int unsigned DEFAULT NULL,
  `additional_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purpose_consent_leads_lead_id_foreign` (`lead_id`),
  KEY `purpose_consent_leads_purpose_consent_id_foreign` (`purpose_consent_id`),
  KEY `purpose_consent_leads_updated_by_id_foreign` (`updated_by_id`),
  CONSTRAINT `purpose_consent_leads_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `purpose_consent_leads_purpose_consent_id_foreign` FOREIGN KEY (`purpose_consent_id`) REFERENCES `purpose_consent` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `purpose_consent_leads_updated_by_id_foreign` FOREIGN KEY (`updated_by_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purpose_consent_leads` WRITE;
/*!40000 ALTER TABLE `purpose_consent_leads` DISABLE KEYS */;
/*!40000 ALTER TABLE `purpose_consent_leads` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purpose_consent_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purpose_consent_users` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int unsigned NOT NULL,
  `purpose_consent_id` int unsigned NOT NULL,
  `status` enum('agree','disagree') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'agree',
  `ip` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `updated_by_id` int unsigned NOT NULL,
  `additional_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purpose_consent_users_client_id_foreign` (`client_id`),
  KEY `purpose_consent_users_purpose_consent_id_foreign` (`purpose_consent_id`),
  KEY `purpose_consent_users_updated_by_id_foreign` (`updated_by_id`),
  CONSTRAINT `purpose_consent_users_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `purpose_consent_users_purpose_consent_id_foreign` FOREIGN KEY (`purpose_consent_id`) REFERENCES `purpose_consent` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `purpose_consent_users_updated_by_id_foreign` FOREIGN KEY (`updated_by_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purpose_consent_users` WRITE;
/*!40000 ALTER TABLE `purpose_consent_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `purpose_consent_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `push_notification_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `push_notification_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `onesignal_app_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `onesignal_rest_api_key` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `notification_logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `push_notification_settings` WRITE;
/*!40000 ALTER TABLE `push_notification_settings` DISABLE KEYS */;
INSERT INTO `push_notification_settings` VALUES (1,NULL,NULL,NULL,'inactive','2022-10-28 07:30:06','2022-10-28 07:30:06');
/*!40000 ALTER TABLE `push_notification_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `push_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `push_subscriptions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `endpoint` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `public_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auth_token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `push_subscriptions_endpoint_company_id_unique` (`endpoint`,`company_id`),
  KEY `push_subscriptions_user_id_index` (`user_id`),
  KEY `push_subscriptions_company_id_foreign` (`company_id`),
  CONSTRAINT `push_subscriptions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `push_subscriptions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `push_subscriptions` WRITE;
/*!40000 ALTER TABLE `push_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `push_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pusher_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pusher_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pusher_app_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pusher_app_key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pusher_app_secret` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pusher_cluster` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `force_tls` tinyint(1) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `taskboard` tinyint(1) NOT NULL DEFAULT '1',
  `messages` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pusher_settings` WRITE;
/*!40000 ALTER TABLE `pusher_settings` DISABLE KEYS */;
INSERT INTO `pusher_settings` VALUES (1,NULL,NULL,NULL,NULL,0,0,1,0,'2022-10-28 07:30:06','2022-10-28 07:30:06');
/*!40000 ALTER TABLE `pusher_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `quotation_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotation_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `quotation_id` int unsigned NOT NULL,
  `item_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int NOT NULL,
  `unit_price` int NOT NULL,
  `amount` double(8,2) NOT NULL,
  `hsn_sac_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `quotation_items_quotation_id_foreign` (`quotation_id`),
  CONSTRAINT `quotation_items_quotation_id_foreign` FOREIGN KEY (`quotation_id`) REFERENCES `quotations` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `quotation_items` WRITE;
/*!40000 ALTER TABLE `quotation_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotation_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `quotations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `business_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `sub_total` double(8,2) NOT NULL,
  `total` double(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `quotations_company_id_foreign` (`company_id`),
  CONSTRAINT `quotations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `quotations` WRITE;
/*!40000 ALTER TABLE `quotations` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `razorpay_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `razorpay_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned NOT NULL,
  `currency_id` int DEFAULT NULL,
  `invoice_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subscription_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `package_id` bigint unsigned NOT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(12,2) unsigned NOT NULL,
  `pay_date` date NOT NULL,
  `next_pay_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `razorpay_invoices_company_id_foreign` (`company_id`),
  KEY `razorpay_invoices_package_id_foreign` (`package_id`),
  CONSTRAINT `razorpay_invoices_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `razorpay_invoices_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `razorpay_invoices` WRITE;
/*!40000 ALTER TABLE `razorpay_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `razorpay_invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `removal_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `removal_requests` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `status` enum('pending','approved','rejected') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `removal_requests_user_id_foreign` (`user_id`),
  KEY `removal_requests_company_id_foreign` (`company_id`),
  CONSTRAINT `removal_requests_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `removal_requests_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `removal_requests` WRITE;
/*!40000 ALTER TABLE `removal_requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `removal_requests` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `removal_requests_lead`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `removal_requests_lead` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `lead_id` int unsigned DEFAULT NULL,
  `status` enum('pending','approved','rejected') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `removal_requests_lead_lead_id_foreign` (`lead_id`),
  KEY `removal_requests_lead_company_id_foreign` (`company_id`),
  CONSTRAINT `removal_requests_lead_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `removal_requests_lead_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `removal_requests_lead` WRITE;
/*!40000 ALTER TABLE `removal_requests_lead` DISABLE KEYS */;
/*!40000 ALTER TABLE `removal_requests_lead` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_user` (
  `user_id` int unsigned NOT NULL,
  `role_id` int unsigned NOT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_user_role_id_foreign` (`role_id`),
  CONSTRAINT `role_user_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `role_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_user` WRITE;
/*!40000 ALTER TABLE `role_user` DISABLE KEYS */;
INSERT INTO `role_user` VALUES (1,1),(2,2),(2,3),(3,3),(10,3),(11,3),(12,3),(13,3),(14,3),(4,4),(5,4),(6,4),(7,4),(8,4),(9,4),(15,5),(15,6),(16,6),(23,6),(24,6),(25,6),(26,6),(27,6),(17,7),(18,7),(19,7),(20,7),(21,7),(22,7),(28,8),(28,9),(29,9),(36,9),(37,9),(38,9),(39,9),(40,9),(30,10),(31,10),(32,10),(33,10),(34,10),(35,10),(41,14),(41,15);
/*!40000 ALTER TABLE `role_user` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_company_id_unique` (`name`,`company_id`),
  KEY `roles_company_id_foreign` (`company_id`),
  CONSTRAINT `roles_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,NULL,'superadmin','App Super Admin','Super Admin is allowed to manage everything of the app.','2022-10-28 07:30:07','2022-10-28 07:30:07'),(2,1,'admin','App Administrator','Admin is allowed to manage everything of the app.','2022-10-28 07:30:07','2022-10-28 07:30:07'),(3,1,'employee','Employee','Employee can see tasks and projects assigned to him.','2022-10-28 07:30:07','2022-10-28 07:30:07'),(4,1,'client','Client','Client can see own tasks and projects.','2022-10-28 07:30:07','2022-10-28 07:30:07'),(5,2,'admin','App Administrator','Admin is allowed to manage everything of the app.','2022-10-28 07:30:08','2022-10-28 07:30:08'),(6,2,'employee','Employee','Employee can see tasks and projects assigned to him.','2022-10-28 07:30:08','2022-10-28 07:30:08'),(7,2,'client','Client','Client can see own tasks and projects.','2022-10-28 07:30:08','2022-10-28 07:30:08'),(8,3,'admin','App Administrator','Admin is allowed to manage everything of the app.','2022-10-28 07:30:09','2022-10-28 07:30:09'),(9,3,'employee','Employee','Employee can see tasks and projects assigned to him.','2022-10-28 07:30:09','2022-10-28 07:30:09'),(10,3,'client','Client','Client can see own tasks and projects.','2022-10-28 07:30:09','2022-10-28 07:30:09'),(11,1,'Manager','Manager',NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(12,2,'Manager','Manager',NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(13,3,'Manager','Manager',NULL,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(14,4,'admin','App Administrator','Admin is allowed to manage everything of the app.','2022-10-28 07:34:31','2022-10-28 07:34:31'),(15,4,'employee','Employee','Employee can see tasks and projects assigned to him.','2022-10-28 07:34:31','2022-10-28 07:34:31'),(16,4,'client','Client','Client can see own tasks and projects.','2022-10-28 07:34:31','2022-10-28 07:34:31');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `seo_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `seo_details` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `page_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `seo_title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seo_keywords` text COLLATE utf8mb4_unicode_ci,
  `seo_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seo_author` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language_setting_id` int unsigned DEFAULT NULL,
  `og_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `seo_details_language_setting_id_foreign` (`language_setting_id`),
  CONSTRAINT `seo_details_language_setting_id_foreign` FOREIGN KEY (`language_setting_id`) REFERENCES `language_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `seo_details` WRITE;
/*!40000 ALTER TABLE `seo_details` DISABLE KEYS */;
INSERT INTO `seo_details` VALUES (1,'terms-of-use','Terms of use','best crm,hr management software, web hr software, hr software online, free hr software, hr software for sme, hr management software for small business, cloud hr software, online hr management software','Worksuite saas is easy to use CRM software that is designed for B2B. It include everything you need to run your businesses. like manage customers, projects, invoices, estimates, timelogs, con',NULL,NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(2,'privacy-policy','Privacy Policy','best crm,hr management software, web hr software, hr software online, free hr software, hr software for sme, hr management software for small business, cloud hr software, online hr management software','Worksuite saas is easy to use CRM software that is designed for B2B. It include everything you need to run your businesses. like manage customers, projects, invoices, estimates, timelogs, con',NULL,NULL,NULL,'2022-10-28 07:30:10','2022-10-28 07:30:10');
/*!40000 ALTER TABLE `seo_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payload` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
INSERT INTO `sessions` VALUES ('6vygZvXy0f8G5uvJ5h8BmEpQ07QCv7zCaRliD9VR',2,'127.0.0.1','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36','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',1667207476);
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sign_up_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sign_up_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `language_setting_id` int unsigned DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sign_up_settings_language_setting_id_foreign` (`language_setting_id`),
  CONSTRAINT `sign_up_settings_language_setting_id_foreign` FOREIGN KEY (`language_setting_id`) REFERENCES `language_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sign_up_settings` WRITE;
/*!40000 ALTER TABLE `sign_up_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `sign_up_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `skills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `skills` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `skills_company_id_foreign` (`company_id`),
  CONSTRAINT `skills_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `skills` WRITE;
/*!40000 ALTER TABLE `skills` DISABLE KEYS */;
/*!40000 ALTER TABLE `skills` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `slack_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slack_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `slack_webhook` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `slack_logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slack_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `slack_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `slack_settings` WRITE;
/*!40000 ALTER TABLE `slack_settings` DISABLE KEYS */;
INSERT INTO `slack_settings` VALUES (1,1,NULL,NULL,'inactive','2022-10-28 07:30:08','2022-10-28 07:30:08'),(2,2,NULL,NULL,'inactive','2022-10-28 07:30:09','2022-10-28 07:30:09'),(3,3,NULL,NULL,'inactive','2022-10-28 07:30:10','2022-10-28 07:30:10'),(4,4,NULL,NULL,'inactive','2022-10-28 07:34:33','2022-10-28 07:34:33');
/*!40000 ALTER TABLE `slack_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `smtp_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `smtp_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `mail_driver` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'smtp',
  `mail_host` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'smtp.gmail.com',
  `mail_port` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '587',
  `mail_username` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'youremail@gmail.com',
  `mail_password` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'your password',
  `mail_from_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'your name',
  `mail_from_email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'from@email.com',
  `mail_encryption` enum('tls','ssl') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'tls',
  `verified` tinyint(1) NOT NULL DEFAULT '0',
  `mail_connection` enum('sync','database') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sync',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `smtp_settings` WRITE;
/*!40000 ALTER TABLE `smtp_settings` DISABLE KEYS */;
INSERT INTO `smtp_settings` VALUES (1,'smtp','smtp.gmail.com','465','myemail@gmail.com','mypassword','Worksuite','from@email.com','ssl',0,'sync','2022-10-28 07:30:06','2022-10-28 07:30:06');
/*!40000 ALTER TABLE `smtp_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `social_auth_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_auth_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `facebook_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facebook_secret_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facebook_status` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `google_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_secret_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_status` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `twitter_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_secret_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_status` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `linkedin_client_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkedin_secret_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkedin_status` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disable',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `social_auth_settings` WRITE;
/*!40000 ALTER TABLE `social_auth_settings` DISABLE KEYS */;
INSERT INTO `social_auth_settings` VALUES (1,NULL,NULL,'disable',NULL,NULL,'disable',NULL,NULL,'disable',NULL,NULL,'disable','2022-10-28 07:30:06','2022-10-28 07:30:06');
/*!40000 ALTER TABLE `social_auth_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `socials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `socials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned DEFAULT NULL,
  `social_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `social_service` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `socials` WRITE;
/*!40000 ALTER TABLE `socials` DISABLE KEYS */;
/*!40000 ALTER TABLE `socials` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sticky_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sticky_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `note_text` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `colour` enum('blue','yellow','red','gray','purple','green') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'blue',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sticky_notes_user_id_foreign` (`user_id`),
  KEY `sticky_notes_company_id_foreign` (`company_id`),
  CONSTRAINT `sticky_notes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `sticky_notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sticky_notes` WRITE;
/*!40000 ALTER TABLE `sticky_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `sticky_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stripe_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `stripe_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned NOT NULL,
  `invoice_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `package_id` bigint unsigned NOT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(12,2) unsigned NOT NULL,
  `pay_date` date NOT NULL,
  `next_pay_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stripe_invoices_company_id_foreign` (`company_id`),
  KEY `stripe_invoices_package_id_foreign` (`package_id`),
  CONSTRAINT `stripe_invoices_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `stripe_invoices_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stripe_invoices` WRITE;
/*!40000 ALTER TABLE `stripe_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `stripe_invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stripe_setting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `stripe_setting` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `api_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `api_secret` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `webhook_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_client_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_secret` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `stripe_status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `razorpay_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razorpay_secret` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razorpay_webhook_secret` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razorpay_status` enum('active','deactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deactive',
  `paypal_mode` enum('sandbox','live') COLLATE utf8mb4_unicode_ci NOT NULL,
  `paystack_client_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paystack_secret` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paystack_status` enum('active','inactive') COLLATE utf8mb4_unicode_ci DEFAULT 'inactive',
  `paystack_merchant_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paystack_payment_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'https://api.paystack.co',
  `mollie_api_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mollie_status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `authorize_api_login_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authorize_transaction_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authorize_signature_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authorize_environment` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authorize_status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `payfast_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payfast_secret` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payfast_status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `payfast_salt_passphrase` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payfast_mode` enum('sandbox','live') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sandbox',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stripe_setting` WRITE;
/*!40000 ALTER TABLE `stripe_setting` DISABLE KEYS */;
INSERT INTO `stripe_setting` VALUES (1,NULL,NULL,NULL,NULL,NULL,'inactive','inactive',NULL,NULL,NULL,'deactive','sandbox',NULL,NULL,'inactive',NULL,'https://api.paystack.co','','inactive',NULL,NULL,NULL,NULL,'inactive',NULL,NULL,'inactive',NULL,'sandbox','2022-10-28 07:30:07','2022-10-28 07:30:07');
/*!40000 ALTER TABLE `stripe_setting` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sub_task_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sub_task_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned DEFAULT NULL,
  `sub_task_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `google_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dropbox_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_task_files_user_id_foreign` (`user_id`),
  KEY `sub_task_files_sub_task_id_foreign` (`sub_task_id`),
  CONSTRAINT `sub_task_files_sub_task_id_foreign` FOREIGN KEY (`sub_task_id`) REFERENCES `sub_tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `sub_task_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sub_task_files` WRITE;
/*!40000 ALTER TABLE `sub_task_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `sub_task_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sub_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sub_tasks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int unsigned NOT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `due_date` datetime DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `status` enum('incomplete','complete') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'incomplete',
  `assigned_to` int unsigned DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_tasks_task_id_foreign` (`task_id`),
  KEY `sub_tasks_assigned_to_foreign` (`assigned_to`),
  KEY `sub_tasks_added_by_foreign` (`added_by`),
  KEY `sub_tasks_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `sub_tasks_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `sub_tasks_assigned_to_foreign` FOREIGN KEY (`assigned_to`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `sub_tasks_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `sub_tasks_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sub_tasks` WRITE;
/*!40000 ALTER TABLE `sub_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sub_tasks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `support_ticket_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `support_ticket_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `support_ticket_reply_id` bigint unsigned NOT NULL,
  `filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `google_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dropbox_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `support_ticket_files_user_id_foreign` (`user_id`),
  KEY `support_ticket_files_support_ticket_reply_id_foreign` (`support_ticket_reply_id`),
  CONSTRAINT `support_ticket_files_support_ticket_reply_id_foreign` FOREIGN KEY (`support_ticket_reply_id`) REFERENCES `support_ticket_replies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `support_ticket_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `support_ticket_files` WRITE;
/*!40000 ALTER TABLE `support_ticket_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `support_ticket_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `support_ticket_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `support_ticket_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `support_ticket_id` bigint unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `support_ticket_replies_support_ticket_id_foreign` (`support_ticket_id`),
  KEY `support_ticket_replies_user_id_foreign` (`user_id`),
  CONSTRAINT `support_ticket_replies_support_ticket_id_foreign` FOREIGN KEY (`support_ticket_id`) REFERENCES `support_tickets` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `support_ticket_replies_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `support_ticket_replies` WRITE;
/*!40000 ALTER TABLE `support_ticket_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `support_ticket_replies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `support_ticket_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `support_ticket_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `support_ticket_types_type_unique` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `support_ticket_types` WRITE;
/*!40000 ALTER TABLE `support_ticket_types` DISABLE KEYS */;
INSERT INTO `support_ticket_types` VALUES (1,'Question',NULL,NULL),(2,'ar',NULL,NULL),(3,'de',NULL,NULL),(4,'es',NULL,NULL);
/*!40000 ALTER TABLE `support_ticket_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `support_tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `support_tickets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `created_by` int unsigned NOT NULL,
  `subject` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('open','pending','resolved','closed') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `priority` enum('low','medium','high','urgent') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'medium',
  `agent_id` int unsigned DEFAULT NULL,
  `support_ticket_type_id` bigint unsigned DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `support_tickets_user_id_foreign` (`user_id`),
  KEY `support_tickets_created_by_foreign` (`created_by`),
  KEY `support_tickets_agent_id_foreign` (`agent_id`),
  KEY `support_tickets_support_ticket_type_id_foreign` (`support_ticket_type_id`),
  CONSTRAINT `support_tickets_agent_id_foreign` FOREIGN KEY (`agent_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `support_tickets_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `support_tickets_support_ticket_type_id_foreign` FOREIGN KEY (`support_ticket_type_id`) REFERENCES `support_ticket_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `support_tickets_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `support_tickets` WRITE;
/*!40000 ALTER TABLE `support_tickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `support_tickets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_category` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `category_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_category_added_by_foreign` (`added_by`),
  KEY `task_category_last_updated_by_foreign` (`last_updated_by`),
  KEY `task_category_company_id_foreign` (`company_id`),
  CONSTRAINT `task_category_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `task_category_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `task_category_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_category` WRITE;
/*!40000 ALTER TABLE `task_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_category` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_comments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int unsigned NOT NULL,
  `task_id` int unsigned NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_comments_user_id_foreign` (`user_id`),
  KEY `task_comments_task_id_foreign` (`task_id`),
  KEY `task_comments_added_by_foreign` (`added_by`),
  KEY `task_comments_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `task_comments_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `task_comments_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `task_comments_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `task_comments_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_comments` WRITE;
/*!40000 ALTER TABLE `task_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_comments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `task_id` int unsigned NOT NULL,
  `filename` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `google_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hashname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dropbox_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_files_user_id_foreign` (`user_id`),
  KEY `task_files_task_id_foreign` (`task_id`),
  KEY `task_files_added_by_foreign` (`added_by`),
  KEY `task_files_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `task_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `task_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `task_files_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `task_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_files` WRITE;
/*!40000 ALTER TABLE `task_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_history` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int unsigned NOT NULL,
  `sub_task_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `board_column_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_history_task_id_foreign` (`task_id`),
  KEY `task_history_sub_task_id_foreign` (`sub_task_id`),
  KEY `task_history_user_id_foreign` (`user_id`),
  KEY `task_history_board_column_id_foreign` (`board_column_id`),
  CONSTRAINT `task_history_board_column_id_foreign` FOREIGN KEY (`board_column_id`) REFERENCES `taskboard_columns` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `task_history_sub_task_id_foreign` FOREIGN KEY (`sub_task_id`) REFERENCES `sub_tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `task_history_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `task_history_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_history` WRITE;
/*!40000 ALTER TABLE `task_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_history` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_label_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_label_list` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int unsigned DEFAULT NULL,
  `label_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_label_list_project_id_foreign` (`project_id`),
  CONSTRAINT `task_label_list_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_label_list` WRITE;
/*!40000 ALTER TABLE `task_label_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_label_list` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_labels` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `label_id` int unsigned NOT NULL,
  `task_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_labels_label_id_foreign` (`label_id`),
  KEY `task_tags_task_id_foreign` (`task_id`),
  CONSTRAINT `task_labels_label_id_foreign` FOREIGN KEY (`label_id`) REFERENCES `task_label_list` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `task_tags_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_labels` WRITE;
/*!40000 ALTER TABLE `task_labels` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_labels` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int unsigned NOT NULL,
  `user_id` int DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_notes_task_id_foreign` (`task_id`),
  KEY `task_notes_added_by_foreign` (`added_by`),
  KEY `task_notes_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `task_notes_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `task_notes_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `task_notes_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_notes` WRITE;
/*!40000 ALTER TABLE `task_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `task_category` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `project` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `start_date` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `due_date` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `assigned_to` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `assigned_by` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `description` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `label` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `status` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `priority` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `make_private` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `time_estimate` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `hours_logged` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `custom_fields` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `copy_task_link` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `files` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `sub_task` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `comments` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `time_logs` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `notes` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `history` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `task_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_settings` WRITE;
/*!40000 ALTER TABLE `task_settings` DISABLE KEYS */;
INSERT INTO `task_settings` VALUES (1,1,'yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','2022-10-28 07:30:08','2022-10-28 07:30:08'),(2,2,'yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','2022-10-28 07:30:09','2022-10-28 07:30:09'),(3,3,'yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','2022-10-28 07:30:10','2022-10-28 07:30:10'),(4,4,'yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','yes','2022-10-28 07:34:33','2022-10-28 07:34:33');
/*!40000 ALTER TABLE `task_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `task_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_users_task_id_foreign` (`task_id`),
  KEY `task_users_user_id_foreign` (`user_id`),
  CONSTRAINT `task_users_task_id_foreign` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `task_users_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `task_users` WRITE;
/*!40000 ALTER TABLE `task_users` DISABLE KEYS */;
INSERT INTO `task_users` VALUES (1,1,3,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(2,2,10,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(3,3,10,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(4,4,13,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(5,5,2,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(6,6,2,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(7,7,13,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(8,8,2,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(9,9,10,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(10,10,11,'2022-10-28 07:30:11','2022-10-28 07:30:11'),(11,11,2,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(12,12,10,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(13,13,2,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(14,14,11,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(15,15,13,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(16,16,13,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(17,17,13,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(18,18,3,'2022-10-28 07:30:12','2022-10-28 07:30:12'),(19,19,16,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(20,20,27,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(21,21,16,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(22,22,27,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(23,23,25,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(24,24,27,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(25,25,24,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(26,26,26,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(27,27,24,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(28,28,24,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(29,29,16,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(30,30,25,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(31,31,23,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(32,32,25,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(33,33,25,'2022-10-28 07:30:15','2022-10-28 07:30:15'),(34,34,36,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(35,35,36,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(36,36,38,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(37,37,38,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(38,38,37,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(39,39,28,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(40,40,29,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(41,41,40,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(42,42,40,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(43,43,36,'2022-10-28 07:30:18','2022-10-28 07:30:18'),(44,44,39,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(45,45,36,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(46,46,36,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(47,47,39,'2022-10-28 07:30:19','2022-10-28 07:30:19'),(48,48,40,'2022-10-28 07:30:19','2022-10-28 07:30:19');
/*!40000 ALTER TABLE `task_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `taskboard_columns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `taskboard_columns` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `column_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `label_color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `taskboard_columns_column_name_company_id_unique` (`column_name`,`company_id`),
  KEY `taskboard_columns_company_id_foreign` (`company_id`),
  CONSTRAINT `taskboard_columns_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `taskboard_columns` WRITE;
/*!40000 ALTER TABLE `taskboard_columns` DISABLE KEYS */;
INSERT INTO `taskboard_columns` VALUES (1,1,'Incomplete','incomplete','#d21010',1,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(2,1,'To Do','to_do','#f5c308',2,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(3,1,'Doing','doing','#00b5ff',3,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(4,1,'Completed','completed','#679c0d',4,'2022-10-28 07:30:08','2022-10-28 07:30:08'),(5,2,'Incomplete','incomplete','#d21010',1,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(6,2,'To Do','to_do','#f5c308',2,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(7,2,'Doing','doing','#00b5ff',3,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(8,2,'Completed','completed','#679c0d',4,'2022-10-28 07:30:09','2022-10-28 07:30:09'),(9,3,'Incomplete','incomplete','#d21010',1,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(10,3,'To Do','to_do','#f5c308',2,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(11,3,'Doing','doing','#00b5ff',3,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(12,3,'Completed','completed','#679c0d',4,'2022-10-28 07:30:10','2022-10-28 07:30:10'),(13,4,'Incomplete','incomplete','#d21010',1,'2022-10-28 07:34:33','2022-10-28 07:34:33'),(14,4,'To Do','to_do','#f5c308',2,'2022-10-28 07:34:33','2022-10-28 07:34:33'),(15,4,'Doing','doing','#00b5ff',3,'2022-10-28 07:34:33','2022-10-28 07:34:33'),(16,4,'Completed','completed','#679c0d',4,'2022-10-28 07:34:33','2022-10-28 07:34:33');
/*!40000 ALTER TABLE `taskboard_columns` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int unsigned DEFAULT NULL,
  `task_short_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `heading` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `due_date` date DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `task_category_id` int unsigned DEFAULT NULL,
  `priority` enum('low','medium','high') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'medium',
  `status` enum('incomplete','completed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'incomplete',
  `board_column_id` int unsigned DEFAULT '1',
  `column_priority` int NOT NULL,
  `completed_on` datetime DEFAULT NULL,
  `created_by` int unsigned DEFAULT NULL,
  `recurring_task_id` int unsigned DEFAULT NULL,
  `dependent_task_id` int unsigned DEFAULT NULL,
  `milestone_id` int unsigned DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT '0',
  `billable` tinyint(1) NOT NULL DEFAULT '1',
  `estimate_hours` int NOT NULL,
  `estimate_minutes` int NOT NULL,
  `added_by` int unsigned DEFAULT NULL,
  `last_updated_by` int unsigned DEFAULT NULL,
  `hash` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `repeat` tinyint(1) NOT NULL DEFAULT '0',
  `repeat_complete` tinyint(1) NOT NULL DEFAULT '0',
  `repeat_count` int DEFAULT NULL,
  `repeat_type` enum('day','week','month','year') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'day',
  `repeat_cycles` int DEFAULT NULL,
  `event_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tasks_due_date_index` (`due_date`),
  KEY `tasks_project_id_foreign` (`project_id`),
  KEY `tasks_task_category_id_foreign` (`task_category_id`),
  KEY `tasks_board_column_id_foreign` (`board_column_id`),
  KEY `tasks_created_by_foreign` (`created_by`),
  KEY `tasks_recurring_task_id_foreign` (`recurring_task_id`),
  KEY `tasks_dependent_task_id_foreign` (`dependent_task_id`),
  KEY `tasks_milestone_id_foreign` (`milestone_id`),
  KEY `tasks_added_by_foreign` (`added_by`),
  KEY `tasks_last_updated_by_foreign` (`last_updated_by`),
  KEY `tasks_deleted_at_index` (`deleted_at`),
  KEY `tasks_company_id_foreign` (`company_id`),
  CONSTRAINT `tasks_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tasks_board_column_id_foreign` FOREIGN KEY (`board_column_id`) REFERENCES `taskboard_columns` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tasks_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `tasks_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `tasks_dependent_task_id_foreign` FOREIGN KEY (`dependent_task_id`) REFERENCES `tasks` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tasks_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tasks_milestone_id_foreign` FOREIGN KEY (`milestone_id`) REFERENCES `project_milestones` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tasks_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `tasks_recurring_task_id_foreign` FOREIGN KEY (`recurring_task_id`) REFERENCES `tasks` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `tasks_task_category_id_foreign` FOREIGN KEY (`task_category_id`) REFERENCES `task_category` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
INSERT INTO `tasks` VALUES (1,1,'IA-1','Alice. \'Anything.','Alice, as the jury asked. \'That I can\'t show it you myself,\' the Mock Turtle angrily: \'really you are painting those roses?\' Five and Seven said nothing, but looked at Alice, and her eyes anxiously.','2022-01-19','2022-01-13',1,NULL,'high','incomplete',3,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'JEZLHPfNF3GnLkJ2aiwbpdJ8dj4QNHEN',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL),(2,1,'IS-2','Though they were.','ME.\' \'You!\' said the Mock Turtle, capering wildly about. \'Change lobsters again!\' yelled the Gryphon went on. Her listeners were perfectly quiet till she was saying, and the shrill voice of thunder.','2022-06-17','2022-06-12',2,NULL,'low','incomplete',4,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'VBh199k8Wk2540th0x3d6DJnOxMhgsVo',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL),(3,1,'IS-3','Quadrille The Mock.','Hatter went on, half to Alice. \'Only a thimble,\' said Alice indignantly. \'Let me alone!\' \'Serpent, I say again!\' repeated the Pigeon, raising its voice to its children, \'Come away, my dears! It\'s.','2022-10-21','2022-10-11',2,NULL,'high','completed',4,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'qibua6nuB6osQRtVc0hghvpc1rRoOjBj',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL),(4,1,'CDOW-4','Alice, a little of.','Her first idea was that it was indeed: she was quite impossible to say \"HOW DOTH THE LITTLE BUSY BEE,\" but it puzzled her too much, so she went on, \'if you only kept on puzzling about it just at.','2022-05-27','2022-05-19',3,NULL,'high','completed',3,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'HoymMsBnLJCEHN7ODP33s937kJ7NzqYV',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL),(5,1,'CDOW-5','Pennyworth only of.','Cat. \'I said pig,\' replied Alice; \'and I do wonder what I see\"!\' \'You might just as well as the other.\' As soon as there was not a moment that it might tell her something worth hearing. For some.','2022-10-15','2022-10-12',3,NULL,'low','completed',4,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'i7aTKdzWY7ZGPfXnKNpQx41tKAma9kBc',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL),(6,1,'CDOW-6','I wonder if I fell.','ME\' beautifully printed on it in time,\' said the Caterpillar. Here was another long passage, and the small ones choked and had come back and see how the Dodo solemnly presented the thimble, saying.','2022-10-23','2022-10-22',3,NULL,'high','incomplete',1,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'Qk3b1EwVjVntOtCwpZxJgffJeO1HYc2r',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL),(7,1,'CDOW-7','Do come back with.','For anything tougher than suet; Yet you turned a back-somersault in at all?\' said Alice, who felt ready to make herself useful, and looking anxiously about her. \'Oh, do let me help to undo it!\' \'I.','2022-06-09','2022-06-08',3,NULL,'high','completed',2,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'BgjeQaOjZEoui5O3Q7yBYDbwekitz06d',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL),(8,1,'CDOW-8','I\'ve finished.\' So.','Dormouse go on in the lock, and to stand on their backs was the fan and gloves. \'How queer it seems,\' Alice said very politely, feeling quite pleased to have no sort of circle, (\'the exact shape.','2022-10-18','2022-10-15',3,NULL,'low','completed',3,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'xWbsehgKYclybKvxBaANF9oCZYd2cKgn',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL),(9,1,'UM-9','I\'d been the right.','So she tucked it away under her arm, with its mouth and began to say \'creatures,\' you see, because some of them bowed low. \'Would you tell me,\' said Alice, swallowing down her flamingo, and began.','2022-04-25','2022-04-21',4,NULL,'medium','incomplete',1,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'0Qp0Ic18LxB0D667A2RRkvs4mbuCkTwu',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL),(10,1,'UM-10','Alice did not like.','Gryphon at the March Hare. \'Then it ought to have him with them,\' the Mock Turtle Soup is made from,\' said the King, the Queen, \'and he shall tell you just now what the flame of a muchness\"--did you.','2022-10-26','2022-10-23',4,NULL,'medium','incomplete',1,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'BsjzjMTPKfq8J0ECwN8yP6InkpziSb46',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:11','2022-10-28 07:30:11',NULL),(11,1,'UM-11','Alice to herself.','The long grass rustled at her own courage. \'It\'s no use now,\' thought poor Alice, \'to pretend to be a very pretty dance,\' said Alice loudly. \'The idea of having nothing to what I get\" is the reason.','2022-10-19','2022-10-14',4,NULL,'high','incomplete',4,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'7kubFslUJ6NHoVFxttvwks9SYWdrbxJH',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL),(12,1,'UM-12','Dinah, and saying.','I wish you could manage it?) \'And what an ignorant little girl she\'ll think me at home! Why, I do so like that curious song about the whiting!\' \'Oh, as to go down the chimney, and said \'That\'s very.','2022-08-19','2022-08-17',4,NULL,'low','completed',3,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'1gk15zHNDajpZnvRKKH9TzWAkUhHbqDj',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL),(13,1,'UM-13','Kings and Queens.','Alice loudly. \'The idea of having nothing to what I see\"!\' \'You might just as if a fish came to the general conclusion, that wherever you go to law: I will just explain to you to learn?\' \'Well.','2022-01-29','2022-01-19',4,NULL,'medium','completed',4,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'lzLL0K31DEfUDp4VZcxwL9U5FdYSMyer',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL),(14,1,'UM-14','For some minutes.','Beautiful, beautiful Soup!\' CHAPTER XI. Who Stole the Tarts? The King looked anxiously round, to make herself useful, and looking at the window.\' \'THAT you won\'t\' thought Alice, and, after waiting.','2022-10-12','2022-10-02',5,NULL,'high','completed',1,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'rv4HfQPMmDGDucT2DaawL7Yx9Ghff2NQ',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL),(15,1,'UM-15','Morcar, the earls.','Gryphon, and the arm that was lying under the sea--\' (\'I haven\'t,\' said Alice)--\'and perhaps you were down here till I\'m somebody else\"--but, oh dear!\' cried Alice in a voice of the month is it?\' he.','2022-06-22','2022-06-20',5,NULL,'low','incomplete',2,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'oSk56I6QxINekgq9CQ1ydxg6LBqbYSlT',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL),(16,1,'UM-16','Alice noticed with.','Bill,\' thought Alice,) \'Well, I can\'t understand it myself to begin lessons: you\'d only have to fly; and the sounds will take care of themselves.\"\' \'How fond she is of finding morals in things!\'.','2022-10-29','2022-10-19',5,NULL,'low','completed',4,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'ITmm9ZniArlFnoVUegIB7UVjQxXPMbuj',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL),(17,1,'UM-17','Majesty means, of.','King. The White Rabbit read:-- \'They told me you had been anything near the door and went on so long that they had to leave off this minute!\' She generally gave herself very good advice, (though she.','2022-05-12','2022-05-06',5,NULL,'low','completed',3,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'CoMLeqXJdwpN92LbGyLb2iSG75k7J75o',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL),(18,1,'UM-18','I\'m sure I can\'t.','So she called softly after it, and on it but tea. \'I don\'t think they play at all this time. \'I want a clean cup,\' interrupted the Hatter: \'let\'s all move one place on.\' He moved on as he found it.','2022-03-03','2022-02-22',5,NULL,'low','incomplete',1,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'vk3eYCXynyF2QIStNYR4MJGc4LFQoRmM',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:12','2022-10-28 07:30:12',NULL),(19,2,'IS-19','Yet you turned a.','Still she went down on their hands and feet at the Cat\'s head with great curiosity, and this Alice thought to herself. (Alice had been wandering, when a cry of \'The trial\'s beginning!\' was heard in.','2022-10-13','2022-10-06',6,NULL,'low','incomplete',7,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'EDC5C9G6VwPiPqn1iQ10RwX5HYPFb4NS',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(20,2,'IS-20','I will prosecute.','Alice began to feel very queer to ME.\' \'You!\' said the Mouse, turning to the conclusion that it is!\' \'Why should it?\' muttered the Hatter. \'It isn\'t a bird,\' Alice remarked. \'Right, as usual,\' said.','2022-11-05','2022-10-26',6,NULL,'high','completed',6,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'dTdMd4UZLjB3yR6zwKoWlTBgXT6r4kLy',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(21,2,'IS-21','Alice did not look.','Alice did not venture to go down the little creature down, and the cool fountains. CHAPTER VIII. The Queen\'s argument was, that her shoulders were nowhere to be a queer thing, to be done, I wonder?\'.','2022-10-08','2022-09-28',6,NULL,'medium','incomplete',6,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'6BXgkWOKbeaP9oOIxKFCoN4EWEbDmVLJ',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(22,2,'IS-22','I\'ll come up: if.','The Cat seemed to be seen: she found this a very humble tone, going down on one knee. \'I\'m a poor man,\' the Hatter began, in a sulky tone; \'Seven jogged my elbow.\' On which Seven looked up eagerly.','2022-10-31','2022-10-21',6,NULL,'medium','completed',8,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'ejPaQBZS5RTZoMIpOIXIWQMUrWN9Jwdl',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(23,2,'IS-23','I can\'t understand.','Alice looked all round the court and got behind him, and said \'No, never\') \'--so you can find it.\' And she tried the effect of lying down with her head!\' Alice glanced rather anxiously at the.','2022-11-03','2022-10-27',6,NULL,'high','incomplete',7,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'NWcEHCVAdlJpCCv3XHleNxOEmWbNkN5b',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(24,2,'RM-24','Mouse had changed.','King was the same thing with you,\' said the Gryphon: \'I went to him,\' said Alice more boldly: \'you know you\'re growing too.\' \'Yes, but some crumbs must have a trial: For really this morning I\'ve.','2022-08-13','2022-08-03',7,NULL,'medium','completed',5,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'FPnJbUlW3D2NhAADoaJ6PBYqOLyw7eS6',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(25,2,'PM-25','White Rabbit with.','And so she bore it as a drawing of a feather flock together.\"\' \'Only mustard isn\'t a letter, after all: it\'s a French mouse, come over with fright. \'Oh, I know!\' exclaimed Alice, who always took a.','2022-05-15','2022-05-07',8,NULL,'medium','incomplete',8,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'5tWXs67TNkMme34n0GbCGQOeJKqEPLk9',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(26,2,'PM-26','Some of the Mock.','Dormouse fell asleep instantly, and neither of the Queen\'s voice in the world she was walking hand in her life, and had just begun \'Well, of all her knowledge of history, Alice had been anxiously.','2022-04-30','2022-04-24',8,NULL,'low','incomplete',8,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'leh3y7xupf5W5RqelkrT9IWfS2cE4ney',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(27,2,'PM-27','Gryphon. Alice did.','I suppose Dinah\'ll be sending me on messages next!\' And she squeezed herself up and saying, \'Thank you, sir, for your walk!\" \"Coming in a VERY good opportunity for repeating his remark, with.','2022-10-21','2022-10-11',8,NULL,'medium','completed',5,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'NYFR2nwREv0lxuqyfAAvLVgWkF1WDcrx',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(28,2,'PM-28','Alice was silent.','And he added in an angry tone, \'Why, Mary Ann, what ARE you doing out here? Run home this moment, I tell you, you coward!\' and at last it unfolded its arms, took the cauldron of soup off the.','2022-08-19','2022-08-16',8,NULL,'high','incomplete',6,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'ckit3J4FAZ5J67h3e6eKQaQgGBdQyNnj',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(29,2,'DMS-29','Let me think: was.','Alice. It looked good-natured, she thought: still it was all very well to say \'creatures,\' you see, because some of the house, \"Let us both go to on the Duchess\'s knee, while plates and dishes.','2022-10-05','2022-09-30',9,NULL,'medium','incomplete',6,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'dwnzRdoBYOdm9gz4H6oblXLyoxv9DEe9',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(30,2,'DMS-30','There was no one.','But, now that I\'m perfectly sure I can\'t tell you my history, and you\'ll understand why it is I hate cats and dogs.\' It was all very well as she could, for her to speak again. In a minute or two.','2022-10-10','2022-10-07',9,NULL,'medium','completed',5,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'g7riNXlcM9gsYlNOiC6JqPXxPbPNiVWN',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(31,2,'DMS-31','Lory hastily. \'I.','I hadn\'t mentioned Dinah!\' she said this last remark, \'it\'s a vegetable. It doesn\'t look like one, but it was only the pepper that makes them bitter--and--and barley-sugar and such things that make.','2022-05-04','2022-05-02',10,NULL,'low','incomplete',8,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'HUEBzeZn9Ew0lXa5rmIqFYDPfR9uOsrg',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(32,2,'DMS-32','Alice, as she ran.','No, there were no tears. \'If you\'re going to remark myself.\' \'Have you seen the Mock Turtle replied in an agony of terror. \'Oh, there goes his PRECIOUS nose\'; as an explanation; \'I\'ve none of YOUR.','2022-10-02','2022-09-30',10,NULL,'high','incomplete',5,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'vLHy9NJZUAprCRdVygI20cQwibHjHpU6',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(33,2,'DMS-33','Alice\'s, and they.','Though they were gardeners, or soldiers, or courtiers, or three of the busy farm-yard--while the lowing of the March Hare. \'Yes, please do!\' but the three gardeners, oblong and flat, with their.','2022-10-30','2022-10-21',10,NULL,'low','incomplete',7,0,NULL,NULL,NULL,NULL,NULL,0,1,0,0,NULL,NULL,'H7N3Sb1BwNXLQmeYWGvDOkS5KumoNNJQ',0,0,NULL,'day',NULL,NULL,'2022-10-28 07:30:15','2022-10-28 07:30:15',NULL),(34,3,'LM-34','But, now that I\'m.','Queen to-day?\' \'I should like it put more simply--\"Never imagine yourself not to be a queer thing, to be trampled under its feet, ran round the refreshments!\' But there seemed to Alice again. \'No, I.'